/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.examples.cloudio.application.ui;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.zest.cloudio.CloudOptionsComposite;
import org.eclipse.zest.cloudio.TagCloud;
import org.eclipse.zest.cloudio.TagCloudViewer;
import org.eclipse.zest.cloudio.layout.DefaultLayouter;
import org.eclipse.zest.cloudio.layout.ILayouter;
import org.eclipse.zest.examples.cloudio.application.Messages;
import org.eclipse.zest.examples.cloudio.application.data.Type;
import org.eclipse.zest.examples.cloudio.application.ui.TypeLabelProvider;

public class TagCloudViewPart
extends ViewPart {
    private TagCloudViewer viewer;
    private TypeLabelProvider labelProvider;
    private CloudOptionsComposite options;
    private ILayouter layouter;

    public void createPartControl(Composite parent) {
        SashForm sash = new SashForm(parent, 256);
        sash.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite cloudComp = new Composite((Composite)sash, 0);
        cloudComp.setLayout((Layout)new GridLayout());
        cloudComp.setLayoutData((Object)new GridData(4, 4, true, true));
        TagCloud cloud = new TagCloud(cloudComp, 768);
        cloud.setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer = new TagCloudViewer(cloud);
        this.layouter = new DefaultLayouter(20, 10);
        this.viewer.setLayouter(this.layouter);
        this.labelProvider = new TypeLabelProvider();
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer v, Object oldInput, Object newInput) {
                List list = (List)newInput;
                if (list == null || list.size() == 0) {
                    return;
                }
                TagCloudViewPart.this.labelProvider.setMaxOccurrences(((Type)list.get(0)).getOccurrences());
                int minIndex = Math.min(list.size() - 1, TagCloudViewPart.this.viewer.getMaxWords());
                TagCloudViewPart.this.labelProvider.setMinOccurrences(((Type)list.get(minIndex)).getOccurrences());
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return ((List)inputElement).toArray();
            }
        });
        this.createSideTab(sash);
        cloud.setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer.getCloud().addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                TagCloudViewPart.this.viewer.getCloud().zoomFit();
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        ArrayList<Type> types = new ArrayList<Type>();
        types.add(new Type(Messages.TagCloudViewPart_Cloudio, 220));
        types.add(new Type(Messages.TagCloudViewPart_Cloudio, 150));
        types.add(new Type(Messages.TagCloudViewPart_Cloudio, 100));
        types.add(new Type(Messages.TagCloudViewPart_NoDataAvailable, 150));
        int size = 55;
        int i = 0;
        while (i < 50) {
            types.add(new Type(Messages.TagCloudViewPart_TagCloud, size));
            --size;
            ++i;
        }
        this.viewer.getCloud().setMaxFontSize(100);
        this.viewer.getCloud().setMinFontSize(15);
        this.labelProvider.setColors(this.options.getColors());
        this.labelProvider.setFonts(this.options.getFonts());
        sash.setWeights(new int[]{72, 28});
        this.viewer.setInput(types);
    }

    private void createSideTab(SashForm form) {
        Composite parent = new Composite((Composite)form, 0);
        parent.setLayout((Layout)new GridLayout());
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.options = new CloudOptionsComposite(parent, 0, this.viewer){

            protected Group addMaskButton(Composite parent) {
                Group buttons = new Group(parent, 4);
                buttons.setLayout((Layout)new GridLayout(2, true));
                buttons.setLayoutData((Object)new GridData(4, 128, true, false));
                Label l = new Label((Composite)buttons, 0);
                l.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
                l.setText(Messages.TagCloudViewPart_Mask);
                Button file = new Button((Composite)buttons, 0x800000);
                file.setLayoutData((Object)new GridData(4, 4, true, false));
                file.setText(Messages.TagCloudViewPart_Open);
                file.addListener(13, event -> {
                    FileDialog fd = new FileDialog(this.getShell(), 4096);
                    fd.setText(Messages.TagCloudViewPart_OpenDialog_Text);
                    String sourceFile = fd.open();
                    if (sourceFile == null) {
                        return;
                    }
                    try {
                        ImageLoader loader = new ImageLoader();
                        BufferedInputStream in = new BufferedInputStream(new FileInputStream(new File(sourceFile)));
                        ImageData[] data = loader.load((InputStream)in);
                        in.close();
                        this.viewer.getCloud().setBackgroundMask(data[0]);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
                return buttons;
            }

            protected void addGroups() {
                this.addMaskButton((Composite)this);
                super.addGroups();
            }

            protected Group addLayoutButtons(Composite parent) {
                Group buttons = super.addLayoutButtons(parent);
                Label l = new Label((Composite)buttons, 0);
                l.setText(Messages.TagCloudViewPart_Scale);
                final Combo scale = new Combo((Composite)buttons, 12);
                scale.setLayoutData((Object)new GridData(4, 128, true, false));
                scale.setItems(new String[]{Messages.TagCloudViewPart_Linear, Messages.TagCloudViewPart_Logarithmic});
                scale.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        switch (scale.getSelectionIndex()) {
                            case 0: {
                                (this).TagCloudViewPart.this.labelProvider.setScale(TypeLabelProvider.Scaling.LINEAR);
                                break;
                            }
                            case 1: {
                                (this).TagCloudViewPart.this.labelProvider.setScale(TypeLabelProvider.Scaling.LOGARITHMIC);
                                break;
                            }
                        }
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                scale.select(1);
                l = new Label((Composite)buttons, 0);
                l.setText(Messages.TagCloudViewPart_XAxisVariation);
                final Combo xAxis = new Combo((Composite)buttons, 12);
                xAxis.setLayoutData((Object)new GridData(4, 128, true, false));
                xAxis.setItems(new String[]{Messages.TagCloudViewPart_0, Messages.TagCloudViewPart_10, Messages.TagCloudViewPart_20, Messages.TagCloudViewPart_30, Messages.TagCloudViewPart_40, Messages.TagCloudViewPart_50, Messages.TagCloudViewPart_60, Messages.TagCloudViewPart_70, Messages.TagCloudViewPart_80, Messages.TagCloudViewPart_90, Messages.TagCloudViewPart_100});
                xAxis.select(2);
                xAxis.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        String item = xAxis.getItem(xAxis.getSelectionIndex());
                        (this).TagCloudViewPart.this.layouter.setOption("xaxis", (Object)Integer.parseInt(item));
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                l = new Label((Composite)buttons, 0);
                l.setText(Messages.TagCloudViewPart_YAxisVariation);
                final Combo yAxis = new Combo((Composite)buttons, 12);
                yAxis.setLayoutData((Object)new GridData(4, 128, true, false));
                yAxis.setItems(new String[]{Messages.TagCloudViewPart_0, Messages.TagCloudViewPart_10, Messages.TagCloudViewPart_20, Messages.TagCloudViewPart_30, Messages.TagCloudViewPart_40, Messages.TagCloudViewPart_50, Messages.TagCloudViewPart_60, Messages.TagCloudViewPart_70, Messages.TagCloudViewPart_80, Messages.TagCloudViewPart_90, Messages.TagCloudViewPart_100});
                yAxis.select(1);
                yAxis.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        String item = yAxis.getItem(yAxis.getSelectionIndex());
                        (this).TagCloudViewPart.this.layouter.setOption("yaxis", (Object)Integer.parseInt(item));
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                Button run = new Button((Composite)buttons, 0);
                run.setLayoutData((Object)new GridData(4, 4, true, true));
                run.setText(Messages.TagCloudViewPart_RePosition);
                run.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        ProgressMonitorDialog dialog = new ProgressMonitorDialog(viewer.getControl().getShell());
                        dialog.setBlockOnOpen(false);
                        dialog.open();
                        dialog.getProgressMonitor().beginTask(Messages.TagCloudViewPart_BeginTask, 100);
                        viewer.reset(dialog.getProgressMonitor(), false);
                        dialog.close();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                Button layout = new Button((Composite)buttons, 0);
                layout.setLayoutData((Object)new GridData(4, 4, true, true));
                layout.setText(Messages.TagCloudViewPart_ReLayout);
                layout.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        ProgressMonitorDialog dialog = new ProgressMonitorDialog(viewer.getControl().getShell());
                        dialog.setBlockOnOpen(false);
                        dialog.open();
                        dialog.getProgressMonitor().beginTask(Messages.TagCloudViewPart_BeginTask, 200);
                        viewer.setInput(viewer.getInput(), dialog.getProgressMonitor());
                        dialog.close();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                return buttons;
            }
        };
        GridData gd = new GridData(4, 0x1000000, true, false);
        this.options.setLayoutData((Object)gd);
    }

    public void setFocus() {
        this.viewer.getCloud().setFocus();
    }

    public void dispose() {
        this.viewer.getCloud().dispose();
        this.labelProvider.dispose();
    }

    public TagCloudViewer getViewer() {
        return this.viewer;
    }
}

