/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.text;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.examples.text.TextLocation;
import org.eclipse.gef.examples.text.edit.TextEditPart;
import org.eclipse.gef.tools.ToolUtilities;

public class SelectionRange {
    public final TextLocation begin;
    public final TextLocation end;
    public final boolean isForward;
    public final boolean trailing;
    private List<EditPart> selectedParts;
    private List<EditPart> leafParts;

    public SelectionRange(TextLocation location) {
        this(location, location, true);
    }

    public SelectionRange(TextLocation begin, TextLocation end) {
        this(begin, end, true);
    }

    public SelectionRange(TextLocation begin, TextLocation end, boolean forward) {
        this(begin, end, forward, true);
    }

    public SelectionRange(TextLocation begin, TextLocation end, boolean forward, boolean trailing) {
        Assert.isNotNull((Object)begin);
        Assert.isNotNull((Object)end);
        this.begin = begin;
        this.end = end;
        this.isForward = forward;
        this.trailing = trailing;
    }

    public SelectionRange(TextEditPart part, int offset) {
        this(new TextLocation(part, offset));
    }

    public SelectionRange(TextEditPart begin, int bo, TextEditPart end, int eo) {
        this(new TextLocation(begin, bo), new TextLocation(end, eo));
    }

    private static void depthFirstTraversal(EditPart part, List<EditPart> result) {
        if (part.getChildren().isEmpty()) {
            result.add(part);
        } else {
            for (EditPart element : part.getChildren()) {
                SelectionRange.depthFirstTraversal(element, result);
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof SelectionRange) {
            SelectionRange other = (SelectionRange)obj;
            return other.begin == this.begin && other.end == this.end && other.isForward == this.isForward;
        }
        return false;
    }

    private static List<EditPart> findLeavesBetweenInclusive(EditPart left, EditPart right) {
        int start;
        List children;
        if (left == right) {
            return Collections.singletonList(left);
        }
        EditPart commonAncestor = ToolUtilities.findCommonAncestor((EditPart)left, (EditPart)right);
        EditPart nextLeft = left.getParent();
        ArrayList<EditPart> result = new ArrayList<EditPart>();
        if (nextLeft == commonAncestor) {
            result.add(left);
        }
        while (nextLeft != commonAncestor) {
            children = nextLeft.getChildren();
            int i = children.indexOf(left);
            while (i < children.size()) {
                SelectionRange.depthFirstTraversal((EditPart)children.get(i), result);
                ++i;
            }
            left = nextLeft;
            nextLeft = nextLeft.getParent();
        }
        ArrayList<EditPart> rightSide = new ArrayList<EditPart>();
        EditPart nextRight = right.getParent();
        if (nextRight == commonAncestor) {
            rightSide.add(right);
        }
        while (nextRight != commonAncestor) {
            children = nextRight.getChildren();
            int i = 0;
            while (i <= children.indexOf(right)) {
                SelectionRange.depthFirstTraversal((EditPart)children.get(i), rightSide);
                ++i;
            }
            right = nextRight;
            nextRight = nextRight.getParent();
        }
        children = commonAncestor.getChildren();
        int i = start = children.indexOf(left) + 1;
        while (i < children.indexOf(right)) {
            SelectionRange.depthFirstTraversal((EditPart)children.get(i), result);
            ++i;
        }
        result.addAll(rightSide);
        return result;
    }

    private static List<EditPart> findNodesBetweenInclusive(EditPart left, EditPart right) {
        List children;
        if (left == right) {
            return Collections.singletonList(left);
        }
        EditPart commonAncestor = ToolUtilities.findCommonAncestor((EditPart)left, (EditPart)right);
        EditPart nextLeft = left.getParent();
        ArrayList<EditPart> result = new ArrayList<EditPart>();
        result.add(left);
        while (nextLeft != commonAncestor) {
            children = nextLeft.getChildren();
            int i = children.indexOf(left) + 1;
            while (i < children.size()) {
                result.add((EditPart)children.get(i));
                ++i;
            }
            left = nextLeft;
            nextLeft = nextLeft.getParent();
        }
        ArrayList<EditPart> rightSide = new ArrayList<EditPart>();
        EditPart nextRight = right.getParent();
        rightSide.add(right);
        while (nextRight != commonAncestor) {
            children = nextRight.getChildren();
            int end = children.indexOf(right);
            int i = 0;
            while (i < end) {
                rightSide.add((EditPart)children.get(i));
                ++i;
            }
            right = nextRight;
            nextRight = nextRight.getParent();
        }
        children = commonAncestor.getChildren();
        int start = children.indexOf(left) + 1;
        int end = children.indexOf(right);
        if (end > start) {
            result.addAll(children.subList(start, end));
        }
        result.addAll(rightSide);
        return result;
    }

    public List<EditPart> getLeafParts() {
        if (this.leafParts == null) {
            List<EditPart> list = SelectionRange.findLeavesBetweenInclusive((EditPart)this.begin.part, (EditPart)this.end.part);
            this.leafParts = Collections.unmodifiableList(list);
        }
        return this.leafParts;
    }

    public List<EditPart> getSelectedParts() {
        if (this.selectedParts == null) {
            List<EditPart> list = SelectionRange.findNodesBetweenInclusive((EditPart)this.begin.part, (EditPart)this.end.part);
            this.selectedParts = Collections.unmodifiableList(list);
        }
        return this.selectedParts;
    }

    public boolean isEmpty() {
        return this.begin.equals(this.end);
    }
}

