/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.internal.core.dom.parser.ISerializableType;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.core.runtime.CoreException;

public class CFunctionType
implements IFunctionType,
ISerializableType {
    private final IType[] parameters;
    private final IType returnType;
    private final boolean takesVarargs;

    public CFunctionType(IType returnType, IType[] parameters) {
        this(returnType, parameters, false);
    }

    public CFunctionType(IType returnType, IType[] parameters, boolean takesVarargs) {
        this.returnType = returnType;
        this.parameters = parameters;
        this.takesVarargs = takesVarargs;
    }

    @Override
    public boolean isSameType(IType o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ITypedef) {
            return o.isSameType(this);
        }
        if (o instanceof IFunctionType) {
            IFunctionType ft = (IFunctionType)o;
            IType[] fps = ft.getParameterTypes();
            if (fps.length != this.parameters.length) {
                return false;
            }
            if (!this.returnType.isSameType(ft.getReturnType())) {
                return false;
            }
            int i = 0;
            while (i < this.parameters.length) {
                if (!this.parameters[i].isSameType(fps[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    @Override
    public IType getReturnType() {
        return this.returnType;
    }

    @Override
    public IType[] getParameterTypes() {
        return this.parameters;
    }

    @Override
    public Object clone() {
        IType t = null;
        try {
            t = (IType)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return t;
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer) throws CoreException {
        int len;
        int codedLen;
        short firstBytes = 5;
        if (this.takesVarargs) {
            firstBytes = (short)(firstBytes | 0x20);
        }
        if ((codedLen = (len = this.parameters.length & 0xFFFF) * 64) < 8192) {
            firstBytes = (short)(firstBytes | codedLen);
            buffer.putShort(firstBytes);
        } else {
            firstBytes = (short)(firstBytes | 0x2000);
            buffer.putShort(firstBytes);
            buffer.putInt(len);
        }
        buffer.marshalType(this.returnType);
        int i = 0;
        while (i < len) {
            buffer.marshalType(this.parameters[i]);
            ++i;
        }
    }

    public static IType unmarshal(short firstBytes, ITypeMarshalBuffer buffer) throws CoreException {
        int len = (firstBytes & 0x2000) != 0 ? buffer.getInt() : (firstBytes & 0x1FFF) / 64;
        IType rt = buffer.unmarshalType();
        IType[] pars = new IType[len];
        int i = 0;
        while (i < pars.length) {
            pars[i] = buffer.unmarshalType();
            ++i;
        }
        return new CFunctionType(rt, pars, (firstBytes & 0x20) != 0);
    }

    @Override
    public boolean takesVarArgs() {
        return this.takesVarargs;
    }
}

