/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.launching;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.launchbar.core.AbstractLaunchConfigProvider;
import org.eclipse.launchbar.core.ILaunchDescriptor;
import org.eclipse.launchbar.core.ProjectLaunchDescriptor;
import org.eclipse.launchbar.core.target.ILaunchTarget;
import org.eclipse.launchbar.core.target.LaunchTargetUtils;

public class CoreBuildGdbManualRemoteLaunchConfigProvider
extends AbstractLaunchConfigProvider {
    public static final String TYPE_ID = "org.eclipse.cdt.debug.core.GdbManualRemoteCoreBuildLaunchConfigType";
    private static final String EMPTY = "";
    private Map<IProject, Map<String, ILaunchConfiguration>> configs = new HashMap<IProject, Map<String, ILaunchConfiguration>>();

    public boolean supports(ILaunchDescriptor descriptor, ILaunchTarget target) throws CoreException {
        if (descriptor instanceof ProjectLaunchDescriptor) {
            String targetTypeId = target.getTypeId();
            return targetTypeId.equals("org.eclipse.cdt.dsf.gdb.remoteTCPLaunchTargetType") || targetTypeId.equals("org.eclipse.cdt.dsf.gdb.remoteSerialLaunchTargetType");
        }
        return false;
    }

    public ILaunchConfigurationType getLaunchConfigurationType(ILaunchDescriptor descriptor, ILaunchTarget target) throws CoreException {
        return DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(TYPE_ID);
    }

    private String getNameSuffix(ILaunchTarget target) {
        Object suffix = target.getId();
        String targetTypeId = target.getTypeId();
        if (targetTypeId.equals("org.eclipse.cdt.dsf.gdb.remoteTCPLaunchTargetType")) {
            suffix = (String)suffix + " TCP";
        }
        if (targetTypeId.equals("org.eclipse.cdt.dsf.gdb.remoteSerialLaunchTargetType")) {
            suffix = (String)suffix + " Serial";
        }
        return LaunchTargetUtils.sanitizeLaunchConfigurationName((String)suffix);
    }

    private String launchConfigName(ILaunchDescriptor descriptor, ILaunchTarget target) {
        String name = descriptor.getName() + " " + this.getNameSuffix(target);
        return name;
    }

    protected ILaunchConfiguration createLaunchConfiguration(ILaunchDescriptor descriptor, ILaunchTarget target) throws CoreException {
        String name = this.launchConfigName(descriptor, target);
        ILaunchConfigurationType type = this.getLaunchConfigurationType(descriptor, target);
        ILaunchConfigurationWorkingCopy workingCopy = type.newInstance(null, name);
        this.populateLaunchConfiguration(descriptor, target, workingCopy);
        return workingCopy.doSave();
    }

    public ILaunchConfiguration getLaunchConfiguration(ILaunchDescriptor descriptor, ILaunchTarget target) throws CoreException {
        ILaunchConfiguration config = null;
        IProject project = (IProject)descriptor.getAdapter(IProject.class);
        if (project != null) {
            Map<String, ILaunchConfiguration> projectConfigs = this.configs.get(project);
            if (projectConfigs == null) {
                projectConfigs = new HashMap<String, ILaunchConfiguration>();
                this.configs.put(project, projectConfigs);
            }
            if ((config = projectConfigs.get(this.launchConfigName(descriptor, target))) == null) {
                config = this.createLaunchConfiguration(descriptor, target);
            } else {
                this.updateLaunchConfiguration(config, target);
            }
        }
        return config;
    }

    protected void updateLaunchConfiguration(ILaunchConfiguration config, ILaunchTarget target) throws CoreException {
        ILaunchConfigurationWorkingCopy workingCopy = config.getWorkingCopy();
        String targetTypeId = target.getTypeId();
        if (targetTypeId.equals("org.eclipse.cdt.dsf.gdb.remoteTCPLaunchTargetType")) {
            String targetHost = target.getAttribute("org.eclipse.cdt.dsf.gdb.HOST", EMPTY);
            String targetPort = target.getAttribute("org.eclipse.cdt.dsf.gdb.PORT", EMPTY);
            String configHost = workingCopy.getAttribute("org.eclipse.cdt.dsf.gdb.HOST", EMPTY);
            String configPort = workingCopy.getAttribute("org.eclipse.cdt.dsf.gdb.PORT", EMPTY);
            if (!configHost.equals(targetHost)) {
                workingCopy.setAttribute("org.eclipse.cdt.dsf.gdb.HOST", targetHost);
            }
            if (!configPort.equals(targetPort)) {
                workingCopy.setAttribute("org.eclipse.cdt.dsf.gdb.PORT", targetPort);
            }
        }
        if (targetTypeId.equals("org.eclipse.cdt.dsf.gdb.remoteSerialLaunchTargetType")) {
            String targetSerialPort = target.getAttribute("org.eclipse.cdt.dsf.gdb.DEV", EMPTY);
            String targetBaudRate = target.getAttribute("org.eclipse.cdt.dsf.gdb.DEV_SPEED", EMPTY);
            String configSerialPort = workingCopy.getAttribute("org.eclipse.cdt.dsf.gdb.DEV", EMPTY);
            String configBaudRate = workingCopy.getAttribute("org.eclipse.cdt.dsf.gdb.DEV", EMPTY);
            if (!configSerialPort.equals(targetSerialPort)) {
                workingCopy.setAttribute("org.eclipse.cdt.dsf.gdb.DEV", targetSerialPort);
            }
            if (!configBaudRate.equals(targetBaudRate)) {
                workingCopy.setAttribute("org.eclipse.cdt.dsf.gdb.DEV_SPEED", targetBaudRate);
            }
        }
        if (workingCopy.isDirty()) {
            workingCopy.doSave();
        }
    }

    protected void populateLaunchConfiguration(ILaunchDescriptor descriptor, ILaunchTarget target, ILaunchConfigurationWorkingCopy workingCopy) throws CoreException {
        super.populateLaunchConfiguration(descriptor, target, workingCopy);
        IProject project = (IProject)descriptor.getAdapter(IProject.class);
        workingCopy.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", project.getName());
        workingCopy.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", EMPTY);
        workingCopy.setMappedResources(new IResource[]{project});
        HashMap<String, String> remoteMap = new HashMap<String, String>();
        remoteMap.put("[debug]", "org.eclipse.cdt.dsf.gdb.launch.remoteCLaunch");
        workingCopy.setAttribute("org.eclipse.debug.core.preferred_launchers", remoteMap);
        String targetTypeId = target.getTypeId();
        if (targetTypeId.equals("org.eclipse.cdt.dsf.gdb.remoteTCPLaunchTargetType")) {
            String host = target.getAttribute("org.eclipse.cdt.dsf.gdb.HOST", EMPTY);
            String port = target.getAttribute("org.eclipse.cdt.dsf.gdb.PORT", EMPTY);
            workingCopy.setAttribute("org.eclipse.cdt.dsf.gdb.REMOTE_TCP", true);
            workingCopy.setAttribute("org.eclipse.cdt.dsf.gdb.HOST", host);
            workingCopy.setAttribute("org.eclipse.cdt.dsf.gdb.PORT", port);
        }
        if (targetTypeId.equals("org.eclipse.cdt.dsf.gdb.remoteSerialLaunchTargetType")) {
            String serialPort = target.getAttribute("org.eclipse.cdt.dsf.gdb.DEV", EMPTY);
            String baudRate = target.getAttribute("org.eclipse.cdt.dsf.gdb.DEV_SPEED", EMPTY);
            workingCopy.setAttribute("org.eclipse.cdt.dsf.gdb.REMOTE_TCP", false);
            workingCopy.setAttribute("org.eclipse.cdt.dsf.gdb.DEV", serialPort);
            workingCopy.setAttribute("org.eclipse.cdt.dsf.gdb.DEV_SPEED", baudRate);
        }
    }

    public boolean launchConfigurationAdded(ILaunchConfiguration configuration) throws CoreException {
        if (this.ownsLaunchConfiguration(configuration)) {
            IProject project = configuration.getMappedResources()[0].getProject();
            Map<String, ILaunchConfiguration> projectConfigs = this.configs.get(project);
            if (projectConfigs == null) {
                projectConfigs = new HashMap<String, ILaunchConfiguration>();
                this.configs.put(project, projectConfigs);
            }
            projectConfigs.put(configuration.getName(), configuration);
            return true;
        }
        return false;
    }

    public boolean launchConfigurationRemoved(ILaunchConfiguration configuration) throws CoreException {
        for (Map.Entry<IProject, Map<String, ILaunchConfiguration>> projectEntry : this.configs.entrySet()) {
            Map<String, ILaunchConfiguration> projectConfigs = projectEntry.getValue();
            for (Map.Entry<String, ILaunchConfiguration> entry : projectConfigs.entrySet()) {
                if (!configuration.equals(entry.getValue())) continue;
                projectConfigs.remove(entry.getKey());
                if (projectConfigs.isEmpty()) {
                    this.configs.remove(projectEntry.getKey());
                }
                return true;
            }
        }
        return false;
    }

    public boolean launchConfigurationChanged(ILaunchConfiguration configuration) throws CoreException {
        return false;
    }

    public void launchDescriptorRemoved(ILaunchDescriptor descriptor) throws CoreException {
        IProject project = (IProject)descriptor.getAdapter(IProject.class);
        if (project != null) {
            this.configs.remove(project);
        }
    }

    public void launchTargetRemoved(ILaunchTarget target) throws CoreException {
        for (Map.Entry<IProject, Map<String, ILaunchConfiguration>> projectEntry : this.configs.entrySet()) {
            Map<String, ILaunchConfiguration> projectConfigs = projectEntry.getValue();
            for (Map.Entry<String, ILaunchConfiguration> entry : projectConfigs.entrySet()) {
                ILaunchConfiguration config = entry.getValue();
                if (!config.getName().endsWith(" " + this.getNameSuffix(target))) continue;
                projectConfigs.remove(entry.getKey());
                config.delete();
            }
        }
    }
}

