"use strict";
(self["webpackChunkcdt_cloud_blueprint_app"] = self["webpackChunkcdt_cloud_blueprint_app"] || []).push([["vendors-node_modules_theia_file-search_lib_browser_file-search-frontend-module_js"],{

/***/ "../../node_modules/@theia/file-search/lib/browser/file-search-frontend-module.js":
/*!****************************************************************************************!*\
  !*** ../../node_modules/@theia/file-search/lib/browser/file-search-frontend-module.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2017 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const common_1 = __webpack_require__(/*! @theia/core/lib/common */ "../../node_modules/@theia/core/lib/common/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const quick_file_open_contribution_1 = __webpack_require__(/*! ./quick-file-open-contribution */ "../../node_modules/@theia/file-search/lib/browser/quick-file-open-contribution.js");
const quick_file_open_1 = __webpack_require__(/*! ./quick-file-open */ "../../node_modules/@theia/file-search/lib/browser/quick-file-open.js");
const file_search_service_1 = __webpack_require__(/*! ../common/file-search-service */ "../../node_modules/@theia/file-search/lib/common/file-search-service.js");
const quick_access_1 = __webpack_require__(/*! @theia/core/lib/browser/quick-input/quick-access */ "../../node_modules/@theia/core/lib/browser/quick-input/quick-access.js");
const quick_file_select_service_1 = __webpack_require__(/*! ./quick-file-select-service */ "../../node_modules/@theia/file-search/lib/browser/quick-file-select-service.js");
exports["default"] = new inversify_1.ContainerModule((bind) => {
    bind(file_search_service_1.FileSearchService).toDynamicValue(ctx => {
        const provider = ctx.container.get(browser_1.WebSocketConnectionProvider);
        return provider.createProxy(file_search_service_1.fileSearchServicePath);
    }).inSingletonScope();
    bind(quick_file_open_contribution_1.QuickFileOpenFrontendContribution).toSelf().inSingletonScope();
    [common_1.CommandContribution, browser_1.KeybindingContribution, common_1.MenuContribution, quick_access_1.QuickAccessContribution].forEach(serviceIdentifier => bind(serviceIdentifier).toService(quick_file_open_contribution_1.QuickFileOpenFrontendContribution));
    bind(quick_file_select_service_1.QuickFileSelectService).toSelf().inSingletonScope();
    bind(quick_file_open_1.QuickFileOpenService).toSelf().inSingletonScope();
});


/***/ }),

/***/ "../../node_modules/@theia/file-search/lib/browser/quick-file-open-contribution.js":
/*!*****************************************************************************************!*\
  !*** ../../node_modules/@theia/file-search/lib/browser/quick-file-open-contribution.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2017 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.QuickFileOpenFrontendContribution = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const uri_1 = __webpack_require__(/*! @theia/core/lib/common/uri */ "../../node_modules/@theia/core/lib/common/uri.js");
const quick_file_open_1 = __webpack_require__(/*! ./quick-file-open */ "../../node_modules/@theia/file-search/lib/browser/quick-file-open.js");
const browser_1 = __webpack_require__(/*! @theia/editor/lib/browser */ "../../node_modules/@theia/editor/lib/browser/index.js");
const nls_1 = __webpack_require__(/*! @theia/core/lib/common/nls */ "../../node_modules/@theia/core/lib/common/nls.js");
let QuickFileOpenFrontendContribution = class QuickFileOpenFrontendContribution {
    registerCommands(commands) {
        commands.registerCommand(quick_file_open_1.quickFileOpen, {
            // eslint-disable-next-line @typescript-eslint/no-explicit-any
            execute: (...args) => {
                let fileURI;
                if (args) {
                    [fileURI] = args;
                }
                if (fileURI) {
                    this.quickFileOpenService.openFile(new uri_1.default(fileURI));
                }
                else {
                    this.quickFileOpenService.open();
                }
            }
        });
    }
    registerKeybindings(keybindings) {
        keybindings.registerKeybinding({
            command: quick_file_open_1.quickFileOpen.id,
            keybinding: 'ctrlcmd+p'
        });
    }
    registerMenus(menus) {
        menus.registerMenuAction(browser_1.EditorMainMenu.WORKSPACE_GROUP, {
            commandId: quick_file_open_1.quickFileOpen.id,
            label: nls_1.nls.localizeByDefault('Go to File...'),
            order: '1',
        });
    }
    registerQuickAccessProvider() {
        this.quickFileOpenService.registerQuickAccessProvider();
    }
};
exports.QuickFileOpenFrontendContribution = QuickFileOpenFrontendContribution;
tslib_1.__decorate([
    (0, inversify_1.inject)(quick_file_open_1.QuickFileOpenService),
    tslib_1.__metadata("design:type", quick_file_open_1.QuickFileOpenService)
], QuickFileOpenFrontendContribution.prototype, "quickFileOpenService", void 0);
exports.QuickFileOpenFrontendContribution = QuickFileOpenFrontendContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], QuickFileOpenFrontendContribution);


/***/ }),

/***/ "../../node_modules/@theia/file-search/lib/browser/quick-file-open.js":
/*!****************************************************************************!*\
  !*** ../../node_modules/@theia/file-search/lib/browser/quick-file-open.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2017 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
var QuickFileOpenService_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.QuickFileOpenService = exports.quickFileOpen = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const quick_input_service_1 = __webpack_require__(/*! @theia/core/lib/browser/quick-input/quick-input-service */ "../../node_modules/@theia/core/lib/browser/quick-input/quick-input-service.js");
const common_1 = __webpack_require__(/*! @theia/core/lib/common */ "../../node_modules/@theia/core/lib/common/index.js");
const message_service_1 = __webpack_require__(/*! @theia/core/lib/common/message-service */ "../../node_modules/@theia/core/lib/common/message-service.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const browser_2 = __webpack_require__(/*! @theia/editor/lib/browser */ "../../node_modules/@theia/editor/lib/browser/index.js");
const navigation_location_service_1 = __webpack_require__(/*! @theia/editor/lib/browser/navigation/navigation-location-service */ "../../node_modules/@theia/editor/lib/browser/navigation/navigation-location-service.js");
const workspace_service_1 = __webpack_require__(/*! @theia/workspace/lib/browser/workspace-service */ "../../node_modules/@theia/workspace/lib/browser/workspace-service.js");
const quick_file_select_service_1 = __webpack_require__(/*! ./quick-file-select-service */ "../../node_modules/@theia/file-search/lib/browser/quick-file-select-service.js");
exports.quickFileOpen = common_1.Command.toDefaultLocalizedCommand({
    id: 'file-search.openFile',
    category: browser_1.CommonCommands.FILE_CATEGORY,
    label: 'Open File...'
});
// Supports patterns of <path><#|:><line><#|:|,><col?>
const LINE_COLON_PATTERN = /\s?[#:\(](?:line )?(\d*)(?:[#:,](\d*))?\)?\s*$/;
let QuickFileOpenService = QuickFileOpenService_1 = class QuickFileOpenService {
    constructor() {
        /**
         * Whether to hide .gitignored (and other ignored) files.
         */
        this.hideIgnoredFiles = true;
        /**
         * Whether the dialog is currently open.
         */
        this.isOpen = false;
        this.updateIsOpen = true;
        this.filterAndRangeDefault = { filter: '', range: undefined };
        /**
         * Tracks the user file search filter and location range e.g. fileFilter:line:column or fileFilter:line,column
         */
        this.filterAndRange = this.filterAndRangeDefault;
    }
    registerQuickAccessProvider() {
        this.quickAccessRegistry.registerQuickAccessProvider({
            getInstance: () => this,
            prefix: QuickFileOpenService_1.PREFIX,
            placeholder: this.getPlaceHolder(),
            helpEntries: [{ description: 'Open File', needsEditor: false }]
        });
    }
    init() {
        var _a;
        (_a = this.quickInputService) === null || _a === void 0 ? void 0 : _a.onHide(() => {
            if (this.updateIsOpen) {
                this.isOpen = false;
            }
            else {
                this.updateIsOpen = true;
            }
        });
    }
    isEnabled() {
        return this.workspaceService.opened;
    }
    open() {
        var _a;
        // Triggering the keyboard shortcut while the dialog is open toggles
        // showing the ignored files.
        if (this.isOpen) {
            this.hideIgnoredFiles = !this.hideIgnoredFiles;
            this.hideQuickPick();
        }
        else {
            this.hideIgnoredFiles = true;
            this.filterAndRange = this.filterAndRangeDefault;
            this.isOpen = true;
        }
        (_a = this.quickInputService) === null || _a === void 0 ? void 0 : _a.open(this.filterAndRange.filter);
    }
    hideQuickPick() {
        var _a;
        this.updateIsOpen = false;
        (_a = this.quickInputService) === null || _a === void 0 ? void 0 : _a.hide();
    }
    /**
     * Get a string (suitable to show to the user) representing the keyboard
     * shortcut used to open the quick file open menu.
     */
    getKeyCommand() {
        const keyCommand = this.keybindingRegistry.getKeybindingsForCommand(exports.quickFileOpen.id);
        if (keyCommand) {
            // We only consider the first keybinding.
            const accel = this.keybindingRegistry.acceleratorFor(keyCommand[0], '+');
            return accel.join(' ');
        }
        return undefined;
    }
    async getPicks(filter, token) {
        this.filterAndRange = this.splitFilterAndRange(filter);
        const fileFilter = this.filterAndRange.filter;
        return this.quickFileSelectService.getPicks(fileFilter, token, {
            hideIgnoredFiles: this.hideIgnoredFiles,
            onSelect: item => this.openFile(item.uri)
        });
    }
    openFile(uri) {
        const options = this.buildOpenerOptions();
        const closedEditor = this.navigationLocationService.closedEditorsStack.find(editor => editor.uri.path.toString() === uri.path.toString());
        this.openerService.getOpener(uri, options)
            .then(opener => opener.open(uri, options))
            .then(widget => {
            // Attempt to restore the editor state if it exists, and no selection is explicitly requested.
            if (widget instanceof browser_2.EditorWidget && closedEditor && !options.selection) {
                widget.editor.restoreViewState(closedEditor.viewState);
            }
        })
            .catch(error => {
            console.warn(error);
            this.messageService.error(common_1.nls.localizeByDefault("Unable to open '{0}'", uri.path.toString()));
        });
    }
    buildOpenerOptions() {
        return { selection: this.filterAndRange.range };
    }
    getPlaceHolder() {
        let placeholder = common_1.nls.localizeByDefault('Search files by name (append {0} to go to line or {1} to go to symbol)', ':', '@');
        const keybinding = this.getKeyCommand();
        if (keybinding) {
            placeholder += common_1.nls.localize('theia/file-search/toggleIgnoredFiles', ' (Press {0} to show/hide ignored files)', keybinding);
        }
        return placeholder;
    }
    /**
     * Splits the given expression into a structure of search-file-filter and
     * location-range.
     *
     * @param expression patterns of <path><#|:><line><#|:|,><col?>
     */
    splitFilterAndRange(expression) {
        var _a, _b;
        let filter = expression;
        let range = undefined;
        // Find line and column number from the expression using RegExp.
        const patternMatch = LINE_COLON_PATTERN.exec(expression);
        if (patternMatch) {
            const line = parseInt((_a = patternMatch[1]) !== null && _a !== void 0 ? _a : '', 10);
            if (Number.isFinite(line)) {
                const lineNumber = line > 0 ? line - 1 : 0;
                const column = parseInt((_b = patternMatch[2]) !== null && _b !== void 0 ? _b : '', 10);
                const startColumn = Number.isFinite(column) && column > 0 ? column - 1 : 0;
                const position = browser_2.Position.create(lineNumber, startColumn);
                filter = expression.substring(0, patternMatch.index);
                range = browser_2.Range.create(position, position);
            }
        }
        return { filter, range };
    }
};
exports.QuickFileOpenService = QuickFileOpenService;
QuickFileOpenService.PREFIX = '';
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.KeybindingRegistry),
    tslib_1.__metadata("design:type", browser_1.KeybindingRegistry)
], QuickFileOpenService.prototype, "keybindingRegistry", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(workspace_service_1.WorkspaceService),
    tslib_1.__metadata("design:type", workspace_service_1.WorkspaceService)
], QuickFileOpenService.prototype, "workspaceService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.OpenerService),
    tslib_1.__metadata("design:type", Object)
], QuickFileOpenService.prototype, "openerService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(quick_input_service_1.QuickInputService),
    (0, inversify_1.optional)(),
    tslib_1.__metadata("design:type", Object)
], QuickFileOpenService.prototype, "quickInputService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.QuickAccessRegistry),
    tslib_1.__metadata("design:type", Object)
], QuickFileOpenService.prototype, "quickAccessRegistry", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(navigation_location_service_1.NavigationLocationService),
    tslib_1.__metadata("design:type", navigation_location_service_1.NavigationLocationService)
], QuickFileOpenService.prototype, "navigationLocationService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(message_service_1.MessageService),
    tslib_1.__metadata("design:type", message_service_1.MessageService)
], QuickFileOpenService.prototype, "messageService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(quick_file_select_service_1.QuickFileSelectService),
    tslib_1.__metadata("design:type", quick_file_select_service_1.QuickFileSelectService)
], QuickFileOpenService.prototype, "quickFileSelectService", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], QuickFileOpenService.prototype, "init", null);
exports.QuickFileOpenService = QuickFileOpenService = QuickFileOpenService_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], QuickFileOpenService);


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_theia_file-search_lib_browser_file-search-frontend-module_js.js.map