/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.helpers;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ClassFileInstaller {
    public static boolean DEBUG = Boolean.getBoolean("ClassFileInstaller.debug");

    public static void main(String ... args) throws Exception {
        if (args.length > 1 && args[0].equals("-jar")) {
            if (args.length < 2) {
                throw new RuntimeException("Usage: jdk.test.lib.helpers.ClassFileInstaller <options> <classes>\nwhere possible options include:\n  -jar <path>             Write to the JAR file <path>");
            }
            String jarFile = args[1];
            String[] classes = ClassFileInstaller.addInnerClasses(args, 2);
            ClassFileInstaller.writeJar_impl(jarFile, null, classes);
        } else {
            String[] classes;
            if (DEBUG) {
                System.out.println("ClassFileInstaller: Writing to " + System.getProperty("user.dir"));
            }
            for (String cls : classes = ClassFileInstaller.addInnerClasses(args, 0)) {
                ClassFileInstaller.writeClassToDisk(cls);
            }
        }
    }

    private static String[] addInnerClasses(String[] classes, int startIdx) {
        boolean seenNewWb = false;
        boolean seenNewWbInner = false;
        String newWb = "jdk.test.whitebox.WhiteBox";
        String newWbInner = "jdk.test.whitebox.WhiteBox$WhiteBoxPermission";
        ArrayList<String> list = new ArrayList<String>();
        block8: for (int i = startIdx; i < classes.length; ++i) {
            String cls = classes[i];
            list.add(cls);
            switch (cls) {
                case "jdk.test.whitebox.WhiteBox": {
                    seenNewWb = true;
                    continue block8;
                }
                case "jdk.test.whitebox.WhiteBox$WhiteBoxPermission": {
                    seenNewWbInner = true;
                }
            }
        }
        if (seenNewWb && !seenNewWbInner) {
            list.add("jdk.test.whitebox.WhiteBox$WhiteBoxPermission");
        }
        String[] array = new String[list.size()];
        list.toArray(array);
        return array;
    }

    private static void writeJar_impl(String jarFile, Manifest manifest, String[] classes) throws Exception {
        if (DEBUG) {
            System.out.println("ClassFileInstaller: Writing to " + ClassFileInstaller.getJarPath(jarFile));
        }
        new File(jarFile).delete();
        FileOutputStream fos = new FileOutputStream(jarFile);
        ZipOutputStream zos = new ZipOutputStream(fos);
        if (manifest != null) {
            ClassFileInstaller.writeToDisk(zos, "META-INF/MANIFEST.MF", manifest.getInputStream());
        }
        for (String cls : classes) {
            ClassFileInstaller.writeClassToDisk(zos, cls);
        }
        zos.close();
        fos.close();
    }

    public static String writeJar(String jarFile, String ... classes) throws Exception {
        classes = ClassFileInstaller.addInnerClasses(classes, 0);
        ClassFileInstaller.writeJar_impl(jarFile, null, classes);
        return ClassFileInstaller.getJarPath(jarFile);
    }

    public static String writeJar(String jarFile, Manifest manifest, String ... classes) throws Exception {
        classes = ClassFileInstaller.addInnerClasses(classes, 0);
        ClassFileInstaller.writeJar_impl(jarFile, manifest, classes);
        return ClassFileInstaller.getJarPath(jarFile);
    }

    public static String getJarPath(String jarFileName) {
        return new File(jarFileName).getAbsolutePath();
    }

    public static void writeClassToDisk(String className) throws Exception {
        ClassFileInstaller.writeClassToDisk((ZipOutputStream)null, className);
    }

    private static void writeClassToDisk(ZipOutputStream zos, String className) throws Exception {
        ClassFileInstaller.writeClassToDisk(zos, className, "");
    }

    public static void writeClassToDisk(String className, String prependPath) throws Exception {
        ClassFileInstaller.writeClassToDisk(null, className, prependPath);
    }

    private static void writeClassToDisk(ZipOutputStream zos, String className, String prependPath) throws Exception {
        Object pathName;
        ClassLoader cl = ClassFileInstaller.class.getClassLoader();
        InputStream is = cl.getResourceAsStream((String)(pathName = className.replace('.', '/').concat(".class")));
        if (is == null) {
            throw new RuntimeException("Failed to find " + (String)pathName);
        }
        if (prependPath.length() > 0) {
            pathName = prependPath + "/" + (String)pathName;
        }
        ClassFileInstaller.writeToDisk(zos, (String)pathName, is);
    }

    public static void writeClassToDisk(String className, byte[] bytecode) throws Exception {
        ClassFileInstaller.writeClassToDisk(null, className, bytecode);
    }

    private static void writeClassToDisk(ZipOutputStream zos, String className, byte[] bytecode) throws Exception {
        ClassFileInstaller.writeClassToDisk(zos, className, bytecode, "");
    }

    public static void writeClassToDisk(String className, byte[] bytecode, String prependPath) throws Exception {
        ClassFileInstaller.writeClassToDisk(null, className, bytecode, prependPath);
    }

    private static void writeClassToDisk(ZipOutputStream zos, String className, byte[] bytecode, String prependPath) throws Exception {
        Object pathName = className.replace('.', '/').concat(".class");
        if (prependPath.length() > 0) {
            pathName = prependPath + "/" + (String)pathName;
        }
        ClassFileInstaller.writeToDisk(zos, (String)pathName, new ByteArrayInputStream(bytecode));
    }

    private static void writeToDisk(ZipOutputStream zos, String pathName, InputStream is) throws Exception {
        if (DEBUG) {
            System.out.println("ClassFileInstaller: Writing " + pathName);
        }
        if (zos != null) {
            int len;
            ZipEntry ze = new ZipEntry(pathName);
            zos.putNextEntry(ze);
            byte[] buf = new byte[1024];
            while ((len = is.read(buf)) > 0) {
                zos.write(buf, 0, len);
            }
        } else {
            Path p = Paths.get(pathName, new String[0]);
            if (pathName.contains("/")) {
                Files.createDirectories(p.getParent(), new FileAttribute[0]);
            }
            Files.copy(is, p, StandardCopyOption.REPLACE_EXISTING);
        }
        is.close();
    }

    public static class Manifest {
        private final InputStream in;

        private Manifest(InputStream in) {
            this.in = in;
        }

        public static Manifest fromSourceFile(String fileName) throws Exception {
            String pathName = System.getProperty("test.src") + File.separator + fileName;
            return new Manifest(new FileInputStream(pathName));
        }

        public static Manifest fromString(String manifest) throws Exception {
            return new Manifest(new ByteArrayInputStream(manifest.getBytes()));
        }

        public InputStream getInputStream() {
            return this.in;
        }
    }
}

