/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.autotools.ui.editors.outline;

import org.eclipse.cdt.autotools.ui.editors.AutoconfEditor;
import org.eclipse.cdt.autotools.ui.editors.parser.AutoconfElement;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class AutoconfContentProvider
implements ITreeContentProvider {
    private IDocumentProvider documentProvider;
    private AutoconfEditor editor;
    protected static final String SECTION_POSITIONS = "section_positions";
    protected IPositionUpdater positionUpdater = new DefaultPositionUpdater("section_positions");

    public AutoconfContentProvider(ITextEditor editor) {
        if (editor instanceof AutoconfEditor) {
            this.editor = (AutoconfEditor)editor;
        }
        this.documentProvider = editor.getDocumentProvider();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        IDocument document;
        if (oldInput != null && (document = this.documentProvider.getDocument(oldInput)) != null) {
            try {
                document.removePositionCategory(SECTION_POSITIONS);
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
                // empty catch block
            }
            document.removePositionUpdater(this.positionUpdater);
        }
        if (newInput != null && (document = this.documentProvider.getDocument(newInput)) != null) {
            document.addPositionCategory(SECTION_POSITIONS);
            document.addPositionUpdater(this.positionUpdater);
        }
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof AutoconfElement) {
            AutoconfElement element = (AutoconfElement)parentElement;
            return element.getChildren();
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof AutoconfElement) {
            return ((AutoconfElement)element).hasChildren();
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(this.editor.getRootElement());
    }
}

