/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.egit.core.AdapterUtils;
import org.eclipse.egit.core.RepositoryCache;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.core.UnitOfWork;
import org.eclipse.egit.core.info.GitInfo;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.UIPreferences;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.CompareUtils;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.commit.DiffDocument;
import org.eclipse.egit.ui.internal.commit.DiffRegionFormatter;
import org.eclipse.egit.ui.internal.commit.DiffViewer;
import org.eclipse.egit.ui.internal.commit.FocusTracker;
import org.eclipse.egit.ui.internal.components.DropDownMenuAction;
import org.eclipse.egit.ui.internal.components.RepositoryMenuUtil;
import org.eclipse.egit.ui.internal.fetch.FetchHeadChangedEvent;
import org.eclipse.egit.ui.internal.history.CommitAndDiffComponent;
import org.eclipse.egit.ui.internal.history.CommitFileDiffViewer;
import org.eclipse.egit.ui.internal.history.CommitGraphTable;
import org.eclipse.egit.ui.internal.history.CommitMessageViewer;
import org.eclipse.egit.ui.internal.history.FileDiff;
import org.eclipse.egit.ui.internal.history.FileDiffInput;
import org.eclipse.egit.ui.internal.history.FindToolbar;
import org.eclipse.egit.ui.internal.history.GenerateHistoryJob;
import org.eclipse.egit.ui.internal.history.GitHistoryRefFilterConfigurationDialog;
import org.eclipse.egit.ui.internal.history.GitHistorySelectionTracker;
import org.eclipse.egit.ui.internal.history.GitHistoryWalk;
import org.eclipse.egit.ui.internal.history.HistoryPageInput;
import org.eclipse.egit.ui.internal.history.ICommitsProvider;
import org.eclipse.egit.ui.internal.history.RefFilterHelper;
import org.eclipse.egit.ui.internal.history.RenameTracker;
import org.eclipse.egit.ui.internal.history.SWTCommit;
import org.eclipse.egit.ui.internal.history.SWTCommitList;
import org.eclipse.egit.ui.internal.history.SWTWalk;
import org.eclipse.egit.ui.internal.history.SearchBar;
import org.eclipse.egit.ui.internal.history.TableLoader;
import org.eclipse.egit.ui.internal.repository.tree.AdditionalRefNode;
import org.eclipse.egit.ui.internal.repository.tree.FileNode;
import org.eclipse.egit.ui.internal.repository.tree.FolderNode;
import org.eclipse.egit.ui.internal.repository.tree.RefNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNodeType;
import org.eclipse.egit.ui.internal.repository.tree.TagNode;
import org.eclipse.egit.ui.internal.selection.MultiViewerSelectionProvider;
import org.eclipse.egit.ui.internal.selection.RepositorySelectionProvider;
import org.eclipse.egit.ui.internal.selection.SelectionUtils;
import org.eclipse.egit.ui.internal.trace.GitTraceLocation;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.jface.action.SubToolBarManager;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.diff.DiffConfig;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.events.ListenerHandle;
import org.eclipse.jgit.events.RefsChangedEvent;
import org.eclipse.jgit.events.RefsChangedListener;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.FollowFilter;
import org.eclipse.jgit.revwalk.RenameCallback;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.OrTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.team.ui.history.HistoryPage;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.IUpdate;

public class GitHistoryPage
extends HistoryPage
implements RefsChangedListener,
TableLoader,
IShowInSource,
IShowInTargetList {
    private static final String CSS_CLASS = "org-eclipse-egit-ui-GitHistoryPage";
    private static final String TEAM_UI_PLUGIN_ID = "org.eclipse.team.ui";
    private static final String TEAM_UI_LINKING_PREFERENCE = "pref_generichistory_view_linking";
    private static final int INITIAL_ITEM = -1;
    private static final String P_REPOSITORY = "GitHistoryPage.Repository";
    private static final EnumSet SUPPORTED_REPOSITORY_NODE_TYPES = EnumSet.of(RepositoryTreeNodeType.REPO, new RepositoryTreeNodeType[]{RepositoryTreeNodeType.REF, RepositoryTreeNodeType.ADDITIONALREF, RepositoryTreeNodeType.TAG, RepositoryTreeNodeType.FOLDER, RepositoryTreeNodeType.FILE, RepositoryTreeNodeType.WORKINGDIR});
    private static final String POPUP_ID = "org.eclipse.egit.ui.historyPageContributions";
    private static final String DESCRIPTION_PATTERN = "{0} - {1}";
    private static final String NAME_PATTERN = "{0}: {1} [{2}]";
    private static final String PREF_SHOWALLFILTER = "org.eclipse.egit.ui.githistorypage.showallfilter";
    private ShowFilter showAllFilter = ShowFilter.SHOWALLRESOURCE;
    private GitHistoryPageActions actions;
    private StyledText errorText;
    private final IPersistentPreferenceStore store = (IPersistentPreferenceStore)Activator.getDefault().getPreferenceStore();
    private ListenerHandle myRefsChangedHandle;
    private HistoryPageInput input;
    private String name;
    private boolean trace = GitTraceLocation.HISTORYVIEW.isActive();
    private Composite topControl;
    private Composite historyControl;
    private SashForm graphDetailSplit;
    private SashForm revInfoSplit;
    private CommitGraphTable graph;
    private CommitAndDiffComponent commitAndDiff;
    private CommitFileDiffViewer fileViewer;
    private Composite warningComposite;
    private CLabel warningLabel;
    private final MenuManager popupMgr = new MenuManager(null, "org.eclipse.egit.ui.historyPageContributions");
    private GenerateHistoryJob job;
    private final ResourceManager resources = new LocalResourceManager(JFaceResources.getResources());
    private AnyObjectId currentHeadId;
    private AnyObjectId currentFetchHeadId;
    private Repository currentRepo;
    private ObjectId selectedObj;
    private String currentRefFilters;
    private boolean currentShowFirstParentOnly;
    private boolean currentShowAdditionalRefs;
    private boolean currentShowNotes;
    private boolean currentFollowRenames;
    private Set<String> fileViewerInterestingPaths;
    private TreeWalk fileDiffWalker;
    private final IPropertyChangeListener listener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            String prop = event.getProperty();
            if ("HistoryView_MaxBranchLength".equals(prop) || "HistoryView_MaxTagLength".equals(prop)) {
                GitHistoryPage.this.graph.getTableView().refresh();
            }
            if ("resourcehistory_show_comment_wrap".equals(prop)) {
                GitHistoryPage.this.commitAndDiff.setWrap((Boolean)event.getNewValue());
            }
        }
    };
    private final IEclipsePreferences.IPreferenceChangeListener prefListener = event -> {
        Composite control;
        if (!"GitRepositoriesView.GitDirectories.relative".equals(event.getKey())) {
            return;
        }
        if (!(this.getCurrentRepo() != null && RepositoryUtil.INSTANCE.contains(this.getCurrentRepo()) || (control = this.historyControl).isDisposed())) {
            control.getDisplay().asyncExec(() -> this.lambda$1((Control)control));
        }
        Object oldValue = event.getOldValue();
        String pathSep = File.pathSeparator;
        if (oldValue != null) {
            String[] oldPaths = oldValue.toString().split(pathSep);
            ArrayList<String> removedPaths = new ArrayList<String>(Arrays.asList(oldPaths));
            Object newValue = event.getNewValue();
            if (newValue != null) {
                String[] newPaths;
                String[] stringArray = newPaths = newValue.toString().split(pathSep);
                int n = newPaths.length;
                int n2 = 0;
                while (n2 < n) {
                    String path = stringArray[n2];
                    removedPaths.remove(path);
                    ++n2;
                }
            }
            for (String path : removedPaths) {
                this.unsetRepoSpecificPreference(path, "resourcehistory_show_first_parent_only");
            }
            this.saveStoreIfNeeded();
        }
    };
    private GitHistorySelectionTracker selectionTracker;
    private List<FilterPath> pathFilters;
    private Runnable refschangedRunnable;
    private final RenameTracker renameTracker = new RenameTracker();
    private final HistoryPageRule pageSchedulingRule;
    private SearchBar searchBar;
    private FocusTracker focusTracker;

    public static boolean isLinkingEnabled() {
        return Platform.getPreferencesService().getBoolean(TEAM_UI_PLUGIN_ID, TEAM_UI_LINKING_PREFERENCE, false, null);
    }

    public static boolean canShowHistoryFor(Object object) {
        if (object instanceof HistoryPageInput) {
            return true;
        }
        if (object instanceof IResource) {
            return GitHistoryPage.typeOk((IResource)object);
        }
        if (object instanceof RepositoryTreeNode) {
            return SUPPORTED_REPOSITORY_NODE_TYPES.contains((Object)((RepositoryTreeNode)object).getType());
        }
        if (object instanceof Path) {
            return true;
        }
        IResource resource = AdapterUtils.adaptToAnyResource((Object)object);
        if (resource != null && GitHistoryPage.typeOk(resource)) {
            return true;
        }
        if (Adapters.adapt((Object)object, GitInfo.class) != null) {
            return true;
        }
        return Adapters.adapt((Object)object, Repository.class) != null;
    }

    private static boolean typeOk(IResource object) {
        switch (object.getType()) {
            case 1: 
            case 2: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    public GitHistoryPage() {
        this.trace = GitTraceLocation.HISTORYVIEW.isActive();
        this.pageSchedulingRule = new HistoryPageRule();
        if (this.trace) {
            GitTraceLocation.getTrace().traceEntry(GitTraceLocation.HISTORYVIEW.getLocation());
        }
    }

    public void createControl(Composite parent) {
        this.trace = GitTraceLocation.HISTORYVIEW.isActive();
        if (this.trace) {
            GitTraceLocation.getTrace().traceEntry(GitTraceLocation.HISTORYVIEW.getLocation());
        }
        this.attachSelectionTracker();
        this.historyControl = this.createMainPanel(parent);
        this.warningComposite = new Composite(this.historyControl, 0);
        this.warningComposite.setLayout((Layout)new GridLayout(2, false));
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).exclude(true).applyTo((Control)this.warningComposite);
        this.warningComposite.setVisible(false);
        this.warningLabel = new CLabel(this.warningComposite, 0);
        this.warningLabel.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK"));
        this.warningLabel.setToolTipText(UIText.GitHistoryPage_IncompleteListTooltip);
        Link preferencesLink = new Link(this.warningComposite, 0);
        preferencesLink.setText(UIText.GitHistoryPage_PreferencesLink);
        preferencesLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String preferencePageId = "org.eclipse.egit.ui.internal.preferences.HistoryPreferencePage";
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)GitHistoryPage.this.getSite().getShell(), (String)preferencePageId, (String[])new String[]{preferencePageId}, null);
                dialog.open();
            }
        });
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.historyControl);
        this.graphDetailSplit = new SashForm(this.historyControl, 512);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.graphDetailSplit);
        this.graph = new CommitGraphTable((Composite)this.graphDetailSplit, this.getSite(), this.popupMgr, this, this.resources);
        UIUtils.setCssClass((Widget)this.graph.getTable(), CSS_CLASS);
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(this.listener);
        this.revInfoSplit = new SashForm((Composite)this.graphDetailSplit, 256);
        this.commitAndDiff = new CommitAndDiffComponent((Composite)this.revInfoSplit, this.getPartSite());
        this.commitAndDiff.setWrap(this.store.getBoolean("resourcehistory_show_comment_wrap"));
        this.fileViewer = new CommitFileDiffViewer((Composite)this.revInfoSplit, (IWorkbenchSite)this.getSite());
        this.fileViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                ArrayList<FileDiff> diffs = new ArrayList<FileDiff>();
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection sel = (IStructuredSelection)selection;
                    for (Object obj : sel.toList()) {
                        if (!(obj instanceof FileDiff)) continue;
                        diffs.add((FileDiff)obj);
                    }
                }
                GitHistoryPage.this.formatDiffs(diffs);
            }
        });
        UIUtils.setCssClass((Widget)this.fileViewer.getControl(), CSS_CLASS);
        this.layoutSashForm(this.graphDetailSplit, "resourcehistory_graph_split");
        this.layoutSashForm(this.revInfoSplit, "resourcehistory_rev_split");
        this.attachCommitSelectionChanged();
        this.initActions();
        this.getSite().setSelectionProvider((ISelectionProvider)new RepositorySelectionProvider((ISelectionProvider)new MultiViewerSelectionProvider(new Viewer[]{this.graph.getTableView(), this.fileViewer}), () -> {
            HistoryPageInput myInput = this.getInputInternal();
            return myInput != null ? myInput.getRepository() : null;
        }));
        this.getSite().registerContextMenu(POPUP_ID, this.popupMgr, (ISelectionProvider)this.graph.getTableView());
        this.getSite().registerContextMenu("org.eclipse.egit.ui.fileDiffContributions", this.fileViewer.getMenuManager(), (ISelectionProvider)this.fileViewer);
        this.focusTracker = new FocusTracker();
        this.trackFocus((Control)this.graph.getTable());
        this.trackFocus(this.commitAndDiff.getDiffViewer().getControl());
        this.trackFocus(this.commitAndDiff.getCommitViewer().getControl());
        this.trackFocus(this.fileViewer.getControl());
        this.layout();
        this.myRefsChangedHandle = RepositoryCache.INSTANCE.getGlobalListenerList().addRefsChangedListener((RefsChangedListener)this);
        InstanceScope.INSTANCE.getNode("org.eclipse.egit.core").addPreferenceChangeListener(this.prefListener);
        IToolBarManager manager = this.getSite().getActionBars().getToolBarManager();
        this.searchBar = new HistorySearchBar(GitHistoryPage.class.getName() + ".searchBar", this.graph, this.actions.findAction, this.getSite().getActionBars());
        manager.prependToGroup("org.eclipse.team.ui.historyView", (IContributionItem)this.searchBar);
        this.getSite().getActionBars().updateActionBars();
        if (this.trace) {
            GitTraceLocation.getTrace().traceExit(GitTraceLocation.HISTORYVIEW.getLocation());
        }
    }

    private void trackFocus(Control control) {
        if (control != null) {
            this.focusTracker.addToFocusTracking(control);
        }
    }

    private void layoutSashForm(final SashForm sf, final String key) {
        sf.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                int[] w = sf.getWeights();
                GitHistoryPage.this.store.putValue(key, UIPreferences.intArrayToString(w));
                GitHistoryPage.this.saveStoreIfNeeded();
            }
        });
        int[] weights = UIPreferences.stringToIntArray(this.store.getString(key), 2);
        if (weights == null) {
            weights = UIPreferences.stringToIntArray(this.store.getDefaultString(key), 2);
        }
        sf.setWeights(weights);
    }

    private Composite createMainPanel(Composite parent) {
        this.topControl = new Composite(parent, 0);
        StackLayout layout = new StackLayout();
        this.topControl.setLayout((Layout)layout);
        Composite c = new Composite(this.topControl, 0);
        layout.topControl = c;
        this.errorText = new StyledText(this.topControl, 0);
        this.errorText.setFont(UIUtils.getFont("org.eclipse.egit.ui.CommitMessageFont"));
        GridLayout parentLayout = new GridLayout();
        parentLayout.marginHeight = 0;
        parentLayout.marginWidth = 0;
        parentLayout.verticalSpacing = 0;
        c.setLayout((Layout)parentLayout);
        return c;
    }

    private void layout() {
        boolean showComment = this.store.getBoolean("resourcehistory_show_rev_comment");
        boolean showFiles = this.store.getBoolean("resourcehistory_show_rev_detail");
        if (showComment && showFiles) {
            this.graphDetailSplit.setMaximizedControl(null);
            this.revInfoSplit.setMaximizedControl(null);
        } else if (showComment && !showFiles) {
            this.graphDetailSplit.setMaximizedControl(null);
            this.revInfoSplit.setMaximizedControl(this.commitAndDiff.getCommitViewer().getControl());
        } else if (!showComment && showFiles) {
            this.graphDetailSplit.setMaximizedControl(null);
            this.revInfoSplit.setMaximizedControl(this.fileViewer.getControl());
        } else if (!showComment && !showFiles) {
            this.graphDetailSplit.setMaximizedControl(this.graph.getControl());
        }
        this.historyControl.layout();
    }

    private void attachCommitSelectionChanged() {
        final CommitMessageViewer commentViewer = this.commitAndDiff.getCommitViewer();
        this.graph.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection s = event.getSelection();
                if (s.isEmpty() || !(s instanceof IStructuredSelection)) {
                    commentViewer.setInput(null);
                    GitHistoryPage.this.fileViewer.newInput(null);
                    return;
                }
                IStructuredSelection sel = (IStructuredSelection)s;
                if (sel.size() > 1) {
                    commentViewer.setInput(null);
                    GitHistoryPage.this.fileViewer.newInput(null);
                    return;
                }
                if (GitHistoryPage.this.input == null) {
                    return;
                }
                SWTCommit c = (SWTCommit)((Object)sel.getFirstElement());
                if (c == commentViewer.getInput()) {
                    return;
                }
                commentViewer.setInput((Object)c);
                boolean firstParentOnly = GitHistoryPage.this.isShowFirstParentOnly();
                try {
                    Throwable throwable = null;
                    Object var7_9 = null;
                    try (RevWalk walk = new RevWalk(GitHistoryPage.this.input.getRepository());){
                        RevCommit unfilteredCommit = walk.parseCommit((AnyObjectId)c);
                        RevCommit[] revCommitArray = unfilteredCommit.getParents();
                        int n = revCommitArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            RevCommit parent = revCommitArray[n2];
                            walk.parseBody((RevObject)parent);
                            ++n2;
                        }
                        GitHistoryPage.this.fileViewer.newInput(new FileDiffInput(GitHistoryPage.this.input.getRepository(), GitHistoryPage.this.fileDiffWalker, unfilteredCommit, GitHistoryPage.this.fileViewerInterestingPaths, GitHistoryPage.this.input.getSingleFile() != null, firstParentOnly));
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    GitHistoryPage.this.fileViewer.newInput(new FileDiffInput(GitHistoryPage.this.input.getRepository(), GitHistoryPage.this.fileDiffWalker, (RevCommit)c, GitHistoryPage.this.fileViewerInterestingPaths, GitHistoryPage.this.input.getSingleFile() != null, firstParentOnly));
                }
            }
        });
        commentViewer.addCommitNavigationListener(this.graph::selectCommit);
    }

    private void attachSelectionTracker() {
        if (this.selectionTracker == null) {
            this.selectionTracker = new GitHistorySelectionTracker();
            this.selectionTracker.attach(this.getSite().getPage());
        }
    }

    private void detachSelectionTracker() {
        if (this.selectionTracker != null) {
            this.selectionTracker.detach(this.getSite().getPage());
        }
    }

    private void initActions() {
        try {
            this.showAllFilter = ShowFilter.valueOf(Activator.getDefault().getPreferenceStore().getString(PREF_SHOWALLFILTER));
        }
        catch (IllegalArgumentException e) {
            this.showAllFilter = ShowFilter.SHOWALLRESOURCE;
        }
        this.actions = new GitHistoryPageActions(this);
        this.setupToolBar();
        this.setupViewMenu();
    }

    private void setupToolBar() {
        IToolBarManager mgr = this.getSite().getActionBars().getToolBarManager();
        mgr.add(this.actions.findAction);
        mgr.add((IAction)this.actions.switchRepositoryAction);
        mgr.add((IAction)this.actions.filterAction);
        mgr.add((IAction)this.actions.compareModeAction);
        mgr.add((IAction)this.actions.selectShownRefsAction);
        mgr.add((IAction)this.actions.showFirstParentOnlyAction);
    }

    private void setupViewMenu() {
        IMenuManager viewMenuMgr = this.getSite().getActionBars().getMenuManager();
        viewMenuMgr.add(this.actions.refreshAction);
        viewMenuMgr.add((IContributionItem)new Separator());
        MenuManager columnsMenuMgr = new MenuManager(UIText.GitHistoryPage_ColumnsSubMenuLabel);
        viewMenuMgr.add((IContributionItem)columnsMenuMgr);
        TableColumn[] columns = this.graph.getTableView().getTable().getColumns();
        int i = 0;
        while (i < columns.length) {
            if (i != 1) {
                ColumnAction action = new ColumnAction(columns[i].getText(), i);
                columnsMenuMgr.add((IAction)action);
                columns[i].addListener(11, event -> action.update());
            }
            ++i;
        }
        MenuManager showSubMenuMgr = new MenuManager(UIText.GitHistoryPage_ShowSubMenuLabel);
        viewMenuMgr.add((IContributionItem)showSubMenuMgr);
        showSubMenuMgr.add((IAction)this.actions.showFirstParentOnlyAction);
        showSubMenuMgr.add((IAction)this.actions.showAdditionalRefsAction);
        showSubMenuMgr.add((IAction)this.actions.showNotesAction);
        showSubMenuMgr.add((IAction)this.actions.followRenamesAction);
        showSubMenuMgr.add((IContributionItem)new Separator());
        showSubMenuMgr.add(this.actions.findAction);
        showSubMenuMgr.add((IAction)this.actions.showCommentAction);
        showSubMenuMgr.add((IAction)this.actions.showFilesAction);
        showSubMenuMgr.add((IContributionItem)new Separator());
        showSubMenuMgr.add((IAction)this.actions.showRelativeDateAction);
        showSubMenuMgr.add((IAction)this.actions.showEmailAddressesAction);
        MenuManager showInMessageManager = new MenuManager(UIText.GitHistoryPage_InRevisionCommentSubMenuLabel);
        showSubMenuMgr.add((IContributionItem)showInMessageManager);
        showInMessageManager.add((IAction)this.actions.showBranchSequenceAction);
        showInMessageManager.add((IAction)this.actions.showTagSequenceAction);
        showInMessageManager.add((IAction)this.actions.wrapCommentAction);
        showInMessageManager.add((IAction)this.actions.fillCommentAction);
        viewMenuMgr.add((IAction)this.actions.filterAction);
        viewMenuMgr.add((IAction)this.actions.configureFiltersAction);
        viewMenuMgr.add((IContributionItem)new Separator());
        viewMenuMgr.add((IAction)this.actions.compareModeAction);
        viewMenuMgr.add((IAction)this.actions.reuseCompareEditorAction);
    }

    public void dispose() {
        this.trace = GitTraceLocation.HISTORYVIEW.isActive();
        if (this.trace) {
            GitTraceLocation.getTrace().traceEntry(GitTraceLocation.HISTORYVIEW.getLocation());
        }
        if (this.focusTracker != null) {
            this.focusTracker.dispose();
            this.focusTracker = null;
        }
        this.detachSelectionTracker();
        Activator.getDefault().getPreferenceStore().removePropertyChangeListener(this.listener);
        InstanceScope.INSTANCE.getNode("org.eclipse.egit.core").removePreferenceChangeListener(this.prefListener);
        if (this.myRefsChangedHandle != null) {
            this.myRefsChangedHandle.remove();
            this.myRefsChangedHandle = null;
        }
        this.resources.dispose();
        for (ActionFactory.IWorkbenchAction action : this.actions.actionsToDispose) {
            action.dispose();
        }
        this.actions.actionsToDispose.clear();
        this.releaseGenerateHistoryJob();
        if (this.popupMgr != null) {
            IContributionItem i;
            IContributionItem[] iContributionItemArray = this.popupMgr.getItems();
            int n = iContributionItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                i = iContributionItemArray[n2];
                if (i instanceof ActionFactory.IWorkbenchAction) {
                    ((ActionFactory.IWorkbenchAction)i).dispose();
                }
                ++n2;
            }
            iContributionItemArray = this.getSite().getActionBars().getMenuManager().getItems();
            n = iContributionItemArray.length;
            n2 = 0;
            while (n2 < n) {
                i = iContributionItemArray[n2];
                if (i instanceof ActionFactory.IWorkbenchAction) {
                    ((ActionFactory.IWorkbenchAction)i).dispose();
                }
                ++n2;
            }
        }
        this.renameTracker.reset(null);
        Job.getJobManager().cancel(JobFamilies.HISTORY_DIFF);
        this.setCurrentRepo(null);
        this.selectedObj = null;
        super.dispose();
    }

    public void setFocus() {
        if (this.repoHasBeenRemoved(this.getCurrentRepo())) {
            this.clearHistoryPage();
            this.graph.getControl().setFocus();
        } else {
            Control control = this.focusTracker.getLastFocusControl();
            if (control == null) {
                control = this.graph.getControl();
            }
            control.setFocus();
        }
    }

    private boolean repoHasBeenRemoved(Repository repo) {
        return repo != null && repo.getDirectory() != null && !repo.getDirectory().exists();
    }

    private void clearHistoryPage() {
        this.setCurrentRepo(null);
        this.selectedObj = null;
        this.name = "";
        this.input = null;
        this.commitAndDiff.getCommitViewer().setInput(null);
        this.fileViewer.newInput(null);
        this.setInput(null);
    }

    private void clearViewers() {
        TableViewer viewer = this.graph.getTableView();
        viewer.setSelection((ISelection)StructuredSelection.EMPTY);
        viewer.setInput((Object)new SWTCommit[0]);
    }

    public Control getControl() {
        return this.topControl;
    }

    public void refresh() {
        this.refresh(null);
    }

    public void refresh(RevCommit toSelect) {
        if (this.repoHasBeenRemoved(this.getCurrentRepo())) {
            this.clearHistoryPage();
        }
        this.input = null;
        this.inputSet(toSelect);
    }

    public void setCompareMode(boolean compareMode) {
        this.store.setValue("resourcehistory_compare_mode", compareMode);
    }

    private RevCommit selectedCommit() {
        IStructuredSelection selection = this.graph.getTableView().getStructuredSelection();
        if (!selection.isEmpty()) {
            return (RevCommit)Adapters.adapt((Object)selection.getFirstElement(), RevCommit.class);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRefsChanged(RefsChangedEvent e) {
        if (this.input == null || e.getRepository() != this.input.getRepository()) {
            return;
        }
        if (this.getControl().isDisposed()) {
            return;
        }
        GitHistoryPage gitHistoryPage = this;
        synchronized (gitHistoryPage) {
            if (this.refschangedRunnable == null) {
                this.refschangedRunnable = () -> {
                    if (!this.getControl().isDisposed()) {
                        if (GitTraceLocation.HISTORYVIEW.isActive()) {
                            GitTraceLocation.getTrace().trace(GitTraceLocation.HISTORYVIEW.getLocation(), "Executing async repository changed event");
                        }
                        this.refschangedRunnable = null;
                        this.initAndStartRevWalk(!(e instanceof FetchHeadChangedEvent));
                    }
                };
                this.getControl().getDisplay().asyncExec(this.refschangedRunnable);
            }
        }
    }

    private IStructuredSelection getSelection() {
        if (this.selectionTracker != null && this.selectionTracker.getSelection() != null) {
            return this.selectionTracker.getSelection();
        }
        ISelection selection = this.getSite().getPage().getSelection();
        if (selection != null) {
            return SelectionUtils.getStructuredSelection(selection);
        }
        return null;
    }

    private Object getMostFittingInput(Object object) {
        HistoryPageInput mostFittingInput;
        IStructuredSelection selection = this.getSelection();
        if (selection != null && !selection.isEmpty() && (mostFittingInput = SelectionUtils.getMostFittingInput(selection, object)) != null) {
            return mostFittingInput;
        }
        return object;
    }

    public boolean setInput(Object object) {
        try {
            Object useAsInput = this.getMostFittingInput(object);
            if (this.selectionTracker != null) {
                this.selectionTracker.clearSelection();
            }
            this.trace = GitTraceLocation.HISTORYVIEW.isActive();
            if (this.trace) {
                GitTraceLocation.getTrace().traceEntry(GitTraceLocation.HISTORYVIEW.getLocation(), useAsInput);
            }
            if (useAsInput == super.getInput()) {
                return true;
            }
            this.input = null;
            boolean bl = super.setInput(useAsInput);
            return bl;
        }
        finally {
            if (this.trace) {
                GitTraceLocation.getTrace().traceExit(GitTraceLocation.HISTORYVIEW.getLocation());
            }
        }
    }

    public boolean inputSet() {
        return this.inputSet(null);
    }

    private boolean inputSet(RevCommit prevSelection) {
        try {
            File file;
            if (this.trace) {
                GitTraceLocation.getTrace().traceEntry(GitTraceLocation.HISTORYVIEW.getLocation());
            }
            if (this.input != null) {
                return true;
            }
            Object o = super.getInput();
            if (o == null) {
                this.setErrorMessage(UIText.GitHistoryPage_NoInputMessage);
                return false;
            }
            boolean showHead = false;
            boolean showRef = false;
            boolean showTag = false;
            Repository repo = null;
            RevCommit selection = null;
            Ref ref = null;
            if (o instanceof IResource) {
                RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)((IResource)o));
                if (mapping != null) {
                    repo = mapping.getRepository();
                    this.input = new HistoryPageInput(repo, new IResource[]{(IResource)o});
                    showHead = true;
                }
            } else if (o instanceof RepositoryTreeNode) {
                RepositoryTreeNode repoNode = (RepositoryTreeNode)o;
                repo = repoNode.getRepository();
                switch (repoNode.getType()) {
                    case FILE: {
                        file = (File)((FileNode)repoNode).getObject();
                        this.input = new HistoryPageInput(repo, new File[]{file});
                        showHead = true;
                        break;
                    }
                    case FOLDER: {
                        File folder = (File)((FolderNode)repoNode).getObject();
                        this.input = new HistoryPageInput(repo, new File[]{folder});
                        showHead = true;
                        break;
                    }
                    case REF: {
                        this.input = new HistoryPageInput(repo);
                        ref = (Ref)((RefNode)repoNode).getObject();
                        showRef = true;
                        break;
                    }
                    case ADDITIONALREF: {
                        this.input = new HistoryPageInput(repo);
                        ref = (Ref)((AdditionalRefNode)repoNode).getObject();
                        if (ref.getObjectId() == null) {
                            ref = null;
                        }
                        showRef = ref != null;
                        break;
                    }
                    case TAG: {
                        this.input = new HistoryPageInput(repo);
                        ref = (Ref)((TagNode)repoNode).getObject();
                        showTag = true;
                        break;
                    }
                    default: {
                        this.input = new HistoryPageInput(repo);
                        showHead = true;
                        break;
                    }
                }
            } else if (o instanceof HistoryPageInput) {
                this.input = (HistoryPageInput)o;
                repo = this.input.getRepository();
            } else if (o instanceof Path) {
                Path path = (Path)o;
                repo = ResourceUtil.getRepository((IPath)path);
                if (repo != null) {
                    this.input = new HistoryPageInput(repo, new File[]{path.toFile()});
                }
            } else {
                RepositoryMapping mapping;
                IResource resource = AdapterUtils.adaptToAnyResource((Object)o);
                if (resource != null && (mapping = RepositoryMapping.getMapping((IResource)resource)) != null) {
                    repo = mapping.getRepository();
                    this.input = new HistoryPageInput(repo, new IResource[]{resource});
                }
            }
            if (repo == null) {
                GitInfo info = (GitInfo)Adapters.adapt((Object)o, GitInfo.class);
                if (info != null && info.getRepository() != null) {
                    repo = info.getRepository();
                    IPath gitPath = Path.fromPortableString((String)info.getGitPath());
                    this.input = new HistoryPageInput(repo, new File[]{new File(gitPath.toOSString())});
                } else {
                    repo = (Repository)Adapters.adapt((Object)o, Repository.class);
                    if (repo != null) {
                        file = (File)Adapters.adapt((Object)o, File.class);
                        this.input = file == null ? new HistoryPageInput(repo) : new HistoryPageInput(repo, new File[]{file});
                    }
                }
            }
            selection = (RevCommit)Adapters.adapt((Object)o, RevCommit.class);
            if (this.input == null || repo == null) {
                this.name = "";
                this.setErrorMessage(UIText.GitHistoryPage_NoInputMessage);
                return false;
            }
            IResource[] inResources = this.input.getItems();
            File[] inFiles = this.input.getFileList();
            this.name = GitHistoryPage.calculateName(this.input);
            boolean filtersActive = inResources != null || inFiles != null;
            this.actions.showAllRepoVersionsAction.setEnabled(filtersActive);
            this.actions.showAllProjectVersionsAction.setEnabled(inResources != null);
            this.actions.showAllFolderVersionsAction.setEnabled(filtersActive);
            this.actions.showAllResourceVersionsAction.setEnabled(filtersActive);
            this.setErrorMessage(null);
            try {
                ObjectId id = null;
                if (ref != null) {
                    id = ref.getLeaf().getObjectId();
                } else if (selection != null) {
                    id = selection.getId();
                }
                this.initAndStartRevWalk(false, id);
            }
            catch (IllegalStateException e) {
                Activator.handleError(e.getMessage(), e, true);
                if (this.trace) {
                    GitTraceLocation.getTrace().traceExit(GitTraceLocation.HISTORYVIEW.getLocation());
                }
                return false;
            }
            if (prevSelection != null) {
                this.graph.selectCommitStored(prevSelection);
            } else {
                if (showHead) {
                    this.showHead(repo);
                }
                if (showRef) {
                    this.showRef(ref, repo);
                }
                if (showTag) {
                    this.showTag(ref, repo);
                }
                if (selection != null) {
                    this.graph.selectCommitStored(selection);
                }
            }
            return true;
        }
        finally {
            if (this.trace) {
                GitTraceLocation.getTrace().traceExit(GitTraceLocation.HISTORYVIEW.getLocation());
            }
        }
    }

    private void showHead(Repository repo) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (RevWalk rw = new RevWalk(repo);){
                ObjectId head = repo.resolve("HEAD");
                if (head == null) {
                    return;
                }
                RevCommit c = rw.parseCommit((AnyObjectId)head);
                this.graph.selectCommitStored(c);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Activator.handleError(e.getMessage(), e, true);
        }
    }

    private void showRef(Ref ref, Repository repo) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (RevWalk rw = new RevWalk(repo);){
                RevCommit c = rw.parseCommit((AnyObjectId)ref.getLeaf().getObjectId());
                this.graph.selectCommit(c);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Activator.handleError(e.getMessage(), e, true);
        }
    }

    private void showTag(Ref ref, Repository repo) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (RevWalk rw = new RevWalk(repo);){
                RevTag t;
                RevObject anyCommit;
                RevCommit c = null;
                RevObject any = rw.parseAny((AnyObjectId)ref.getLeaf().getObjectId());
                if (any instanceof RevCommit) {
                    c = (RevCommit)any;
                } else if (any instanceof RevTag && (anyCommit = rw.parseAny((AnyObjectId)(t = rw.parseTag((AnyObjectId)any)).getObject())) instanceof RevCommit) {
                    c = (RevCommit)anyCommit;
                }
                if (c != null) {
                    this.graph.selectCommit(c);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Activator.handleError(e.getMessage(), e, true);
        }
    }

    private static String calculateName(HistoryPageInput in) {
        int n;
        String repositoryName = RepositoryUtil.INSTANCE.getRepositoryName(in.getRepository());
        if (in.getItems() == null && in.getFileList() == null) {
            return NLS.bind((String)UIText.GitHistoryPage_RepositoryNamePattern, (Object)repositoryName);
        }
        if (in.getItems() != null && in.getItems().length == 1) {
            IResource resource = in.getItems()[0];
            String type = switch (resource.getType()) {
                case 1 -> UIText.GitHistoryPage_FileType;
                case 4 -> UIText.GitHistoryPage_ProjectType;
                default -> UIText.GitHistoryPage_FolderType;
            };
            Object path = resource.getFullPath().makeRelative().toString();
            if (resource.getType() == 2) {
                path = (String)path + "/";
            }
            return NLS.bind((String)NAME_PATTERN, (Object[])new Object[]{type, path, repositoryName});
        }
        if (in.getFileList() != null && in.getFileList().length == 1) {
            Object path;
            String type;
            File resource = in.getFileList()[0];
            if (resource.isDirectory()) {
                type = UIText.GitHistoryPage_FolderType;
                path = resource.getPath() + "/";
            } else {
                type = UIText.GitHistoryPage_FileType;
                path = resource.getPath();
            }
            return NLS.bind((String)NAME_PATTERN, (Object[])new Object[]{type, path, repositoryName});
        }
        int count = 0;
        StringBuilder b = new StringBuilder();
        if (in.getItems() != null) {
            count = in.getItems().length;
            IResource[] iResourceArray = in.getItems();
            n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource res = iResourceArray[n2];
                b.append(res.getFullPath());
                if (res.getType() == 2) {
                    b.append('/');
                }
                if (b.length() > 100) {
                    b.append("...  ");
                    break;
                }
                b.append(", ");
                ++n2;
            }
        }
        if (in.getFileList() != null) {
            count = in.getFileList().length;
            boolean isBare = in.getRepository().isBare();
            File[] fileArray = in.getFileList();
            int n3 = fileArray.length;
            n = 0;
            while (n < n3) {
                File file = fileArray[n];
                if (isBare) {
                    b.append(Path.fromOSString((String)file.toString()));
                } else {
                    b.append(GitHistoryPage.getRepoRelativePath(in.getRepository(), file));
                }
                if (file.isDirectory()) {
                    b.append('/');
                }
                if (b.length() > 100) {
                    b.append("...  ");
                    break;
                }
                b.append(", ");
                ++n;
            }
        }
        if (b.length() > 2) {
            b.setLength(b.length() - 2);
        }
        String multiResourcePrefix = NLS.bind((String)UIText.GitHistoryPage_MultiResourcesType, (Object)count);
        return NLS.bind((String)NAME_PATTERN, (Object[])new Object[]{multiResourcePrefix, b.toString(), repositoryName});
    }

    private static String getRepoRelativePath(Repository repo, File file) {
        Path workdirPath = new Path(repo.getWorkTree().getPath());
        IPath filePath = new Path(file.getPath()).setDevice(null);
        return filePath.removeFirstSegments(workdirPath.segmentCount()).toString();
    }

    public void setErrorMessage(final String message) {
        if (this.trace) {
            GitTraceLocation.getTrace().traceEntry(GitTraceLocation.HISTORYVIEW.getLocation(), (Object)message);
        }
        this.getHistoryPageSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (GitHistoryPage.this.topControl.isDisposed()) {
                    return;
                }
                StackLayout layout = (StackLayout)GitHistoryPage.this.topControl.getLayout();
                if (message != null) {
                    GitHistoryPage.this.errorText.setText(message);
                    layout.topControl = GitHistoryPage.this.errorText;
                } else {
                    GitHistoryPage.this.errorText.setText("");
                    layout.topControl = GitHistoryPage.this.historyControl;
                }
                GitHistoryPage.this.topControl.layout();
            }
        });
        if (this.trace) {
            GitTraceLocation.getTrace().traceExit(GitTraceLocation.HISTORYVIEW.getLocation());
        }
    }

    public boolean isValidInput(Object object) {
        return GitHistoryPage.canShowHistoryFor(object);
    }

    public <T> T getAdapter(Class<T> adapter) {
        return null;
    }

    public String getDescription() {
        String filterHint = null;
        switch (this.showAllFilter) {
            case SHOWALLREPO: {
                filterHint = UIText.GitHistoryPage_AllChangesInRepoHint;
                break;
            }
            case SHOWALLPROJECT: {
                filterHint = UIText.GitHistoryPage_AllChangesInProjectHint;
                break;
            }
            case SHOWALLFOLDER: {
                filterHint = UIText.GitHistoryPage_AllChangesInFolderHint;
                break;
            }
            case SHOWALLRESOURCE: {
                filterHint = UIText.GitHistoryPage_AllChangesOfResourceHint;
            }
        }
        return NLS.bind((String)DESCRIPTION_PATTERN, (Object)this.getName(), (Object)filterHint);
    }

    public String getName() {
        return this.name;
    }

    public HistoryPageInput getInputInternal() {
        return this.input;
    }

    public Object getInput() {
        return this.getInputInternal();
    }

    private Repository getCurrentRepo() {
        return this.currentRepo;
    }

    private void setCurrentRepo(Repository newRepo) {
        Repository old = this.getCurrentRepo();
        this.currentRepo = newRepo;
        if (!Objects.equals(old, newRepo)) {
            this.firePropertyChange(this, P_REPOSITORY, old, newRepo);
        }
    }

    void setWarningTextInUIThread(final Job j) {
        this.graph.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!GitHistoryPage.this.graph.getControl().isDisposed() && GitHistoryPage.this.job == j) {
                    GitHistoryPage.this.setWarningText(UIText.GitHistoryPage_ListIncompleteWarningMessage);
                }
            }
        });
    }

    void showCommitList(final Job j, final SWTCommitList list, final SWTCommit[] asArray, final RevCommit toSelect, final boolean incomplete, final RevFlag highlightFlag) {
        if (this.trace) {
            GitTraceLocation.getTrace().traceEntry(GitTraceLocation.HISTORYVIEW.getLocation(), new Object[]{asArray.length});
        }
        if (this.job != j || this.graph.getControl().isDisposed()) {
            return;
        }
        this.graph.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!GitHistoryPage.this.graph.getControl().isDisposed() && GitHistoryPage.this.job == j) {
                    GitHistoryPage.this.setWarningText(incomplete ? UIText.GitHistoryPage_ListIncompleteWarningMessage : null);
                    GitHistoryPage.this.setErrorMessage(null);
                    GitHistoryPage.this.graph.setInput(highlightFlag, list, asArray, GitHistoryPage.this.input, true);
                    if (toSelect != null) {
                        GitHistoryPage.this.graph.selectCommitStored(toSelect);
                    }
                    if (GitHistoryPage.this.getFollowRenames()) {
                        GitHistoryPage.this.updateInterestingPathsOfFileViewer();
                    }
                    if (GitHistoryPage.this.trace) {
                        GitTraceLocation.getTrace().trace(GitTraceLocation.HISTORYVIEW.getLocation(), "Setting input to table");
                    }
                    final Object currentInput = GitHistoryPage.super.getInput();
                    GitHistoryPage.this.searchBar.setInput(new ICommitsProvider(){

                        @Override
                        public Object getSearchContext() {
                            return currentInput;
                        }

                        @Override
                        public SWTCommit[] getCommits() {
                            return asArray;
                        }

                        @Override
                        public RevFlag getHighlight() {
                            return highlightFlag;
                        }
                    });
                    GitHistoryPage.this.actions.findAction.setEnabled(true);
                    if (GitHistoryPage.this.store.getBoolean("resourcehistory_show_findtoolbar")) {
                        GitHistoryPage.this.searchBar.setVisible(true);
                    }
                }
            }
        });
        if (this.trace) {
            GitTraceLocation.getTrace().traceExit(GitTraceLocation.HISTORYVIEW.getLocation());
        }
    }

    private void updateInterestingPathsOfFileViewer() {
        this.fileViewer.setInterestingPaths(this.fileViewerInterestingPaths);
        this.fileViewer.refresh();
    }

    private void setWarningText(String warning) {
        if (this.warningComposite == null || this.warningComposite.isDisposed()) {
            return;
        }
        GridData gd = (GridData)this.warningComposite.getLayoutData();
        gd.exclude = warning == null;
        this.warningComposite.setVisible(!gd.exclude);
        if (warning != null) {
            this.warningLabel.setText(warning);
        } else {
            this.warningLabel.setText("");
        }
        this.warningComposite.getParent().layout(true);
    }

    private void initAndStartRevWalk(boolean forceNewWalk) {
        this.initAndStartRevWalk(forceNewWalk, this.selectedObj);
    }

    private void initAndStartRevWalk(boolean forceNewWalk, ObjectId newSelectedObj) throws IllegalStateException {
        try {
            if (this.trace) {
                GitTraceLocation.getTrace().traceEntry(GitTraceLocation.HISTORYVIEW.getLocation());
            }
            if (this.input == null) {
                return;
            }
            Repository db = this.input.getRepository();
            if (this.repoHasBeenRemoved(db)) {
                this.clearHistoryPage();
                return;
            }
            Assert.isNotNull((Object)db);
            UnitOfWork.execute((Repository)db, () -> {
                boolean fetchHeadChanged;
                AnyObjectId headId = this.resolveHead(db, true);
                if (headId == null) {
                    this.currentHeadId = null;
                    this.currentFetchHeadId = null;
                    this.selectedObj = null;
                    this.setCurrentRepo(db);
                    this.clearViewers();
                    return;
                }
                AnyObjectId fetchHeadId = this.resolveFetchHead(db);
                ArrayList<FilterPath> paths = this.buildFilterPaths(this.input.getItems(), this.input.getFileList(), db);
                boolean repoChanged = false;
                if (!db.equals(this.getCurrentRepo())) {
                    repoChanged = true;
                    this.setCurrentRepo(db);
                }
                boolean objChanged = false;
                if (newSelectedObj != null && newSelectedObj != this.selectedObj) {
                    objChanged = !newSelectedObj.equals((AnyObjectId)this.selectedObj);
                }
                this.selectedObj = newSelectedObj;
                boolean settingsChanged = this.updateSettings();
                boolean pathsChanged = this.pathChanged(this.pathFilters, paths);
                boolean headChanged = !headId.equals(this.currentHeadId) && this.showsHead(db);
                boolean bl2 = fetchHeadChanged = this.currentShowAdditionalRefs && fetchHeadId != null && !fetchHeadId.equals(this.currentFetchHeadId);
                if (forceNewWalk || repoChanged || objChanged || headChanged || fetchHeadChanged || pathsChanged || settingsChanged) {
                    this.releaseGenerateHistoryJob();
                    if (repoChanged || pathsChanged) {
                        this.clearViewers();
                    }
                    SWTWalk walk = this.createNewWalk(db, headId, fetchHeadId);
                    this.fileDiffWalker = this.createFileWalker((RevWalk)walk, db, paths);
                    RevCommit toShow = null;
                    if (!repoChanged) {
                        if (headChanged) {
                            toShow = this.toRevCommit((RevWalk)walk, headId);
                        } else if (fetchHeadChanged) {
                            toShow = this.toRevCommit((RevWalk)walk, fetchHeadId);
                        }
                    }
                    RevCommit toLoad = null;
                    if (newSelectedObj != null) {
                        toLoad = this.toRevCommit((RevWalk)walk, (AnyObjectId)newSelectedObj);
                    }
                    this.loadInitialHistory((RevWalk)walk, toShow, toLoad);
                } else {
                    this.graph.setHistoryPageInput(this.input);
                }
            });
        }
        finally {
            if (this.trace) {
                GitTraceLocation.getTrace().traceExit(GitTraceLocation.HISTORYVIEW.getLocation());
            }
        }
    }

    private RevCommit toRevCommit(RevWalk w, AnyObjectId id) {
        try {
            return w.parseCommit(id);
        }
        catch (IOException e) {
            return null;
        }
    }

    private boolean showsHead(@NonNull Repository db) {
        return new RefFilterHelper(db).getRefFilters().stream().anyMatch(f -> f.isSelected() && "HEAD".equals(f.getFilterString()));
    }

    private boolean updateSettings() {
        String newRefFilters = "";
        Repository repo = this.getCurrentRepo();
        if (repo != null) {
            newRefFilters = this.store.getString(RepositoryUtil.INSTANCE.getRepositorySpecificPreferenceKey(repo, "resourcehistory_selected_ref_filters"));
        }
        boolean refFiltersChanged = !Objects.equals(this.currentRefFilters, newRefFilters);
        this.currentRefFilters = newRefFilters;
        boolean isShowFirstParentOnly = this.isShowFirstParentOnly();
        boolean firstParentOnlyChanged = this.currentShowFirstParentOnly ^ isShowFirstParentOnly;
        this.currentShowFirstParentOnly = isShowFirstParentOnly;
        boolean additionalRefsChange = this.currentShowAdditionalRefs ^ this.store.getBoolean("resourcehistory_show_additionalrefs");
        this.currentShowAdditionalRefs = this.store.getBoolean("resourcehistory_show_additionalrefs");
        boolean showNotesChanged = this.currentShowNotes ^ this.store.getBoolean("resourcehistory_show_notes");
        this.currentShowNotes = this.store.getBoolean("resourcehistory_show_notes");
        boolean followRenamesChanged = this.currentFollowRenames ^ this.getFollowRenames();
        this.currentFollowRenames = this.getFollowRenames();
        return refFiltersChanged || firstParentOnlyChanged || additionalRefsChange || showNotesChanged || followRenamesChanged;
    }

    protected boolean getFollowRenames() {
        return this.store.getBoolean("resourcehistory_follow_renames");
    }

    private AnyObjectId resolveHead(Repository db, boolean acceptNull) {
        ObjectId headId;
        try {
            headId = db.resolve("HEAD");
        }
        catch (IOException e) {
            throw new IllegalStateException(NLS.bind((String)UIText.GitHistoryPage_errorParsingHead, (Object)RepositoryUtil.INSTANCE.getRepositoryName(db)), e);
        }
        if (headId == null && !acceptNull) {
            throw new IllegalStateException(NLS.bind((String)UIText.GitHistoryPage_errorParsingHead, (Object)RepositoryUtil.INSTANCE.getRepositoryName(db)));
        }
        return headId;
    }

    private AnyObjectId resolveFetchHead(Repository db) {
        try {
            return db.resolve("FETCH_HEAD");
        }
        catch (IOException e) {
            return null;
        }
    }

    private ArrayList<FilterPath> buildFilterPaths(IResource[] inResources, File[] inFiles, Repository db) throws IllegalStateException {
        ArrayList<FilterPath> paths;
        if (inResources != null) {
            paths = new ArrayList<FilterPath>(inResources.length);
            IResource[] iResourceArray = inResources;
            int n = inResources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource r = iResourceArray[n2];
                RepositoryMapping map = RepositoryMapping.getMapping((IResource)r);
                if (map != null) {
                    String path;
                    if (db != map.getRepository()) {
                        throw new IllegalStateException(UIText.RepositoryAction_multiRepoSelection);
                    }
                    if (this.showAllFilter == ShowFilter.SHOWALLFOLDER) {
                        path = r.getParent() instanceof IWorkspaceRoot ? map.getRepoRelativePath((IResource)r.getProject()) : map.getRepoRelativePath((IResource)r.getParent());
                        if (path != null && path.length() > 0) {
                            paths.add(new FilterPath(path, false));
                        }
                    } else if (this.showAllFilter == ShowFilter.SHOWALLPROJECT) {
                        path = map.getRepoRelativePath((IResource)r.getProject());
                        if (path != null && path.length() > 0) {
                            paths.add(new FilterPath(path, false));
                        }
                    } else if (this.showAllFilter != ShowFilter.SHOWALLREPO && (path = map.getRepoRelativePath(r)) != null && path.length() > 0) {
                        paths.add(new FilterPath(path, r.getType() == 1));
                    }
                }
                ++n2;
            }
        } else if (inFiles != null) {
            if (this.showAllFilter == ShowFilter.SHOWALLPROJECT || this.showAllFilter == ShowFilter.SHOWALLREPO) {
                return new ArrayList<FilterPath>(0);
            }
            paths = new ArrayList(inFiles.length);
            if (db.isBare()) {
                File[] fileArray = inFiles;
                int n = inFiles.length;
                int n3 = 0;
                while (n3 < n) {
                    File file = fileArray[n3];
                    if (!file.isAbsolute()) {
                        Path filePath = new Path(file.getPath());
                        paths.add(new FilterPath(filePath.toString(), false));
                    }
                    ++n3;
                }
                return paths;
            }
            Path workdirPath = new Path(db.getWorkTree().getPath());
            Path gitDirPath = new Path(db.getDirectory().getPath());
            int segmentCount = workdirPath.segmentCount();
            File[] fileArray = inFiles;
            int n = inFiles.length;
            int n4 = 0;
            while (n4 < n) {
                Path pathToAdd;
                boolean isRegularFile;
                Path filePath;
                File file = fileArray[n4];
                if (this.showAllFilter == ShowFilter.SHOWALLFOLDER) {
                    filePath = new Path(file.getParentFile().getPath());
                    isRegularFile = false;
                } else {
                    filePath = new Path(file.getPath());
                    isRegularFile = file.isFile();
                }
                if (!file.isAbsolute()) {
                    pathToAdd = filePath;
                } else {
                    if (gitDirPath.isPrefixOf((IPath)filePath)) {
                        throw new IllegalStateException(NLS.bind((String)UIText.GitHistoryPage_FileOrFolderPartOfGitDirMessage, (Object)filePath.toOSString()));
                    }
                    pathToAdd = filePath.removeFirstSegments(segmentCount);
                }
                pathToAdd = pathToAdd.setDevice(null);
                if (!pathToAdd.isEmpty()) {
                    paths.add(new FilterPath(pathToAdd.toString(), isRegularFile));
                }
                ++n4;
            }
        } else {
            paths = new ArrayList(0);
        }
        return paths;
    }

    private boolean pathChanged(List<FilterPath> o, List<FilterPath> n) {
        if (o == null) {
            return !n.isEmpty();
        }
        return !o.equals(n);
    }

    private void unsetRepoSpecificPreference(String repositoryPath, String key) {
        String prefString = RepositoryUtil.INSTANCE.getRepositorySpecificPreferenceKey(repositoryPath, key);
        this.store.setToDefault(prefString);
    }

    private void saveStoreIfNeeded() {
        if (this.store.needsSaving()) {
            try {
                this.store.save();
            }
            catch (IOException e) {
                Activator.handleError(e.getMessage(), e, false);
            }
        }
    }

    private boolean isShowFirstParentOnly() {
        String repoSpecificKey;
        String prefKey = "resourcehistory_show_first_parent_only";
        boolean firstParent = this.store.getBoolean("resourcehistory_show_first_parent_only");
        Repository repo = this.getCurrentRepo();
        if (repo != null && this.store.contains(repoSpecificKey = RepositoryUtil.INSTANCE.getRepositorySpecificPreferenceKey(repo, "resourcehistory_show_first_parent_only"))) {
            firstParent = this.store.getBoolean(repoSpecificKey);
        }
        return firstParent;
    }

    @NonNull
    private SWTWalk createNewWalk(@NonNull Repository db, AnyObjectId headId, AnyObjectId fetchHeadId) {
        this.currentHeadId = headId;
        this.currentFetchHeadId = fetchHeadId;
        GitHistoryWalk walk = new GitHistoryWalk(db, this.selectedObj);
        if (this.isShowFirstParentOnly()) {
            walk.setFirstParent(true);
        }
        try {
            if (this.store.getBoolean("resourcehistory_show_additionalrefs")) {
                walk.addAdditionalRefs(db.getRefDatabase().getAdditionalRefs());
            }
            walk.addAdditionalRefs(db.getRefDatabase().getRefsByPrefix("refs/notes/"));
        }
        catch (IOException e) {
            throw new IllegalStateException(NLS.bind((String)UIText.GitHistoryPage_errorReadingAdditionalRefs, (Object)RepositoryUtil.INSTANCE.getRepositoryName(db)), e);
        }
        walk.sort(RevSort.COMMIT_TIME_DESC, true);
        walk.sort(RevSort.BOUNDARY, true);
        walk.setRetainBody(false);
        return walk;
    }

    private void formatDiffs(final List<FileDiff> diffs) {
        Job.getJobManager().cancel(JobFamilies.HISTORY_DIFF);
        final DiffViewer diffViewer = this.commitAndDiff.getDiffViewer();
        if (diffs.isEmpty()) {
            if (UIUtils.isUsable((Viewer)diffViewer)) {
                Document document = new Document();
                diffViewer.setDocument((IDocument)document);
            }
            return;
        }
        Job formatJob = new Job(UIText.GitHistoryPage_FormatDiffJobName){

            protected IStatus run(IProgressMonitor monitor) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                int maxLines = Activator.getDefault().getPreferenceStore().getInt("HistoryView_MaxDiffLines");
                final DiffDocument document = new DiffDocument();
                Throwable throwable = null;
                Object var5_6 = null;
                try (DiffRegionFormatter formatter = new DiffRegionFormatter((IDocument)document, document.getLength(), maxLines);){
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)diffs.size());
                    for (FileDiff diff : diffs) {
                        if (progress.isCanceled() || diff.getBlobs().length > 2 || document.getNumberOfLines() > maxLines) break;
                        progress.subTask(diff.getPath());
                        try {
                            formatter.write(diff);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        progress.worked(1);
                    }
                    if (progress.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    document.connect(formatter);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                UIJob uiJob = new UIJob(UIText.GitHistoryPage_FormatDiffJobName){

                    public IStatus runInUIThread(IProgressMonitor uiMonitor) {
                        if (uiMonitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        if (UIUtils.isUsable((Viewer)diffViewer)) {
                            diffViewer.setDocument((IDocument)document);
                        }
                        return Status.OK_STATUS;
                    }

                    public boolean belongsTo(Object family) {
                        return JobFamilies.HISTORY_DIFF.equals(family);
                    }
                };
                uiJob.setRule((ISchedulingRule)GitHistoryPage.this.pageSchedulingRule);
                GitHistoryPage.this.schedule((Job)uiJob);
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return JobFamilies.HISTORY_DIFF.equals(family);
            }
        };
        formatJob.setRule((ISchedulingRule)this.pageSchedulingRule);
        this.schedule(formatJob);
    }

    private TreeWalk createFileWalker(RevWalk walk, Repository db, List<FilterPath> paths) {
        TreeWalk fileWalker = new TreeWalk(db);
        fileWalker.setRecursive(true);
        fileWalker.setFilter(TreeFilter.ANY_DIFF);
        if (this.store.getBoolean("resourcehistory_follow_renames") && !paths.isEmpty() && this.allRegularFiles(paths)) {
            this.pathFilters = paths;
            ArrayList<String> selectedPaths = new ArrayList<String>(paths.size());
            for (FilterPath filterPath : paths) {
                selectedPaths.add(filterPath.getPath());
            }
            this.fileViewerInterestingPaths = new HashSet<String>(selectedPaths);
            TreeFilter followFilter = this.createFollowFilterFor(selectedPaths);
            walk.setTreeFilter(followFilter);
            walk.setRevFilter(this.renameTracker.getFilter());
        } else if (paths.size() > 0) {
            this.pathFilters = paths;
            ArrayList<String> stringPaths = new ArrayList<String>(paths.size());
            for (FilterPath p : paths) {
                stringPaths.add(p.getPath());
            }
            walk.setTreeFilter(AndTreeFilter.create((TreeFilter)PathFilterGroup.createFromStrings(stringPaths), (TreeFilter)TreeFilter.ANY_DIFF));
            this.fileViewerInterestingPaths = new HashSet<String>(stringPaths);
        } else {
            this.pathFilters = null;
            walk.setTreeFilter(TreeFilter.ALL);
            this.fileViewerInterestingPaths = null;
        }
        return fileWalker;
    }

    private TreeFilter createFollowFilterFor(List<String> paths) {
        if (paths == null || paths.isEmpty()) {
            throw new IllegalArgumentException("paths must not be null nor empty");
        }
        DiffConfig diffConfig = (DiffConfig)this.getCurrentRepo().getConfig().get(DiffConfig.KEY);
        ArrayList<FollowFilter> followFilters = new ArrayList<FollowFilter>(paths.size());
        for (String path : paths) {
            followFilters.add(this.createFollowFilter(path, diffConfig));
        }
        if (followFilters.size() == 1) {
            FollowFilter followFilter = (FollowFilter)followFilters.get(0);
            this.renameTracker.reset(followFilter.getPath());
            return (TreeFilter)followFilters.get(0);
        }
        return OrTreeFilter.create(followFilters);
    }

    private FollowFilter createFollowFilter(String path, DiffConfig diffConfig) {
        FollowFilter followFilter = FollowFilter.create((String)path, (DiffConfig)diffConfig);
        followFilter.setRenameCallback(new RenameCallback(){

            public void renamed(DiffEntry entry) {
                GitHistoryPage.this.renameTracker.getCallback().renamed(entry);
                if (GitHistoryPage.this.fileViewerInterestingPaths != null) {
                    GitHistoryPage.this.fileViewerInterestingPaths.add(entry.getOldPath());
                    GitHistoryPage.this.fileViewerInterestingPaths.add(entry.getNewPath());
                }
            }
        });
        return followFilter;
    }

    private boolean allRegularFiles(List<FilterPath> paths) {
        for (FilterPath filterPath : paths) {
            if (filterPath.isRegularFile()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void loadItem(int item) {
        if (this.job != null && this.job.loadNextBatch(item)) {
            this.loadHistory(item);
        }
    }

    @Override
    public void loadCommit(RevCommit c) {
        if (this.job == null) {
            return;
        }
        this.job.setLoadHint(c);
        if (this.trace) {
            GitTraceLocation.getTrace().trace(GitTraceLocation.HISTORYVIEW.getLocation(), "Scheduling GenerateHistoryJob");
        }
        this.schedule(this.job);
    }

    private void loadInitialHistory(@NonNull RevWalk walk, RevCommit toShow, RevCommit toLoad) {
        this.job = new GenerateHistoryJob(this, walk, this.resources);
        this.job.setRule(this.pageSchedulingRule);
        this.job.setLoadHint(-1);
        if (toLoad != null) {
            this.job.setLoadHint(toLoad);
        } else if (toShow != null) {
            this.job.setShowHint(toShow);
        }
        if (this.trace) {
            GitTraceLocation.getTrace().trace(GitTraceLocation.HISTORYVIEW.getLocation(), "Scheduling initial GenerateHistoryJob");
        }
        this.schedule(this.job);
    }

    private void loadHistory(int itemToLoad) {
        if (this.job == null) {
            return;
        }
        this.job.setLoadHint(itemToLoad);
        if (this.trace) {
            GitTraceLocation.getTrace().trace(GitTraceLocation.HISTORYVIEW.getLocation(), "Scheduling incremental GenerateHistoryJob");
        }
        this.schedule(this.job);
    }

    private IWorkbenchPartSite getPartSite() {
        IWorkbenchPart part = this.getHistoryPageSite().getPart();
        IWorkbenchPartSite site = null;
        if (part != null) {
            site = part.getSite();
        }
        return site;
    }

    private void schedule(Job j) {
        IWorkbenchSiteProgressService p;
        IWorkbenchPartSite site = this.getPartSite();
        if (site != null && (p = (IWorkbenchSiteProgressService)Adapters.adapt((Object)site, IWorkbenchSiteProgressService.class)) != null) {
            p.schedule(j, 0L, true);
            return;
        }
        j.schedule();
    }

    private void releaseGenerateHistoryJob() {
        if (this.job != null) {
            if (this.job.getState() != 0) {
                this.job.cancel();
            }
            this.job.release();
            this.job = null;
        }
    }

    public ShowInContext getShowInContext() {
        if (this.fileViewer != null && this.fileViewer.getControl().isFocusControl()) {
            return this.fileViewer.getShowInContext();
        }
        return null;
    }

    public String[] getShowInTargetIds() {
        return new String[]{"org.eclipse.team.ui.GenericHistoryView"};
    }

    public String getRenamedPath(String path, ObjectId commit) {
        return this.renameTracker.getPath(commit, path);
    }

    private /* synthetic */ void lambda$1(Control control) {
        if (!control.isDisposed()) {
            this.setInput(null);
        }
    }

    private class ColumnAction
    extends Action
    implements IUpdate {
        private final int columnIndex;

        public ColumnAction(String text, int idx) {
            super(text, 2);
            this.columnIndex = idx;
            this.update();
        }

        public void run() {
            GitHistoryPage.this.graph.setVisible(this.columnIndex, this.isChecked());
        }

        public void update() {
            this.setChecked(GitHistoryPage.this.graph.getTableView().getTable().getColumn(this.columnIndex).getWidth() > 0);
        }
    }

    private static class FilterPath {
        private String path;
        private boolean regularFile;

        public FilterPath(String path, boolean regularFile) {
            this.path = path;
            this.regularFile = regularFile;
        }

        public String getPath() {
            return this.path;
        }

        public boolean isRegularFile() {
            return this.regularFile;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof FilterPath)) {
                return false;
            }
            FilterPath other = (FilterPath)obj;
            if (this.path == null) {
                return other.path == null;
            }
            return this.path.equals(other.path);
        }

        public int hashCode() {
            if (this.path != null) {
                return this.path.hashCode();
            }
            return super.hashCode();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Path: ");
            builder.append(this.getPath());
            builder.append(", regular: ");
            builder.append(this.isRegularFile());
            return builder.toString();
        }
    }

    private static class GitHistoryPageActions {
        List<ActionFactory.IWorkbenchAction> actionsToDispose = new ArrayList<ActionFactory.IWorkbenchAction>();
        BooleanPrefAction showRelativeDateAction;
        BooleanPrefAction showEmailAddressesAction;
        BooleanPrefAction showNotesAction;
        BooleanPrefAction showTagSequenceAction;
        BooleanPrefAction showBranchSequenceAction;
        BooleanPrefAction wrapCommentAction;
        BooleanPrefAction fillCommentAction;
        IAction findAction;
        IAction refreshAction;
        BooleanPrefAction showCommentAction;
        BooleanPrefAction showFilesAction;
        ActionFactory.IWorkbenchAction compareModeAction;
        ActionFactory.IWorkbenchAction selectShownRefsAction;
        ActionFactory.IWorkbenchAction showFirstParentOnlyAction;
        ActionFactory.IWorkbenchAction showAdditionalRefsAction;
        BooleanPrefAction followRenamesAction;
        ActionFactory.IWorkbenchAction reuseCompareEditorAction;
        ShowFilterAction showAllRepoVersionsAction;
        ShowFilterAction showAllProjectVersionsAction;
        ShowFilterAction showAllFolderVersionsAction;
        ShowFilterAction showAllResourceVersionsAction;
        FilterAction filterAction;
        RepositoryMenuUtil.RepositoryToolbarAction switchRepositoryAction;
        ActionFactory.IWorkbenchAction configureFiltersAction;
        private GitHistoryPage historyPage;

        GitHistoryPageActions(GitHistoryPage historyPage) {
            this.historyPage = historyPage;
            this.createActions();
        }

        private void createActions() {
            this.createRepositorySwitchAction();
            this.createFindToolbarAction();
            this.createRefreshAction();
            this.createFilterActions();
            this.createCompareModeAction();
            this.createReuseCompareEditorAction();
            this.createSelectShownRefsAction();
            this.createShowFirstParentOnlyAction();
            this.createShowAdditionalRefsAction();
            this.createShowCommentAction();
            this.createShowFilesAction();
            this.createShowRelativeDateAction();
            this.createShowEmailAddressesAction();
            this.createShowNotesAction();
            this.createShowTagSequenceAction();
            this.createShowBranchSequenceAction();
            this.createWrapCommentAction();
            this.createFillCommentAction();
            this.createFollowRenamesAction();
            this.createConfigureFiltersAction();
            this.wrapCommentAction.setEnabled(this.showCommentAction.isChecked());
            this.fillCommentAction.setEnabled(this.showCommentAction.isChecked());
            this.historyPage.getSite().getActionBars().updateActionBars();
        }

        private void createRepositorySwitchAction() {
            this.switchRepositoryAction = new RepositoryMenuUtil.RepositoryToolbarAction(true, () -> this.historyPage.getCurrentRepo(), repo -> {
                HistoryPageInput currentInput;
                Repository current = this.historyPage.getCurrentRepo();
                if (current != null && repo.getDirectory().equals(current.getDirectory()) && (currentInput = this.historyPage.getInputInternal()) != null && currentInput.getItems() == null && currentInput.getFileList() == null) {
                    return;
                }
                if (this.historyPage.selectionTracker != null) {
                    this.historyPage.selectionTracker.clearSelection();
                }
                this.historyPage.getHistoryView().showHistoryFor((Object)new RepositoryNode(null, (Repository)repo));
            });
            this.actionsToDispose.add(this.switchRepositoryAction);
        }

        private void createFindToolbarAction() {
            this.findAction = new Action(UIText.GitHistoryPage_FindMenuLabel, UIIcons.ELCL16_FIND){

                public void run() {
                    historyPage.store.setValue("resourcehistory_show_findtoolbar", this.isChecked());
                    historyPage.saveStoreIfNeeded();
                    historyPage.searchBar.setVisible(this.isChecked());
                }

                public void setChecked(boolean checked) {
                    super.setChecked(checked);
                    if (checked) {
                        this.setToolTipText(UIText.GitHistoryPage_FindHideTooltip);
                    } else {
                        this.setToolTipText(UIText.GitHistoryPage_FindShowTooltip);
                    }
                }
            };
            this.findAction.setActionDefinitionId("org.eclipse.ui.edit.findReplace");
            this.findAction.setEnabled(false);
            boolean isChecked = this.historyPage.store.getBoolean("resourcehistory_show_findtoolbar");
            this.findAction.setChecked(isChecked);
            this.historyPage.getSite().getActionBars().setGlobalActionHandler(ActionFactory.FIND.getId(), this.findAction);
        }

        private void createRefreshAction() {
            this.refreshAction = new Action(UIText.GitHistoryPage_RefreshMenuLabel, UIIcons.ELCL16_REFRESH){

                public void run() {
                    historyPage.refresh();
                }
            };
            this.refreshAction.setActionDefinitionId("org.eclipse.ui.file.refresh");
            this.historyPage.getSite().getActionBars().setGlobalActionHandler(ActionFactory.REFRESH.getId(), this.refreshAction);
        }

        private void createFilterActions() {
            this.showAllRepoVersionsAction = new ShowFilterAction(ShowFilter.SHOWALLREPO, UIIcons.FILTERNONE, UIText.GitHistoryPage_AllInRepoMenuLabel, UIText.GitHistoryPage_AllInRepoTooltip);
            this.showAllProjectVersionsAction = new ShowFilterAction(ShowFilter.SHOWALLPROJECT, UIIcons.FILTERPROJECT, UIText.GitHistoryPage_AllInProjectMenuLabel, UIText.GitHistoryPage_AllInProjectTooltip);
            this.showAllFolderVersionsAction = new ShowFilterAction(ShowFilter.SHOWALLFOLDER, UIIcons.FILTERFOLDER, UIText.GitHistoryPage_AllInParentMenuLabel, UIText.GitHistoryPage_AllInParentTooltip);
            this.showAllResourceVersionsAction = new ShowFilterAction(ShowFilter.SHOWALLRESOURCE, UIIcons.FILTERRESOURCE, UIText.GitHistoryPage_AllOfResourceMenuLabel, UIText.GitHistoryPage_AllOfResourceTooltip);
            this.filterAction = new FilterAction(new IAction[]{this.showAllRepoVersionsAction, this.showAllProjectVersionsAction, this.showAllFolderVersionsAction, this.showAllResourceVersionsAction});
            this.showAllRepoVersionsAction.setChecked(this.historyPage.showAllFilter == this.showAllRepoVersionsAction.filter);
            this.showAllProjectVersionsAction.setChecked(this.historyPage.showAllFilter == this.showAllProjectVersionsAction.filter);
            this.showAllFolderVersionsAction.setChecked(this.historyPage.showAllFilter == this.showAllFolderVersionsAction.filter);
            this.showAllResourceVersionsAction.setChecked(this.historyPage.showAllFilter == this.showAllResourceVersionsAction.filter);
            this.actionsToDispose.add(this.filterAction);
        }

        private void createCompareModeAction() {
            this.compareModeAction = new BooleanPrefAction(this, "resourcehistory_compare_mode", UIText.GitHistoryPage_CompareModeMenuLabel){

                @Override
                void apply(boolean value) {
                }
            };
            this.compareModeAction.setImageDescriptor(UIIcons.ELCL16_COMPARE_VIEW);
            this.compareModeAction.setToolTipText(UIText.GitHistoryPage_compareMode);
            this.actionsToDispose.add(this.compareModeAction);
        }

        private void createReuseCompareEditorAction() {
            this.reuseCompareEditorAction = new CompareUtils.ReuseCompareEditorAction();
            this.actionsToDispose.add(this.reuseCompareEditorAction);
        }

        private void createSelectShownRefsAction() {
            this.selectShownRefsAction = new SelectShownRefsAction();
            this.actionsToDispose.add(this.selectShownRefsAction);
        }

        private void createShowFirstParentOnlyAction() {
            this.showFirstParentOnlyAction = new ShowFirstParentOnlyPrefAction();
            this.actionsToDispose.add(this.showFirstParentOnlyAction);
        }

        private void createShowAdditionalRefsAction() {
            this.showAdditionalRefsAction = new BooleanPrefAction(this, "resourcehistory_show_additionalrefs", UIText.GitHistoryPage_ShowAdditionalRefsMenuLabel){

                @Override
                void apply(boolean value) {
                    historyPage.refresh(historyPage.selectedCommit());
                }
            };
            this.actionsToDispose.add(this.showAdditionalRefsAction);
        }

        private void createFollowRenamesAction() {
            this.followRenamesAction = new BooleanPrefAction(this, "resourcehistory_follow_renames", UIText.GitHistoryPage_FollowRenames){

                @Override
                void apply(boolean follow) {
                    historyPage.refresh(historyPage.selectedCommit());
                }
            };
            this.followRenamesAction.apply(this.followRenamesAction.isChecked());
            this.actionsToDispose.add(this.followRenamesAction);
        }

        private void createShowCommentAction() {
            this.showCommentAction = new BooleanPrefAction(this, "resourcehistory_show_rev_comment", UIText.ResourceHistory_toggleRevComment){

                @Override
                void apply(boolean value) {
                    historyPage.layout();
                    wrapCommentAction.setEnabled(this.isChecked());
                    fillCommentAction.setEnabled(this.isChecked());
                }
            };
            this.actionsToDispose.add(this.showCommentAction);
        }

        private void createShowFilesAction() {
            this.showFilesAction = new BooleanPrefAction(this, "resourcehistory_show_rev_detail", UIText.ResourceHistory_toggleRevDetail){

                @Override
                void apply(boolean value) {
                    historyPage.layout();
                }
            };
            this.actionsToDispose.add(this.showFilesAction);
        }

        private void createShowRelativeDateAction() {
            this.showRelativeDateAction = new BooleanPrefAction(this, "resourcehistory_show_relative_date", UIText.ResourceHistory_toggleRelativeDate){

                @Override
                void apply(boolean date) {
                }
            };
            this.showRelativeDateAction.apply(this.showRelativeDateAction.isChecked());
            this.actionsToDispose.add(this.showRelativeDateAction);
        }

        private void createShowEmailAddressesAction() {
            this.showEmailAddressesAction = new BooleanPrefAction(this, "resourcehistory_show_email_addresses", UIText.GitHistoryPage_toggleEmailAddresses){

                @Override
                void apply(boolean date) {
                }
            };
            this.showEmailAddressesAction.apply(this.showEmailAddressesAction.isChecked());
            this.actionsToDispose.add(this.showEmailAddressesAction);
        }

        private void createShowNotesAction() {
            this.showNotesAction = new BooleanPrefAction(this, "resourcehistory_show_notes", UIText.ResourceHistory_toggleShowNotes){

                @Override
                void apply(boolean value) {
                    historyPage.refresh();
                }
            };
            this.showNotesAction.apply(this.showNotesAction.isChecked());
            this.actionsToDispose.add(this.showNotesAction);
        }

        private void createShowTagSequenceAction() {
            this.showTagSequenceAction = new BooleanPrefAction(this, "HistoryView_ShowTagSequence", UIText.ResourceHistory_ShowTagSequence){

                @Override
                void apply(boolean value) {
                }
            };
            this.showTagSequenceAction.apply(this.showTagSequenceAction.isChecked());
            this.actionsToDispose.add(this.showTagSequenceAction);
        }

        private void createShowBranchSequenceAction() {
            this.showBranchSequenceAction = new BooleanPrefAction(this, "HistoryView_ShowBranchSequence", UIText.ResourceHistory_ShowBranchSequence){

                @Override
                void apply(boolean value) {
                }
            };
            this.showBranchSequenceAction.apply(this.showBranchSequenceAction.isChecked());
            this.actionsToDispose.add(this.showBranchSequenceAction);
        }

        private void createWrapCommentAction() {
            this.wrapCommentAction = new BooleanPrefAction(this, "resourcehistory_show_comment_wrap", UIText.ResourceHistory_toggleCommentWrap){

                @Override
                void apply(boolean wrap) {
                }
            };
            this.wrapCommentAction.apply(this.wrapCommentAction.isChecked());
            this.actionsToDispose.add(this.wrapCommentAction);
        }

        private void createFillCommentAction() {
            this.fillCommentAction = new BooleanPrefAction(this, "resourcehistory_fill_comment_paragraph", UIText.ResourceHistory_toggleCommentFill){

                @Override
                void apply(boolean fill) {
                }
            };
            this.fillCommentAction.apply(this.fillCommentAction.isChecked());
            this.actionsToDispose.add(this.fillCommentAction);
        }

        private void createConfigureFiltersAction() {
            this.configureFiltersAction = new ConfigureFilterAction();
            this.actionsToDispose.add(this.configureFiltersAction);
        }

        private abstract class BooleanPrefAction
        extends Action
        implements IPropertyChangeListener,
        ActionFactory.IWorkbenchAction {
            private final String prefName;

            BooleanPrefAction(String pn, String text) {
                this.setText(text);
                this.prefName = pn;
                GitHistoryPageActions.this.historyPage.store.addPropertyChangeListener((IPropertyChangeListener)this);
                this.setChecked(GitHistoryPageActions.this.historyPage.store.getBoolean(this.prefName));
            }

            public void run() {
                GitHistoryPageActions.this.historyPage.store.setValue(this.prefName, this.isChecked());
                GitHistoryPageActions.this.historyPage.saveStoreIfNeeded();
            }

            abstract void apply(boolean var1);

            public void propertyChange(PropertyChangeEvent event) {
                Control control;
                if (this.prefName.equals(event.getProperty()) && (control = GitHistoryPageActions.this.historyPage.getControl()) != null && !control.isDisposed()) {
                    control.getDisplay().asyncExec(() -> {
                        if (!control.isDisposed()) {
                            this.setChecked(GitHistoryPageActions.this.historyPage.store.getBoolean(this.prefName));
                            this.apply(this.isChecked());
                        }
                    });
                }
            }

            public void dispose() {
                GitHistoryPageActions.this.historyPage.store.removePropertyChangeListener((IPropertyChangeListener)this);
            }
        }

        private class ConfigureFilterAction
        extends Action
        implements ActionFactory.IWorkbenchAction,
        IPropertyChangeListener {
            private GitHistoryRefFilterConfigurationDialog dialog;
            private RefFilterHelper helper;

            ConfigureFilterAction() {
                super(UIText.GitHistoryPage_configureFilters);
                GitHistoryPageActions.this.historyPage.addPropertyChangeListener(this);
                Repository currentRepo = GitHistoryPageActions.this.historyPage.getCurrentRepo();
                if (currentRepo != null) {
                    this.helper = new RefFilterHelper(currentRepo);
                }
            }

            public void run() {
                if (GitHistoryPageActions.this.historyPage.getCurrentRepo() == null) {
                    return;
                }
                this.dialog = new GitHistoryRefFilterConfigurationDialog(GitHistoryPageActions.this.historyPage.getSite().getWorkbenchWindow().getShell(), GitHistoryPageActions.this.historyPage.getCurrentRepo(), this.helper);
                if (this.dialog.open() == 0) {
                    GitHistoryPageActions.this.historyPage.refresh(GitHistoryPageActions.this.historyPage.selectedCommit());
                }
            }

            public void dispose() {
                GitHistoryPageActions.this.historyPage.removePropertyChangeListener(this);
                if (this.dialog != null) {
                    this.dialog.close();
                }
            }

            public void propertyChange(PropertyChangeEvent event) {
                if (GitHistoryPage.P_REPOSITORY.equals(event.getProperty())) {
                    Repository currentRepo = GitHistoryPageActions.this.historyPage.getCurrentRepo();
                    if (currentRepo == null) {
                        this.setEnabled(false);
                        this.helper = null;
                    } else {
                        this.setEnabled(true);
                        this.helper = new RefFilterHelper(currentRepo);
                    }
                }
            }
        }

        private static class FilterAction
        extends DropDownMenuAction {
            @NonNull
            private final List<IAction> actions;
            private final IPropertyChangeListener listener;
            private boolean childEnablement = true;

            public FilterAction(IAction ... actions) {
                super(UIText.GitHistoryPage_FilterSubMenuLabel);
                List<Object> a = actions == null ? Collections.emptyList() : Arrays.asList(actions);
                this.actions = a;
                this.setToolTipText(UIText.GitHistoryPage_FilterTooltip);
                this.listener = e -> {
                    if ("enabled".equals(e.getProperty())) {
                        boolean previousEnablement = this.isEnabled();
                        this.childEnablement = this.actions.stream().anyMatch(IAction::isEnabled);
                        boolean currentEnablement = this.isEnabled();
                        if (currentEnablement != previousEnablement) {
                            IAction currentChild;
                            IAction iAction = currentChild = currentEnablement ? (IAction)this.actions.stream().filter(IAction::isChecked).findFirst().orElse(null) : null;
                            if (currentChild == null) {
                                this.setToolTipText(UIText.GitHistoryPage_FilterTooltip);
                            } else {
                                this.setToolTipText(MessageFormat.format(UIText.GitHistoryPage_FilterTooltipCurrent, currentChild.getToolTipText()));
                            }
                            this.firePropertyChange("enabled", previousEnablement, currentEnablement);
                        }
                    } else if ("checked".equals(e.getProperty())) {
                        Object source;
                        Object newValue = e.getNewValue();
                        boolean isChecked = false;
                        if (newValue instanceof Boolean) {
                            isChecked = (Boolean)newValue;
                        } else if (newValue instanceof String) {
                            isChecked = Boolean.parseBoolean((String)newValue);
                        }
                        if (isChecked && (source = e.getSource()) instanceof IAction) {
                            ImageDescriptor image;
                            if (this.isEnabled()) {
                                this.setToolTipText(MessageFormat.format(UIText.GitHistoryPage_FilterTooltipCurrent, ((IAction)source).getToolTipText()));
                            }
                            if ((image = ((IAction)source).getImageDescriptor()) != null) {
                                this.setImageDescriptor(image);
                            }
                        }
                    }
                };
                for (IAction action : this.actions) {
                    action.addPropertyChangeListener(this.listener);
                }
            }

            @Override
            protected Collection<IContributionItem> getActions() {
                return this.actions.stream().map(ActionContributionItem::new).collect(Collectors.toList());
            }

            public boolean isEnabled() {
                return super.isEnabled() && this.childEnablement;
            }

            @Override
            public void dispose() {
                for (IAction action : this.actions) {
                    action.removePropertyChangeListener(this.listener);
                }
                super.dispose();
            }

            @Override
            public void run() {
                if (!this.isEnabled()) {
                    return;
                }
                int i = 1;
                for (IAction action : this.actions) {
                    if (action.isChecked()) {
                        IAction next = this.actions.get(i % this.actions.size());
                        while (next != action) {
                            if (next.isEnabled()) {
                                action.setChecked(false);
                                next.setChecked(true);
                                next.run();
                                break;
                            }
                            next = this.actions.get(++i % this.actions.size());
                        }
                        return;
                    }
                    ++i;
                }
            }
        }

        private class SelectShownRefsAction
        extends DropDownMenuAction
        implements IPropertyChangeListener {
            private boolean headMode;
            private RefFilterHelper helper;

            public SelectShownRefsAction() {
                super(UIText.GitHistoryPage_SelectShownRefsMenuLabel);
                GitHistoryPageActions.this.historyPage.addPropertyChangeListener(this);
                Repository currentRepo = GitHistoryPageActions.this.historyPage.getCurrentRepo();
                if (currentRepo != null) {
                    this.helper = new RefFilterHelper(currentRepo);
                }
                this.setHeadModeFromHelperState();
                this.updateUiForMode();
            }

            private void setHeadModeFromHelperState() {
                if (this.helper == null) {
                    return;
                }
                Set<RefFilterHelper.RefFilter> filters = this.helper.getRefFilters();
                this.headMode = this.helper.isOnlyHEADSelected(filters);
            }

            private void updateUiForMode() {
                if (this.headMode) {
                    this.setImageDescriptor(UIIcons.BRANCH);
                    this.setToolTipText(UIText.GitHistoryPage_showingHistoryOfHead);
                } else {
                    this.setImageDescriptor(UIIcons.BRANCHES);
                    this.setToolTipText(UIText.GitHistoryPage_showingHistoryOfConfiguredFilters);
                }
            }

            @Override
            public void dispose() {
                GitHistoryPageActions.this.historyPage.removePropertyChangeListener(this);
                super.dispose();
            }

            @Override
            protected Collection<IContributionItem> getActions() {
                if (GitHistoryPageActions.this.historyPage.getCurrentRepo() == null) {
                    return new ArrayList<IContributionItem>();
                }
                ArrayList<IContributionItem> actions = new ArrayList<IContributionItem>();
                actions.add((IContributionItem)new ActionContributionItem((IAction)GitHistoryPageActions.this.configureFiltersAction));
                actions.add((IContributionItem)new Separator());
                Set<RefFilterHelper.RefFilter> filters = this.helper.getRefFilters();
                ArrayList<RefFilterHelper.RefFilter> sortedFilters = new ArrayList<RefFilterHelper.RefFilter>(filters);
                sortedFilters.sort(Comparator.comparing(RefFilterHelper.RefFilter::isPreconfigured, Comparator.reverseOrder()).thenComparing(RefFilterHelper.RefFilter::getFilterString, String.CASE_INSENSITIVE_ORDER));
                boolean separated = false;
                for (RefFilterHelper.RefFilter filter : sortedFilters) {
                    ShownRefAction action = new ShownRefAction(filter, () -> {
                        this.helper.setRefFilters(filters);
                        this.setHeadModeFromHelperState();
                        this.updateUiForMode();
                        GitHistoryPageActions.this.historyPage.refresh();
                    });
                    if (!separated && !filter.isPreconfigured()) {
                        actions.add((IContributionItem)new Separator());
                        separated = true;
                    }
                    actions.add((IContributionItem)new ActionContributionItem((IAction)action));
                }
                return actions;
            }

            @Override
            public void run() {
                if (GitHistoryPageActions.this.historyPage.getCurrentRepo() == null) {
                    return;
                }
                Set<RefFilterHelper.RefFilter> filters = this.helper.getRefFilters();
                if (this.helper.isOnlyHEADSelected(filters)) {
                    this.helper.restoreLastSelectionState(filters);
                    this.headMode = false;
                } else {
                    this.helper.saveSelectionStateAsLastSelectionState(filters);
                    this.helper.selectOnlyHEAD(filters);
                    this.headMode = true;
                }
                this.updateUiForMode();
                this.helper.setRefFilters(filters);
                GitHistoryPageActions.this.historyPage.refresh(GitHistoryPageActions.this.historyPage.selectedCommit());
            }

            public void propertyChange(PropertyChangeEvent event) {
                if (GitHistoryPage.P_REPOSITORY.equals(event.getProperty())) {
                    Repository currentRepo = GitHistoryPageActions.this.historyPage.getCurrentRepo();
                    if (currentRepo == null) {
                        this.setEnabled(false);
                        this.helper = null;
                    } else {
                        this.setEnabled(true);
                        this.helper = new RefFilterHelper(currentRepo);
                        this.setHeadModeFromHelperState();
                        this.updateUiForMode();
                    }
                }
            }

            private class ShownRefAction
            extends Action {
                private RefFilterHelper.RefFilter filter;
                private Runnable postChangeAction;

                public ShownRefAction(RefFilterHelper.RefFilter filter, Runnable postChangeAction) {
                    super(filter.getFilterString(), 2);
                    if (filter.isPreconfigured()) {
                        this.setText(filter.getFilterString() + UIText.GitHistoryPage_filterRefDialog_preconfiguredText);
                    }
                    this.filter = filter;
                    this.postChangeAction = postChangeAction;
                }

                public boolean isChecked() {
                    return this.filter.isSelected();
                }

                public void run() {
                    if (((SelectShownRefsAction)SelectShownRefsAction.this).GitHistoryPageActions.this.historyPage.getCurrentRepo() == null) {
                        return;
                    }
                    this.filter.setSelected(!this.filter.isSelected());
                    this.postChangeAction.run();
                }
            }
        }

        private class ShowFilterAction
        extends Action {
            private final ShowFilter filter;

            ShowFilterAction(ShowFilter filter, ImageDescriptor icon, String menuLabel, String toolTipText) {
                super(null, 2);
                this.filter = filter;
                this.setImageDescriptor(icon);
                this.setText(menuLabel);
                this.setToolTipText(toolTipText);
            }

            public void run() {
                String oldName = GitHistoryPageActions.this.historyPage.getName();
                String oldDescription = GitHistoryPageActions.this.historyPage.getDescription();
                if (!this.isChecked() && GitHistoryPageActions.this.historyPage.showAllFilter == this.filter) {
                    GitHistoryPageActions.this.historyPage.showAllFilter = ShowFilter.SHOWALLRESOURCE;
                    GitHistoryPageActions.this.showAllResourceVersionsAction.setChecked(true);
                    GitHistoryPageActions.this.historyPage.initAndStartRevWalk(false);
                }
                if (this.isChecked() && GitHistoryPageActions.this.historyPage.showAllFilter != this.filter) {
                    GitHistoryPageActions.this.historyPage.showAllFilter = this.filter;
                    if (this != GitHistoryPageActions.this.showAllRepoVersionsAction) {
                        GitHistoryPageActions.this.showAllRepoVersionsAction.setChecked(false);
                    }
                    if (this != GitHistoryPageActions.this.showAllProjectVersionsAction) {
                        GitHistoryPageActions.this.showAllProjectVersionsAction.setChecked(false);
                    }
                    if (this != GitHistoryPageActions.this.showAllFolderVersionsAction) {
                        GitHistoryPageActions.this.showAllFolderVersionsAction.setChecked(false);
                    }
                    if (this != GitHistoryPageActions.this.showAllResourceVersionsAction) {
                        GitHistoryPageActions.this.showAllResourceVersionsAction.setChecked(false);
                    }
                    GitHistoryPageActions.this.historyPage.initAndStartRevWalk(false);
                }
                GitHistoryPageActions.this.historyPage.firePropertyChange(GitHistoryPageActions.this.historyPage, "org.eclipse.team.ui.name", oldName, GitHistoryPageActions.this.historyPage.getName());
                GitHistoryPageActions.this.historyPage.firePropertyChange(GitHistoryPageActions.this.historyPage, "org.eclipse.team.ui.description", oldDescription, GitHistoryPageActions.this.historyPage.getDescription());
                Activator.getDefault().getPreferenceStore().setValue(GitHistoryPage.PREF_SHOWALLFILTER, GitHistoryPageActions.this.historyPage.showAllFilter.toString());
            }

            public String toString() {
                return "ShowFilter[" + this.filter.toString() + "]";
            }
        }

        private class ShowFirstParentOnlyPrefAction
        extends Action
        implements IPropertyChangeListener,
        ActionFactory.IWorkbenchAction {
            ShowFirstParentOnlyPrefAction() {
                super(UIText.GitHistoryPage_ShowFirstParentOnlyMenuLabel);
                GitHistoryPageActions.this.historyPage.addPropertyChangeListener(this);
                GitHistoryPageActions.this.historyPage.store.addPropertyChangeListener((IPropertyChangeListener)this);
                this.setChecked(GitHistoryPageActions.this.historyPage.isShowFirstParentOnly());
                this.setImageDescriptor(UIIcons.FIRST_PARENT_ONLY);
                this.setToolTipText(UIText.GitHistoryPage_showFirstParentOnly);
            }

            public void run() {
                String prefKey = "resourcehistory_show_first_parent_only";
                Repository repo = GitHistoryPageActions.this.historyPage.getCurrentRepo();
                if (repo != null) {
                    String repoSpecificKey = RepositoryUtil.INSTANCE.getRepositorySpecificPreferenceKey(repo, "resourcehistory_show_first_parent_only");
                    boolean newBoolean = this.isChecked();
                    if (newBoolean == GitHistoryPageActions.this.historyPage.store.getBoolean("resourcehistory_show_first_parent_only")) {
                        GitHistoryPageActions.this.historyPage.store.setToDefault(repoSpecificKey);
                    } else {
                        String newValue = newBoolean ? "true" : "false";
                        GitHistoryPageActions.this.historyPage.store.putValue(repoSpecificKey, newValue);
                    }
                    GitHistoryPageActions.this.historyPage.saveStoreIfNeeded();
                }
                GitHistoryPageActions.this.historyPage.refresh(GitHistoryPageActions.this.historyPage.selectedCommit());
            }

            private void applyNewState(boolean newState, boolean forceRefresh) {
                Control control = GitHistoryPageActions.this.historyPage.getControl();
                if (control != null && !control.isDisposed()) {
                    control.getDisplay().asyncExec(() -> {
                        if (!control.isDisposed()) {
                            this.setChecked(newState);
                        }
                    });
                }
                if (forceRefresh) {
                    GitHistoryPageActions.this.historyPage.refresh(GitHistoryPageActions.this.historyPage.selectedCommit());
                }
            }

            public void propertyChange(PropertyChangeEvent event) {
                Repository repo = GitHistoryPageActions.this.historyPage.getCurrentRepo();
                String prefKey = "resourcehistory_show_first_parent_only";
                if (repo == null) {
                    if ("resourcehistory_show_first_parent_only".equals(event.getProperty())) {
                        this.applyNewState(GitHistoryPageActions.this.historyPage.store.getBoolean("resourcehistory_show_first_parent_only"), true);
                    }
                    return;
                }
                String repoSpecificKey = RepositoryUtil.INSTANCE.getRepositorySpecificPreferenceKey(repo, "resourcehistory_show_first_parent_only");
                if ("resourcehistory_show_first_parent_only".equals(event.getProperty()) && !GitHistoryPageActions.this.historyPage.store.contains(repoSpecificKey)) {
                    this.applyNewState(GitHistoryPageActions.this.historyPage.store.getBoolean("resourcehistory_show_first_parent_only"), true);
                }
                if (GitHistoryPage.P_REPOSITORY.equals(event.getProperty())) {
                    this.applyNewState(GitHistoryPageActions.this.historyPage.isShowFirstParentOnly(), false);
                }
            }

            public void dispose() {
                GitHistoryPageActions.this.historyPage.removePropertyChangeListener(this);
                GitHistoryPageActions.this.historyPage.store.removePropertyChangeListener((IPropertyChangeListener)this);
            }
        }
    }

    private static class HistoryPageRule
    implements ISchedulingRule {
        private HistoryPageRule() {
        }

        public boolean contains(ISchedulingRule rule) {
            return this == rule;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return this == rule;
        }
    }

    private static final class HistorySearchBar
    extends SearchBar {
        private IActionBars bars;
        private final IAction openCloseToggle;
        private boolean wasVisible = false;
        private final KeyListener keyListener = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                int key = SWTKeySupport.convertEventToUnmodifiedAccelerator((KeyEvent)e);
                if (key == 27) {
                    this.setVisible(false);
                    e.doit = false;
                }
            }
        };
        private final Listener mouseListener = new Listener(){
            private boolean hasFocus;
            private boolean hadFocusOnMouseDown;

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 15: {
                        toolbar.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                hasFocus = true;
                            }
                        });
                        break;
                    }
                    case 16: {
                        this.hasFocus = false;
                        break;
                    }
                    case 3: {
                        this.hadFocusOnMouseDown = this.hasFocus;
                        break;
                    }
                    case 4: {
                        if (this.hadFocusOnMouseDown) break;
                        graph.getControl().setFocus();
                        toolbar.setFocus();
                        break;
                    }
                }
            }
        };

        public HistorySearchBar(String id, CommitGraphTable graph, IAction openCloseAction, IActionBars bars) {
            super(id, graph);
            this.bars = bars;
            this.openCloseToggle = openCloseAction;
            super.setVisible(false);
        }

        public boolean isDynamic() {
            return true;
        }

        @Override
        protected FindToolbar createControl(Composite parent) {
            FindToolbar createdControl = super.createControl(parent);
            this.toolbar.addKeyListener(this.keyListener);
            this.toolbar.addListener(15, this.mouseListener);
            this.toolbar.addListener(16, this.mouseListener);
            this.toolbar.addListener(3, this.mouseListener);
            this.toolbar.addListener(4, this.mouseListener);
            if (this.wasVisible) {
                return this.toolbar;
            }
            this.wasVisible = true;
            this.toolbar.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (toolbar != null && !toolbar.isDisposed()) {
                        graph.getControl().setFocus();
                        toolbar.setFocus();
                    }
                }
            });
            return createdControl;
        }

        private void beforeHide() {
            this.lastText = this.toolbar.getText();
            this.lastSearchContext = this.searchContext;
            this.showStatus(this.toolbar, "");
            this.toolbar = null;
            this.openCloseToggle.setChecked(false);
            this.wasVisible = false;
        }

        private void workAroundBug551067(boolean visible) {
            SubToolBarManager subManager;
            IContributionItem item;
            IContributionManager parent = this.getParent();
            if (parent instanceof SubToolBarManager && (item = (subManager = (SubToolBarManager)parent).getParent().find(this.getId())) instanceof SubContributionItem) {
                item.setVisible(visible && subManager.isVisible());
            }
        }

        public void setVisible(boolean visible) {
            if (visible != this.isVisible()) {
                if (!visible) {
                    this.beforeHide();
                }
                super.setVisible(visible);
                this.workAroundBug551067(visible);
                if (this.bars != null) {
                    this.bars.updateActionBars();
                }
                if (visible && this.toolbar != null) {
                    this.openCloseToggle.setChecked(true);
                    this.graph.getControl().setFocus();
                    this.toolbar.setFocus();
                } else if (!visible && !this.graph.getControl().isDisposed()) {
                    this.graph.getControl().setFocus();
                }
            }
        }

        @Override
        protected void showStatus(FindToolbar originator, String text) {
            this.bars.getStatusLineManager().setMessage(text);
        }
    }

    static enum ShowFilter {
        SHOWALLRESOURCE,
        SHOWALLFOLDER,
        SHOWALLPROJECT,
        SHOWALLREPO;

    }
}

