/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.model;

import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filter.parser.FilterCu;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filter.parser.IFilterStrings;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public abstract class AbstractTmfTraceDataProvider {
    private final ITmfTrace fTrace;

    public AbstractTmfTraceDataProvider(ITmfTrace trace) {
        this.fTrace = trace;
    }

    protected ITmfTrace getTrace() {
        return this.fTrace;
    }

    protected Map<Integer, Predicate<@NonNull Multimap<@NonNull String, @NonNull Object>>> computeRegexPredicate(Multimap<Integer, String> regexes) {
        HashMap<@NonNull Integer, @NonNull Predicate<@NonNull Multimap<@NonNull String, @NonNull Object>>> predicates = new HashMap<Integer, Predicate<Multimap<String, Object>>>();
        for (Map.Entry entry : regexes.asMap().entrySet()) {
            Predicate<Multimap<String, Object>> predicate;
            String regex = IFilterStrings.mergeFilters((Collection)entry.getValue());
            FilterCu cu = FilterCu.compile(regex);
            Predicate<Multimap<String, Object>> predicate2 = predicate = cu != null ? cu.generate() : null;
            if (predicate == null) continue;
            predicates.put((Integer)entry.getKey(), predicate);
        }
        return predicates;
    }
}

