/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.databinding.internal;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.AbstractObservableList;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.list.ListDiffEntry;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.NotifyingList;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.resource.Resource;

public class EWritableList<Type>
extends AbstractObservableList
implements IObservableList {
    private NotifyingList<Type> wrappedList;
    private Object elementType;
    private boolean stale = false;
    private Adapter listener;

    public EWritableList(NotifyingList<Type> wrappedList) {
        this(Realm.getDefault(), wrappedList);
    }

    public EWritableList(Realm realm, NotifyingList<Type> wrappedList) {
        this(realm, wrappedList, null);
    }

    public EWritableList(Realm realm, NotifyingList<Type> wrappedList, Class<Type> elementType) {
        super(realm);
        this.wrappedList = wrappedList;
        this.elementType = elementType;
    }

    protected void firstListenerAdded() {
        if (!(this.wrappedList.getNotifier() instanceof Notifier)) {
            throw new IllegalArgumentException("Wrapped list must have a notifier attached!");
        }
        Notifier notifier = (Notifier)this.wrappedList.getNotifier();
        this.listener = new Listener(this.wrappedList.getFeature());
        notifier.eAdapters().add((Object)this.listener);
    }

    protected void lastListenerRemoved() {
        if (!(this.wrappedList.getNotifier() instanceof Notifier)) {
            throw new IllegalArgumentException("Wrapped list must have a notifier attached!");
        }
        Notifier notifier = (Notifier)this.wrappedList.getNotifier();
        this.listener = new Listener(this.wrappedList.getFeature());
        notifier.eAdapters().remove((Object)this.listener);
    }

    public synchronized void dispose() {
        super.dispose();
    }

    private void getterCalled() {
        ObservableTracker.getterCalled((IObservable)this);
    }

    public boolean add(Object o) {
        this.checkRealm();
        return this.wrappedList.add(o);
    }

    public boolean addAll(Collection c) {
        this.checkRealm();
        return this.wrappedList.addAll(c);
    }

    public boolean addAll(int index, Collection c) {
        this.checkRealm();
        return this.wrappedList.addAll(index, c);
    }

    public boolean contains(Object o) {
        this.getterCalled();
        return this.wrappedList.contains(o);
    }

    public boolean containsAll(Collection c) {
        this.getterCalled();
        return this.wrappedList.containsAll(c);
    }

    public Object get(int index) {
        this.getterCalled();
        return this.wrappedList.get(index);
    }

    public Object getElementType() {
        this.checkRealm();
        return this.elementType;
    }

    public int indexOf(Object o) {
        this.getterCalled();
        return this.wrappedList.indexOf(o);
    }

    public boolean isEmpty() {
        this.getterCalled();
        return this.wrappedList.isEmpty();
    }

    public Iterator<Type> iterator() {
        this.getterCalled();
        return this.wrappedList.iterator();
    }

    public int lastIndexOf(Object o) {
        this.getterCalled();
        return this.wrappedList.lastIndexOf(o);
    }

    public ListIterator<Type> listIterator() {
        this.getterCalled();
        return this.wrappedList.listIterator();
    }

    public ListIterator<Type> listIterator(int index) {
        this.getterCalled();
        return this.wrappedList.listIterator(index);
    }

    public Object move(int oldIndex, int newIndex) {
        this.checkRealm();
        return this.wrappedList.move(newIndex, oldIndex);
    }

    public boolean remove(Object o) {
        this.checkRealm();
        return this.wrappedList.remove(o);
    }

    public Object remove(int index) {
        this.checkRealm();
        return this.wrappedList.remove(index);
    }

    public boolean removeAll(Collection c) {
        this.checkRealm();
        return this.wrappedList.removeAll(c);
    }

    public boolean retainAll(Collection c) {
        this.checkRealm();
        return this.wrappedList.retainAll(c);
    }

    public Object set(int index, Object element) {
        this.checkRealm();
        return this.wrappedList.set(index, element);
    }

    public int doGetSize() {
        this.getterCalled();
        return this.wrappedList.size();
    }

    public List<Type> subList(int fromIndex, int toIndex) {
        this.getterCalled();
        return this.wrappedList.subList(fromIndex, toIndex);
    }

    public Object[] toArray() {
        this.getterCalled();
        return this.wrappedList.toArray();
    }

    public Object[] toArray(Object[] a) {
        this.getterCalled();
        return this.wrappedList.toArray();
    }

    public void add(int index, Object element) {
        this.checkRealm();
        this.wrappedList.add(index, element);
    }

    public void clear() {
        this.checkRealm();
        this.wrappedList.clear();
    }

    public boolean isStale() {
        this.getterCalled();
        return this.stale;
    }

    private class Listener
    extends AdapterImpl {
        private Object feature;

        public Listener(Object feature) {
            this.feature = feature;
        }

        public void notifyChanged(Notification msg) {
            if (this.feature == null && msg.getFeature() == null && msg.getFeatureID(Resource.class) != 2) {
                return;
            }
            if (this.feature == msg.getFeature() && !msg.isTouch()) {
                ListDiff diff;
                switch (msg.getEventType()) {
                    case 3: {
                        diff = Diffs.createListDiff((ListDiffEntry)Diffs.createListDiffEntry((int)msg.getPosition(), (boolean)true, (Object)msg.getNewValue()));
                        break;
                    }
                    case 5: {
                        Collection newValues = (Collection)msg.getNewValue();
                        ListDiffEntry[] listDiffEntries = new ListDiffEntry[newValues.size()];
                        int position = msg.getPosition();
                        int index = 0;
                        for (Object newValue : newValues) {
                            listDiffEntries[index++] = Diffs.createListDiffEntry((int)position++, (boolean)true, newValue);
                        }
                        diff = Diffs.createListDiff((ListDiffEntry[])listDiffEntries);
                        break;
                    }
                    case 4: {
                        diff = Diffs.createListDiff((ListDiffEntry)Diffs.createListDiffEntry((int)msg.getPosition(), (boolean)false, (Object)msg.getOldValue()));
                        break;
                    }
                    case 6: {
                        Collection oldValues = (Collection)msg.getOldValue();
                        ListDiffEntry[] listDiffEntries = new ListDiffEntry[oldValues.size()];
                        int position = msg.getPosition();
                        int index = 0;
                        for (Object oldValue : oldValues) {
                            listDiffEntries[index++] = Diffs.createListDiffEntry((int)position++, (boolean)false, oldValue);
                        }
                        diff = Diffs.createListDiff((ListDiffEntry[])listDiffEntries);
                        break;
                    }
                    case 7: {
                        Object movedValue = msg.getNewValue();
                        ListDiffEntry[] listDiffEntries = new ListDiffEntry[]{Diffs.createListDiffEntry((int)((Integer)msg.getOldValue()), (boolean)false, (Object)movedValue), Diffs.createListDiffEntry((int)msg.getPosition(), (boolean)true, (Object)movedValue)};
                        diff = Diffs.createListDiff((ListDiffEntry[])listDiffEntries);
                        break;
                    }
                    case 2: {
                        return;
                    }
                    default: {
                        throw new RuntimeException("unhandled case");
                    }
                }
                EWritableList.this.getRealm().exec(new Runnable(){

                    @Override
                    public void run() {
                        EWritableList.this.fireListChange(diff);
                    }
                });
            }
        }
    }
}

