/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.IASTComment;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTImageLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIncludeStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroExpansion;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorStatement;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFileNomination;
import org.eclipse.cdt.core.dom.ast.IMacroBinding;
import org.eclipse.cdt.core.parser.ISignificantMacros;
import org.eclipse.cdt.core.parser.IncludeExportPatterns;
import org.eclipse.cdt.core.parser.util.CharArrayObjectMap;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.ASTNodeSpecification;
import org.eclipse.cdt.internal.core.dom.parser.ASTProblem;
import org.eclipse.cdt.internal.core.parser.scanner.ASTComment;
import org.eclipse.cdt.internal.core.parser.scanner.ASTElif;
import org.eclipse.cdt.internal.core.parser.scanner.ASTElse;
import org.eclipse.cdt.internal.core.parser.scanner.ASTEndif;
import org.eclipse.cdt.internal.core.parser.scanner.ASTError;
import org.eclipse.cdt.internal.core.parser.scanner.ASTFileLocation;
import org.eclipse.cdt.internal.core.parser.scanner.ASTFunctionStyleMacroDefinition;
import org.eclipse.cdt.internal.core.parser.scanner.ASTIf;
import org.eclipse.cdt.internal.core.parser.scanner.ASTIfdef;
import org.eclipse.cdt.internal.core.parser.scanner.ASTIfndef;
import org.eclipse.cdt.internal.core.parser.scanner.ASTImageLocation;
import org.eclipse.cdt.internal.core.parser.scanner.ASTInclusionStatement;
import org.eclipse.cdt.internal.core.parser.scanner.ASTMacroDefinition;
import org.eclipse.cdt.internal.core.parser.scanner.ASTMacroExpansion;
import org.eclipse.cdt.internal.core.parser.scanner.ASTMacroExpansionLocation;
import org.eclipse.cdt.internal.core.parser.scanner.ASTMacroReferenceName;
import org.eclipse.cdt.internal.core.parser.scanner.ASTPragma;
import org.eclipse.cdt.internal.core.parser.scanner.ASTPragmaOperator;
import org.eclipse.cdt.internal.core.parser.scanner.ASTPreprocessorName;
import org.eclipse.cdt.internal.core.parser.scanner.ASTPreprocessorNode;
import org.eclipse.cdt.internal.core.parser.scanner.ASTUndef;
import org.eclipse.cdt.internal.core.parser.scanner.AbstractCharArray;
import org.eclipse.cdt.internal.core.parser.scanner.DependencyTree;
import org.eclipse.cdt.internal.core.parser.scanner.FindNodeByImageLocation;
import org.eclipse.cdt.internal.core.parser.scanner.ILocationCtx;
import org.eclipse.cdt.internal.core.parser.scanner.ILocationResolver;
import org.eclipse.cdt.internal.core.parser.scanner.ISkippedIndexedFilesListener;
import org.eclipse.cdt.internal.core.parser.scanner.ImageLocationInfo;
import org.eclipse.cdt.internal.core.parser.scanner.InternalFileContent;
import org.eclipse.cdt.internal.core.parser.scanner.InternalFileContentProvider;
import org.eclipse.cdt.internal.core.parser.scanner.Lexer;
import org.eclipse.cdt.internal.core.parser.scanner.LocationCtx;
import org.eclipse.cdt.internal.core.parser.scanner.LocationCtxContainer;
import org.eclipse.cdt.internal.core.parser.scanner.LocationCtxFile;
import org.eclipse.cdt.internal.core.parser.scanner.LocationCtxMacroExpansion;
import org.eclipse.cdt.internal.core.parser.scanner.SignificantMacros;

public class LocationMap
implements ILocationResolver {
    private final Lexer.LexerOptions fLexerOptions;
    private String fTranslationUnitPath;
    private IASTTranslationUnit fTranslationUnit;
    private ArrayList<ASTPreprocessorNode> fDirectives = new ArrayList();
    private ArrayList<ASTProblem> fProblems = new ArrayList();
    private ArrayList<ASTComment> fComments = new ArrayList();
    private ArrayList<ASTMacroDefinition> fBuiltinMacros = new ArrayList();
    private ArrayList<ASTPreprocessorName> fMacroReferences = new ArrayList();
    private LocationCtxFile fRootContext;
    private LocationCtx fCurrentContext;
    private int fLastChildInsertionOffset;
    private IdentityHashMap<IBinding, IASTPreprocessorMacroDefinition> fMacroDefinitionMap;
    private List<ISkippedIndexedFilesListener> fSkippedFilesListeners = new ArrayList<ISkippedIndexedFilesListener>();
    private Map<String, LocationCtxFile> fFileContexts;

    public LocationMap(Lexer.LexerOptions lexOptions) {
        this.fLexerOptions = lexOptions;
    }

    @Override
    public Lexer.LexerOptions getLexerOptions() {
        return this.fLexerOptions;
    }

    public void registerPredefinedMacro(IMacroBinding macro) {
        this.registerPredefinedMacro(macro, null, -1);
    }

    public void registerMacroFromIndex(IMacroBinding macro, IName originalDefinition, int expansionOffset) {
        this.registerPredefinedMacro(macro, originalDefinition, expansionOffset);
    }

    private void registerPredefinedMacro(IMacroBinding macro, IName originalDefinition, int expansionOffset) {
        ASTMacroDefinition astMacro = macro.isFunctionStyle() ? new ASTFunctionStyleMacroDefinition(this.fTranslationUnit, macro, originalDefinition, expansionOffset) : new ASTMacroDefinition(this.fTranslationUnit, macro, originalDefinition, expansionOffset);
        this.fBuiltinMacros.add(astMacro);
    }

    public ILocationCtx pushTranslationUnit(String filename, AbstractCharArray buffer) {
        assert (this.fCurrentContext == null);
        this.fTranslationUnitPath = filename;
        this.fRootContext = new LocationCtxFile(null, filename, buffer, 0, 0, 0, null, true);
        this.fCurrentContext = this.fRootContext;
        this.fLastChildInsertionOffset = 0;
        return this.fCurrentContext;
    }

    public ILocationCtx pushPreInclusion(AbstractCharArray buffer, int offset, boolean isMacroFile) {
        assert (this.fCurrentContext instanceof LocationCtxContainer);
        int sequenceNumber = this.getSequenceNumberForOffset(offset);
        this.fCurrentContext = new LocationCtxContainer((LocationCtxContainer)this.fCurrentContext, buffer, offset, offset, sequenceNumber);
        this.fLastChildInsertionOffset = 0;
        return this.fCurrentContext;
    }

    public ILocationCtx pushInclusion(int startOffset, int nameOffset, int nameEndOffset, int endOffset, AbstractCharArray buffer, String filename, char[] name, boolean userInclude, boolean heuristic, boolean isSource) {
        assert (this.fCurrentContext instanceof LocationCtxContainer);
        int startNumber = this.getSequenceNumberForOffset(startOffset);
        int nameNumber = this.getSequenceNumberForOffset(nameOffset);
        int nameEndNumber = this.getSequenceNumberForOffset(nameEndOffset);
        int endNumber = this.getSequenceNumberForOffset(endOffset);
        boolean exported = this.isExportedIncludeAt(endOffset);
        ASTInclusionStatement inclusionStatement = new ASTInclusionStatement(this.fTranslationUnit, startNumber, nameNumber, nameEndNumber, endNumber, name, filename, userInclude, true, heuristic, exported, null);
        this.fDirectives.add(inclusionStatement);
        this.fCurrentContext = new LocationCtxFile((LocationCtxContainer)this.fCurrentContext, filename, buffer, startOffset, endOffset, endNumber, inclusionStatement, isSource);
        this.fLastChildInsertionOffset = 0;
        return this.fCurrentContext;
    }

    public IASTName encounterImplicitMacroExpansion(IMacroBinding macro, ImageLocationInfo imageLocationInfo) {
        return new ASTMacroReferenceName(null, IASTPreprocessorMacroExpansion.NESTED_EXPANSION_NAME, 0, 0, macro, imageLocationInfo);
    }

    public IASTName encounterDefinedExpression(IMacroBinding macro, int startOffset, int endOffset) {
        int startNumber = this.getSequenceNumberForOffset(startOffset);
        int endNumber = this.getSequenceNumberForOffset(endOffset);
        return new ASTMacroReferenceName(null, IASTPreprocessorStatement.MACRO_NAME, startNumber, endNumber, macro, null);
    }

    public ILocationCtx pushMacroExpansion(int nameOffset, int nameEndOffset, int endOffset, int contextLength, IMacroBinding macro, IASTName[] implicitMacroReferences, ImageLocationInfo[] imageLocations) {
        assert (this.fCurrentContext instanceof LocationCtxContainer);
        int nameNumber = this.getSequenceNumberForOffset(nameOffset);
        int nameEndNumber = this.getSequenceNumberForOffset(nameEndOffset);
        int endNumber = this.getSequenceNumberForOffset(endOffset);
        int length = endNumber - nameNumber;
        ASTMacroExpansion expansion = new ASTMacroExpansion(this.fTranslationUnit, nameNumber, endNumber);
        ASTMacroReferenceName explicitRef = new ASTMacroReferenceName((IASTNode)expansion, IASTPreprocessorMacroExpansion.EXPANSION_NAME, nameNumber, nameEndNumber, macro, null);
        this.addMacroReference(explicitRef);
        IASTName[] iASTNameArray = implicitMacroReferences;
        int n = implicitMacroReferences.length;
        int n2 = 0;
        while (n2 < n) {
            IASTName implicitMacroReference = iASTNameArray[n2];
            ASTMacroReferenceName name = (ASTMacroReferenceName)implicitMacroReference;
            name.setParent(expansion);
            name.setOffsetAndLength(nameNumber, length);
            this.addMacroReference(name);
            ++n2;
        }
        LocationCtxMacroExpansion expansionCtx = new LocationCtxMacroExpansion(this, (LocationCtxContainer)this.fCurrentContext, nameOffset, endOffset, endNumber, contextLength, imageLocations, explicitRef);
        expansion.setContext(expansionCtx);
        this.fCurrentContext = expansionCtx;
        this.fLastChildInsertionOffset = 0;
        return this.fCurrentContext;
    }

    private void addMacroReference(ASTPreprocessorName name) {
        if (name != null) {
            this.fMacroReferences.add(name);
        }
    }

    public void popContext(ILocationCtx locationCtx) {
        assert (this.fCurrentContext == locationCtx);
        LocationCtx child = this.fCurrentContext;
        LocationCtx parent = (LocationCtx)this.fCurrentContext.getParent();
        if (parent != null) {
            this.fCurrentContext = parent;
            this.fLastChildInsertionOffset = child.fEndOffsetInParent;
            parent.addChildSequenceLength(child.getSequenceLength());
        }
    }

    public ASTInclusionStatement encounterPoundInclude(int startOffset, int nameOffset, int nameEndOffset, int endOffset, char[] name, String filename, boolean userInclude, boolean active, boolean heuristic, IFileNomination nominationDelegate) {
        boolean exported = this.isExportedIncludeAt(endOffset);
        startOffset = this.getSequenceNumberForOffset(startOffset);
        nameOffset = this.getSequenceNumberForOffset(nameOffset);
        nameEndOffset = this.getSequenceNumberForOffset(nameEndOffset);
        endOffset = this.getSequenceNumberForOffset(endOffset);
        ASTInclusionStatement inc = new ASTInclusionStatement(this.fTranslationUnit, startOffset, nameOffset, nameEndOffset, endOffset, name, filename, userInclude, active, heuristic, exported, nominationDelegate);
        this.fDirectives.add(inc);
        return inc;
    }

    private boolean isExportedIncludeAt(int includeEndOffset) {
        int distance;
        LocationCtxFile context;
        boolean exported = false;
        if (this.fLexerOptions.fIncludeExportPatterns != null && this.fCurrentContext instanceof LocationCtxFile && !(exported = (context = (LocationCtxFile)this.fCurrentContext).isInsideIncludeExportBlock()) && (distance = context.getOffsetOfIncludeExport() - includeEndOffset) >= 0 && CharArrayUtils.indexOf('\n', context.getSource(includeEndOffset, distance)) < 0) {
            exported = true;
        }
        return exported;
    }

    public void encounteredComment(int offset, int endOffset, boolean isBlockComment, AbstractCharArray input) {
        ASTComment comment = new ASTComment(this.fTranslationUnit, this.getCurrentFilePath(), offset, endOffset, isBlockComment);
        if (this.fLexerOptions.fIncludeExportPatterns != null && this.fCurrentContext instanceof LocationCtxFile) {
            CharSequence text = this.getTrimmedCommentText(input.subSequence(offset, endOffset), isBlockComment);
            IncludeExportPatterns patterns = this.fLexerOptions.fIncludeExportPatterns;
            if (patterns.getIncludeExportPattern() != null && patterns.getIncludeExportPattern().matcher(text).matches()) {
                ((LocationCtxFile)this.fCurrentContext).setOffsetOfIncludeExport(offset);
            } else if (patterns.getIncludeBeginExportsPattern() != null && patterns.getIncludeBeginExportsPattern().matcher(text).matches()) {
                ((LocationCtxFile)this.fCurrentContext).setInsideIncludeExportBlock(true);
            } else if (patterns.getIncludeEndExportsPattern() != null && patterns.getIncludeEndExportsPattern().matcher(text).matches()) {
                ((LocationCtxFile)this.fCurrentContext).setInsideIncludeExportBlock(false);
            }
        }
        this.fComments.add(comment);
    }

    /*
     * Unable to fully structure code
     */
    private CharSequence getTrimmedCommentText(CharSequence comment, boolean isBlockComment) {
        end = comment.length() - (isBlockComment != false ? 2 : 0);
        begin = 2;
        while (begin < end) {
            if (!Character.isWhitespace(comment.charAt(begin))) break;
            ++begin;
        }
        if (end > begin) ** GOTO lbl-1000
        return "";
        while (Character.isWhitespace(comment.charAt(end))) lbl-1000:
        // 2 sources

        {
            if (--end >= begin) continue;
        }
        return comment.subSequence(begin, end + 1);
    }

    public void encounterProblem(int id, char[] arg, int offset, int endOffset) {
        offset = this.getSequenceNumberForOffset(offset);
        endOffset = this.getSequenceNumberForOffset(endOffset);
        ASTProblem problem = new ASTProblem(this.fTranslationUnit, IASTTranslationUnit.SCANNER_PROBLEM, id, arg, false, offset, endOffset);
        this.fProblems.add(problem);
    }

    public ASTElse encounterPoundElse(int startOffset, int endOffset, boolean isActive) {
        startOffset = this.getSequenceNumberForOffset(startOffset);
        endOffset = this.getSequenceNumberForOffset(endOffset);
        ASTElse astElse = new ASTElse(this.fTranslationUnit, startOffset, endOffset, isActive);
        this.fDirectives.add(astElse);
        return astElse;
    }

    public ASTElif encounterPoundElif(int startOffset, int condOffset, int condEndOffset, int endOffset, boolean taken, IASTName[] macrosInDefinedExpression) {
        startOffset = this.getSequenceNumberForOffset(startOffset);
        condOffset = this.getSequenceNumberForOffset(condOffset);
        condEndOffset = this.getSequenceNumberForOffset(condEndOffset);
        ASTElif elif = new ASTElif(this.fTranslationUnit, startOffset, condOffset, condEndOffset, taken);
        this.fDirectives.add(elif);
        IASTName[] iASTNameArray = macrosInDefinedExpression;
        int n = macrosInDefinedExpression.length;
        int n2 = 0;
        while (n2 < n) {
            IASTName element = iASTNameArray[n2];
            ASTMacroReferenceName name = (ASTMacroReferenceName)element;
            name.setParent(elif);
            name.setPropertyInParent(IASTPreprocessorStatement.MACRO_NAME);
            this.addMacroReference(name);
            ++n2;
        }
        return elif;
    }

    public ASTEndif encounterPoundEndIf(int startOffset, int endOffset) {
        startOffset = this.getSequenceNumberForOffset(startOffset);
        endOffset = this.getSequenceNumberForOffset(endOffset);
        ASTEndif stmt = new ASTEndif(this.fTranslationUnit, startOffset, endOffset);
        this.fDirectives.add(stmt);
        return stmt;
    }

    public void encounterPoundError(int startOffset, int condOffset, int condEndOffset, int endOffset) {
        startOffset = this.getSequenceNumberForOffset(startOffset);
        condOffset = this.getSequenceNumberForOffset(condOffset);
        condEndOffset = this.getSequenceNumberForOffset(condEndOffset);
        this.fDirectives.add(new ASTError(this.fTranslationUnit, startOffset, condOffset, condEndOffset));
    }

    public void encounterPoundPragma(int startOffset, int condOffset, int condEndOffset, int endOffset) {
        startOffset = this.getSequenceNumberForOffset(startOffset);
        condOffset = this.getSequenceNumberForOffset(condOffset);
        condEndOffset = this.getSequenceNumberForOffset(condEndOffset);
        this.fDirectives.add(new ASTPragma(this.fTranslationUnit, startOffset, condOffset, condEndOffset));
    }

    public void encounterPragmaOperator(int startNumber, int condNumber, int condEndNumber, int endNumber) {
        this.fDirectives.add(new ASTPragmaOperator(this.fTranslationUnit, startNumber, condNumber, condEndNumber, endNumber));
    }

    public ASTIfdef encounterPoundIfdef(int startOffset, int condOffset, int condEndOffset, int endOffset, boolean taken, IMacroBinding macro) {
        startOffset = this.getSequenceNumberForOffset(startOffset);
        condOffset = this.getSequenceNumberForOffset(condOffset);
        condEndOffset = this.getSequenceNumberForOffset(condEndOffset);
        ASTIfdef ifdef = new ASTIfdef(this.fTranslationUnit, startOffset, condOffset, condEndOffset, taken, macro);
        this.fDirectives.add(ifdef);
        this.addMacroReference(ifdef.getMacroReference());
        return ifdef;
    }

    public ASTIfndef encounterPoundIfndef(int startOffset, int condOffset, int condEndOffset, int endOffset, boolean taken, IMacroBinding macro) {
        startOffset = this.getSequenceNumberForOffset(startOffset);
        condOffset = this.getSequenceNumberForOffset(condOffset);
        condEndOffset = this.getSequenceNumberForOffset(condEndOffset);
        ASTIfndef ifndef = new ASTIfndef(this.fTranslationUnit, startOffset, condOffset, condEndOffset, taken, macro);
        this.fDirectives.add(ifndef);
        this.addMacroReference(ifndef.getMacroReference());
        return ifndef;
    }

    public ASTIf encounterPoundIf(int startOffset, int condOffset, int condEndOffset, int endOffset, boolean taken, IASTName[] macrosInDefinedExpression) {
        startOffset = this.getSequenceNumberForOffset(startOffset);
        condOffset = this.getSequenceNumberForOffset(condOffset);
        condEndOffset = this.getSequenceNumberForOffset(condEndOffset);
        ASTIf astif = new ASTIf(this.fTranslationUnit, startOffset, condOffset, condEndOffset, taken);
        this.fDirectives.add(astif);
        IASTName[] iASTNameArray = macrosInDefinedExpression;
        int n = macrosInDefinedExpression.length;
        int n2 = 0;
        while (n2 < n) {
            IASTName element = iASTNameArray[n2];
            ASTMacroReferenceName name = (ASTMacroReferenceName)element;
            name.setParent(astif);
            name.setPropertyInParent(IASTPreprocessorStatement.MACRO_NAME);
            this.addMacroReference(name);
            ++n2;
        }
        return astif;
    }

    public void encounterPoundDefine(int startOffset, int nameOffset, int nameEndOffset, int expansionOffset, int endOffset, boolean isActive, IMacroBinding macrodef) {
        startOffset = this.getSequenceNumberForOffset(startOffset);
        nameOffset = this.getSequenceNumberForOffset(nameOffset);
        nameEndOffset = this.getSequenceNumberForOffset(nameEndOffset);
        expansionOffset = this.getSequenceNumberForOffset(expansionOffset);
        endOffset = this.getSequenceNumberForOffset(endOffset);
        ASTMacroDefinition astMacro = !macrodef.isFunctionStyle() ? new ASTMacroDefinition(this.fTranslationUnit, macrodef, startOffset, nameOffset, nameEndOffset, expansionOffset, endOffset, isActive) : new ASTFunctionStyleMacroDefinition(this.fTranslationUnit, macrodef, startOffset, nameOffset, nameEndOffset, expansionOffset, endOffset, isActive);
        this.fDirectives.add(astMacro);
    }

    public void encounterPoundUndef(IMacroBinding definition, int startOffset, int nameOffset, int nameEndOffset, int endOffset, char[] name, boolean isActive) {
        startOffset = this.getSequenceNumberForOffset(startOffset);
        nameOffset = this.getSequenceNumberForOffset(nameOffset);
        nameEndOffset = this.getSequenceNumberForOffset(nameEndOffset);
        ASTUndef undef = new ASTUndef(this.fTranslationUnit, name, startOffset, nameOffset, nameEndOffset, definition, isActive);
        this.fDirectives.add(undef);
        this.addMacroReference(undef.getMacroName());
    }

    @Override
    public void setRootNode(IASTTranslationUnit root) {
        this.fTranslationUnit = root;
        if (this.fTranslationUnit instanceof ISkippedIndexedFilesListener) {
            this.fSkippedFilesListeners.add((ISkippedIndexedFilesListener)((Object)root));
        }
    }

    @Override
    public String getTranslationUnitPath() {
        return this.fTranslationUnitPath;
    }

    public int getCurrentLineNumber(int offset) {
        return this.fCurrentContext.getLineNumber(offset);
    }

    public String getCurrentFilePath() {
        return this.fCurrentContext.getFilePath();
    }

    int getSequenceNumberForOffset(int offset) {
        return this.fCurrentContext.getSequenceNumberForOffset(offset, offset < this.fLastChildInsertionOffset);
    }

    @Override
    public String getContainingFilePath(int sequenceNumber) {
        LocationCtx ctx = this.fRootContext.findSurroundingContext(sequenceNumber, 1);
        return ctx.getFilePath();
    }

    @Override
    public boolean isPartOfSourceFile(int sequenceNumber) {
        LocationCtx ctx = this.fRootContext.findSurroundingContext(sequenceNumber, 1);
        if (ctx == this.fRootContext && this.fTranslationUnit != null) {
            return !this.fTranslationUnit.isHeaderUnit();
        }
        return ctx.isSourceFile();
    }

    @Override
    public ASTFileLocation getMappedFileLocation(int sequenceNumber, int length) {
        return this.fRootContext.findMappedFileLocation(sequenceNumber, length);
    }

    @Override
    public int convertToSequenceEndNumber(int sequenceNumber) {
        return this.fRootContext.convertToSequenceEndNumber(sequenceNumber);
    }

    @Override
    public char[] getUnpreprocessedSignature(IASTFileLocation loc) {
        ASTFileLocation floc = this.convertFileLocation(loc);
        if (floc == null) {
            return CharArrayUtils.EMPTY;
        }
        return floc.getSource();
    }

    @Override
    public IASTPreprocessorMacroExpansion[] getMacroExpansions(IASTFileLocation loc) {
        ASTFileLocation floc = this.convertFileLocation(loc);
        if (floc == null) {
            return IASTPreprocessorMacroExpansion.EMPTY_ARRAY;
        }
        LocationCtxFile ctx = floc.getLocationContext();
        ArrayList<IASTPreprocessorMacroExpansion> list = new ArrayList<IASTPreprocessorMacroExpansion>();
        ctx.collectMacroExpansions(floc.getNodeOffset(), floc.getNodeLength(), list);
        return list.toArray(new IASTPreprocessorMacroExpansion[list.size()]);
    }

    private ASTFileLocation convertFileLocation(IASTFileLocation loc) {
        if (loc == null) {
            return null;
        }
        if (loc instanceof ASTFileLocation) {
            return (ASTFileLocation)loc;
        }
        String fileName = loc.getFileName();
        int nodeOffset = loc.getNodeOffset();
        int nodeLength = loc.getNodeLength();
        int sequenceNumber = this.getSequenceNumberForFileOffset(fileName, nodeOffset);
        if (sequenceNumber < 0) {
            return null;
        }
        int length = 0;
        if (nodeLength > 0 && (length = this.getSequenceNumberForFileOffset(fileName, nodeOffset + nodeLength - 1) + 1 - sequenceNumber) < 0) {
            return null;
        }
        return this.getMappedFileLocation(sequenceNumber, length);
    }

    @Override
    public IASTNodeLocation[] getLocations(int sequenceNumber, int length) {
        ArrayList<IASTNodeLocation> result = new ArrayList<IASTNodeLocation>();
        this.fRootContext.collectLocations(sequenceNumber, length, result);
        return result.toArray(new IASTNodeLocation[result.size()]);
    }

    @Override
    public boolean isPartOfTranslationUnitFile(int sequenceNumber) {
        return this.fRootContext.isThisFile(sequenceNumber);
    }

    @Override
    public IASTImageLocation getImageLocation(int sequenceNumber, int length) {
        ArrayList<IASTNodeLocation> result = new ArrayList<IASTNodeLocation>();
        this.fRootContext.collectLocations(sequenceNumber, length, result);
        if (result.size() != 1) {
            return null;
        }
        IASTNodeLocation loc = result.get(0);
        if (loc instanceof IASTFileLocation) {
            IASTFileLocation floc = (IASTFileLocation)loc;
            return new ASTImageLocation(1, floc.getFileName(), floc.getNodeOffset(), floc.getNodeLength());
        }
        if (loc instanceof ASTMacroExpansionLocation) {
            ASTMacroExpansionLocation mel = (ASTMacroExpansionLocation)loc;
            return mel.getImageLocation();
        }
        return null;
    }

    @Override
    public void findPreprocessorNode(ASTNodeSpecification<?> nodeSpec) {
        int sequenceStart = nodeSpec.getSequenceStart();
        int sequenceEnd = nodeSpec.getSequenceEnd();
        int from = this.findLastNodeBefore(this.fDirectives, sequenceStart);
        int i = from + 1;
        while (i < this.fDirectives.size()) {
            ASTPreprocessorNode directive = this.fDirectives.get(i);
            if (directive.getOffset() > sequenceEnd) break;
            directive.findNode(nodeSpec);
            ++i;
        }
        from = this.findLastMacroReferenceBefore(this.fMacroReferences, sequenceStart);
        i = from + 1;
        while (i < this.fMacroReferences.size()) {
            ASTPreprocessorNode macroRef = this.fMacroReferences.get(i);
            if (macroRef.getOffset() > sequenceEnd) break;
            if (macroRef.getPropertyInParent() != IASTPreprocessorMacroExpansion.NESTED_EXPANSION_NAME) {
                nodeSpec.visit(macroRef);
                IASTNode parent = macroRef.getParent();
                if (parent instanceof ASTMacroExpansion) {
                    ASTMacroExpansion expansion = (ASTMacroExpansion)parent;
                    assert (expansion.getMacroReference() == macroRef);
                    if (nodeSpec.canContainMatches(expansion)) {
                        nodeSpec.visit(expansion);
                        if (!nodeSpec.requiresClass(IASTPreprocessorMacroExpansion.class)) {
                            ASTPreprocessorName[] nestedMacros;
                            LocationCtxMacroExpansion ctx = expansion.getContext();
                            if (this.fTranslationUnit != null) {
                                FindNodeByImageLocation visitor = new FindNodeByImageLocation(ctx.fSequenceNumber, ctx.getSequenceLength(), nodeSpec);
                                this.fTranslationUnit.accept(visitor);
                            }
                            ASTPreprocessorName[] aSTPreprocessorNameArray = nestedMacros = expansion.getNestedMacroReferences();
                            int n = nestedMacros.length;
                            int n2 = 0;
                            while (n2 < n) {
                                ASTPreprocessorName nested = aSTPreprocessorNameArray[n2];
                                IASTImageLocation imgLoc = nested.getImageLocation();
                                if (imgLoc != null && imgLoc.getLocationKind() == 3) {
                                    nodeSpec.visit(nested, imgLoc);
                                }
                                ++n2;
                            }
                        }
                    }
                }
            }
            ++i;
        }
    }

    private int findLastNodeBefore(ArrayList<? extends ASTPreprocessorNode> nodes, int sequenceStart) {
        int lower = -1;
        int upper = nodes.size() - 1;
        while (lower < upper) {
            int middle = (lower + upper + 1) / 2;
            ASTPreprocessorNode candidate = nodes.get(middle);
            if (candidate.getOffset() + candidate.getLength() >= sequenceStart) {
                upper = middle - 1;
                continue;
            }
            lower = middle;
        }
        return lower;
    }

    private int findLastMacroReferenceBefore(ArrayList<? extends ASTPreprocessorName> nodes, int sequenceStart) {
        int lower = -1;
        int upper = nodes.size() - 1;
        while (lower < upper) {
            int middle = (lower + upper + 1) / 2;
            ASTPreprocessorNode candidate = nodes.get(middle);
            IASTNode parent = candidate.getParent();
            if (parent instanceof ASTMacroExpansion) {
                candidate = (ASTMacroExpansion)parent;
            }
            if (candidate.getOffset() + candidate.getLength() >= sequenceStart) {
                upper = middle - 1;
                continue;
            }
            lower = middle;
        }
        return lower;
    }

    @Override
    public int getSequenceNumberForFileOffset(String filePath, int fileOffset) {
        LocationCtxFile ctx = this.fRootContext;
        if (filePath != null) {
            if (this.fFileContexts == null) {
                this.fFileContexts = new HashMap<String, LocationCtxFile>();
                this.fFileContexts.put(this.fRootContext.getFilePath(), this.fRootContext);
                ArrayDeque<LocationCtxContainer> queue = new ArrayDeque<LocationCtxContainer>();
                LocationCtxContainer c = this.fRootContext;
                while (c != null) {
                    for (LocationCtx child : c.getChildren()) {
                        if (child instanceof LocationCtxFile) {
                            LocationCtxFile childFileContext = (LocationCtxFile)child;
                            String path = childFileContext.getFilePath();
                            if (this.fFileContexts.containsKey(path)) continue;
                            this.fFileContexts.put(path, childFileContext);
                            queue.add(childFileContext);
                            continue;
                        }
                        if (!(child instanceof LocationCtxContainer)) continue;
                        queue.add((LocationCtxContainer)child);
                    }
                    c = (LocationCtxContainer)queue.pollFirst();
                }
            }
            ctx = this.fFileContexts.get(filePath);
        }
        if (ctx == null) {
            return -1;
        }
        return ctx.getSequenceNumberForOffset(fileOffset, true);
    }

    @Override
    public IASTFileLocation flattenLocations(IASTNodeLocation[] locations) {
        IASTFileLocation to;
        if (locations.length == 0) {
            return null;
        }
        IASTFileLocation from = locations[0].asFileLocation();
        if (from == (to = locations[locations.length - 1].asFileLocation())) {
            return from;
        }
        if (from instanceof ASTFileLocation && to instanceof ASTFileLocation) {
            int sequenceNumber = ((ASTFileLocation)from).getSequenceNumber();
            int length = ((ASTFileLocation)from).getSequenceEndNumber() - sequenceNumber;
            if (length > 0) {
                return this.getMappedFileLocation(sequenceNumber, length);
            }
        }
        return null;
    }

    @Override
    public IASTPreprocessorMacroDefinition[] getMacroDefinitions() {
        ArrayList<IASTPreprocessorMacroDefinition> result = new ArrayList<IASTPreprocessorMacroDefinition>();
        for (ASTPreprocessorNode directive : this.fDirectives) {
            if (!(directive instanceof IASTPreprocessorMacroDefinition)) continue;
            result.add((IASTPreprocessorMacroDefinition)((Object)directive));
        }
        return result.toArray(new IASTPreprocessorMacroDefinition[result.size()]);
    }

    @Override
    public IASTPreprocessorIncludeStatement[] getIncludeDirectives() {
        ArrayList<IASTPreprocessorIncludeStatement> result = new ArrayList<IASTPreprocessorIncludeStatement>();
        for (ASTPreprocessorNode directive : this.fDirectives) {
            if (!(directive instanceof IASTPreprocessorIncludeStatement)) continue;
            result.add((IASTPreprocessorIncludeStatement)((Object)directive));
        }
        return result.toArray(new IASTPreprocessorIncludeStatement[result.size()]);
    }

    @Override
    public IASTComment[] getComments() {
        return this.fComments.toArray(new IASTComment[this.fComments.size()]);
    }

    @Override
    public IASTPreprocessorStatement[] getAllPreprocessorStatements() {
        return this.fDirectives.toArray(new IASTPreprocessorStatement[this.fDirectives.size()]);
    }

    @Override
    public IASTPreprocessorMacroDefinition[] getBuiltinMacroDefinitions() {
        return this.fBuiltinMacros.toArray(new IASTPreprocessorMacroDefinition[this.fBuiltinMacros.size()]);
    }

    @Override
    public IASTProblem[] getScannerProblems() {
        return this.fProblems.toArray(new IASTProblem[this.fProblems.size()]);
    }

    @Override
    public int getScannerProblemsCount() {
        return this.fProblems.size();
    }

    @Override
    public IASTName[] getDeclarations(IMacroBinding binding) {
        IASTName[] iASTNameArray;
        IASTPreprocessorMacroDefinition def = this.getMacroDefinition(binding);
        if (def == null) {
            iASTNameArray = IASTName.EMPTY_NAME_ARRAY;
        } else {
            IASTName[] iASTNameArray2 = new IASTName[1];
            iASTNameArray = iASTNameArray2;
            iASTNameArray2[0] = def.getName();
        }
        return iASTNameArray;
    }

    IASTPreprocessorMacroDefinition getMacroDefinition(IMacroBinding binding) {
        if (this.fMacroDefinitionMap == null) {
            IASTPreprocessorMacroDefinition[] defs;
            IASTPreprocessorMacroDefinition def;
            this.fMacroDefinitionMap = new IdentityHashMap();
            int i = 0;
            while (i < this.fBuiltinMacros.size()) {
                def = this.fBuiltinMacros.get(i);
                IASTName name = def.getName();
                if (name != null) {
                    this.fMacroDefinitionMap.put(name.getBinding(), def);
                }
                ++i;
            }
            IASTPreprocessorMacroDefinition[] iASTPreprocessorMacroDefinitionArray = defs = this.getMacroDefinitions();
            int n = defs.length;
            int n2 = 0;
            while (n2 < n) {
                def = iASTPreprocessorMacroDefinitionArray[n2];
                IASTName name = def.getName();
                if (name != null) {
                    this.fMacroDefinitionMap.put(name.getBinding(), def);
                }
                ++n2;
            }
        }
        return this.fMacroDefinitionMap.get(binding);
    }

    @Override
    public IASTName[] getReferences(IMacroBinding binding) {
        ArrayList<IASTName> result = new ArrayList<IASTName>();
        for (IASTName iASTName : this.fMacroReferences) {
            if (iASTName.getBinding() != binding) continue;
            result.add(iASTName);
        }
        return result.toArray(new IASTName[result.size()]);
    }

    public IASTName[] getMacroReferences() {
        return this.fMacroReferences.toArray(new IASTName[this.fMacroReferences.size()]);
    }

    public ASTPreprocessorName[] getNestedMacroReferences(ASTMacroExpansion expansion) {
        ASTMacroReferenceName explicitRef = expansion.getMacroReference();
        ArrayList<ASTPreprocessorName> result = new ArrayList<ASTPreprocessorName>();
        for (ASTPreprocessorName name : this.fMacroReferences) {
            if (name.getParent() != expansion || name == explicitRef) continue;
            result.add(name);
        }
        return result.toArray(new ASTPreprocessorName[result.size()]);
    }

    @Override
    public IASTTranslationUnit.IDependencyTree getDependencyTree() {
        return new DependencyTree(this.fRootContext);
    }

    public void cleanup() {
    }

    public void skippedFile(int sequenceNumber, InternalFileContent fi) {
        for (ISkippedIndexedFilesListener l : this.fSkippedFilesListeners) {
            l.skippedFile(sequenceNumber, fi);
        }
    }

    public void parsingFile(InternalFileContentProvider fileContentProvider, InternalFileContent fileContent) {
        for (ISkippedIndexedFilesListener l : this.fSkippedFilesListeners) {
            l.parsingFile(fileContentProvider, fileContent);
        }
    }

    public IFileNomination reportPragmaOnceSemantics(ILocationCtx locationCtx) {
        if (locationCtx == this.fRootContext) {
            if (this.fTranslationUnit != null) {
                this.fTranslationUnit.setPragmaOnceSemantics(true);
            }
            return this.fTranslationUnit;
        }
        if (locationCtx instanceof LocationCtxFile) {
            ASTInclusionStatement stmt = ((LocationCtxFile)locationCtx).getInclusionStatement();
            if (stmt != null) {
                stmt.setPragamOnceSemantics(true);
            }
            return stmt;
        }
        return null;
    }

    public void endTranslationUnit(int endOffset, CharArrayObjectMap<char[]> sigMacros) {
        if (this.fTranslationUnit != null) {
            int offset = this.getSequenceNumberForOffset(endOffset);
            ((ASTNode)((Object)this.fTranslationUnit)).setLength(offset);
            if (sigMacros != null) {
                ISignificantMacros sig = sigMacros.isEmpty() ? ISignificantMacros.NONE : new SignificantMacros(sigMacros);
                this.fTranslationUnit.setSignificantMacros(sig);
            }
        }
    }
}

