/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.console.ui.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class ConsoleViewManager {
    private List<Descriptor> extensions = new ArrayList<Descriptor>(5);

    public ConsoleViewManager(String extensionPoint) {
        this.extensions.add(new Descriptor("org.eclipse.ui.console.ConsoleView", 0));
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(extensionPoint);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            Descriptor descriptor = new Descriptor(element);
            if (this.isValidDescriptor(descriptor)) {
                this.extensions.add(descriptor);
            }
            ++n2;
        }
        Collections.sort(this.extensions, new Comparator<Descriptor>(){

            @Override
            public int compare(Descriptor arg0, Descriptor arg1) {
                return arg1.priority - arg0.priority;
            }
        });
    }

    public Descriptor[] getDescriptors() {
        return this.extensions.toArray(new Descriptor[this.extensions.size()]);
    }

    public Descriptor getFirst() {
        return this.extensions.get(0);
    }

    protected boolean isValidDescriptor(Descriptor descriptor) {
        return descriptor != null;
    }

    public static class Descriptor {
        private final String viewId;
        private final int priority;

        public Descriptor(String viewId, int priority) {
            this.viewId = viewId;
            this.priority = priority;
        }

        public Descriptor(IConfigurationElement element) {
            this.viewId = element.getAttribute("viewId");
            this.priority = Descriptor.parseInt(element.getAttribute("priority"));
        }

        protected static int parseInt(String value) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                return 0;
            }
        }

        public String getViewId() {
            return this.viewId;
        }
    }
}

