/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.text;

import org.eclipse.dltk.ui.text.PartitionDoubleClickSelector;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

public class JSDocDoubleClickStrategy
extends PartitionDoubleClickSelector {
    public JSDocDoubleClickStrategy(String partitioning) {
        super(partitioning, 0, 0);
    }

    protected IRegion findExtendedDoubleClickSelection(IDocument document, int position) {
        int end;
        int start;
        block9: {
            IRegion line;
            IRegion word;
            block8: {
                try {
                    IRegion match = super.findExtendedDoubleClickSelection(document, position);
                    if (match != null) {
                        return match;
                    }
                    word = this.findWord(document, position);
                    line = document.getLineInformationOfOffset(position);
                    if (position != line.getOffset() + line.getLength()) break block8;
                    return null;
                }
                catch (BadLocationException badLocationException) {
                    return null;
                }
            }
            start = word.getOffset();
            end = start + word.getLength();
            if (start > 0 && document.getChar(start - 1) == '@' && Character.isJavaIdentifierPart(document.getChar(start)) && (start == 1 || Character.isWhitespace(document.getChar(start - 2)) || document.getChar(start - 2) == '{')) {
                --start;
            } else if (end == position && end == start + 1 && end < line.getOffset() + line.getLength() && document.getChar(end) == '@') {
                return this.findExtendedDoubleClickSelection(document, position + 1);
            }
            if (start != end) break block9;
            return null;
        }
        return new Region(start, end - start);
    }

    protected IRegion findWord(IDocument document, int offset) {
        try {
            IRegion line = document.getLineInformationOfOffset(offset);
            String s = document.get(line.getOffset(), line.getLength());
            int index = offset - line.getOffset();
            int left = s.lastIndexOf(123, index);
            if (left >= 0) {
                ++left;
                int right = s.indexOf(125, index - 1);
                if (right >= 0) {
                    return new Region(line.getOffset() + left, right - left);
                }
            }
        }
        catch (BadLocationException badLocationException) {}
        return super.findWord(document, offset);
    }
}

