/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.wizards;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.ScriptModelUtil;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.internal.ui.util.SWTUtil;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.ComboDialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.dltk.ui.ModelElementLabelProvider;
import org.eclipse.dltk.ui.dialogs.StatusInfo;
import org.eclipse.dltk.ui.text.templates.ICodeTemplateArea;
import org.eclipse.dltk.ui.text.templates.SourceModuleTemplateContext;
import org.eclipse.dltk.ui.util.CodeGeneration;
import org.eclipse.dltk.ui.wizards.ISourceModuleWizard;
import org.eclipse.dltk.ui.wizards.ISourceModuleWizardExtension;
import org.eclipse.dltk.ui.wizards.ISourceModuleWizardMode;
import org.eclipse.dltk.ui.wizards.Messages;
import org.eclipse.dltk.ui.wizards.NewContainerWizardPage;
import org.eclipse.dltk.ui.wizards.NewSourceModuleWizard;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.PreferencesUtil;

public abstract class NewSourceModulePage
extends NewContainerWizardPage {
    static final String FILE = "NewSourceModulePage.file";
    private static final String TEMPLATE = "NewSourceModulePage.template";
    static final String EXTENSIONS = "NewSourceModulePage.extensions";
    protected IStatus sourceModuleStatus;
    private final List<IStatus> extensionStatus = new ArrayList<IStatus>();
    private StringDialogField fileDialogField;
    private static final String NO_TEMPLATE = "";
    private Template[] fTemplates;
    private ComboDialogField fTemplateDialogField = null;
    final List<ModeEntry> modes = new ArrayList<ModeEntry>();
    private final IDialogFieldListener modeSelectionUpdater = new IDialogFieldListener(){

        @Override
        public void dialogFieldChanged(DialogField field) {
            ModeEntry selection = null;
            for (ModeEntry f : NewSourceModulePage.this.modes) {
                if (f.field == null || !f.field.isSelected()) continue;
                selection = f;
            }
            if (selection != null) {
                for (ModeEntry f : NewSourceModulePage.this.modes) {
                    f.setSelection(f == selection);
                }
            }
            NewSourceModulePage.this.handleFieldChanged(NewSourceModulePage.TEMPLATE);
        }
    };

    private IStatus fileChanged() {
        StatusInfo status = new StatusInfo();
        if (this.getFileText().length() == 0) {
            status.setError(Messages.NewSourceModulePage_pathCannotBeEmpty);
        } else {
            if (!Path.EMPTY.isValidSegment(this.getFileText())) {
                status.setError(Messages.NewSourceModulePage_InvalidFileName);
            }
            if (this.getScriptFolder() != null) {
                ISourceModule module = this.getScriptFolder().getSourceModule(this.getFileName());
                if (module.exists()) {
                    status.setError(Messages.NewSourceModulePage_fileAlreadyExists);
                } else {
                    URI location;
                    IResource resource = module.getResource();
                    if (resource != null && (location = resource.getLocationURI()) != null) {
                        try {
                            IFileStore store = EFS.getStore((URI)location);
                            if (store.fetchInfo().exists()) {
                                status.setError(Messages.NewSourceModulePage_error_TypeNameExistsDifferentCase);
                            }
                        }
                        catch (CoreException coreException) {
                            status.setError(Messages.NewSourceModulePage_error_uri_location_unkown);
                        }
                    }
                }
            }
        }
        return status;
    }

    public void init(IStructuredSelection selection) {
        if (this.getTemplateArea() != null) {
            this.createTemplateField();
        }
        IModelElement element = this.getInitialScriptElement(selection);
        this.initContainerPage(element);
        this.updateTemplates();
        this.updateStatus(new IStatus[]{this.containerStatus, this.fileChanged()});
    }

    protected void createFileControls(Composite parent, int nColumns) {
        this.fileDialogField.doFillIntoGrid(parent, nColumns - 1);
        Text text = this.fileDialogField.getTextControl(null);
        LayoutUtil.setWidthHint((Control)text, this.getMaxFieldWidth());
        LayoutUtil.setHorizontalGrabbing((Control)text);
        DialogField.createEmptySpace(parent);
    }

    protected void createTemplateControls(Composite parent, int nColumns) {
        this.fTemplateDialogField.doFillIntoGrid(parent, nColumns - 1);
        LayoutUtil.setWidthHint((Control)this.fTemplateDialogField.getComboControl(null), this.getMaxFieldWidth());
        Button configureTemplates = new Button(parent, 8);
        GridData configureData = new GridData(4, 0, false, false);
        configureData.widthHint = SWTUtil.getButtonWidthHint(configureTemplates);
        configureTemplates.setLayoutData((Object)configureData);
        configureTemplates.setText(Messages.NewSourceModulePage_ConfigureTemplates);
        configureTemplates.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String templateName = null;
                Template template = NewSourceModulePage.this.getSelectedTemplate();
                if (template != null) {
                    templateName = template.getName();
                }
                HashMap<String, String> data = null;
                if (templateName != null) {
                    data = new HashMap<String, String>();
                    data.put("CodeTemplatePreferencePage.select_template", templateName);
                }
                String prefPageId = NewSourceModulePage.this.getTemplateArea().getTemplatePreferencePageId();
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)NewSourceModulePage.this.getShell(), (String)prefPageId, (String[])new String[]{prefPageId}, data);
                if (dialog.open() == 0) {
                    NewSourceModulePage.this.updateTemplates();
                }
            }
        });
    }

    protected void updateTemplates() {
        if (this.fTemplateDialogField != null) {
            Template template;
            Template selected = this.getSelectedTemplate();
            String name = selected != null ? selected.getName() : this.getLastUsedTemplateName();
            this.fTemplates = this.getApplicableTemplates();
            int idx = 0;
            String[] names = new String[this.fTemplates.length + 1];
            int i = 0;
            while (i < this.fTemplates.length) {
                names[i + 1] = this.fTemplates[i].getName();
                if (name != null && name.equals(names[i + 1])) {
                    idx = i + 1;
                }
                ++i;
            }
            if (idx == 0 && (template = this.getDefaultTemplate()) != null) {
                int i2 = 0;
                while (i2 < this.fTemplates.length) {
                    if (template == this.fTemplates[i2]) {
                        idx = i2 + 1;
                        break;
                    }
                    ++i2;
                }
            }
            names[0] = Messages.NewSourceModulePage_noTemplate;
            this.fTemplateDialogField.setItems(names);
            this.fTemplateDialogField.selectItem(idx);
        }
    }

    protected Template getDefaultTemplate() {
        ICodeTemplateArea templateArea;
        String defaultTemplateId = this.getDefaultCodeTemplateId();
        if (defaultTemplateId != null && (templateArea = this.getTemplateArea()) != null) {
            TemplateStore store = templateArea.getTemplateAccess().getTemplateStore();
            return store.findTemplateById(defaultTemplateId);
        }
        return null;
    }

    protected Template[] getApplicableTemplates() {
        ArrayList<Template> result = new ArrayList<Template>();
        ICodeTemplateArea templateArea = this.getTemplateArea();
        if (templateArea != null) {
            TemplateStore store = templateArea.getTemplateAccess().getTemplateStore();
            String[] contextTypeIds = this.getCodeTemplateContextTypeIds();
            int i = 0;
            while (i < contextTypeIds.length) {
                Template[] templates = store.getTemplates(contextTypeIds[i]);
                Arrays.sort(templates, new Comparator<Template>(){

                    @Override
                    public int compare(Template t0, Template t1) {
                        return t0.getName().compareToIgnoreCase(t1.getName());
                    }
                });
                int j = 0;
                while (j < templates.length) {
                    result.add(templates[j]);
                    ++j;
                }
                ++i;
            }
        }
        return result.toArray(new Template[result.size()]);
    }

    protected String getLastUsedTemplateKey() {
        return String.valueOf(((Object)((Object)this)).getClass().getName()) + "_LAST_USED_TEMPLATE";
    }

    protected String getLastUsedTemplateName() {
        IDialogSettings dialogSettings = this.getDialogSettings();
        return dialogSettings != null ? dialogSettings.get(this.getLastUsedTemplateKey()) : null;
    }

    protected void saveLastUsedTemplateName(String name) {
        IDialogSettings dialogSettings = this.getDialogSettings();
        if (dialogSettings != null) {
            dialogSettings.put(this.getLastUsedTemplateKey(), name);
        }
    }

    protected Template getSelectedTemplate() {
        int index;
        if (this.fTemplateDialogField != null && (index = this.fTemplateDialogField.getSelectionIndex() - 1) >= 0 && index < this.fTemplates.length) {
            return this.fTemplates[index];
        }
        return null;
    }

    public NewSourceModulePage() {
        super("wizardPage");
        this.setTitle(this.getPageTitle());
        this.setDescription(this.getPageDescription());
        this.sourceModuleStatus = new StatusInfo();
        this.fileDialogField = new StringDialogField();
        this.fileDialogField.setLabelText(Messages.NewSourceModulePage_file);
        this.fileDialogField.setDialogFieldListener(new IDialogFieldListener(){

            @Override
            public void dialogFieldChanged(DialogField field) {
                NewSourceModulePage.this.sourceModuleStatus = NewSourceModulePage.this.fileChanged();
                NewSourceModulePage.this.handleFieldChanged(NewSourceModulePage.FILE);
            }
        });
    }

    protected void createTemplateField() {
        this.fTemplateDialogField = new ComboDialogField(8);
        this.fTemplateDialogField.setLabelText(Messages.NewSourceModulePage_Template);
    }

    @Override
    protected void handleFieldChanged(String fieldName) {
        IWizard wizard;
        super.handleFieldChanged(fieldName);
        if (fieldName == "NewContainerWizardPage.container") {
            this.sourceModuleStatus = this.fileChanged();
        }
        if ((fieldName == FILE || fieldName == "NewContainerWizardPage.container") && (wizard = this.getWizard()) != null) {
            ((NewSourceModuleWizard)wizard).fireFieldChange(fieldName);
        }
        if (fieldName == EXTENSIONS) {
            this.extensionStatus.clear();
            for (ISourceModuleWizardExtension extension : this.getExtensions()) {
                IStatus status = extension.validate();
                if (status == null) continue;
                this.extensionStatus.add(status);
            }
        }
        ArrayList<IStatus> statuses = new ArrayList<IStatus>();
        if (this.containerStatus != null) {
            statuses.add(this.containerStatus);
        }
        if (this.sourceModuleStatus != null) {
            statuses.add(this.sourceModuleStatus);
        }
        statuses.addAll(this.extensionStatus);
        this.updateStatus(statuses.toArray(new IStatus[statuses.size()]));
    }

    public ISourceModule createFile(IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        String fileName = this.getFileName();
        ISourceModule module = this.getScriptFolder().getSourceModule(fileName);
        CreateContext context = new CreateContext(this.getScriptFolder(), module);
        context.addStep("PREPARE", 0, new InitializeFileContent());
        context.addStep("EXECUTE", 0, new CreateSourceModuleStep());
        for (ISourceModuleWizardExtension extension : this.getExtensions()) {
            extension.prepare(context);
        }
        ArrayList steps = new ArrayList();
        Collections.addAll(steps, context.getSteps("PREPARE"));
        Collections.addAll(steps, context.getSteps("EXECUTE"));
        Collections.addAll(steps, context.getSteps("FINALIZE"));
        for (ISourceModuleWizard.ICreateStep step : steps) {
            step.execute(context, monitor);
        }
        return module;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridData layoutData = new GridData(4, 0, true, false);
        composite.setLayoutData((Object)layoutData);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        this.createContentControls(composite, 3);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
    }

    private ModeEntry getActiveMode() {
        for (ModeEntry f : this.modes) {
            if (!f.getSelection()) continue;
            return f;
        }
        if (!this.modes.isEmpty()) {
            return this.modes.get(0);
        }
        throw new IllegalStateException("No modes");
    }

    protected void createContentControls(Composite composite, int nColumns) {
        this.createContainerControls(composite, nColumns);
        this.createFileControls(composite, nColumns);
        ArrayList<ISourceModuleWizardMode> modes = new ArrayList<ISourceModuleWizardMode>();
        for (ISourceModuleWizardExtension extension : this.getExtensions()) {
            modes.addAll(extension.getModes());
        }
        if (!modes.isEmpty()) {
            Group contents = new Group(composite, 0);
            contents.setText("Location");
            GridData ggd = new GridData(4, -1, true, false);
            ggd.horizontalSpan = nColumns;
            contents.setLayoutData((Object)ggd);
            contents.setLayout((Layout)new GridLayout(nColumns, false));
            ModeEntry wsEntry = this.addMode((Composite)contents, nColumns, new WorkspaceMode());
            ((GridData)wsEntry.field.getSelectionButton().getLayoutData()).horizontalSpan = nColumns;
            for (ISourceModuleWizardMode template : modes) {
                this.addMode((Composite)contents, nColumns, template);
            }
            for (ModeEntry modeEntry : this.modes) {
                modeEntry.field.setDialogFieldListener(this.modeSelectionUpdater);
            }
        } else {
            ModeEntry entry = new ModeEntry(null, new WorkspaceMode());
            entry.setSelection(true);
            this.modes.add(entry);
        }
        if (this.fTemplateDialogField != null) {
            this.createTemplateControls(composite, nColumns);
        }
    }

    private List<ISourceModuleWizardExtension> getExtensions() {
        return ((NewSourceModuleWizard)this.getWizard()).getExtensions();
    }

    private ModeEntry addMode(Composite parent, int nColumns, ISourceModuleWizardMode template) {
        SelectionButtonDialogField field = new SelectionButtonDialogField(16);
        field.setLabelText(template.getName());
        field.doFillIntoGrid(parent, 1);
        template.createControl(parent, nColumns - 1);
        ModeEntry entry = new ModeEntry(field, template);
        this.modes.add(entry);
        String activeMode = ((NewSourceModuleWizard)this.getWizard()).getMode();
        if (activeMode == null) {
            activeMode = "org.eclipse.dltk.ui.sourceModuleWizard.workspace";
        }
        entry.setSelection(template.getId().equals(activeMode));
        entry.field.setEnabled(((NewSourceModuleWizard)this.getWizard()).isModeEnabled(template.getId()));
        return entry;
    }

    protected String getFileText() {
        return this.fileDialogField.getText();
    }

    public void setFileText(String name, boolean canBeModified) {
        this.fileDialogField.setText(name);
        this.fileDialogField.setEnabled(canBeModified);
    }

    protected String getFileName() {
        String fileText = this.getFileText();
        String[] extensions = this.getFileExtensions();
        int i = 0;
        while (i < extensions.length) {
            String extension = extensions[i];
            if (extension.length() > 0 && fileText.endsWith("." + extension)) {
                return fileText;
            }
            ++i;
        }
        return String.valueOf(fileText) + "." + extensions[0];
    }

    protected String[] getFileExtensions() {
        String requiredNature = this.getRequiredNature();
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit((String)requiredNature);
        String[] extensions = ScriptModelUtil.getFileExtensions((IDLTKLanguageToolkit)toolkit);
        if (extensions != null) {
            return extensions;
        }
        return new String[]{NO_TEMPLATE};
    }

    protected IScriptFolder chooseScriptFolder() {
        Object element;
        ElementListSelectionDialog dialog;
        block5: {
            ModelElementLabelProvider labelProvider = new ModelElementLabelProvider(ModelElementLabelProvider.SHOW_DEFAULT);
            dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
            dialog.setIgnoreCase(false);
            dialog.setTitle(Messages.NewSourceModulePage_selectScriptFolder);
            dialog.setMessage(Messages.NewSourceModulePage_selectScriptFolder);
            dialog.setEmptyListMessage(Messages.NewSourceModulePage_noFoldersAvailable);
            IProjectFragment projectFragment = this.getProjectFragment();
            if (projectFragment != null) {
                try {
                    dialog.setElements((Object[])projectFragment.getChildren());
                }
                catch (ModelException e) {
                    if (!DLTKCore.DEBUG) break block5;
                    e.printStackTrace();
                }
            }
        }
        dialog.setHelpAvailable(false);
        if (this.getScriptFolder() != null) {
            dialog.setInitialSelections(new Object[]{this.getScriptFolder()});
        }
        if (dialog.open() == 0 && (element = dialog.getFirstResult()) instanceof IScriptFolder) {
            return (IScriptFolder)element;
        }
        return null;
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setFocus();
        }
    }

    protected void setFocus() {
        this.fileDialogField.setFocus();
    }

    protected abstract String getPageTitle();

    protected abstract String getPageDescription();

    protected ICodeTemplateArea getTemplateArea() {
        return null;
    }

    protected String[] getCodeTemplateContextTypeIds() {
        return null;
    }

    protected String getDefaultCodeTemplateId() {
        return null;
    }

    protected String getFileContent(ISourceModule module) throws CoreException {
        ICodeTemplateArea templateArea = this.getTemplateArea();
        if (templateArea != null) {
            Template template = this.getSelectedTemplate();
            this.saveLastUsedTemplateName(template != null ? template.getName() : NO_TEMPLATE);
            if (template != null) {
                TemplateContextType contextType = templateArea.getTemplateAccess().getContextTypeRegistry().getContextType(template.getContextTypeId());
                SourceModuleTemplateContext context = new SourceModuleTemplateContext(contextType, CodeGeneration.getLineDelimiterUsed((IModelElement)module));
                context.setSourceModuleVariables(module);
                String[] fullLine = new String[]{};
                String result = CodeGeneration.evaluateTemplate(context, template, fullLine);
                return result != null ? result : NO_TEMPLATE;
            }
        }
        return this.getFileContent();
    }

    protected String getFileContent() {
        return NO_TEMPLATE;
    }

    protected IEnvironment getEnvironment() {
        IProjectFragment fragment = this.getProjectFragment();
        if (fragment != null) {
            return EnvironmentManager.getEnvironment((IProject)fragment.getScriptProject().getProject());
        }
        return null;
    }

    String getMode() {
        return this.getActiveMode().template.getId();
    }

    void setMode(String mode) {
        for (ModeEntry entry : this.modes) {
            entry.setSelection(mode != null && mode.equals(entry.template.getId()));
        }
    }

    void enableMode(String mode, boolean enable) {
        boolean updateSelection = false;
        for (ModeEntry entry : this.modes) {
            if (!mode.equals(entry.template.getId()) || entry.field == null) continue;
            if (entry.getSelection() && !enable) {
                updateSelection = true;
                entry.setSelection(false);
            }
            entry.field.setEnabled(enable);
        }
        if (updateSelection) {
            for (ModeEntry entry : this.modes) {
                if (entry.field != null && !entry.field.isEnabled()) continue;
                entry.setSelection(true);
                break;
            }
        }
    }

    private static class CreateContext
    implements ISourceModuleWizard.ICreateContext {
        final IScriptFolder scriptFolder;
        final ISourceModule sourceModule;
        final List<StepEntry> entries = new ArrayList<StepEntry>();
        private String content = "";

        public CreateContext(IScriptFolder scriptFolder, ISourceModule sourceModule) {
            this.scriptFolder = scriptFolder;
            this.sourceModule = sourceModule;
        }

        @Override
        public IEnvironment getEnvironment() {
            IEnvironment environment = EnvironmentManager.getEnvironment((IModelElement)this.getScriptFolder());
            if (environment == null) {
                environment = EnvironmentManager.getLocalEnvironment();
            }
            return environment;
        }

        @Override
        public IScriptFolder getScriptFolder() {
            return this.scriptFolder;
        }

        @Override
        public IScriptProject getScriptProject() {
            return this.getScriptFolder().getScriptProject();
        }

        @Override
        public ISourceModule getSourceModule() {
            return this.sourceModule;
        }

        @Override
        public void addStep(String kind, int priority, ISourceModuleWizard.ICreateStep step) {
            this.entries.add(new StepEntry(kind, priority, step));
        }

        @Override
        public ISourceModuleWizard.ICreateStep[] getSteps(String kind) {
            ArrayList<StepEntry> selection = new ArrayList<StepEntry>();
            for (StepEntry entry : this.entries) {
                if (!kind.equals(entry.kind)) continue;
                selection.add(entry);
            }
            Collections.sort(selection, new Comparator<StepEntry>(){

                @Override
                public int compare(StepEntry e1, StepEntry e2) {
                    return e1.priority - e1.priority;
                }
            });
            ISourceModuleWizard.ICreateStep[] steps = new ISourceModuleWizard.ICreateStep[selection.size()];
            int i = 0;
            while (i < selection.size()) {
                steps[i] = ((StepEntry)selection.get((int)i)).step;
                ++i;
            }
            return steps;
        }

        @Override
        public String getContent() {
            return this.content;
        }

        @Override
        public void setContent(String content) {
            this.content = content;
        }

        private static class StepEntry {
            final String kind;
            final int priority;
            final ISourceModuleWizard.ICreateStep step;

            public StepEntry(String kind, int priority, ISourceModuleWizard.ICreateStep step) {
                this.kind = kind;
                this.priority = priority;
                this.step = step;
            }
        }
    }

    static class CreateSourceModuleStep
    implements ISourceModuleWizard.ICreateStep {
        CreateSourceModuleStep() {
        }

        @Override
        public void execute(ISourceModuleWizard.ICreateContext context, IProgressMonitor monitor) throws CoreException {
            context.getScriptFolder().createSourceModule(context.getSourceModule().getElementName(), context.getContent(), true, monitor);
        }
    }

    class InitializeFileContent
    implements ISourceModuleWizard.ICreateStep {
        InitializeFileContent() {
        }

        @Override
        public void execute(ISourceModuleWizard.ICreateContext context, IProgressMonitor monitor) throws CoreException {
            context.setContent(NewSourceModulePage.this.getFileContent(context.getSourceModule()));
        }
    }

    private static class ModeEntry {
        final SelectionButtonDialogField field;
        final ISourceModuleWizardMode template;
        private Boolean enabled = null;

        public ModeEntry(SelectionButtonDialogField field, ISourceModuleWizardMode template) {
            this.field = field;
            this.template = template;
        }

        public boolean getSelection() {
            return this.enabled != null && this.enabled != false;
        }

        public void setSelection(boolean value) {
            if (this.enabled == null || value != this.enabled) {
                if (this.field != null) {
                    this.field.setSelection(value);
                }
                this.template.setEnabled(value);
                this.enabled = value;
            }
        }
    }

    private static class WorkspaceMode
    implements ISourceModuleWizardMode {
        @Override
        public void createControl(Composite parent, int columns) {
        }

        @Override
        public String getId() {
            return "org.eclipse.dltk.ui.sourceModuleWizard.workspace";
        }

        @Override
        public String getName() {
            return "&workspace";
        }

        @Override
        public void setEnabled(boolean enabled) {
        }
    }
}

