/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.NopTypeNameRequestor;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.core.search.TypeNameMatch;
import org.eclipse.dltk.core.search.TypeNameRequestor;
import org.eclipse.dltk.internal.corext.util.Messages;
import org.eclipse.dltk.internal.corext.util.OpenTypeHistory;
import org.eclipse.dltk.internal.ui.DLTKUIMessages;
import org.eclipse.dltk.internal.ui.dialogs.TypeSelectionComponent;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.IDLTKUILanguageToolkit;
import org.eclipse.dltk.ui.ScriptElementLabels;
import org.eclipse.dltk.ui.dialogs.TypeSelectionExtension;
import org.eclipse.dltk.ui.util.ExceptionHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class TypeSelectionDialog2
extends SelectionStatusDialog {
    private String fTitle;
    private boolean fMultipleSelection;
    private IRunnableContext fRunnableContext;
    private IDLTKSearchScope fScope;
    private int fElementKind;
    private String fInitialFilter;
    private int fSelectionMode;
    private ISelectionStatusValidator fValidator;
    private TypeSelectionComponent fContent;
    private TypeSelectionExtension fExtension;
    public static final int NONE = 0;
    public static final int CARET_BEGINNING = 1;
    public static final int FULL_SELECTION = 2;
    private static boolean fgFirstTime = true;
    private IDLTKUILanguageToolkit fToolkit;

    public TypeSelectionDialog2(Shell parent, boolean multi, IRunnableContext context, IDLTKSearchScope scope, int elementKinds, IDLTKUILanguageToolkit toolkit) {
        this(parent, multi, context, scope, elementKinds, null, toolkit);
    }

    public TypeSelectionDialog2(Shell parent, boolean multi, IRunnableContext context, IDLTKSearchScope scope, int elementKinds, TypeSelectionExtension extension, IDLTKUILanguageToolkit toolkit) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fMultipleSelection = multi;
        this.fRunnableContext = context;
        this.fScope = scope;
        this.fElementKind = elementKinds;
        this.fSelectionMode = 0;
        this.fExtension = extension;
        if (this.fExtension != null) {
            this.fValidator = this.fExtension.getSelectionValidator();
        }
        this.fToolkit = toolkit;
    }

    public void setFilter(String filter) {
        this.setFilter(filter, 2);
    }

    public void setFilter(String filter, int selectionMode) {
        this.fInitialFilter = filter;
        this.fSelectionMode = selectionMode;
    }

    public void setValidator(ISelectionStatusValidator validator) {
        this.fValidator = validator;
    }

    protected TypeNameMatch[] getSelectedTypes() {
        if (this.fContent == null || this.fContent.isDisposed()) {
            return null;
        }
        return this.fContent.getSelection();
    }

    public void create() {
        super.create();
        this.fContent.populate(this.fSelectionMode);
        this.getOkButton().setEnabled(this.fContent.getSelection().length > 0);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        this.fContent = new TypeSelectionComponent(area, 0, this.getMessage(), this.fMultipleSelection, this.fScope, this.fElementKind, this.fInitialFilter, new TitleLabel(), this.fExtension, this.fToolkit);
        GridData gd = new GridData(1808);
        this.fContent.setLayoutData(gd);
        this.fContent.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                TypeSelectionDialog2.this.handleDefaultSelected(TypeSelectionDialog2.this.fContent.getSelection());
            }

            public void widgetSelected(SelectionEvent e) {
                TypeSelectionDialog2.this.handleWidgetSelected(TypeSelectionDialog2.this.fContent.getSelection());
            }
        });
        return area;
    }

    protected void handleDefaultSelected(TypeNameMatch[] selection) {
        if (selection.length == 0) {
            return;
        }
        this.okPressed();
    }

    protected void handleWidgetSelected(TypeNameMatch[] selection) {
        Status status = null;
        if (selection.length == 0) {
            status = new Status(4, DLTKUIPlugin.getPluginId(), 4, "", null);
        } else if (this.fValidator != null) {
            ArrayList<IType> jElements = new ArrayList<IType>();
            int i = 0;
            while (i < selection.length) {
                IType type = selection[i].getType();
                if (type == null) {
                    status = new Status(4, DLTKUIPlugin.getPluginId(), 4, Messages.format(DLTKUIMessages.TypeSelectionDialog_error_type_doesnot_exist, selection[i].getFullyQualifiedName()), null);
                    break;
                }
                jElements.add(type);
                ++i;
            }
            if (status == null) {
                status = this.fValidator.validate(jElements.toArray());
            }
        } else {
            status = new Status(0, DLTKUIPlugin.getPluginId(), 0, "", null);
        }
        this.updateStatus((IStatus)status);
    }

    public int open() {
        IWorkbenchWindow window;
        try {
            this.ensureConsistency();
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, DLTKUIMessages.TypeSelectionDialog_error3Title, DLTKUIMessages.TypeSelectionDialog_error3Message);
            return 1;
        }
        catch (InterruptedException interruptedException) {
            return 1;
        }
        if (this.fInitialFilter == null && (window = DLTKUIPlugin.getActiveWorkbenchWindow()) != null) {
            Object object;
            ISelection selection = window.getSelectionService().getSelection();
            if (selection instanceof ITextSelection) {
                String text = ((ITextSelection)selection).getText();
                this.setInitialFilter(text);
            } else if (selection instanceof IStructuredSelection && (object = ((IStructuredSelection)selection).getFirstElement()) instanceof IModelElement) {
                IModelElement element = (IModelElement)object;
                String text = element.getElementName();
                this.setInitialFilter(text);
            }
        }
        return super.open();
    }

    private void setInitialFilter(String text) {
        if (text != null && (text = text.trim()).length() > 0) {
            this.setFilter(text);
        }
    }

    public boolean close() {
        boolean result;
        try {
            if (this.getReturnCode() == 0) {
                OpenTypeHistory.getInstance(this.fToolkit).save();
            }
        }
        finally {
            result = super.close();
        }
        return result;
    }

    public void setTitle(String title) {
        super.setTitle(title);
        this.fTitle = title;
    }

    protected void computeResult() {
        TypeNameMatch[] selected = this.fContent.getSelection();
        if (selected == null || selected.length == 0) {
            this.setResult(null);
            return;
        }
        if (this.fScope == null) {
            this.fScope = this.fContent.getScope();
        }
        OpenTypeHistory history = OpenTypeHistory.getInstance(this.fToolkit);
        ArrayList<Object> result = new ArrayList<Object>(selected.length);
        int i = 0;
        while (i < selected.length) {
            TypeNameMatch typeInfo = selected[i];
            IType type = typeInfo.getType();
            if (!type.exists()) {
                ISourceModule module = type.getSourceModule();
                if (module.exists()) {
                    result.add(module);
                } else {
                    String title = DLTKUIMessages.TypeSelectionDialog_errorTitle;
                    IProjectFragment root = typeInfo.getProjectFragment();
                    ScriptElementLabels labels = this.fToolkit.getScriptElementLabels();
                    String containerName = labels.getElementLabel((IModelElement)root, 0x20000000000L);
                    String message = Messages.format(DLTKUIMessages.TypeSelectionDialog_dialogMessage, new String[]{typeInfo.getFullyQualifiedName(), containerName});
                    MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
                    history.remove(typeInfo);
                    this.setResult(null);
                }
            } else {
                history.accessed(typeInfo);
                result.add(type);
            }
            ++i;
        }
        this.setResult(result);
    }

    private void ensureConsistency() throws InvocationTargetException, InterruptedException {
        class ConsistencyRunnable
        implements IRunnableWithProgress {
            ConsistencyRunnable() {
            }

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                if (fgFirstTime) {
                    IJobManager manager = Job.getJobManager();
                    manager.join((Object)"org.eclipse.dltk.ui", monitor);
                }
                OpenTypeHistory history = OpenTypeHistory.getInstance(TypeSelectionDialog2.this.fToolkit);
                if (fgFirstTime || history.isEmpty()) {
                    monitor.beginTask(DLTKUIMessages.TypeSelectionDialog_progress_consistency, 100);
                    if (history.needConsistencyCheck()) {
                        this.refreshSearchIndices((IProgressMonitor)new SubProgressMonitor(monitor, 90));
                        history.checkConsistency((IProgressMonitor)new SubProgressMonitor(monitor, 10));
                    } else {
                        this.refreshSearchIndices(monitor);
                    }
                    monitor.done();
                    fgFirstTime = false;
                } else {
                    history.checkConsistency(monitor);
                }
            }

            public boolean needsExecution() {
                OpenTypeHistory history = OpenTypeHistory.getInstance(TypeSelectionDialog2.this.fToolkit);
                return fgFirstTime || history.isEmpty() || history.needConsistencyCheck();
            }

            private void refreshSearchIndices(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    new SearchEngine().searchAllTypeNames(null, 0, "_______________".toCharArray(), 8, 2, SearchEngine.createWorkspaceScope((IDLTKLanguageToolkit)TypeSelectionDialog2.this.fToolkit.getCoreToolkit()), (TypeNameRequestor)new NopTypeNameRequestor(), 3, monitor);
                }
                catch (ModelException e) {
                    throw new InvocationTargetException(e);
                }
            }
        }
        ConsistencyRunnable runnable = new ConsistencyRunnable();
        if (!runnable.needsExecution()) {
            return;
        }
        IRunnableContext context = this.fRunnableContext != null ? this.fRunnableContext : PlatformUI.getWorkbench().getProgressService();
        context.run(true, true, (IRunnableWithProgress)runnable);
    }

    private class TitleLabel
    implements TypeSelectionComponent.ITitleLabel {
        private TitleLabel() {
        }

        @Override
        public void setText(String text) {
            if (text == null || text.length() == 0) {
                TypeSelectionDialog2.this.getShell().setText(TypeSelectionDialog2.this.fTitle);
            } else {
                TypeSelectionDialog2.this.getShell().setText(Messages.format(DLTKUIMessages.TypeSelectionDialog2_title_format, new String[]{TypeSelectionDialog2.this.fTitle, text}));
            }
        }
    }
}

