/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.ui.text;

import java.util.Arrays;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ruby.internal.ui.text.IRubySymbols;
import org.eclipse.dltk.ruby.internal.ui.text.ScriptHeuristicScanner;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

public class RubyHeuristicScanner
extends ScriptHeuristicScanner
implements IRubySymbols {
    private static final int[] BLOCK_BEGINNING_KEYWORDS = new int[]{1001, 1005, 1007, 1011, 1018, 1019, 1020, 1022, 1026, 1031, 1032, 1002};
    private static final int[] BLOCK_BEGINNING_SYMBOLS = new int[]{1, 3};
    private static final int[] BLOCK_MIDDLES = new int[]{1012, 1023, 1029, 1030, 1013};
    private static final int[] BLOCK_ENDINGS = new int[]{1008, 2, 4};

    static {
        Arrays.sort(BLOCK_BEGINNING_KEYWORDS);
        Arrays.sort(BLOCK_BEGINNING_SYMBOLS);
        Arrays.sort(BLOCK_MIDDLES);
        Arrays.sort(BLOCK_ENDINGS);
    }

    public RubyHeuristicScanner(IDocument document) {
        super(document, "__ruby_partitioning", "__dftl_partition_content_type");
    }

    public int getToken(int pos, String s) {
        Assert.isNotNull((Object)s);
        switch (s.length()) {
            case 2: {
                if ("if".equals(s)) {
                    return 1001;
                }
                if ("do".equals(s)) {
                    return 1002;
                }
                if ("in".equals(s)) {
                    return 1003;
                }
                if (!"or".equals(s)) break;
                return 1004;
            }
            case 3: {
                if ("for".equals(s)) {
                    return 1005;
                }
                if ("and".equals(s)) {
                    return 1006;
                }
                if ("def".equals(s)) {
                    return 1007;
                }
                if ("end".equals(s)) {
                    if (pos > 0 && this.getChar(pos - 1) == '=') {
                        return 1034;
                    }
                    return 1008;
                }
                if ("END".equals(s)) {
                    return 1008;
                }
                if ("nil".equals(s)) {
                    return 1009;
                }
                if (!"not".equals(s)) break;
                return 1010;
            }
            case 4: {
                if ("case".equals(s)) {
                    return 1011;
                }
                if ("else".equals(s)) {
                    return 1012;
                }
                if ("when".equals(s)) {
                    return 1013;
                }
                if ("then".equals(s)) {
                    return 1014;
                }
                if ("next".equals(s)) {
                    return 1015;
                }
                if (!"redo".equals(s)) break;
                return 1016;
            }
            case 5: {
                if ("break".equals(s)) {
                    return 1017;
                }
                if ("catch".equals(s)) {
                    return 1018;
                }
                if ("class".equals(s)) {
                    return 1019;
                }
                if ("while".equals(s)) {
                    return 1020;
                }
                if ("alias".equals(s)) {
                    return 1021;
                }
                if ("BEGIN".equals(s)) {
                    return 1022;
                }
                if ("begin".equals(s)) {
                    if (pos > 0 && this.getChar(pos - 1) == '=') {
                        return 1033;
                    }
                    return 1022;
                }
                if ("elsif".equals(s)) {
                    return 1023;
                }
                if ("retry".equals(s)) {
                    return 1024;
                }
                if ("undef".equals(s)) {
                    return 1025;
                }
                if ("until".equals(s)) {
                    return 1026;
                }
                if (!"yield".equals(s)) break;
                return 1027;
            }
            case 6: {
                if ("return".equals(s)) {
                    return 1028;
                }
                if ("ensure".equals(s)) {
                    return 1029;
                }
                if ("rescue".equals(s)) {
                    return 1030;
                }
                if ("unless".equals(s)) {
                    return 1031;
                }
                if (!"module".equals(s)) break;
                return 1032;
            }
            case 7: {
                if (!"defined".equals(s)) break;
                return 1035;
            }
        }
        return 15;
    }

    private char getChar(int pos) {
        try {
            return this.getDocument().getChar(pos);
        }
        catch (BadLocationException e) {
            DLTKUIPlugin.log((Throwable)e);
            return '\u0000';
        }
    }

    public IRegion findSurroundingBlock(int offset) {
        int end;
        int start = this.findBlockBeginningOffset(offset);
        if (start == -1) {
            start = 0;
        }
        if ((end = this.findBlockEndingOffset(offset)) == -1) {
            end = this.getDocument().getLength();
        }
        return new Region(start, end - start);
    }

    public boolean isBlockBeginning(int offset, int bound) {
        int token = this.previousToken(bound, offset);
        while (token != -1) {
            if (Arrays.binarySearch(BLOCK_BEGINNING_SYMBOLS, token) >= 0) {
                return true;
            }
            if (Arrays.binarySearch(BLOCK_BEGINNING_KEYWORDS, token) >= 0) {
                int pos = this.getPosition();
                int prevToken = token;
                token = this.previousToken(this.getPosition(), offset);
                if (token == -1 || token == 11 || prevToken == 1002) {
                    this.setPosition(pos + 1);
                    return true;
                }
            }
            token = this.previousToken(this.getPosition(), offset);
        }
        return false;
    }

    public boolean isBlockMiddle(int offset, int bound) {
        if (Arrays.binarySearch(BLOCK_MIDDLES, this.nextToken(offset, bound)) >= 0) {
            this.findNonIdentifierBackward(offset, -2);
            this.setPosition(this.getPosition() + 1);
            return true;
        }
        return false;
    }

    public boolean isBlockEnding(int offset, int bound) {
        int token = this.nextToken(offset, bound);
        while (token != -1) {
            if (Arrays.binarySearch(BLOCK_ENDINGS, token) >= 0) {
                return true;
            }
            token = this.nextToken(this.getPosition(), bound);
        }
        return false;
    }

    public int findBlockBeginningOffset(int offset) {
        try {
            IDocument d = this.getDocument();
            int line = d.getLineOfOffset(offset);
            int endingCount = 0;
            while (line >= 0) {
                IRegion info = d.getLineInformation(line);
                int start = info.getOffset();
                int end = Math.min(info.getOffset() + info.getLength(), offset);
                this.setPosition(start);
                while (this.getPosition() < end) {
                    if (!this.isBlockEnding(this.getPosition(), end)) continue;
                    ++endingCount;
                }
                start = info.getOffset();
                end = Math.min(info.getOffset() + info.getLength(), offset);
                this.setPosition(end);
                while (this.getPosition() > start) {
                    if (!this.isBlockBeginning(start, this.getPosition())) continue;
                    if (endingCount > 0) {
                        --endingCount;
                        continue;
                    }
                    return this.getPosition();
                }
                --line;
            }
        }
        catch (BadLocationException e) {
            DLTKUIPlugin.log((Throwable)e);
        }
        return -1;
    }

    public int findBlockEndingOffset(int offset) {
        try {
            IDocument d = this.getDocument();
            int line = d.getLineOfOffset(offset);
            int lineNum = d.getNumberOfLines();
            int beginningCount = 0;
            while (line < lineNum) {
                IRegion info = d.getLineInformation(line);
                int start = Math.max(info.getOffset(), offset);
                int end = info.getOffset() + info.getLength();
                this.setPosition(end);
                while (this.getPosition() > start) {
                    if (!this.isBlockBeginning(start, this.getPosition())) continue;
                    ++beginningCount;
                }
                start = Math.max(info.getOffset(), offset);
                end = info.getOffset() + info.getLength();
                this.setPosition(start);
                while (this.getPosition() < end) {
                    if (!this.isBlockEnding(this.getPosition(), end)) continue;
                    if (beginningCount > 0) {
                        --beginningCount;
                        continue;
                    }
                    return this.getPosition();
                }
                ++line;
            }
        }
        catch (BadLocationException e) {
            DLTKUIPlugin.log((Throwable)e);
        }
        return -1;
    }

    public int previousTokenAfterInput(int offset, String appended) {
        int token;
        block4: {
            try {
                if (this.getPartition(offset).getType() == "__dftl_partition_content_type") break block4;
                return -1;
            }
            catch (BadLocationException e) {
                DLTKUIPlugin.log((Throwable)e);
                return -1;
            }
        }
        if (appended.length() == 1 && (token = this.getGenericToken(appended.charAt(0))) != 14) {
            return token;
        }
        IRegion line = this.getDocument().getLineInformationOfOffset(offset);
        String content = String.valueOf(this.getDocument().get(line.getOffset(), offset - line.getOffset())) + appended;
        Document newDoc = new Document(content);
        RubyHeuristicScanner scanner = new RubyHeuristicScanner((IDocument)newDoc);
        return scanner.previousToken(content.length(), -2);
    }
}

