/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.debug;

import org.eclipse.dltk.debug.core.model.ComplexScriptType;
import org.eclipse.dltk.debug.core.model.IScriptType;
import org.eclipse.dltk.debug.core.model.IScriptTypeFactory;
import org.eclipse.dltk.debug.core.model.IScriptValue;
import org.eclipse.dltk.debug.core.model.StringScriptType;

public class TclTypeFactory
implements IScriptTypeFactory {
    private final TclStringScriptType stringType = new TclStringScriptType();
    private final TclNamespaceType namespaceType = new TclNamespaceType();
    private static final String NAMESPACE = "namespace";

    public IScriptType buildType(String type) {
        if ("string".equals(type)) {
            return this.stringType;
        }
        if (NAMESPACE.equals(type)) {
            return this.namespaceType;
        }
        return new ComplexScriptType(type);
    }

    private static class TclNamespaceType
    extends ComplexScriptType {
        public TclNamespaceType() {
            super(TclTypeFactory.NAMESPACE);
        }

        public String formatValue(IScriptValue value) {
            return TclTypeFactory.NAMESPACE;
        }
    }

    private static class TclStringScriptType
    extends StringScriptType {
        public TclStringScriptType() {
            super("string");
        }

        public String formatValue(IScriptValue value) {
            String string = value.getRawValue();
            if (string == null) {
                return null;
            }
            return TclStringScriptType.escapeString(string, false);
        }

        public String formatDetails(IScriptValue value) {
            String string = value.getRawValue();
            if (string == null) {
                return null;
            }
            return TclStringScriptType.escapeString(string, true);
        }

        private static String escapeString(String input, boolean allowWhitespace) {
            if (!TclStringScriptType.isEscapeNeeded(input)) {
                return input;
            }
            StringBuffer result = new StringBuffer(input.length() + 8);
            int length = input.length();
            int i = 0;
            while (i < length) {
                char c = input.charAt(i);
                if (TclStringScriptType.isEscapeNeeded(c)) {
                    if (allowWhitespace && (c == ' ' || c == '\n' || c == '\t')) {
                        result.append(c);
                    } else {
                        result.append('\\');
                        if (c < ' ') {
                            switch (c) {
                                case '\u0007': {
                                    result.append('a');
                                    break;
                                }
                                case '\b': {
                                    result.append('b');
                                    break;
                                }
                                case '\t': {
                                    result.append('t');
                                    break;
                                }
                                case '\u000b': {
                                    result.append('v');
                                    break;
                                }
                                case '\f': {
                                    result.append('f');
                                    break;
                                }
                                case '\n': {
                                    result.append('n');
                                    break;
                                }
                                case '\r': {
                                    result.append('r');
                                    break;
                                }
                                default: {
                                    result.append(TclStringScriptType.toHexChar(c / 16));
                                    result.append(TclStringScriptType.toHexChar(c % 16));
                                    break;
                                }
                            }
                        } else {
                            result.append(c);
                        }
                    }
                } else {
                    result.append(c);
                }
                ++i;
            }
            return result.toString();
        }

        private static boolean canBraceEscape(String value) {
            int length = value.length();
            int i = 0;
            while (i < length) {
                char c = value.charAt(i);
                if (c < ' ' || c == '{' || c == '}') {
                    return false;
                }
                ++i;
            }
            return true;
        }

        private static char toHexChar(int value) {
            if (value <= 9) {
                return (char)(48 + value);
            }
            return (char)(65 + (value - 10));
        }

        private static boolean isEscapeNeeded(String value) {
            int length = value.length();
            int i = 0;
            while (i < length) {
                if (TclStringScriptType.isEscapeNeeded(value.charAt(i))) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private static boolean isEscapeNeeded(char c) {
            if (c < ' ') {
                return true;
            }
            switch (c) {
                case ' ': 
                case '\"': 
                case '$': 
                case '[': 
                case '\\': 
                case '{': 
                case '}': {
                    return true;
                }
            }
            return false;
        }
    }
}

