/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.ui.manpages;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.dltk.compiler.util.Util;
import org.eclipse.dltk.tcl.internal.ui.TclUI;
import org.eclipse.dltk.tcl.ui.manpages.Documentation;
import org.eclipse.dltk.tcl.ui.manpages.ManPageFolder;
import org.eclipse.dltk.tcl.ui.manpages.ManpagesFactory;
import org.eclipse.dltk.utils.CharArraySequence;

public class ManPageFinder {
    private static final String CONTENTS_HTM = "contents.htm";
    private static final List<String> SKIP_DIRS = Arrays.asList("TkLib", "TclLib", "Keywords", "UserCmd");

    public void find(Documentation documentation, File dir) {
        File[] children;
        if (!dir.isDirectory()) {
            return;
        }
        if (SKIP_DIRS.contains(dir.getName())) {
            return;
        }
        File[] fileArray = children = dir.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() || file.getName().startsWith(ManPageFinder.CONTENTS_HTM);
            }
        });
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            String path;
            File child = fileArray[n2];
            if (child.isDirectory()) {
                this.find(documentation, child);
            } else if (child.getName().startsWith(CONTENTS_HTM) && documentation.findFolder(path = dir.getAbsolutePath()) == null) {
                ManPageFolder folder = ManpagesFactory.eINSTANCE.createManPageFolder();
                folder.setPath(path);
                this.parseContentsFile(child, folder);
                if (!folder.getKeywords().isEmpty()) {
                    documentation.getFolders().add((Object)folder);
                }
            }
            ++n2;
        }
    }

    private void parseContentsFile(File c, ManPageFolder folder) {
        char[] result;
        try {
            result = Util.getFileCharContent((File)c, null);
        }
        catch (IOException e) {
            TclUI.error("Error reading " + c, e);
            return;
        }
        Pattern pattern = Pattern.compile("<a\\s+href=\"([a-zA-Z_0-9]+\\.html?)\"\\s*>(\\w+)</a>", 2);
        Matcher matcher = pattern.matcher((CharSequence)new CharArraySequence(result));
        while (matcher.find()) {
            String file = matcher.group(1);
            if (file.equalsIgnoreCase("Copyright.htm")) continue;
            String word = matcher.group(2);
            folder.addPage(word, file);
        }
    }
}

