/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.core.parser.processors.tcl;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.expressions.StringLiteral;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.compiler.problem.ProblemSeverities;
import org.eclipse.dltk.tcl.ast.TclStatement;
import org.eclipse.dltk.tcl.ast.expressions.TclBlockExpression;
import org.eclipse.dltk.tcl.core.AbstractTclCommandProcessor;
import org.eclipse.dltk.tcl.core.ITclParser;
import org.eclipse.dltk.tcl.core.TclParseUtil;
import org.eclipse.dltk.tcl.core.ast.TclAdvancedExecuteExpression;
import org.eclipse.dltk.tcl.core.ast.TclCatchStatement;
import org.eclipse.dltk.tcl.core.ast.TclVariableDeclaration;
import org.eclipse.dltk.tcl.internal.core.parser.processors.tcl.Messages;

public class TclCatchProcessor
extends AbstractTclCommandProcessor {
    public ASTNode process(TclStatement statement, ITclParser parser, ASTNode parent) {
        if (statement.getCount() >= 2) {
            Block bl;
            Object block;
            Expression e = statement.getAt(1);
            TclVariableDeclaration variable = null;
            if (statement.getCount() > 2) {
                Expression variableName = statement.getAt(2);
                variable = new TclVariableDeclaration(TclParseUtil.makeVariable(variableName), null, variableName.sourceStart(), variableName.sourceEnd());
            }
            if (e instanceof Block) {
                TclCatchStatement catchStatement = new TclCatchStatement((Block)e, variable, statement.sourceStart(), statement.sourceEnd());
                this.addToParent(parent, (ASTNode)catchStatement);
                return catchStatement;
            }
            if (e instanceof TclBlockExpression) {
                block = (TclBlockExpression)e;
                String blockContent = block.getBlock();
                blockContent = blockContent.substring(1, blockContent.length() - 1);
                Block bl2 = new Block(e.sourceStart(), e.sourceEnd());
                TclCatchStatement catchStatement = new TclCatchStatement(bl2, variable, statement.sourceStart(), statement.sourceEnd());
                this.addToParent(parent, (ASTNode)catchStatement);
                parser.parse(blockContent, block.sourceStart() + 1 - parser.getStartPos(), (ASTNode)bl2);
                return catchStatement;
            }
            if (e instanceof SimpleReference) {
                bl = new Block(e.sourceStart(), e.sourceEnd());
                TclCatchStatement catchStatement = new TclCatchStatement(bl, variable, statement.sourceStart(), statement.sourceEnd());
                this.addToParent(parent, (ASTNode)catchStatement);
                bl.addStatement((ASTNode)e);
                return catchStatement;
            }
            if (e instanceof StringLiteral) {
                bl = new Block(e.sourceStart(), e.sourceEnd());
                TclCatchStatement catchStatement = new TclCatchStatement(bl, variable, statement.sourceStart(), statement.sourceEnd());
                this.addToParent(parent, (ASTNode)catchStatement);
                bl.addStatement((ASTNode)e);
                return catchStatement;
            }
            if (e instanceof TclAdvancedExecuteExpression) {
                block = (TclAdvancedExecuteExpression)e;
                Block bl3 = new Block(e.sourceStart(), e.sourceEnd());
                TclCatchStatement catchStatement = new TclCatchStatement(bl3, variable, block.sourceStart(), block.sourceEnd());
                this.addToParent(parent, (ASTNode)catchStatement);
                bl3.getStatements().addAll(block.getChilds());
                return catchStatement;
            }
        } else {
            this.report(parser, Messages.TclProcProcessor_Wrong_Number_of_Arguments, (ASTNode)statement, ProblemSeverities.Error);
        }
        return null;
    }
}

