/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.browsing.ext;

import org.eclipse.dltk.ui.browsing.ext.ColumnFormData;
import org.eclipse.dltk.ui.browsing.ext.ColumnFormLayout;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;

public class ColumnForm
extends Composite {
    public int SASH_WIDTH = 3;
    int columnStyle;
    Sash[] sashes = new Sash[0];
    Color background = null;
    Color foreground = null;
    Control[] controls = new Control[0];
    Listener sashListener;
    static final int DRAG_MINIMUM = 20;

    public ColumnForm(Composite parent, int style) {
        super(parent, ColumnForm.checkStyle(style));
        super.setLayout((Layout)new ColumnFormLayout());
        this.columnStyle = 512;
        if ((style & 0x800) != 0) {
            this.columnStyle |= 0x800;
        }
        if ((style & 0x10000) != 0) {
            this.columnStyle |= 0x10000;
        }
        this.sashListener = new Listener(){

            public void handleEvent(Event e) {
                ColumnForm.this.onDragSash(e);
            }
        };
        this.layout();
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                ColumnForm.this.drawLines(e);
            }
        });
    }

    protected void drawLines(PaintEvent e) {
        Rectangle clientArea = this.getClientArea();
        int[] widths = new int[this.controls.length];
        int total = 0;
        int i = 0;
        while (i < this.controls.length) {
            Object data = this.controls[i].getLayoutData();
            if (data != null && data instanceof ColumnFormData) {
                widths[i] = ((ColumnFormData)data).width;
            } else {
                data = new ColumnFormData();
                this.controls[i].setLayoutData(data);
                widths[i] = 200;
                ((ColumnFormData)data).width = 200;
            }
            total += widths[i];
            ++i;
        }
        int sashwidth = this.sashes.length > 0 ? this.SASH_WIDTH + this.sashes[0].getBorderWidth() * 2 : 2 * this.SASH_WIDTH;
        int drawWidth = clientArea.width - (total += (this.sashes.length - 1) * sashwidth);
        int lines = drawWidth / 200;
        int last = drawWidth % 200;
        int x = total;
        int i2 = 0;
        while (i2 < lines) {
            e.gc.setBackground(this.getDisplay().getSystemColor(22));
            e.gc.fillRectangle(x, clientArea.x, sashwidth, clientArea.height);
            e.gc.setBackground(this.getDisplay().getSystemColor(25));
            e.gc.fillRectangle(x += sashwidth, clientArea.x, 200, clientArea.height);
            x += 200;
            ++i2;
        }
        e.gc.setBackground(this.getDisplay().getSystemColor(22));
        e.gc.fillRectangle(x, clientArea.x, sashwidth, clientArea.height);
        e.gc.setBackground(this.getDisplay().getSystemColor(25));
        e.gc.fillRectangle(x += sashwidth, clientArea.x, last, clientArea.height);
    }

    static int checkStyle(int style) {
        int mask = 0x6000800;
        return style & mask;
    }

    public int getStyle() {
        int style = super.getStyle();
        style |= 0x100;
        if ((this.columnStyle & 0x10000) != 0) {
            style |= 0x10000;
        }
        return style;
    }

    Control[] getControls(boolean onlyVisible) {
        Control[] children = this.getChildren();
        Control[] result = new Control[]{};
        int i = 0;
        while (i < children.length) {
            if (!(children[i] instanceof Sash || onlyVisible && !children[i].getVisible())) {
                Control[] newResult = new Control[result.length + 1];
                System.arraycopy(result, 0, newResult, 0, result.length);
                newResult[result.length] = children[i];
                result = newResult;
            }
            ++i;
        }
        return result;
    }

    void onDragSash(Event event) {
        Sash sash = (Sash)event.widget;
        int sashIndex = -1;
        int i = 0;
        while (i < this.sashes.length) {
            if (this.sashes[i] == sash) {
                sashIndex = i;
                break;
            }
            ++i;
        }
        if (sashIndex == -1) {
            return;
        }
        Control c1 = this.controls[sashIndex];
        Rectangle b1 = c1.getBounds();
        Rectangle sashBounds = sash.getBounds();
        boolean correction = false;
        correction = b1.width < 20;
        int shift = event.x - sashBounds.x;
        Object data1 = c1.getLayoutData();
        if (data1 == null || !(data1 instanceof ColumnFormData)) {
            data1 = new ColumnFormData();
            c1.setLayoutData(data1);
        }
        ((ColumnFormData)data1).width = b1.width + shift;
        b1.width += shift;
        if (((ColumnFormData)data1).width < 20) {
            ((ColumnFormData)data1).width = 20;
            event.x = b1.x + 20;
            b1.width = 20;
            event.doit = false;
        }
        if (correction || event.doit && event.detail != 1) {
            c1.setBounds(b1);
            sash.setBounds(event.x, event.y, event.width, event.height);
        }
        this.layout();
        this.redraw();
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.background = color;
        int i = 0;
        while (i < this.sashes.length) {
            this.sashes[i].setBackground(this.background);
            ++i;
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.foreground = color;
        int i = 0;
        while (i < this.sashes.length) {
            this.sashes[i].setForeground(this.foreground);
            ++i;
        }
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
    }
}

