/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.swtbot.support.api.dialog;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.sirius.diagram.ui.business.api.image.GallerySelectable;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.internal.dialogs.TreeImagesGalleryComposite;
import org.eclipse.sirius.diagram.ui.tools.internal.dialogs.widgets.gallery.GalleryItem;
import org.eclipse.sirius.tests.swtbot.support.utils.SWTBotUtils;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.matchers.WidgetMatcherFactory;
import org.eclipse.swtbot.swt.finder.waits.Conditions;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBotControl;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotButton;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotText;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.SelfDescribing;

public final class ImageSelectionGalleryHelper {
    public static final String DIALOG_TITLE = Messages.ImageSelectionDialog_title;

    private ImageSelectionGalleryHelper() {
    }

    public static void selectGalleryItem(SWTBot bot, final String itemName) {
        final GallerySelectable widget = ImageSelectionGalleryHelper.getGallery(bot);
        try {
            Job.getJobManager().join((Object)TreeImagesGalleryComposite.REFRESH_IMAGE_JOB_FAMILY, (IProgressMonitor)new NullProgressMonitor());
            widget.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    GalleryItem groupItem = widget.getItem(0);
                    GalleryItem[] galleryItems = groupItem.getItems();
                    GalleryItem itemToSelect = null;
                    GalleryItem[] galleryItemArray = galleryItems;
                    int n = galleryItems.length;
                    int n2 = 0;
                    while (n2 < n) {
                        GalleryItem item = galleryItemArray[n2];
                        if (itemName.equals(item.getText())) {
                            itemToSelect = item;
                        }
                        ++n2;
                    }
                    widget.selectItem(itemToSelect, true);
                    SWTBotUtils.waitAllUiEvents();
                }
            });
        }
        catch (InterruptedException | OperationCanceledException throwable) {}
    }

    public static GallerySelectable getGallery(SWTBot bot) {
        Matcher matcher = Matchers.allOf((Matcher[])new Matcher[]{WidgetMatcherFactory.widgetOfType(GallerySelectable.class)});
        AbstractSWTBotControl swtBot = new AbstractSWTBotControl((Control)((GallerySelectable)bot.widget(matcher)), (SelfDescribing)matcher);
        return (GallerySelectable)swtBot.widget;
    }

    public static void selectWorkspaceImage(SWTBot bot, String pathToImage, boolean clickOK) {
        bot.waitUntil(Conditions.shellIsActive((String)DIALOG_TITLE));
        String[] pathSegments = pathToImage.split("/");
        if (pathSegments.length > 0) {
            String imageName = pathSegments[pathSegments.length - 1];
            SWTBotText text = ImageSelectionGalleryHelper.getFilterTextArea(bot);
            text.setFocus();
            text.setText(imageName);
            SWTBotTree tree = bot.tree();
            SWTBotTreeItem treeItem = tree.getTreeItem(pathSegments[0]);
            int i = 0;
            while (i < pathSegments.length - 1) {
                treeItem = tree.expandNode(new String[]{pathSegments[i]});
                ++i;
            }
            treeItem.select();
            ImageSelectionGalleryHelper.selectGalleryItem(bot, imageName);
        }
        if (clickOK) {
            ImageSelectionGalleryHelper.clickButton(bot, "OK", true);
        }
    }

    public static void selectWorkspaceImage(SWTBot bot, String pathToImage) {
        ImageSelectionGalleryHelper.selectWorkspaceImage(bot, pathToImage, true);
    }

    public static SWTBotButton getButton(SWTBot bot, String buttonLabel) {
        bot.waitUntil(Conditions.shellIsActive((String)DIALOG_TITLE));
        SWTBotShell activeShell = bot.shell(DIALOG_TITLE);
        return activeShell.bot().button(buttonLabel);
    }

    public static void clickButton(SWTBot bot, String buttonLabel, boolean shouldCloseDialog) {
        SWTBotButton button = ImageSelectionGalleryHelper.getButton(bot, buttonLabel);
        SWTBotShell activeShell = bot.shell(DIALOG_TITLE);
        button.click();
        SWTBotUtils.waitAllUiEvents();
        if (shouldCloseDialog) {
            bot.waitUntil(Conditions.shellCloses((SWTBotShell)activeShell));
        }
    }

    public static SWTBotText getFilterTextArea(SWTBot swtBot) {
        return swtBot.text(1);
    }

    public static SWTBotButton getResetImageStyleButton(SWTBot bot) {
        return ImageSelectionGalleryHelper.getButton(bot, Messages.ImageSelectionDialog_resetImageStyle_buttonLabel);
    }

    public static SWTBotText getImagePathText(SWTBot bot) {
        bot.waitUntil(Conditions.shellIsActive((String)DIALOG_TITLE));
        SWTBotShell activeShell = bot.shell(DIALOG_TITLE);
        return activeShell.bot().text(0);
    }
}

