/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.queryrender.sparql.ir.util.transform;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.rdf4j.queryrender.sparql.TupleExprIRRenderer;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrBGP;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrFilter;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrNode;
import org.eclipse.rdf4j.queryrender.sparql.ir.util.transform.BaseTransform;

public final class NormalizeFilterNotInTransform
extends BaseTransform {
    private NormalizeFilterNotInTransform() {
    }

    public static IrBGP apply(IrBGP bgp, TupleExprIRRenderer r) {
        if (bgp == null) {
            return null;
        }
        ArrayList<IrNode> out = new ArrayList<IrNode>();
        Iterator<IrNode> iterator = bgp.getLines().iterator();
        while (iterator.hasNext()) {
            String rewritten;
            IrFilter f;
            IrNode n;
            IrNode m = n = iterator.next();
            if (n instanceof IrFilter && (f = (IrFilter)n).getBody() == null && f.getConditionText() != null && (rewritten = NormalizeFilterNotInTransform.tryRewriteNotIn(f.getConditionText())) != null) {
                IrFilter nf = new IrFilter(rewritten, f.isNewScope());
                m = nf;
            }
            m = BaseTransform.rewriteContainers(m, child -> NormalizeFilterNotInTransform.apply(child, r));
            out.add(m);
        }
        return BaseTransform.bgpWithLines(bgp, out);
    }

    static String tryRewriteNotIn(String cond) {
        if (cond == null) {
            return null;
        }
        String s = cond.trim();
        List<String> parts = NormalizeFilterNotInTransform.splitTopLevelAnd(s);
        if (parts.size() < 2) {
            return null;
        }
        String varName = null;
        ArrayList<String> items = new ArrayList<String>();
        for (String p : parts) {
            String t = NormalizeFilterNotInTransform.stripOuterParens(p.trim());
            Match m = NormalizeFilterNotInTransform.matchInequality(t);
            if (m == null) {
                return null;
            }
            if (varName == null) {
                varName = m.var;
            } else if (!varName.equals(m.var)) {
                return null;
            }
            items.add(m.item);
        }
        if (items.size() < 2 || varName == null) {
            return null;
        }
        return "?" + varName + " NOT IN (" + String.join((CharSequence)", ", items) + ")";
    }

    private static Match matchInequality(String t) {
        String v;
        int idx = t.indexOf("!=");
        if (idx < 0) {
            return null;
        }
        String left = t.substring(0, idx).trim();
        String right = t.substring(idx + 2).trim();
        left = NormalizeFilterNotInTransform.stripOuterParens(left);
        right = NormalizeFilterNotInTransform.stripOuterParens(right);
        if (left.startsWith("?") && !(v = left.substring(1)).isEmpty() && NormalizeFilterNotInTransform.isVarName(v) && NormalizeFilterNotInTransform.isItemToken(right)) {
            return new Match(v, right);
        }
        if (right.startsWith("?") && !(v = right.substring(1)).isEmpty() && NormalizeFilterNotInTransform.isVarName(v) && NormalizeFilterNotInTransform.isItemToken(left)) {
            return new Match(v, left);
        }
        return null;
    }

    private static boolean isVarName(String s) {
        char c0;
        char c = c0 = s.isEmpty() ? (char)'\u0000' : s.charAt(0);
        if (!Character.isLetter(c0) && c0 != '_') {
            return false;
        }
        for (int i = 1; i < s.length(); ++i) {
            char c2 = s.charAt(i);
            if (Character.isLetterOrDigit(c2) || c2 == '_') continue;
            return false;
        }
        return true;
    }

    private static boolean isItemToken(String s) {
        if (s == null || s.isEmpty()) {
            return false;
        }
        if (s.charAt(0) == '<') {
            return s.endsWith(">");
        }
        if (s.charAt(0) == '\"') {
            int i = 1;
            boolean esc = false;
            boolean closed = false;
            while (i < s.length()) {
                char c = s.charAt(i++);
                if (esc) {
                    esc = false;
                    continue;
                }
                if (c == '\\') {
                    esc = true;
                    continue;
                }
                if (c != '\"') continue;
                closed = true;
                break;
            }
            if (!closed) {
                return false;
            }
            if (i == s.length()) {
                return true;
            }
            if (s.charAt(i) == '@') {
                String lang = s.substring(i + 1);
                return !lang.isEmpty() && lang.matches("[A-Za-z0-9-]+");
            }
            if (i + 1 < s.length() && s.charAt(i) == '^' && s.charAt(i + 1) == '^') {
                String rest = s.substring(i + 2);
                if (rest.startsWith("<") && rest.endsWith(">")) {
                    return true;
                }
                return rest.matches("[A-Za-z_][\\w.-]*:[^\\s,()]+");
            }
            return false;
        }
        if ("true".equals(s) || "false".equals(s)) {
            return true;
        }
        if (s.matches("[+-]?((\\d+\\.\\d*)|(\\.\\d+)|(\\d+))(?:[eE][+-]?\\d+)?")) {
            return true;
        }
        if (s.matches("[A-Za-z_][\\w.-]*:[^\\s,()]+")) {
            return true;
        }
        return !s.contains(" ") && !s.contains(")") && !s.contains("(");
    }

    private static String stripOuterParens(String x) {
        String t = x;
        while (t.length() >= 2 && t.charAt(0) == '(' && t.charAt(t.length() - 1) == ')') {
            int depth = 0;
            boolean ok = true;
            for (int i = 0; i < t.length(); ++i) {
                char c = t.charAt(i);
                if (c == '(') {
                    ++depth;
                } else if (c == ')') {
                    --depth;
                }
                if (depth != 0 || i >= t.length() - 1) continue;
                ok = false;
                break;
            }
            if (!ok) break;
            t = t.substring(1, t.length() - 1).trim();
        }
        return t;
    }

    private static List<String> splitTopLevelAnd(String s) {
        ArrayList<String> parts = new ArrayList<String>();
        int depth = 0;
        boolean inStr = false;
        boolean esc = false;
        int last = 0;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (inStr) {
                if (esc) {
                    esc = false;
                    continue;
                }
                if (c == '\\') {
                    esc = true;
                    continue;
                }
                if (c != '\"') continue;
                inStr = false;
                continue;
            }
            if (c == '\"') {
                inStr = true;
                continue;
            }
            if (c == '(') {
                ++depth;
                continue;
            }
            if (c == ')') {
                --depth;
                continue;
            }
            if (c != '&' || depth != 0 || i + 1 >= s.length() || s.charAt(i + 1) != '&') continue;
            parts.add(s.substring(last, i).trim());
            last = ++i + 1;
        }
        parts.add(s.substring(last).trim());
        return parts;
    }

    private static final class Match {
        final String var;
        final String item;

        Match(String var, String item) {
            this.var = var;
            this.item = item;
        }
    }
}

