/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.contextaware;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.CloseableIteratorIteration;
import org.eclipse.rdf4j.common.iteration.ConvertingIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BooleanQuery;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.Operation;
import org.eclipse.rdf4j.query.Query;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.Update;
import org.eclipse.rdf4j.query.impl.SimpleDataset;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.eclipse.rdf4j.repository.base.RepositoryConnectionWrapper;
import org.eclipse.rdf4j.repository.util.RDFInserter;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;

public class ContextAwareConnection
extends RepositoryConnectionWrapper {
    private static final IRI[] ALL_CONTEXTS = new IRI[0];
    private final ContextAwareConnection next;
    private boolean includeInferred = true;
    private int maxQueryTime;
    private QueryLanguage ql = QueryLanguage.SPARQL;
    private String baseURI;
    private IRI[] readContexts = ALL_CONTEXTS;
    private IRI[] addContexts = ALL_CONTEXTS;
    private IRI[] removeContexts = ALL_CONTEXTS;
    private IRI[] archiveContexts = ALL_CONTEXTS;
    private IRI insertContext = null;

    public ContextAwareConnection(Repository repository) throws RepositoryException {
        this(repository, repository.getConnection());
    }

    public ContextAwareConnection(RepositoryConnection connection) throws RepositoryException {
        this(connection.getRepository(), connection);
    }

    public ContextAwareConnection(Repository repository, RepositoryConnection connection) throws RepositoryException {
        super(repository, connection);
        ContextAwareConnection next = null;
        RepositoryConnection up = connection;
        while (up instanceof RepositoryConnectionWrapper) {
            if (up instanceof ContextAwareConnection) {
                next = (ContextAwareConnection)up;
                break;
            }
            up = ((RepositoryConnectionWrapper)up).getDelegate();
        }
        this.next = next;
    }

    @Override
    protected boolean isDelegatingRemove() throws RepositoryException {
        return this.getArchiveContexts().length == 0 && this.getRemoveContexts().length < 2;
    }

    public boolean isIncludeInferred() {
        return this.includeInferred;
    }

    public void setIncludeInferred(boolean includeInferred) {
        this.includeInferred = includeInferred;
        if (this.next != null) {
            this.next.setIncludeInferred(includeInferred);
        }
    }

    public int getMaxQueryTime() {
        return this.maxQueryTime;
    }

    public void setMaxQueryTime(int maxQueryTime) {
        this.maxQueryTime = maxQueryTime;
        if (this.next != null) {
            this.next.setMaxQueryTime(maxQueryTime);
        }
    }

    public QueryLanguage getQueryLanguage() {
        return this.ql;
    }

    public void setQueryLanguage(QueryLanguage ql) {
        this.ql = ql;
        if (this.next != null) {
            this.next.setQueryLanguage(ql);
        }
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public void setBaseURI(String baseURI) {
        this.baseURI = baseURI;
        if (this.next != null) {
            this.next.setBaseURI(baseURI);
        }
    }

    public IRI[] getReadContexts() {
        return this.readContexts;
    }

    public void setReadContexts(IRI ... readContexts) {
        this.readContexts = readContexts;
        if (this.next != null) {
            this.next.setReadContexts(readContexts);
        }
    }

    @Deprecated
    public IRI[] getAddContexts() {
        if (this.isNilContext(this.addContexts)) {
            return new IRI[]{this.getInsertContext()};
        }
        return this.addContexts;
    }

    @Deprecated
    public void setAddContexts(IRI ... addContexts) {
        this.addContexts = addContexts;
        if (this.isNilContext(addContexts)) {
            this.insertContext = null;
        } else if (addContexts.length == 1) {
            this.insertContext = addContexts[0];
        }
        if (this.next != null) {
            this.next.setAddContexts(addContexts);
        }
    }

    public IRI[] getRemoveContexts() {
        return this.removeContexts;
    }

    public void setRemoveContexts(IRI ... removeContexts) {
        this.removeContexts = removeContexts;
        if (this.next != null) {
            this.next.setRemoveContexts(removeContexts);
        }
    }

    @Deprecated
    public IRI[] getArchiveContexts() {
        return this.archiveContexts;
    }

    @Deprecated
    public void setArchiveContexts(IRI ... archiveContexts) {
        this.archiveContexts = archiveContexts;
        if (this.next != null) {
            this.next.setArchiveContexts(archiveContexts);
        }
    }

    public IRI getInsertContext() {
        return this.insertContext;
    }

    public void setInsertContext(IRI insertContext) {
        this.insertContext = insertContext;
        this.addContexts = new IRI[]{insertContext};
        if (this.next != null) {
            this.next.setInsertContext(insertContext);
        }
    }

    @Override
    public void add(File file, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        if (this.isNilContext(contexts) && !dataFormat.supportsContexts()) {
            super.add(file, this.getBaseURI(), dataFormat, (Resource[])this.getAddContexts());
        } else {
            super.add(file, this.getBaseURI(), dataFormat, contexts);
        }
    }

    @Override
    public void add(File file, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        if (baseURI == null) {
            baseURI = this.getBaseURI();
        }
        if (this.isNilContext(contexts) && !dataFormat.supportsContexts()) {
            super.add(file, baseURI, dataFormat, (Resource[])this.getAddContexts());
        } else {
            super.add(file, baseURI, dataFormat, contexts);
        }
    }

    @Override
    public void add(InputStream in, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        if (this.isNilContext(contexts) && !dataFormat.supportsContexts()) {
            super.add(in, this.getBaseURI(), dataFormat, (Resource[])this.getAddContexts());
        } else {
            super.add(in, this.getBaseURI(), dataFormat, contexts);
        }
    }

    @Override
    public void add(InputStream in, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        if (baseURI == null) {
            baseURI = this.getBaseURI();
        }
        if (this.isNilContext(contexts) && !dataFormat.supportsContexts()) {
            super.add(in, baseURI, dataFormat, (Resource[])this.getAddContexts());
        } else {
            super.add(in, baseURI, dataFormat, contexts);
        }
    }

    @Override
    public void add(Iterable<? extends Statement> statements, Resource ... contexts) throws RepositoryException {
        if (this.isNilContext(contexts)) {
            this.add(new CloseableIteratorIteration<Statement>(statements.iterator()), new Resource[0]);
        } else {
            super.add(statements, contexts);
        }
    }

    @Override
    public void add(CloseableIteration<? extends Statement> statementIter, Resource ... contexts) throws RepositoryException {
        final IRI insertContext = this.getInsertContext();
        if (this.isNilContext(contexts)) {
            super.add((CloseableIteration<? extends Statement>)new ConvertingIteration<Statement, Statement>(statementIter){

                @Override
                protected Statement convert(Statement st) {
                    if (st.getContext() == null) {
                        return ContextAwareConnection.this.getValueFactory().createStatement(st.getSubject(), st.getPredicate(), st.getObject(), insertContext);
                    }
                    return st;
                }
            }, new Resource[0]);
        } else {
            super.add(statementIter, contexts);
        }
    }

    @Override
    public void add(Reader reader, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        if (this.isNilContext(contexts) && !dataFormat.supportsContexts()) {
            super.add(reader, this.getBaseURI(), dataFormat, (Resource[])this.getAddContexts());
        } else {
            super.add(reader, this.getBaseURI(), dataFormat, contexts);
        }
    }

    @Override
    public void add(Reader reader, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        if (baseURI == null) {
            baseURI = this.getBaseURI();
        }
        if (this.isNilContext(contexts) && !dataFormat.supportsContexts()) {
            super.add(reader, baseURI, dataFormat, (Resource[])this.getAddContexts());
        } else {
            super.add(reader, baseURI, dataFormat, contexts);
        }
    }

    @Override
    public void add(Resource subject, IRI predicate, Value object, Resource ... contexts) throws RepositoryException {
        if (this.isNilContext(contexts)) {
            super.add(subject, predicate, object, (Resource[])this.getAddContexts());
        } else {
            super.add(subject, predicate, object, contexts);
        }
    }

    @Override
    public void add(Statement st, Resource ... contexts) throws RepositoryException {
        if (this.isNilContext(contexts) && st.getContext() == null) {
            super.add(st, (Resource[])this.getAddContexts());
        } else {
            super.add(st, contexts);
        }
    }

    @Override
    public void add(URL url, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        if (this.isNilContext(contexts) && !dataFormat.supportsContexts()) {
            super.add(url, this.getBaseURI(), dataFormat, (Resource[])this.getAddContexts());
        } else {
            super.add(url, this.getBaseURI(), dataFormat, contexts);
        }
    }

    @Override
    public void add(URL url, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        if (baseURI == null) {
            baseURI = this.getBaseURI();
        }
        if (this.isNilContext(contexts) && !dataFormat.supportsContexts()) {
            super.add(url, baseURI, dataFormat, (Resource[])this.getAddContexts());
        } else {
            super.add(url, baseURI, dataFormat, contexts);
        }
    }

    @Override
    public void clear(Resource ... contexts) throws RepositoryException {
        if (this.isAllContext(contexts)) {
            super.clear(this.getRemoveContexts());
        } else {
            super.clear(contexts);
        }
    }

    @Override
    public void export(RDFHandler handler, Resource ... contexts) throws RepositoryException, RDFHandlerException {
        if (this.isAllContext(contexts)) {
            super.export(handler, this.getReadContexts());
        } else {
            super.export(handler, contexts);
        }
    }

    public void exportStatements(Resource subj, IRI pred, Value obj, RDFHandler handler, Resource ... contexts) throws RepositoryException, RDFHandlerException {
        if (this.isAllContext(contexts)) {
            super.exportStatements(subj, pred, obj, this.isIncludeInferred(), handler, this.getReadContexts());
        } else {
            super.exportStatements(subj, pred, obj, this.isIncludeInferred(), handler, contexts);
        }
    }

    @Override
    public void exportStatements(Resource subj, IRI pred, Value obj, boolean includeInferred, RDFHandler handler, Resource ... contexts) throws RepositoryException, RDFHandlerException {
        if (this.isAllContext(contexts)) {
            super.exportStatements(subj, pred, obj, includeInferred, handler, this.getReadContexts());
        } else {
            super.exportStatements(subj, pred, obj, includeInferred, handler, contexts);
        }
    }

    @Override
    public RepositoryResult<Statement> getStatements(Resource subj, IRI pred, Value obj, Resource ... contexts) throws RepositoryException {
        if (this.isAllContext(contexts)) {
            return super.getStatements(subj, pred, obj, this.isIncludeInferred(), (Resource[])this.getReadContexts());
        }
        return super.getStatements(subj, pred, obj, this.isIncludeInferred(), contexts);
    }

    @Override
    public RepositoryResult<Statement> getStatements(Resource subj, IRI pred, Value obj, boolean includeInferred, Resource ... contexts) throws RepositoryException {
        if (this.isAllContext(contexts)) {
            return super.getStatements(subj, pred, obj, includeInferred, (Resource[])this.getReadContexts());
        }
        return super.getStatements(subj, pred, obj, includeInferred, contexts);
    }

    @Override
    public boolean hasStatement(Resource subj, IRI pred, Value obj, boolean includeInferred, Resource ... contexts) throws RepositoryException {
        if (this.isAllContext(contexts)) {
            return super.hasStatement(subj, pred, obj, includeInferred, (Resource[])this.getReadContexts());
        }
        return super.hasStatement(subj, pred, obj, includeInferred, contexts);
    }

    @Override
    public boolean hasStatement(Statement st, boolean includeInferred, Resource ... contexts) throws RepositoryException {
        if (this.isAllContext(contexts) && st.getContext() == null) {
            return super.hasStatement(st, includeInferred, this.getReadContexts());
        }
        return super.hasStatement(st, includeInferred, contexts);
    }

    public boolean hasStatement(Resource subj, IRI pred, Value obj, Resource ... contexts) throws RepositoryException {
        if (this.isAllContext(contexts)) {
            return super.hasStatement(subj, pred, obj, this.isIncludeInferred(), (Resource[])this.getReadContexts());
        }
        return super.hasStatement(subj, pred, obj, this.isIncludeInferred(), contexts);
    }

    public boolean hasStatement(Statement st, Resource ... contexts) throws RepositoryException {
        if (this.isAllContext(contexts) && st.getContext() == null) {
            return super.hasStatement(st, this.isIncludeInferred(), this.getReadContexts());
        }
        return super.hasStatement(st, this.isIncludeInferred(), contexts);
    }

    @Override
    public GraphQuery prepareGraphQuery(String query) throws MalformedQueryException, RepositoryException {
        return this.prepareGraphQuery(this.getQueryLanguage(), query);
    }

    @Override
    public Query prepareQuery(String query) throws MalformedQueryException, RepositoryException {
        return this.prepareQuery(this.getQueryLanguage(), query);
    }

    @Override
    public TupleQuery prepareTupleQuery(String query) throws MalformedQueryException, RepositoryException {
        return this.prepareTupleQuery(this.getQueryLanguage(), query);
    }

    @Override
    public Update prepareUpdate(String query) throws MalformedQueryException, RepositoryException {
        return this.prepareUpdate(this.getQueryLanguage(), query);
    }

    @Override
    public GraphQuery prepareGraphQuery(QueryLanguage ql, String query) throws MalformedQueryException, RepositoryException {
        return this.prepareGraphQuery(ql, query, this.getBaseURI());
    }

    @Override
    public Query prepareQuery(QueryLanguage ql, String query) throws MalformedQueryException, RepositoryException {
        return this.prepareQuery(ql, query, this.getBaseURI());
    }

    @Override
    public TupleQuery prepareTupleQuery(QueryLanguage ql, String query) throws MalformedQueryException, RepositoryException {
        return this.prepareTupleQuery(ql, query, this.getBaseURI());
    }

    @Override
    public BooleanQuery prepareBooleanQuery(QueryLanguage ql, String query) throws MalformedQueryException, RepositoryException {
        return this.prepareBooleanQuery(ql, query, this.getBaseURI());
    }

    @Override
    public Update prepareUpdate(QueryLanguage ql, String query) throws MalformedQueryException, RepositoryException {
        return this.prepareUpdate(ql, query, this.getBaseURI());
    }

    @Override
    public GraphQuery prepareGraphQuery(QueryLanguage ql, String query, String baseURI) throws MalformedQueryException, RepositoryException {
        if (baseURI == null) {
            baseURI = this.getBaseURI();
        }
        return this.initQuery(super.prepareGraphQuery(ql, query, baseURI));
    }

    @Override
    public Query prepareQuery(QueryLanguage ql, String query, String baseURI) throws MalformedQueryException, RepositoryException {
        if (baseURI == null) {
            baseURI = this.getBaseURI();
        }
        return this.initQuery(super.prepareQuery(ql, query, baseURI));
    }

    @Override
    public TupleQuery prepareTupleQuery(QueryLanguage ql, String query, String baseURI) throws MalformedQueryException, RepositoryException {
        if (baseURI == null) {
            baseURI = this.getBaseURI();
        }
        return this.initQuery(super.prepareTupleQuery(ql, query, baseURI));
    }

    @Override
    public BooleanQuery prepareBooleanQuery(QueryLanguage ql, String query, String baseURI) throws MalformedQueryException, RepositoryException {
        if (baseURI == null) {
            baseURI = this.getBaseURI();
        }
        return this.initQuery(super.prepareBooleanQuery(ql, query, baseURI));
    }

    @Override
    public Update prepareUpdate(QueryLanguage ql, String update, String baseURI) throws MalformedQueryException, RepositoryException {
        if (baseURI == null) {
            baseURI = this.getBaseURI();
        }
        return this.initOperation(super.prepareUpdate(ql, update, baseURI));
    }

    @Override
    public void remove(Iterable<? extends Statement> statements, Resource ... contexts) throws RepositoryException {
        if (this.isAllContext(contexts)) {
            this.remove(new CloseableIteratorIteration<Statement>(statements.iterator()), new Resource[0]);
        } else {
            super.remove(statements, contexts);
        }
    }

    @Override
    public void remove(CloseableIteration<? extends Statement> statementIter, Resource ... contexts) throws RepositoryException {
        final IRI[] removeContexts = this.getRemoveContexts();
        if (this.isAllContext(contexts) && removeContexts.length == 1) {
            super.remove((CloseableIteration<? extends Statement>)new ConvertingIteration<Statement, Statement>(statementIter){

                @Override
                protected Statement convert(Statement st) {
                    if (st.getContext() == null) {
                        return ContextAwareConnection.this.getValueFactory().createStatement(st.getSubject(), st.getPredicate(), st.getObject(), removeContexts[0]);
                    }
                    return st;
                }
            }, new Resource[0]);
        } else {
            super.remove(statementIter, contexts);
        }
    }

    @Override
    public void remove(Resource subject, IRI predicate, Value object, Resource ... contexts) throws RepositoryException {
        if (this.isAllContext(contexts)) {
            super.remove(subject, predicate, object, (Resource[])this.getRemoveContexts());
        } else {
            super.remove(subject, predicate, object, contexts);
        }
    }

    @Override
    public void remove(Statement st, Resource ... contexts) throws RepositoryException {
        if (this.isAllContext(contexts) && st.getContext() == null) {
            super.remove(st, (Resource[])this.getRemoveContexts());
        } else {
            super.remove(st, contexts);
        }
    }

    @Override
    public long size(Resource ... contexts) throws RepositoryException {
        if (this.isAllContext(contexts)) {
            return super.size(this.getReadContexts());
        }
        return super.size(contexts);
    }

    @Override
    protected void removeWithoutCommit(Resource subject, IRI predicate, Value object, Resource ... contexts) throws RepositoryException {
        Resource[] archiveContexts = this.getArchiveContexts();
        if (archiveContexts.length > 0) {
            RDFInserter handler = new RDFInserter(this.getDelegate());
            try {
                this.getDelegate().exportStatements(subject, predicate, object, true, handler, archiveContexts);
            }
            catch (RDFHandlerException e) {
                if (e.getCause() instanceof RepositoryException) {
                    throw (RepositoryException)e.getCause();
                }
                throw new AssertionError((Object)e);
            }
        }
        if (this.isAllContext(contexts)) {
            this.getDelegate().remove(subject, predicate, object, (Resource[])this.getRemoveContexts());
        } else {
            this.getDelegate().remove(subject, predicate, object, contexts);
        }
    }

    private <O extends Query> O initQuery(O query) {
        this.initOperation(query);
        query.setMaxQueryTime(this.getMaxQueryTime());
        return query;
    }

    private <O extends Operation> O initOperation(O op) {
        IRI[] readContexts = this.getReadContexts();
        IRI[] removeContexts = this.getRemoveContexts();
        IRI insertContext = this.getInsertContext();
        if (readContexts.length > 0 || removeContexts.length > 0 || insertContext != null) {
            SimpleDataset ds = new SimpleDataset();
            for (IRI graph : readContexts) {
                ds.addDefaultGraph(graph);
            }
            for (IRI graph : removeContexts) {
                ds.addDefaultRemoveGraph(graph);
            }
            ds.setDefaultInsertGraph(insertContext);
            op.setDataset(ds);
        }
        op.setIncludeInferred(this.isIncludeInferred());
        return op;
    }

    private boolean isNilContext(Resource[] contexts) {
        return this.isAllContext(contexts) || contexts.length == 1 && contexts[0] == null;
    }

    private boolean isAllContext(Resource[] contexts) {
        return contexts == null || contexts.length == 0;
    }
}

