/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.queryrender.sparql.ir.util.transform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.queryrender.sparql.TupleExprIRRenderer;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrBGP;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrGraph;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrMinus;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrNode;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrOptional;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrPathTriple;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrService;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrStatementPattern;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrSubSelect;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrUnion;
import org.eclipse.rdf4j.queryrender.sparql.ir.util.transform.BaseTransform;
import org.eclipse.rdf4j.queryrender.sparql.ir.util.transform.PathTextUtils;

public final class FuseUnionOfPathTriplesPartialTransform
extends BaseTransform {
    private FuseUnionOfPathTriplesPartialTransform() {
    }

    public static IrBGP apply(IrBGP bgp, TupleExprIRRenderer r) {
        if (bgp == null) {
            return null;
        }
        ArrayList<IrNode> out = new ArrayList<IrNode>();
        Iterator<IrNode> iterator = bgp.getLines().iterator();
        while (iterator.hasNext()) {
            IrNode n;
            IrNode m = n = iterator.next();
            if (n instanceof IrUnion) {
                m = FuseUnionOfPathTriplesPartialTransform.fuseUnion((IrUnion)n, r);
            } else if (n instanceof IrBGP) {
                m = FuseUnionOfPathTriplesPartialTransform.apply((IrBGP)n, r);
            } else if (n instanceof IrGraph) {
                IrGraph g = (IrGraph)n;
                IrBGP inner = FuseUnionOfPathTriplesPartialTransform.apply(g.getWhere(), r);
                m = new IrGraph(g.getGraph(), inner, g.isNewScope());
            } else if (n instanceof IrOptional) {
                IrOptional o = (IrOptional)n;
                IrOptional no = new IrOptional(FuseUnionOfPathTriplesPartialTransform.apply(o.getWhere(), r), o.isNewScope());
                no.setNewScope(o.isNewScope());
                m = no;
            } else if (n instanceof IrMinus) {
                IrMinus mi = (IrMinus)n;
                m = new IrMinus(FuseUnionOfPathTriplesPartialTransform.apply(mi.getWhere(), r), mi.isNewScope());
            } else if (n instanceof IrService) {
                IrService s = (IrService)n;
                m = new IrService(s.getServiceRefText(), s.isSilent(), FuseUnionOfPathTriplesPartialTransform.apply(s.getWhere(), r), s.isNewScope());
            } else if (n instanceof IrSubSelect) {
                // empty if block
            }
            out.add(m);
        }
        return BaseTransform.bgpWithLines(bgp, out);
    }

    private static IrNode fuseUnion(IrUnion u, TupleExprIRRenderer r) {
        Object gName;
        if (u == null || u.getBranches().size() < 2) {
            return u;
        }
        IrUnion transformed = new IrUnion(u.isNewScope());
        for (IrBGP b : u.getBranches()) {
            transformed.addBranch(FuseUnionOfPathTriplesPartialTransform.apply(b, r));
        }
        u = transformed;
        if (BaseTransform.unionIsExplicitAndAllBranchesScoped(u)) {
            return u;
        }
        class Key {
            final String gName;
            final String sName;
            final String oName;

            Key(String gName, String sName, String oName) {
                this.gName = gName;
                this.sName = sName;
                this.oName = oName;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Key key = (Key)o;
                return Objects.equals(this.gName, key.gName) && Objects.equals(this.sName, key.sName) && Objects.equals(this.oName, key.oName);
            }

            public int hashCode() {
                return Objects.hash(this.gName, this.sName, this.oName);
            }
        }
        class Group {
            final Var g;
            final Var s;
            final Var o;
            final List<Integer> idxs = new ArrayList<Integer>();

            Group(Var g, Var s, Var o) {
                this.g = g;
                this.s = s;
                this.o = o;
            }
        }
        LinkedHashMap<Key, Group> groups = new LinkedHashMap<Key, Group>();
        ArrayList<String> pathTexts = new ArrayList<String>();
        pathTexts.add(null);
        for (int i = 0; i < u.getBranches().size(); ++i) {
            IrBGP b = u.getBranches().get(i);
            Object g = null;
            Var sVar = null;
            Var oVar = null;
            String ptxt = null;
            IrNode cur = b.getLines().size() == 1 ? b.getLines().get(0) : null;
            boolean progressed = true;
            while (progressed && cur != null) {
                IrBGP nb;
                progressed = false;
                if (cur instanceof IrBGP && (nb = (IrBGP)cur).getLines().size() == 1) {
                    cur = nb.getLines().get(0);
                    progressed = true;
                    continue;
                }
                if (!(cur instanceof IrGraph)) continue;
                IrGraph gb = (IrGraph)cur;
                g = gb.getGraph();
                if (gb.getWhere() == null || gb.getWhere().getLines().size() != 1) continue;
                cur = gb.getWhere().getLines().get(0);
                progressed = true;
            }
            if (cur instanceof IrPathTriple) {
                IrPathTriple pt = (IrPathTriple)cur;
                sVar = pt.getSubject();
                oVar = pt.getObject();
                ptxt = pt.getPathText();
            } else if (cur instanceof IrStatementPattern) {
                IrStatementPattern sp = (IrStatementPattern)cur;
                sVar = sp.getSubject();
                oVar = sp.getObject();
                String string = ptxt = FuseUnionOfPathTriplesPartialTransform.isConstantIriPredicate(sp) ? FuseUnionOfPathTriplesPartialTransform.iri(sp.getPredicate(), r) : null;
            }
            if (sVar == null || oVar == null || ptxt == null) {
                pathTexts.add(null);
                continue;
            }
            String trimmed = ptxt.trim();
            if (trimmed.endsWith("?") || trimmed.endsWith("*") || trimmed.endsWith("+")) {
                pathTexts.add(null);
                continue;
            }
            pathTexts.add(trimmed);
            gName = g == null ? null : ((Var)g).getName();
            String sName = sVar.getName();
            String oName = oVar.getName();
            Key k = new Key((String)gName, sName, oName);
            Group grp = (Group)groups.get(k);
            if (grp == null) {
                grp = new Group((Var)g, sVar, oVar);
                groups.put(k, grp);
            }
            grp.idxs.add(i + 1);
        }
        HashSet<Integer> fusedIdxs = new HashSet<Integer>();
        IrUnion out = new IrUnion(u.isNewScope());
        for (Group grp : groups.values()) {
            String merged;
            Object aNonNeg;
            boolean pathGeneratedUnion;
            List<Integer> idxs = grp.idxs;
            if (idxs.size() < 2) continue;
            boolean shareAnon = FuseUnionOfPathTriplesPartialTransform.branchesShareAnonPathVar(u, idxs);
            boolean safeAlt = FuseUnionOfPathTriplesPartialTransform.branchesFormSafeAlternation(idxs, pathTexts);
            boolean bl = pathGeneratedUnion = !u.isNewScope();
            if (!shareAnon && (!pathGeneratedUnion || !safeAlt)) continue;
            ArrayList<String> alts = new ArrayList<String>();
            gName = idxs.iterator();
            while (gName.hasNext()) {
                int idx = gName.next();
                String t = (String)pathTexts.get(idx);
                if (t == null) continue;
                alts.add(t);
            }
            if (idxs.size() == 2) {
                List<String> aTokens = FuseUnionOfPathTriplesPartialTransform.splitTopLevelAlternation((String)pathTexts.get(idxs.get(0)));
                List<String> bTokens = FuseUnionOfPathTriplesPartialTransform.splitTopLevelAlternation((String)pathTexts.get(idxs.get(1)));
                ArrayList<String> negMembers = new ArrayList<String>();
                aNonNeg = new ArrayList();
                ArrayList<String> bNonNeg = new ArrayList<String>();
                FuseUnionOfPathTriplesPartialTransform.extractNegAndNonNeg(aTokens, negMembers, (List<String>)aNonNeg);
                FuseUnionOfPathTriplesPartialTransform.extractNegAndNonNeg(bTokens, negMembers, bNonNeg);
                ArrayList<Object> outTok = new ArrayList<Object>((Collection<Object>)aNonNeg);
                if (!negMembers.isEmpty()) {
                    outTok.add("!(" + String.join((CharSequence)"|", negMembers) + ")");
                }
                outTok.addAll(bNonNeg);
                merged = outTok.isEmpty() ? String.join((CharSequence)"|", alts) : String.join((CharSequence)"|", outTok);
            } else {
                merged = String.join((CharSequence)"|", alts);
            }
            boolean branchScope = u.isNewScope();
            IrBGP b = new IrBGP(branchScope);
            HashSet<Var> acc = new HashSet<Var>();
            aNonNeg = idxs.iterator();
            while (aNonNeg.hasNext()) {
                IrNode only;
                int idx = aNonNeg.next();
                IrBGP br = u.getBranches().get(idx - 1);
                IrNode irNode = only = br.getLines().size() == 1 ? br.getLines().get(0) : null;
                if (only instanceof IrGraph) {
                    IrGraph gb = (IrGraph)only;
                    if (gb.getWhere() == null || gb.getWhere().getLines().size() != 1 || !(gb.getWhere().getLines().get(0) instanceof IrPathTriple)) continue;
                    IrPathTriple pt = (IrPathTriple)gb.getWhere().getLines().get(0);
                    acc.addAll(pt.getPathVars());
                    continue;
                }
                if (!(only instanceof IrPathTriple)) continue;
                acc.addAll(((IrPathTriple)only).getPathVars());
            }
            IrPathTriple mergedPt = new IrPathTriple(grp.s, merged, grp.o, branchScope, acc);
            if (grp.g != null) {
                b.add(new IrGraph(grp.g, FuseUnionOfPathTriplesPartialTransform.wrap(mergedPt), false));
            } else {
                b.add(mergedPt);
            }
            out.addBranch(b);
            fusedIdxs.addAll(idxs);
        }
        for (int i = 0; i < u.getBranches().size(); ++i) {
            if (fusedIdxs.contains(i + 1)) continue;
            out.addBranch(u.getBranches().get(i));
        }
        IrUnion normalized = new IrUnion(out.isNewScope());
        for (IrBGP br : out.getBranches()) {
            normalized.addBranch(FuseUnionOfPathTriplesPartialTransform.unwrapSingleBgpLayer(br));
        }
        return normalized;
    }

    private static IrBGP unwrapSingleBgpLayer(IrBGP branch) {
        IrBGP inner;
        IrNode only;
        IrBGP b;
        if (branch == null) {
            return null;
        }
        IrBGP cur = branch;
        while ((b = cur).getLines().size() == 1 && (only = b.getLines().get(0)) instanceof IrBGP && (inner = (IrBGP)only).getLines().size() == 1) {
            boolean simple;
            IrNode innerOnly = inner.getLines().get(0);
            boolean bl = simple = innerOnly instanceof IrPathTriple || innerOnly instanceof IrGraph && ((IrGraph)innerOnly).getWhere() != null && ((IrGraph)innerOnly).getWhere().getLines().size() == 1 && ((IrGraph)innerOnly).getWhere().getLines().get(0) instanceof IrPathTriple;
            if (!simple) break;
            IrBGP replaced = new IrBGP(b.isNewScope());
            replaced.add(innerOnly);
            cur = replaced;
        }
        return cur;
    }

    private static boolean branchesShareAnonPathVar(IrUnion u, List<Integer> idxs) {
        HashSet<String> intersection = null;
        for (int idx : idxs) {
            IrBGP br = u.getBranches().get(idx - 1);
            Set<String> names = FuseUnionOfPathTriplesPartialTransform.collectAnonNamesFromPathTripleBranch(br);
            if (names.isEmpty()) {
                return false;
            }
            if (intersection == null) {
                intersection = new HashSet<String>(names);
                continue;
            }
            intersection.retainAll(names);
            if (!intersection.isEmpty()) continue;
            return false;
        }
        return intersection != null && !intersection.isEmpty();
    }

    private static Set<String> collectAnonNamesFromPathTripleBranch(IrBGP b) {
        HashSet<String> out = new HashSet<String>();
        if (b == null || b.getLines().size() != 1) {
            return out;
        }
        IrNode only = b.getLines().get(0);
        if (only instanceof IrGraph) {
            IrGraph g = (IrGraph)only;
            if (g.getWhere() == null || g.getWhere().getLines().size() != 1) {
                return out;
            }
            only = g.getWhere().getLines().get(0);
        }
        if (only instanceof IrPathTriple) {
            Set<Var> pvs;
            IrPathTriple pt = (IrPathTriple)only;
            Var s = pt.getSubject();
            Var o = pt.getObject();
            if (FuseUnionOfPathTriplesPartialTransform.isAnonPathVar(s) || FuseUnionOfPathTriplesPartialTransform.isAnonPathInverseVar(s)) {
                out.add(s.getName());
            }
            if (FuseUnionOfPathTriplesPartialTransform.isAnonPathVar(o) || FuseUnionOfPathTriplesPartialTransform.isAnonPathInverseVar(o)) {
                out.add(o.getName());
            }
            if ((pvs = pt.getPathVars()) != null) {
                for (Var v : pvs) {
                    if (v == null || v.hasValue() || v.getName() == null || !v.getName().startsWith("_anon_path_") && !v.getName().startsWith("_anon_path_inverse_")) continue;
                    out.add(v.getName());
                }
            }
        }
        return out;
    }

    private static boolean branchesFormSafeAlternation(List<Integer> idxs, List<String> pathTexts) {
        if (idxs == null || idxs.size() < 2) {
            return false;
        }
        for (int idx : idxs) {
            if (idx <= 0 || idx >= pathTexts.size()) {
                return false;
            }
            String p = pathTexts.get(idx);
            if (p != null) continue;
            return false;
        }
        return true;
    }

    private static IrBGP wrap(IrPathTriple pt) {
        IrBGP b = new IrBGP(false);
        b.add(pt);
        return b;
    }

    private static List<String> splitTopLevelAlternation(String path) {
        if (path == null) {
            return new ArrayList<String>();
        }
        String s = PathTextUtils.trimSingleOuterParens(path.trim());
        return PathTextUtils.splitTopLevel(s, '|');
    }

    private static void extractNegAndNonNeg(List<String> tokens, List<String> negMembers, List<String> nonNeg) {
        if (tokens == null) {
            return;
        }
        for (String t : tokens) {
            String x = t.trim();
            if (x.startsWith("!(") && x.endsWith(")")) {
                String inner = x.substring(2, x.length() - 1).trim();
                List<String> innerToks = FuseUnionOfPathTriplesPartialTransform.splitTopLevelAlternation(inner);
                for (String it : innerToks) {
                    String m = it.trim();
                    if (m.isEmpty()) continue;
                    negMembers.add(m);
                }
                continue;
            }
            if (x.startsWith("!^")) {
                negMembers.add(x.substring(1).trim());
                continue;
            }
            if (x.startsWith("!") && (x.length() == 1 || x.charAt(1) != '(')) {
                negMembers.add(x.substring(1).trim());
                continue;
            }
            nonNeg.add(x);
        }
    }
}

