/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.impl;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Comparator;
import java.util.Date;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.rdf4j.common.annotation.Experimental;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.MutableBindingSet;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryBindingSet;

public interface QueryEvaluationContext {
    @Experimental
    default public Comparator<Value> getComparator() {
        return null;
    }

    public Literal getNow();

    public Dataset getDataset();

    default public MutableBindingSet createBindingSet() {
        return new QueryBindingSet();
    }

    default public Predicate<BindingSet> hasBinding(String variableName) {
        return bs -> bs.hasBinding(variableName);
    }

    default public Function<BindingSet, Binding> getBinding(String variableName) {
        return bs -> bs.getBinding(variableName);
    }

    default public Function<BindingSet, Value> getValue(String variableName) {
        Function<BindingSet, Binding> getBinding = this.getBinding(variableName);
        return bs -> {
            Binding binding = (Binding)getBinding.apply((BindingSet)bs);
            if (binding == null) {
                return null;
            }
            return binding.getValue();
        };
    }

    default public BiConsumer<Value, MutableBindingSet> setBinding(String variableName) {
        return (val, bs) -> bs.setBinding(variableName, val);
    }

    default public BiConsumer<Value, MutableBindingSet> addBinding(String variableName) {
        return (val, bs) -> bs.addBinding(variableName, val);
    }

    default public MutableBindingSet createBindingSet(BindingSet bindings) {
        return new QueryBindingSet(bindings);
    }

    public static class Minimal
    implements QueryEvaluationContext {
        private static final VarHandle NOW;
        private volatile Literal now;
        private final Dataset dataset;
        private final ValueFactory valueFactory;
        private final Comparator<Value> comparator;

        public Minimal(Literal now, Dataset dataset, Comparator<Value> comparator) {
            this.now = now;
            this.dataset = dataset;
            this.valueFactory = SimpleValueFactory.getInstance();
            this.comparator = comparator;
        }

        public Minimal(Literal now, Dataset dataset) {
            this(now, dataset, null);
        }

        public Minimal(Dataset dataset) {
            this(null, dataset);
        }

        public Minimal(Dataset dataset, Comparator<Value> comparator) {
            this(null, dataset, comparator);
        }

        public Minimal(Dataset dataset, ValueFactory valueFactory, Comparator<Value> comparator) {
            this.dataset = dataset;
            this.valueFactory = valueFactory;
            this.comparator = comparator;
        }

        public Minimal(Dataset dataset, ValueFactory valueFactory) {
            this(dataset, valueFactory, null);
        }

        @Override
        public Comparator<Value> getComparator() {
            return this.comparator;
        }

        @Override
        public Literal getNow() {
            boolean success;
            Literal now = NOW.get(this);
            if (now == null && !(success = NOW.compareAndSet(this, null, now = this.valueFactory.createLiteral(new Date())))) {
                now = NOW.getAcquire(this);
            }
            return now;
        }

        @Override
        public Dataset getDataset() {
            return this.dataset;
        }

        static {
            try {
                NOW = MethodHandles.privateLookupIn(Minimal.class, MethodHandles.lookup()).findVarHandle(Minimal.class, "now", Literal.class);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new UnsupportedOperationException("The nowInLiteral field is missing");
            }
        }
    }
}

