/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.io.eval.ManyValueWorker;
import org.apache.solr.client.solrj.io.eval.RecursiveNumericEvaluator;
import org.apache.solr.client.solrj.io.eval.StreamEvaluatorException;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class SubtractEvaluator
extends RecursiveNumericEvaluator
implements ManyValueWorker {
    protected static final long serialVersionUID = 1L;

    public SubtractEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (this.containedEvaluators.size() < 2) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting at least two values but found %d", expression, this.containedEvaluators.size()));
        }
    }

    @Override
    public Object doWork(Object ... values) throws IOException {
        if (Arrays.stream(values).anyMatch(item -> null == item)) {
            return null;
        }
        if (0 == values.length) {
            return null;
        }
        List<BigDecimal> flattenedValues = this.flatten(Arrays.stream(values).collect(Collectors.toList()));
        BigDecimal result = flattenedValues.get(0);
        for (int idx = 1; idx < flattenedValues.size(); ++idx) {
            result = this.subtract(result, flattenedValues.get(idx));
        }
        return result;
    }

    private List<BigDecimal> flatten(Collection<?> values) {
        ArrayList<BigDecimal> flattened = new ArrayList<BigDecimal>();
        for (Object value : values) {
            if (null == value) {
                flattened.add(null);
            }
            if (value instanceof Collection) {
                flattened.addAll(this.flatten((Collection)value));
                continue;
            }
            if (value instanceof BigDecimal) {
                flattened.add((BigDecimal)value);
                continue;
            }
            if (value instanceof Number) {
                flattened.add(new BigDecimal(value.toString()));
                continue;
            }
            throw new StreamEvaluatorException("Numeric value expected but found type %s for value %s", value.getClass().getName(), value.toString());
        }
        return flattened;
    }

    private BigDecimal subtract(BigDecimal left, Object right) throws IOException {
        if (null == right) {
            return null;
        }
        return left.subtract((BigDecimal)right);
    }
}

