/*
 * Decompiled with CFR 0.152.
 */
package no.hasmac.jsonld.compaction;

import jakarta.json.JsonArray;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import no.hasmac.jsonld.JsonLdError;
import no.hasmac.jsonld.JsonLdErrorCode;
import no.hasmac.jsonld.JsonLdVersion;
import no.hasmac.jsonld.context.ActiveContext;
import no.hasmac.jsonld.context.InverseContext;
import no.hasmac.jsonld.context.TermDefinition;
import no.hasmac.jsonld.json.JsonUtils;
import no.hasmac.jsonld.lang.BlankNode;
import no.hasmac.jsonld.lang.GraphObject;
import no.hasmac.jsonld.lang.Keywords;
import no.hasmac.jsonld.lang.ListObject;
import no.hasmac.jsonld.lang.NodeObject;
import no.hasmac.jsonld.lang.ValueObject;
import no.hasmac.jsonld.uri.UriRelativizer;

public final class UriCompaction {
    private final ActiveContext activeContext;
    private JsonValue value;
    private boolean vocab;
    private boolean reverse;

    private UriCompaction(ActiveContext activeContext) {
        this.activeContext = activeContext;
        this.value = null;
        this.vocab = false;
        this.reverse = false;
    }

    public static UriCompaction with(ActiveContext activeContext) {
        return new UriCompaction(activeContext);
    }

    public UriCompaction value(JsonValue value) {
        this.value = value;
        return this;
    }

    public UriCompaction vocab(boolean vocab) {
        this.vocab = vocab;
        return this;
    }

    public UriCompaction reverse(boolean reverse) {
        this.reverse = reverse;
        return this;
    }

    public String compact(String variable) throws JsonLdError {
        String suffix;
        String term;
        if (variable == null) {
            return null;
        }
        if (this.activeContext.getInverseContext() == null) {
            this.activeContext.createInverseContext();
        }
        InverseContext inverseContext = this.activeContext.getInverseContext();
        if (this.vocab && inverseContext.contains(variable) && (term = this.compact_4(variable)) != null) {
            return term;
        }
        if (this.vocab && this.activeContext.getVocabularyMapping() != null && variable.startsWith(this.activeContext.getVocabularyMapping()) && variable.length() > this.activeContext.getVocabularyMapping().length() && !this.activeContext.containsTerm(suffix = variable.substring(this.activeContext.getVocabularyMapping().length()))) {
            return suffix;
        }
        String compactUri = null;
        if ((compactUri = this.compact_7(variable, compactUri)) != null) {
            return compactUri;
        }
        if (!variable.startsWith("_:") && !Keywords.contains(variable)) {
            try {
                URI uri = URI.create(variable);
                if (uri.isAbsolute() && uri.getScheme() != null && uri.getAuthority() == null && this.activeContext.getTerm(uri.getScheme()).filter(TermDefinition::isPrefix).isPresent()) {
                    throw new JsonLdError(JsonLdErrorCode.IRI_CONFUSED_WITH_PREFIX);
                }
            }
            catch (IllegalArgumentException uri) {
                // empty catch block
            }
        }
        if (!this.vocab && this.activeContext.getBaseUri() != null && !BlankNode.hasPrefix(variable)) {
            String relativeUri = UriRelativizer.relativize(this.activeContext.getBaseUri(), variable);
            return Keywords.matchForm(relativeUri) ? "./".concat(relativeUri) : relativeUri;
        }
        return variable;
    }

    private String compact_7(String variable, String compactUri) {
        for (Map.Entry<String, TermDefinition> termEntry : this.activeContext.getTermsMapping().entrySet()) {
            String uriMapping;
            TermDefinition termDefinition = termEntry.getValue();
            if (termDefinition.getUriMapping() == null || termDefinition.isNotPrefix() || !variable.startsWith(termDefinition.getUriMapping()) || variable.equals(termDefinition.getUriMapping())) continue;
            String compactUriCandidate = termEntry.getKey().concat(":").concat(variable.substring(termDefinition.getUriMapping().length()));
            TermDefinition term = this.activeContext.getTermNullable(compactUriCandidate);
            if (term == null && (compactUri == null || compactUriCandidate.compareTo(compactUri) < 0)) {
                compactUri = compactUriCandidate;
                continue;
            }
            if (term == null || (uriMapping = term.getUriMapping()) == null || !uriMapping.equals(variable) || !JsonUtils.isNull(this.value)) continue;
            compactUri = compactUriCandidate;
        }
        return compactUri;
    }

    private String compact_4(String variable) throws JsonLdError {
        JsonValue preserve;
        Object defaultLanguage = "@none";
        if (this.activeContext.getDefaultLanguage() != null) {
            defaultLanguage = this.activeContext.getDefaultLanguage().toLowerCase();
            if (this.activeContext.getDefaultBaseDirection() != null) {
                defaultLanguage = (String)defaultLanguage + "_".concat(this.activeContext.getDefaultBaseDirection().name().toLowerCase());
            }
        } else if (this.activeContext.getDefaultBaseDirection() != null) {
            defaultLanguage = "_".concat(this.activeContext.getDefaultBaseDirection().name().toLowerCase());
        }
        if (JsonUtils.containsKey(this.value, "@preserve") && JsonUtils.isNotNull(preserve = (JsonValue)this.value.asJsonObject().get((Object)"@preserve"))) {
            this.value = (JsonValue)JsonUtils.toJsonArray(preserve).get(0);
        }
        ArrayList<String> containers = new ArrayList<String>(8);
        String typeLanguage = "@language";
        Object typeLanguageValue = "@null";
        if (JsonUtils.containsKey(this.value, "@index") && !GraphObject.isGraphObject(this.value)) {
            containers.add("@index");
            containers.add("@index".concat("@set"));
        }
        if (this.reverse) {
            typeLanguage = "@type";
            typeLanguageValue = "@reverse";
            containers.add("@set");
        } else if (ListObject.isListObject(this.value)) {
            if (!this.value.asJsonObject().containsKey((Object)"@index")) {
                containers.add("@list");
            }
            JsonArray list = ((JsonValue)this.value.asJsonObject().get((Object)"@list")).asJsonArray();
            String commonType = null;
            Object commonLanguage = list.isEmpty() ? defaultLanguage : null;
            for (JsonValue item : list) {
                Object itemLanguage = "@none";
                String itemType = "@none";
                if (JsonUtils.containsKey(item, "@value")) {
                    if (item.asJsonObject().containsKey((Object)"@direction")) {
                        itemLanguage = "";
                        if (item.asJsonObject().containsKey((Object)"@language")) {
                            itemLanguage = item.asJsonObject().getString("@language").toLowerCase();
                        }
                        itemLanguage = (String)itemLanguage + "_".concat(item.asJsonObject().getString("@direction").toLowerCase());
                    } else if (item.asJsonObject().containsKey((Object)"@language")) {
                        itemLanguage = item.asJsonObject().getString("@language").toLowerCase();
                    } else if (item.asJsonObject().containsKey((Object)"@type")) {
                        itemType = item.asJsonObject().getString("@type");
                    } else {
                        itemLanguage = "@null";
                    }
                } else {
                    itemType = "@id";
                }
                if (commonLanguage == null) {
                    commonLanguage = itemLanguage;
                } else if (!Objects.equals(itemLanguage, commonLanguage) && JsonUtils.containsKey(item, "@value")) {
                    commonLanguage = "@none";
                }
                if (commonType == null) {
                    commonType = itemType;
                } else if (!Objects.equals(itemType, commonType)) {
                    commonType = "@none";
                }
                if (!"@none".equals(commonLanguage) || !"@none".equals(commonType)) continue;
                break;
            }
            if (commonType == null) {
                commonType = "@none";
            }
            if (!"@none".equals(commonType)) {
                typeLanguage = "@type";
                typeLanguageValue = commonType;
            } else {
                typeLanguageValue = commonLanguage;
            }
        } else if (GraphObject.isGraphObject(this.value)) {
            if (this.value.asJsonObject().containsKey((Object)"@index")) {
                containers.add("@graph".concat("@index"));
                containers.add("@graph".concat("@index").concat("@set"));
            }
            if (this.value.asJsonObject().containsKey((Object)"@id")) {
                containers.add("@graph".concat("@id"));
                containers.add("@graph".concat("@id").concat("@set"));
            }
            containers.add("@graph");
            containers.add("@graph".concat("@set"));
            containers.add("@set");
            if (!this.value.asJsonObject().containsKey((Object)"@index")) {
                containers.add("@graph".concat("@index"));
                containers.add("@graph".concat("@index").concat("@set"));
            }
            if (!this.value.asJsonObject().containsKey((Object)"@id")) {
                containers.add("@graph".concat("@id"));
                containers.add("@graph".concat("@id").concat("@set"));
            }
            containers.add("@index");
            containers.add("@index".concat("@set"));
            typeLanguage = "@type";
            typeLanguageValue = "@id";
        } else {
            if (ValueObject.isValueObject(this.value)) {
                JsonValue language;
                if (JsonUtils.contains("@direction", this.value) && !JsonUtils.contains("@index", this.value)) {
                    JsonValue direction;
                    typeLanguageValue = "";
                    if (JsonUtils.contains("@language", this.value) && JsonUtils.isString(language = (JsonValue)this.value.asJsonObject().get((Object)"@language"))) {
                        typeLanguageValue = ((JsonString)language).getString().toLowerCase();
                    }
                    if (JsonUtils.isString(direction = (JsonValue)this.value.asJsonObject().get((Object)"@direction"))) {
                        typeLanguageValue = (String)typeLanguageValue + "_".concat(((JsonString)direction).getString().toLowerCase());
                    }
                    containers.add("@language");
                    containers.add("@language".concat("@set"));
                } else if (JsonUtils.contains("@language", this.value) && !JsonUtils.contains("@index", this.value)) {
                    if (JsonUtils.contains("@language", this.value) && JsonUtils.isString(language = (JsonValue)this.value.asJsonObject().get((Object)"@language"))) {
                        typeLanguageValue = ((JsonString)language).getString().toLowerCase();
                    }
                    containers.add("@language");
                    containers.add("@language".concat("@set"));
                } else if (JsonUtils.contains("@type", this.value)) {
                    typeLanguage = "@type";
                    typeLanguageValue = this.value.asJsonObject().getString("@type");
                }
            } else {
                typeLanguage = "@type";
                typeLanguageValue = "@id";
                containers.add("@id");
                containers.add("@id".concat("@set"));
                containers.add("@type");
                containers.add("@set".concat("@type"));
            }
            containers.add("@set");
        }
        containers.add("@none");
        if (!(this.activeContext.inMode(JsonLdVersion.V1_0) || !JsonUtils.isNotObject(this.value) && this.value.asJsonObject().containsKey((Object)"@index"))) {
            containers.add("@index");
            containers.add("@index".concat("@set"));
        }
        if (!this.activeContext.inMode(JsonLdVersion.V1_0) && JsonUtils.containsKey(this.value, "@value") && this.value.asJsonObject().size() == 1) {
            containers.add("@language");
            containers.add("@language".concat("@set"));
        }
        if (typeLanguageValue == null) {
            typeLanguageValue = "@null";
        }
        ArrayList<String> preferredValues = new ArrayList<String>();
        if ("@reverse".equals(typeLanguageValue)) {
            preferredValues.add("@reverse");
        }
        if (("@reverse".equals(typeLanguageValue) || "@id".equals(typeLanguageValue)) && JsonUtils.containsKey(this.value, "@id")) {
            JsonValue idValue = (JsonValue)this.value.asJsonObject().get((Object)"@id");
            if (this.activeContext.getOptions().isRdfStar() && NodeObject.isEmbeddedNode(idValue)) {
                preferredValues.add("@id");
                preferredValues.add("@vocab");
            } else if (JsonUtils.isString(idValue)) {
                String idString = ((JsonString)idValue).getString();
                String compactedIdValue = this.activeContext.uriCompaction().vocab(true).compact(idString);
                TermDefinition compactedIdValueTermDefinition = this.activeContext.getTermNullable(compactedIdValue);
                if (compactedIdValueTermDefinition != null && idString.equals(compactedIdValueTermDefinition.getUriMapping())) {
                    preferredValues.add("@vocab");
                    preferredValues.add("@id");
                } else {
                    preferredValues.add("@id");
                    preferredValues.add("@vocab");
                }
            } else {
                throw new JsonLdError(JsonLdErrorCode.INVALID_KEYWORD_ID_VALUE, "An @id entry was encountered whose value was not a string but [" + String.valueOf(idValue) + "].");
            }
            preferredValues.add("@none");
        } else {
            preferredValues.add((String)typeLanguageValue);
            preferredValues.add("@none");
            if (ListObject.isListObject(this.value) && JsonUtils.isEmptyArray((JsonValue)this.value.asJsonObject().get((Object)"@list"))) {
                typeLanguage = "@any";
            }
        }
        preferredValues.add("@any");
        for (String preferredValue : new ArrayList(preferredValues)) {
            int index = preferredValue.indexOf(95);
            if (index == -1) continue;
            preferredValues.add(preferredValue.substring(index));
        }
        String term = this.activeContext.termSelector(variable, containers, typeLanguage).match(preferredValues);
        return term;
    }
}

