/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.base.io;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Supplier;
import org.eclipse.passage.lic.api.LicensingException;
import org.eclipse.passage.lic.base.io.CollectedFiles;
import org.eclipse.passage.lic.base.io.FileCollection;
import org.eclipse.passage.lic.base.io.PassageFileExtension;

public final class LenientFileCollection
implements CollectedFiles {
    private final Supplier<Path> base;
    private final PassageFileExtension extension;

    public LenientFileCollection(Supplier<Path> base, PassageFileExtension extension) {
        this.base = Objects.requireNonNull(base, "LenientFileCollection::base path");
        this.extension = Objects.requireNonNull(extension, "LenientFileCollection::extension");
    }

    @Override
    public Collection<Path> get() throws LicensingException {
        if (this.baseIsOk()) {
            return new FileCollection(this.base, this.extension).get();
        }
        return Collections.emptyList();
    }

    private boolean baseIsOk() {
        return Files.exists(this.base.get(), new LinkOption[0]);
    }
}

