/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.base.inspection;

import java.util.Objects;
import org.eclipse.passage.lic.api.inspection.EnvironmentProperty;
import org.eclipse.passage.lic.internal.base.i18n.InspectionMessages;

public abstract class BaseEnvironmentProperty
implements EnvironmentProperty {
    protected final String separator = ".";
    private final String name;
    private final String family;

    protected BaseEnvironmentProperty(String family, String name) {
        Objects.requireNonNull(family);
        Objects.requireNonNull(name);
        this.family = family;
        this.name = name;
    }

    protected BaseEnvironmentProperty(FullyQualifiedName fqn) {
        this.family = fqn.family(".");
        this.name = fqn.name(".");
    }

    public final String family() {
        return this.family;
    }

    public final String name() {
        return this.name;
    }

    public final boolean equals(Object object) {
        if (!EnvironmentProperty.class.isInstance(object)) {
            return false;
        }
        EnvironmentProperty property = (EnvironmentProperty)object;
        return this.family.equals(property.family()) && this.name.equals(property.name());
    }

    public final int hashCode() {
        return Objects.hash(this.family, this.name);
    }

    public final String toString() {
        return String.format("%s%s%s", this.family, ".", this.name);
    }

    private static final class FullyQualifiedName {
        private final String fqn;

        FullyQualifiedName(String fqn) {
            this.fqn = fqn;
        }

        String family(String separator) {
            return this.fqn.substring(0, this.bound(separator));
        }

        String name(String separator) {
            return this.fqn.substring(this.bound(separator) + separator.length());
        }

        private int bound(String separator) {
            int bound = this.fqn.indexOf(separator);
            if (bound < 1) {
                throw new IllegalArgumentException(String.format(InspectionMessages.getString("BaseEnvironmentProperty.unexpected_format"), separator, this.fqn));
            }
            return bound;
        }
    }

    public static final class Of
    extends BaseEnvironmentProperty {
        public Of(String fqn) {
            super(new FullyQualifiedName(fqn));
        }
    }
}

