/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.conversion;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.internal.databinding.BindingMessages;

public class StringToBooleanPrimitiveConverter
implements IConverter<String, Boolean> {
    private static final String[] trueValues;
    private static final String[] falseValues;

    static {
        String delimiter = BindingMessages.getString("ValueDelimiter");
        String values = BindingMessages.getString("TrueStringValues");
        trueValues = StringToBooleanPrimitiveConverter.valuesToSortedArray(delimiter, values);
        values = BindingMessages.getString("FalseStringValues");
        falseValues = StringToBooleanPrimitiveConverter.valuesToSortedArray(delimiter, values);
    }

    private static String[] valuesToSortedArray(String delimiter, String values) {
        LinkedList<String> list = new LinkedList<String>();
        StringTokenizer tokenizer = new StringTokenizer(values, delimiter);
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken().toUpperCase());
        }
        Object[] array = list.toArray(new String[list.size()]);
        Arrays.sort(array);
        return array;
    }

    @Override
    public Boolean convert(String s) {
        if (Arrays.binarySearch(trueValues, s = s.toUpperCase()) > -1) {
            return Boolean.TRUE;
        }
        if (Arrays.binarySearch(falseValues, s) > -1) {
            return Boolean.FALSE;
        }
        throw new IllegalArgumentException(s + " is not a legal boolean value");
    }

    @Override
    public Object getFromType() {
        return String.class;
    }

    @Override
    public Object getToType() {
        return Boolean.TYPE;
    }
}

