/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.quickaccess.providers;

import java.util.Objects;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.actions.NewWizardShortcutAction;
import org.eclipse.ui.quickaccess.QuickAccessElement;
import org.eclipse.ui.wizards.IWizardDescriptor;

public class WizardElement
extends QuickAccessElement {
    private final IWizardDescriptor wizardDescriptor;

    WizardElement(IWizardDescriptor wizardDescriptor) {
        this.wizardDescriptor = wizardDescriptor;
    }

    @Override
    public void execute() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            NewWizardShortcutAction wizardAction = new NewWizardShortcutAction(window, this.wizardDescriptor);
            wizardAction.run();
        }
    }

    @Override
    public String getId() {
        return this.wizardDescriptor.getId();
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return this.wizardDescriptor.getImageDescriptor();
    }

    @Override
    public String getLabel() {
        return this.wizardDescriptor.getLabel() + " - " + this.wizardDescriptor.getDescription();
    }

    public int hashCode() {
        return Objects.hashCode(this.wizardDescriptor);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WizardElement other = (WizardElement)obj;
        return Objects.equals(this.wizardDescriptor, other.wizardDescriptor);
    }
}

