/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.descriptor.basic.MPartDescriptor;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.views.IViewDescriptor;
import org.eclipse.ui.views.IViewRegistry;

public class ViewContentProvider
implements ITreeContentProvider {
    private final Map<Object, Object[]> childMap = new HashMap<Object, Object[]>();
    private MApplication application;
    private final IViewRegistry viewRegistry;

    public ViewContentProvider(MApplication application) {
        this.application = application;
        this.viewRegistry = WorkbenchPlugin.getDefault().getViewRegistry();
    }

    public void dispose() {
        this.childMap.clear();
    }

    public Object getParent(Object element) {
        return null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.childMap.clear();
        this.application = (MApplication)newInput;
    }

    public Object[] getElements(Object element) {
        return this.getChildren(element);
    }

    public boolean hasChildren(Object element) {
        if (element instanceof MApplication) {
            return true;
        }
        return element instanceof String;
    }

    public Object[] getChildren(Object element) {
        Object[] children = this.childMap.get(element);
        if (children == null) {
            children = this.createChildren(element);
            this.childMap.put(element, children);
        }
        return children;
    }

    private Object[] createChildren(Object element) {
        if (element instanceof MApplication) {
            return this.determineTopLevelElements(element).toArray();
        }
        if (element instanceof String) {
            return this.determineViewsInCategory((String)element).toArray();
        }
        return new Object[0];
    }

    private Set<MPartDescriptor> determineViewsInCategory(String categoryDescription) {
        List descriptors = this.application.getDescriptors();
        HashSet<MPartDescriptor> categoryDescriptors = new HashSet<MPartDescriptor>();
        for (MPartDescriptor descriptor : descriptors) {
            String category;
            if (this.isFilteredByActivity(descriptor) || !categoryDescription.equals(category = descriptor.getCategory())) continue;
            categoryDescriptors.add(descriptor);
        }
        return categoryDescriptors;
    }

    private Set<Object> determineTopLevelElements(Object element) {
        List descriptors = ((MApplication)element).getDescriptors();
        HashSet<String> categories = new HashSet<String>();
        HashSet<MPartDescriptor> visibleViews = new HashSet<MPartDescriptor>();
        for (MPartDescriptor descriptor : descriptors) {
            if (!this.isView(descriptor) || this.isFilteredByActivity(descriptor)) continue;
            String category = descriptor.getCategory();
            if (category == null) {
                visibleViews.add(descriptor);
                continue;
            }
            categories.add(category);
        }
        HashSet<Object> combinedTopElements = new HashSet<Object>();
        combinedTopElements.addAll(categories);
        combinedTopElements.addAll(visibleViews);
        return combinedTopElements;
    }

    private boolean isView(MPartDescriptor descriptor) {
        return descriptor.getTags().contains("View");
    }

    private boolean isFilteredByActivity(MPartDescriptor descriptor) {
        IContributionFactory contributionFactory;
        IViewDescriptor view = this.viewRegistry.find(descriptor.getElementId());
        boolean isFiltered = view == null || WorkbenchActivityHelper.filterItem(view);
        boolean isE3View = "bundleclass://org.eclipse.ui.workbench/org.eclipse.ui.internal.e4.compatibility.CompatibilityView".equals(descriptor.getContributionURI());
        if (isE3View) {
            return isFiltered;
        }
        if (view == null && (contributionFactory = (IContributionFactory)this.application.getContext().get(IContributionFactory.class)) != null) {
            String uriToCheck = descriptor.getContributionURI();
            if (uriToCheck == null) {
                uriToCheck = descriptor.getContributorURI();
            }
            return !contributionFactory.isEnabled(uriToCheck);
        }
        return false;
    }
}

