/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.dialog;

import org.eclipse.nebula.widgets.opal.commons.SWTGraphicUtil;
import org.eclipse.nebula.widgets.opal.dialog.Dialog;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;

abstract class DialogArea {
    private static final String MORE_DETAILS_IMAGE = "moreDetails.png";
    private static final String FEWER_DETAILS_IMAGE = "fewerDetails.png";
    private static final String WINDOWS_DEFAULT_FONT = "Segoe UI";
    private static final String MAC_OS_DEFAULT_FONT = "Lucida Grande";
    protected final Dialog parent;
    private boolean initialised;

    public DialogArea(Dialog parent) {
        this.parent = parent;
    }

    abstract void render();

    boolean isInitialised() {
        return this.initialised;
    }

    void setInitialised(boolean initialised) {
        this.initialised = initialised;
    }

    protected Font getNormalFont() {
        if (SWTGraphicUtil.isMacOS()) {
            return this.getFont(MAC_OS_DEFAULT_FONT, 11, 0);
        }
        return this.getFont(WINDOWS_DEFAULT_FONT, 9, 0);
    }

    protected Font getBiggerFont() {
        if (SWTGraphicUtil.isMacOS()) {
            return this.getFont(MAC_OS_DEFAULT_FONT, 13, 0);
        }
        return this.getFont(WINDOWS_DEFAULT_FONT, 11, 0);
    }

    private Font getFont(String name, int size, int style) {
        Font font = new Font((Device)Display.getCurrent(), name, size, style);
        this.parent.shell.addDisposeListener(e -> SWTGraphicUtil.safeDispose((Resource)font));
        return font;
    }

    protected Color getTitleColor() {
        Color color = new Color((Device)Display.getCurrent(), 35, 107, 178);
        SWTGraphicUtil.addDisposer((Widget)this.parent.shell, (Resource[])new Resource[]{color});
        return color;
    }

    protected Color getGreyColor() {
        Color color = new Color((Device)Display.getCurrent(), 240, 240, 240);
        SWTGraphicUtil.addDisposer((Widget)this.parent.shell, (Resource[])new Resource[]{color});
        return color;
    }

    protected Image getFewerDetailsImage() {
        return this.loadImage("images/fewerDetails.png");
    }

    protected Image getMoreDetailsImage() {
        return this.loadImage("images/moreDetails.png");
    }

    private Image loadImage(String fileName) {
        Image image = SWTGraphicUtil.createImageFromFile((String)fileName);
        SWTGraphicUtil.addDisposer((Widget)this.parent.shell, (Resource[])new Resource[]{image});
        return image;
    }
}

