/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.timeline.jface;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IToolTipProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.nebula.widgets.timeline.ICursor;
import org.eclipse.nebula.widgets.timeline.ITimelineEvent;
import org.eclipse.nebula.widgets.timeline.ITimelineFactory;
import org.eclipse.nebula.widgets.timeline.TimeBaseConverter;
import org.eclipse.nebula.widgets.timeline.TimelineComposite;
import org.eclipse.nebula.widgets.timeline.Timing;
import org.eclipse.nebula.widgets.timeline.figures.RootFigure;
import org.eclipse.nebula.widgets.timeline.figures.detail.cursor.CursorFigure;
import org.eclipse.nebula.widgets.timeline.figures.detail.cursor.CursorLayer;
import org.eclipse.nebula.widgets.timeline.figures.detail.track.TrackFigure;
import org.eclipse.nebula.widgets.timeline.figures.detail.track.TracksLayer;
import org.eclipse.nebula.widgets.timeline.figures.detail.track.lane.EventFigure;
import org.eclipse.nebula.widgets.timeline.figures.detail.track.lane.LaneFigure;
import org.eclipse.nebula.widgets.timeline.figures.overview.OverviewCursorLayer;
import org.eclipse.nebula.widgets.timeline.jface.DefaultTimelineContentProvider;
import org.eclipse.nebula.widgets.timeline.jface.DefaultTimelineLabelProvider;
import org.eclipse.nebula.widgets.timeline.jface.ITimelineContentProvider;
import org.eclipse.nebula.widgets.timeline.jface.ITimelineLabelProvider;
import org.eclipse.nebula.widgets.timeline.jface.ITimelineStyleProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;

public class TimelineViewer
extends StructuredViewer {
    private final TimelineComposite fControl;
    private final ModelMap fElementToFigureMap = new ModelMap();

    private static String toColorCode(Color color) {
        RGB rgb = color.getRGB();
        return "#" + TimelineViewer.toHexValue(rgb.red) + TimelineViewer.toHexValue(rgb.green) + TimelineViewer.toHexValue(rgb.blue);
    }

    private static String toHexValue(int value) {
        String result = Integer.toString(value, 16);
        return result.length() == 2 ? result : "0" + result;
    }

    public TimelineViewer(Composite parent, int flags) {
        this.fControl = new TimelineComposite(parent, flags);
        this.setContentProvider((IContentProvider)new DefaultTimelineContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new DefaultTimelineLabelProvider(this.fControl.getRootFigure().getResourceManager()));
        this.setInput(ITimelineFactory.eINSTANCE.createTimeline());
    }

    public TimelineViewer(Composite parent) {
        this(parent, 0);
    }

    public void setStyleProvider(ITimelineStyleProvider styleProvider) {
        this.getControl().getRootFigure().setStyleProvider(styleProvider);
    }

    public ITimelineStyleProvider getStyleProvider() {
        return this.getControl().getRootFigure().getStyleProvider();
    }

    protected void inputChanged(Object input, Object oldInput) {
        this.fElementToFigureMap.clear();
        this.registerFigure(input, (IFigure)this.getControl().getRootFigure());
        ITimelineContentProvider contentProvider = this.getContentProvider();
        if (contentProvider != null) {
            contentProvider.inputChanged((Viewer)this, oldInput, input);
        }
        super.inputChanged(input, oldInput);
    }

    public void setContentProvider(IContentProvider provider) {
        if (!(provider instanceof ITimelineContentProvider)) {
            throw new IllegalArgumentException("Content provider needs to implement ITimelineContentProvider");
        }
        super.setContentProvider(provider);
    }

    public ITimelineContentProvider getContentProvider() {
        return (ITimelineContentProvider)super.getContentProvider();
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        if (!(labelProvider instanceof ITimelineLabelProvider)) {
            throw new IllegalArgumentException("Label provider needs to implement ITimelineLabelProvider");
        }
        super.setLabelProvider(labelProvider);
    }

    public ITimelineLabelProvider getLabelProvider() {
        return (ITimelineLabelProvider)super.getLabelProvider();
    }

    protected Widget doFindInputItem(Object element) {
        return null;
    }

    protected Widget doFindItem(Object element) {
        return null;
    }

    private boolean isRootElement(Object element) {
        return this.getInput().equals(element);
    }

    private boolean isTrackElement(Object element) {
        return this.getTrackElements().contains(element);
    }

    private boolean isLaneElement(Object element) {
        return this.getLaneElements().contains(element);
    }

    private boolean isEventElement(Object element) {
        return this.geEventElements().contains(element);
    }

    private boolean isCursorElement(Object element) {
        return this.getCursorElements().contains(element);
    }

    private Collection<Object> getCursorElements() {
        return Arrays.asList(this.getContentProvider().getCursors(this.getInput()));
    }

    private Collection<Object> getTrackElements() {
        return Arrays.asList(this.getContentProvider().getTracks(this.getInput()));
    }

    private Collection<Object> getLaneElements() {
        HashSet<Object> lanes = new HashSet<Object>();
        for (Object track : this.getTrackElements()) {
            lanes.addAll(Arrays.asList(this.getContentProvider().getLanes(track)));
        }
        return lanes;
    }

    private Collection<Object> geEventElements() {
        HashSet<Object> events = new HashSet<Object>();
        for (Object track : this.getLaneElements()) {
            events.addAll(Arrays.asList(this.getContentProvider().getEvents(track)));
        }
        return events;
    }

    public void update(Object element, String[] properties) {
        IFigure figure = (IFigure)this.fElementToFigureMap.get(element);
        if (figure != null) {
            if (this.isCursorElement(element)) {
                this.getControl().getRootFigure().updateCursorFigure(figure, this.toCursor(element));
            } else if (this.isTrackElement(element)) {
                this.getControl().getRootFigure().updateTrackFigure(figure, this.getLabelProvider().getText(element));
            } else if (this.isEventElement(element)) {
                this.getControl().getRootFigure().updateEventFigure(figure, this.toEvent(element));
            } else if (this.isLaneElement(element) && this.getLabelProvider() instanceof IColorProvider) {
                Color foreground = ((IColorProvider)this.getLabelProvider()).getForeground(element);
                if (foreground == null) {
                    foreground = this.getStyleProvider().getLaneColor();
                }
                figure.setForegroundColor(foreground);
                this.internalRefresh(element);
            }
        }
    }

    private ICursor toCursor(Object element) {
        if (element instanceof ICursor) {
            return (ICursor)element;
        }
        Timing timings = this.getLabelProvider().getTimings(element);
        if (timings != null) {
            ICursor cursor = ITimelineFactory.eINSTANCE.createCursor();
            cursor.setTimestamp((long)timings.getTimestamp());
            return cursor;
        }
        return null;
    }

    private ITimelineEvent toEvent(Object element) {
        if (element instanceof ITimelineEvent) {
            return (ITimelineEvent)element;
        }
        Timing timings = this.getLabelProvider().getTimings(element);
        if (timings != null) {
            Color color;
            ITimelineEvent event = ITimelineFactory.eINSTANCE.createTimelineEvent();
            event.setStartTimestamp((long)timings.getTimestamp());
            event.setDuration((long)timings.getDuration());
            ITimelineLabelProvider labelProvider = this.getLabelProvider();
            event.setTitle(labelProvider.getText(element));
            if (labelProvider instanceof IToolTipProvider) {
                event.setMessage(((IToolTipProvider)labelProvider).getToolTipText(element));
            }
            if (labelProvider instanceof IColorProvider && (color = ((IColorProvider)labelProvider).getForeground(element)) != null) {
                event.setColorCode(TimelineViewer.toColorCode(color));
            }
            return event;
        }
        return null;
    }

    protected void internalRefresh(Object element) {
        IFigure figure = (IFigure)this.fElementToFigureMap.get(element);
        if (figure != null) {
            if (figure instanceof RootFigure) {
                this.unregisterModelElements(new HashSet(this.fElementToFigureMap.keySet()));
                this.registerFigure(this.getInput(), (IFigure)this.getControl().getRootFigure());
                ((RootFigure)figure).clear();
                RootFigure.getTimeViewDetails(figure).resetEventArea();
                TracksLayer tracksLayer = RootFigure.getFigure(figure, TracksLayer.class);
                Object[] objectArray = this.getContentProvider().getTracks(this.getInput());
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object track = objectArray[n2];
                    TrackFigure trackFigure = ((RootFigure)figure).createTrackFigure(this.getLabelProvider().getText(track));
                    this.registerFigure(track, (IFigure)trackFigure);
                    this.internalRefresh(track);
                    ++n2;
                }
                objectArray = this.getContentProvider().getCursors(this.getInput());
                n = objectArray.length;
                n2 = 0;
                while (n2 < n) {
                    Object cursorElement = objectArray[n2];
                    CursorFigure cursorFigure = ((RootFigure)figure).createCursorFigure(this.toCursor(cursorElement));
                    this.registerFigure(cursorElement, (IFigure)cursorFigure);
                    ++n2;
                }
            } else if (figure instanceof TrackFigure) {
                this.unregisterFigures(figure.getChildren());
                ((TrackFigure)figure).removeAll();
                Object track = this.getModelElementFor(figure);
                Object[] objectArray = this.getContentProvider().getLanes(track);
                int n = objectArray.length;
                int n3 = 0;
                while (n3 < n) {
                    Object lane = objectArray[n3];
                    LaneFigure laneFigure = this.getControl().getRootFigure().createLaneFigure((TrackFigure)figure);
                    figure.add((IFigure)laneFigure);
                    this.fElementToFigureMap.put(lane, (IFigure)laneFigure);
                    this.internalRefresh(lane);
                    ++n3;
                }
            } else if (figure instanceof LaneFigure) {
                this.unregisterFigures(figure.getChildren());
                for (EventFigure eventFigure : ((LaneFigure)figure).getEventFigures()) {
                    this.getControl().getRootFigure().deleteEventFigure(eventFigure);
                }
                Object lane = this.getModelElementFor(figure);
                Object[] objectArray = this.getContentProvider().getEvents(lane);
                int n = objectArray.length;
                int n4 = 0;
                while (n4 < n) {
                    Object event = objectArray[n4];
                    EventFigure eventFigure = this.getControl().getRootFigure().createEventFigure((LaneFigure)figure, this.toEvent(event));
                    this.fElementToFigureMap.put(event, (IFigure)eventFigure);
                    ++n4;
                }
            } else if (figure instanceof CursorFigure) {
                if (!Arrays.asList(this.getContentProvider().getCursors(this.getInput())).contains(element)) {
                    RootFigure.getFigure(figure, CursorLayer.class).remove(figure);
                    this.unregisterModelElement(element);
                }
                RootFigure rootFigure = RootFigure.getRootFigure(figure);
                RootFigure.getFigure((IFigure)rootFigure, CursorLayer.class).revalidate();
                RootFigure.getFigure((IFigure)rootFigure, OverviewCursorLayer.class).revalidate();
            }
        } else if (Arrays.asList(this.getContentProvider().getCursors(this.getInput())).contains(element)) {
            CursorFigure cursorFigure = this.getControl().getRootFigure().createCursorFigure(this.toCursor(element));
            this.registerFigure(element, (IFigure)cursorFigure);
        }
    }

    private Object getModelElementFor(IFigure figure) {
        return this.fElementToFigureMap.getKey(figure);
    }

    private void unregisterModelElements(Collection<?> modelElements) {
        for (Object element : modelElements) {
            this.unregisterModelElement(element);
        }
    }

    private void unregisterModelElement(Object modelElement) {
        this.fElementToFigureMap.remove(modelElement);
    }

    private void unregisterFigures(Collection<?> figures) {
        for (Object element : figures) {
            this.fElementToFigureMap.removeValue(element);
        }
    }

    private void registerFigure(Object modelElement, IFigure figure) {
        this.fElementToFigureMap.put(modelElement, figure);
    }

    public void createCursor(ICursor cursor) {
        this.getControl().getRootFigure().createCursorFigure(cursor);
    }

    public void deleteCursor(ICursor cursor) {
        this.getControl().getRootFigure().deleteCursor(cursor);
    }

    public void reveal(Object element) {
        if ((element = this.toEvent(element)) == null) {
            element = this.toCursor(element);
        }
        if (element instanceof ITimelineEvent) {
            TimeBaseConverter timeViewDetails = RootFigure.getTimeViewDetails((IFigure)this.getControl().getRootFigure());
            timeViewDetails.revealEvent(new Timing(((ITimelineEvent)element).getStartTimestamp(), ((ITimelineEvent)element).getDuration()));
        } else if (element instanceof ICursor) {
            TimeBaseConverter timeViewDetails = RootFigure.getTimeViewDetails((IFigure)this.getControl().getRootFigure());
            timeViewDetails.revealEvent(new Timing(((ICursor)element).getTimestamp(), 0.0));
        }
    }

    protected List<Object> getSelectionFromWidget() {
        Object modelElement;
        EventFigure selectedFigure = this.getControl().getRootFigure().getSelection();
        if (selectedFigure != null && (modelElement = this.fElementToFigureMap.getKey((IFigure)selectedFigure)) != null) {
            return Arrays.asList(modelElement);
        }
        return Collections.emptyList();
    }

    protected void setSelectionToWidget(List l, boolean reveal) {
        if (!l.isEmpty()) {
            IFigure eventFigure;
            ITimelineEvent event = this.toEvent(l.get(0));
            if (event != null && (eventFigure = (IFigure)this.fElementToFigureMap.get(event)) instanceof EventFigure) {
                this.getControl().getRootFigure().setSelection((EventFigure)eventFigure);
            }
        } else {
            this.getControl().getRootFigure().setSelection(null);
        }
    }

    public TimelineComposite getControl() {
        return this.fControl;
    }

    protected void doUpdateItem(Widget item, Object element, boolean fullMap) {
    }

    private class ModelMap
    extends HashMap<Object, IFigure> {
        private static final long serialVersionUID = 6568720330224087046L;
        private final Map<IFigure, Object> fReverseMap = new HashMap<IFigure, Object>();

        private ModelMap() {
        }

        @Override
        public IFigure put(Object key, IFigure value) {
            this.fReverseMap.put(value, key);
            return super.put(key, value);
        }

        public Object getKey(IFigure value) {
            return this.fReverseMap.get(value);
        }

        @Override
        public IFigure remove(Object key) {
            IFigure value = (IFigure)super.remove(key);
            this.fReverseMap.remove(value);
            return value;
        }

        public IFigure removeValue(Object modelElement) {
            return this.remove(this.fReverseMap.get(modelElement));
        }
    }
}

