/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.timeline.figures.detail.cursor;

import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.nebula.widgets.timeline.ICursor;
import org.eclipse.nebula.widgets.timeline.TimeBaseConverter;
import org.eclipse.nebula.widgets.timeline.Timing;
import org.eclipse.nebula.widgets.timeline.figures.RootFigure;

public class CursorLayer
extends FreeformLayer {
    public CursorLayer() {
        this.setLayoutManager((LayoutManager)new CursorLayout());
    }

    protected boolean useLocalCoordinates() {
        return true;
    }

    private class CursorLayout
    extends XYLayout {
        private CursorLayout() {
        }

        public void layout(IFigure parent) {
            TimeBaseConverter timeViewDetails = RootFigure.getTimeViewDetails(parent);
            for (Object child : CursorLayer.this.getChildren()) {
                ICursor cursor = (ICursor)this.getConstraint((IFigure)child);
                Dimension preferredSize = ((IFigure)child).getPreferredSize();
                Timing screenCoordinates = timeViewDetails.toDetailCoordinates(cursor.getTiming());
                PrecisionRectangle screenBounds = new PrecisionRectangle(screenCoordinates.getTimestamp(), 0.0, (double)preferredSize.width(), (double)CursorLayer.this.getBounds().height());
                screenBounds.translate(-preferredSize.width() / 2, 0);
                ((IFigure)child).setBounds((Rectangle)screenBounds);
            }
        }
    }
}

