/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.oscilloscope;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import org.eclipse.nebula.widgets.oscilloscope.Oscilloscope;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public abstract class OscilloscopeDispatcher {
    private final PlayClip clipper = new PlayClip();
    public static final int[] BACKGROUND_MONITOR;
    public static final int[] BACKGROUND_MONITOR_SMALL;
    public static final int NO_PULSE = 0;
    private Image image;

    static {
        int[] nArray = new int[398];
        nArray[0] = 255;
        nArray[1] = 216;
        nArray[2] = 255;
        nArray[3] = 224;
        nArray[5] = 16;
        nArray[6] = 74;
        nArray[7] = 70;
        nArray[8] = 73;
        nArray[9] = 70;
        nArray[11] = 1;
        nArray[12] = 1;
        nArray[13] = 1;
        nArray[15] = 72;
        nArray[17] = 72;
        nArray[20] = 255;
        nArray[21] = 254;
        nArray[23] = 19;
        nArray[24] = 67;
        nArray[25] = 114;
        nArray[26] = 101;
        nArray[27] = 97;
        nArray[28] = 116;
        nArray[29] = 101;
        nArray[30] = 100;
        nArray[31] = 32;
        nArray[32] = 119;
        nArray[33] = 105;
        nArray[34] = 116;
        nArray[35] = 104;
        nArray[36] = 32;
        nArray[37] = 71;
        nArray[38] = 73;
        nArray[39] = 77;
        nArray[40] = 80;
        nArray[41] = 255;
        nArray[42] = 219;
        nArray[44] = 67;
        nArray[46] = 5;
        nArray[47] = 3;
        nArray[48] = 4;
        nArray[49] = 4;
        nArray[50] = 4;
        nArray[51] = 3;
        nArray[52] = 5;
        nArray[53] = 4;
        nArray[54] = 4;
        nArray[55] = 4;
        nArray[56] = 5;
        nArray[57] = 5;
        nArray[58] = 5;
        nArray[59] = 6;
        nArray[60] = 7;
        nArray[61] = 12;
        nArray[62] = 8;
        nArray[63] = 7;
        nArray[64] = 7;
        nArray[65] = 7;
        nArray[66] = 7;
        nArray[67] = 15;
        nArray[68] = 11;
        nArray[69] = 11;
        nArray[70] = 9;
        nArray[71] = 12;
        nArray[72] = 17;
        nArray[73] = 15;
        nArray[74] = 18;
        nArray[75] = 18;
        nArray[76] = 17;
        nArray[77] = 15;
        nArray[78] = 17;
        nArray[79] = 17;
        nArray[80] = 19;
        nArray[81] = 22;
        nArray[82] = 28;
        nArray[83] = 23;
        nArray[84] = 19;
        nArray[85] = 20;
        nArray[86] = 26;
        nArray[87] = 21;
        nArray[88] = 17;
        nArray[89] = 17;
        nArray[90] = 24;
        nArray[91] = 33;
        nArray[92] = 24;
        nArray[93] = 26;
        nArray[94] = 29;
        nArray[95] = 29;
        nArray[96] = 31;
        nArray[97] = 31;
        nArray[98] = 31;
        nArray[99] = 19;
        nArray[100] = 23;
        nArray[101] = 34;
        nArray[102] = 36;
        nArray[103] = 34;
        nArray[104] = 30;
        nArray[105] = 36;
        nArray[106] = 28;
        nArray[107] = 30;
        nArray[108] = 31;
        nArray[109] = 30;
        nArray[110] = 255;
        nArray[111] = 219;
        nArray[113] = 67;
        nArray[114] = 1;
        nArray[115] = 5;
        nArray[116] = 5;
        nArray[117] = 5;
        nArray[118] = 7;
        nArray[119] = 6;
        nArray[120] = 7;
        nArray[121] = 14;
        nArray[122] = 8;
        nArray[123] = 8;
        nArray[124] = 14;
        nArray[125] = 30;
        nArray[126] = 20;
        nArray[127] = 17;
        nArray[128] = 20;
        nArray[129] = 30;
        nArray[130] = 30;
        nArray[131] = 30;
        nArray[132] = 30;
        nArray[133] = 30;
        nArray[134] = 30;
        nArray[135] = 30;
        nArray[136] = 30;
        nArray[137] = 30;
        nArray[138] = 30;
        nArray[139] = 30;
        nArray[140] = 30;
        nArray[141] = 30;
        nArray[142] = 30;
        nArray[143] = 30;
        nArray[144] = 30;
        nArray[145] = 30;
        nArray[146] = 30;
        nArray[147] = 30;
        nArray[148] = 30;
        nArray[149] = 30;
        nArray[150] = 30;
        nArray[151] = 30;
        nArray[152] = 30;
        nArray[153] = 30;
        nArray[154] = 30;
        nArray[155] = 30;
        nArray[156] = 30;
        nArray[157] = 30;
        nArray[158] = 30;
        nArray[159] = 30;
        nArray[160] = 30;
        nArray[161] = 30;
        nArray[162] = 30;
        nArray[163] = 30;
        nArray[164] = 30;
        nArray[165] = 30;
        nArray[166] = 30;
        nArray[167] = 30;
        nArray[168] = 30;
        nArray[169] = 30;
        nArray[170] = 30;
        nArray[171] = 30;
        nArray[172] = 30;
        nArray[173] = 30;
        nArray[174] = 30;
        nArray[175] = 30;
        nArray[176] = 30;
        nArray[177] = 30;
        nArray[178] = 30;
        nArray[179] = 255;
        nArray[180] = 192;
        nArray[182] = 17;
        nArray[183] = 8;
        nArray[185] = 20;
        nArray[187] = 20;
        nArray[188] = 3;
        nArray[189] = 1;
        nArray[190] = 34;
        nArray[192] = 2;
        nArray[193] = 17;
        nArray[194] = 1;
        nArray[195] = 3;
        nArray[196] = 17;
        nArray[197] = 1;
        nArray[198] = 255;
        nArray[199] = 196;
        nArray[201] = 23;
        nArray[203] = 1;
        nArray[204] = 1;
        nArray[205] = 1;
        nArray[206] = 1;
        nArray[220] = 4;
        nArray[221] = 5;
        nArray[222] = 7;
        nArray[223] = 255;
        nArray[224] = 196;
        nArray[226] = 34;
        nArray[227] = 16;
        nArray[229] = 2;
        nArray[230] = 2;
        nArray[232] = 5;
        nArray[233] = 5;
        nArray[234] = 1;
        nArray[245] = 1;
        nArray[246] = 3;
        nArray[247] = 4;
        nArray[248] = 2;
        nArray[249] = 20;
        nArray[250] = 33;
        nArray[251] = 52;
        nArray[252] = 84;
        nArray[253] = 17;
        nArray[254] = 115;
        nArray[255] = 145;
        nArray[256] = 178;
        nArray[257] = 209;
        nArray[258] = 97;
        nArray[259] = 255;
        nArray[260] = 196;
        nArray[262] = 23;
        nArray[263] = 1;
        nArray[264] = 1;
        nArray[265] = 1;
        nArray[266] = 1;
        nArray[267] = 1;
        nArray[280] = 2;
        nArray[282] = 1;
        nArray[283] = 3;
        nArray[284] = 255;
        nArray[285] = 196;
        nArray[287] = 27;
        nArray[288] = 17;
        nArray[290] = 2;
        nArray[291] = 2;
        nArray[292] = 3;
        nArray[293] = 1;
        nArray[306] = 1;
        nArray[307] = 2;
        nArray[308] = 17;
        nArray[309] = 33;
        nArray[310] = 49;
        nArray[311] = 81;
        nArray[312] = 18;
        nArray[313] = 255;
        nArray[314] = 218;
        nArray[316] = 12;
        nArray[317] = 3;
        nArray[318] = 1;
        nArray[320] = 2;
        nArray[321] = 17;
        nArray[322] = 3;
        nArray[323] = 17;
        nArray[325] = 63;
        nArray[327] = 225;
        nArray[328] = 37;
        nArray[329] = 87;
        nArray[330] = 118;
        nArray[331] = 245;
        nArray[332] = 59;
        nArray[333] = 79;
        nArray[334] = 217;
        nArray[335] = 140;
        nArray[336] = 212;
        nArray[337] = 60;
        nArray[338] = 24;
        nArray[339] = 60;
        nArray[340] = 226;
        nArray[341] = 250;
        nArray[342] = 83;
        nArray[343] = 110;
        nArray[344] = 196;
        nArray[345] = 74;
        nArray[346] = 10;
        nArray[347] = 205;
        nArray[348] = 211;
        nArray[349] = 133;
        nArray[350] = 245;
        nArray[351] = 141;
        nArray[352] = 180;
        nArray[353] = 155;
        nArray[354] = 122;
        nArray[355] = 106;
        nArray[356] = 255;
        nArray[358] = 78;
        nArray[359] = 77;
        nArray[360] = 187;
        nArray[361] = 88;
        nArray[362] = 4;
        nArray[363] = 164;
        nArray[364] = 237;
        nArray[365] = 96;
        nArray[366] = 204;
        nArray[367] = 5;
        nArray[368] = 89;
        nArray[369] = 168;
        nArray[370] = 120;
        nArray[371] = 48;
        nArray[372] = 121;
        nArray[373] = 197;
        nArray[374] = 244;
        nArray[375] = 10;
        nArray[376] = 223;
        nArray[377] = 5;
        nArray[378] = 233;
        nArray[379] = 240;
        nArray[380] = 148;
        nArray[381] = 170;
        nArray[382] = 238;
        nArray[383] = 222;
        nArray[384] = 167;
        nArray[385] = 105;
        nArray[386] = 251;
        nArray[387] = 48;
        nArray[388] = 9;
        nArray[389] = 237;
        nArray[390] = 20;
        nArray[391] = 182;
        nArray[392] = 137;
        nArray[393] = 64;
        nArray[394] = 6;
        nArray[395] = 140;
        nArray[396] = 255;
        nArray[397] = 217;
        BACKGROUND_MONITOR = nArray;
        int[] nArray2 = new int[710];
        nArray2[0] = 255;
        nArray2[1] = 216;
        nArray2[2] = 255;
        nArray2[3] = 224;
        nArray2[5] = 16;
        nArray2[6] = 74;
        nArray2[7] = 70;
        nArray2[8] = 73;
        nArray2[9] = 70;
        nArray2[11] = 1;
        nArray2[12] = 1;
        nArray2[13] = 1;
        nArray2[15] = 72;
        nArray2[17] = 72;
        nArray2[20] = 255;
        nArray2[21] = 254;
        nArray2[23] = 20;
        nArray2[24] = 67;
        nArray2[25] = 114;
        nArray2[26] = 101;
        nArray2[27] = 97;
        nArray2[28] = 116;
        nArray2[29] = 101;
        nArray2[30] = 100;
        nArray2[31] = 32;
        nArray2[32] = 119;
        nArray2[33] = 105;
        nArray2[34] = 116;
        nArray2[35] = 104;
        nArray2[36] = 32;
        nArray2[37] = 71;
        nArray2[38] = 73;
        nArray2[39] = 77;
        nArray2[40] = 80;
        nArray2[42] = 255;
        nArray2[43] = 219;
        nArray2[45] = 67;
        nArray2[47] = 2;
        nArray2[48] = 1;
        nArray2[49] = 1;
        nArray2[50] = 2;
        nArray2[51] = 1;
        nArray2[52] = 1;
        nArray2[53] = 2;
        nArray2[54] = 2;
        nArray2[55] = 2;
        nArray2[56] = 2;
        nArray2[57] = 2;
        nArray2[58] = 2;
        nArray2[59] = 2;
        nArray2[60] = 2;
        nArray2[61] = 3;
        nArray2[62] = 5;
        nArray2[63] = 3;
        nArray2[64] = 3;
        nArray2[65] = 3;
        nArray2[66] = 3;
        nArray2[67] = 3;
        nArray2[68] = 6;
        nArray2[69] = 4;
        nArray2[70] = 4;
        nArray2[71] = 3;
        nArray2[72] = 5;
        nArray2[73] = 7;
        nArray2[74] = 6;
        nArray2[75] = 7;
        nArray2[76] = 7;
        nArray2[77] = 7;
        nArray2[78] = 6;
        nArray2[79] = 7;
        nArray2[80] = 7;
        nArray2[81] = 8;
        nArray2[82] = 9;
        nArray2[83] = 11;
        nArray2[84] = 9;
        nArray2[85] = 8;
        nArray2[86] = 8;
        nArray2[87] = 10;
        nArray2[88] = 8;
        nArray2[89] = 7;
        nArray2[90] = 7;
        nArray2[91] = 10;
        nArray2[92] = 13;
        nArray2[93] = 10;
        nArray2[94] = 10;
        nArray2[95] = 11;
        nArray2[96] = 12;
        nArray2[97] = 12;
        nArray2[98] = 12;
        nArray2[99] = 12;
        nArray2[100] = 7;
        nArray2[101] = 9;
        nArray2[102] = 14;
        nArray2[103] = 15;
        nArray2[104] = 13;
        nArray2[105] = 12;
        nArray2[106] = 14;
        nArray2[107] = 11;
        nArray2[108] = 12;
        nArray2[109] = 12;
        nArray2[110] = 12;
        nArray2[111] = 255;
        nArray2[112] = 219;
        nArray2[114] = 67;
        nArray2[115] = 1;
        nArray2[116] = 2;
        nArray2[117] = 2;
        nArray2[118] = 2;
        nArray2[119] = 3;
        nArray2[120] = 3;
        nArray2[121] = 3;
        nArray2[122] = 6;
        nArray2[123] = 3;
        nArray2[124] = 3;
        nArray2[125] = 6;
        nArray2[126] = 12;
        nArray2[127] = 8;
        nArray2[128] = 7;
        nArray2[129] = 8;
        nArray2[130] = 12;
        nArray2[131] = 12;
        nArray2[132] = 12;
        nArray2[133] = 12;
        nArray2[134] = 12;
        nArray2[135] = 12;
        nArray2[136] = 12;
        nArray2[137] = 12;
        nArray2[138] = 12;
        nArray2[139] = 12;
        nArray2[140] = 12;
        nArray2[141] = 12;
        nArray2[142] = 12;
        nArray2[143] = 12;
        nArray2[144] = 12;
        nArray2[145] = 12;
        nArray2[146] = 12;
        nArray2[147] = 12;
        nArray2[148] = 12;
        nArray2[149] = 12;
        nArray2[150] = 12;
        nArray2[151] = 12;
        nArray2[152] = 12;
        nArray2[153] = 12;
        nArray2[154] = 12;
        nArray2[155] = 12;
        nArray2[156] = 12;
        nArray2[157] = 12;
        nArray2[158] = 12;
        nArray2[159] = 12;
        nArray2[160] = 12;
        nArray2[161] = 12;
        nArray2[162] = 12;
        nArray2[163] = 12;
        nArray2[164] = 12;
        nArray2[165] = 12;
        nArray2[166] = 12;
        nArray2[167] = 12;
        nArray2[168] = 12;
        nArray2[169] = 12;
        nArray2[170] = 12;
        nArray2[171] = 12;
        nArray2[172] = 12;
        nArray2[173] = 12;
        nArray2[174] = 12;
        nArray2[175] = 12;
        nArray2[176] = 12;
        nArray2[177] = 12;
        nArray2[178] = 12;
        nArray2[179] = 12;
        nArray2[180] = 255;
        nArray2[181] = 192;
        nArray2[183] = 17;
        nArray2[184] = 8;
        nArray2[186] = 10;
        nArray2[188] = 10;
        nArray2[189] = 3;
        nArray2[190] = 1;
        nArray2[191] = 34;
        nArray2[193] = 2;
        nArray2[194] = 17;
        nArray2[195] = 1;
        nArray2[196] = 3;
        nArray2[197] = 17;
        nArray2[198] = 1;
        nArray2[199] = 255;
        nArray2[200] = 196;
        nArray2[202] = 31;
        nArray2[205] = 1;
        nArray2[206] = 5;
        nArray2[207] = 1;
        nArray2[208] = 1;
        nArray2[209] = 1;
        nArray2[210] = 1;
        nArray2[211] = 1;
        nArray2[212] = 1;
        nArray2[221] = 1;
        nArray2[222] = 2;
        nArray2[223] = 3;
        nArray2[224] = 4;
        nArray2[225] = 5;
        nArray2[226] = 6;
        nArray2[227] = 7;
        nArray2[228] = 8;
        nArray2[229] = 9;
        nArray2[230] = 10;
        nArray2[231] = 11;
        nArray2[232] = 255;
        nArray2[233] = 196;
        nArray2[235] = 181;
        nArray2[236] = 16;
        nArray2[238] = 2;
        nArray2[239] = 1;
        nArray2[240] = 3;
        nArray2[241] = 3;
        nArray2[242] = 2;
        nArray2[243] = 4;
        nArray2[244] = 3;
        nArray2[245] = 5;
        nArray2[246] = 5;
        nArray2[247] = 4;
        nArray2[248] = 4;
        nArray2[251] = 1;
        nArray2[252] = 125;
        nArray2[253] = 1;
        nArray2[254] = 2;
        nArray2[255] = 3;
        nArray2[257] = 4;
        nArray2[258] = 17;
        nArray2[259] = 5;
        nArray2[260] = 18;
        nArray2[261] = 33;
        nArray2[262] = 49;
        nArray2[263] = 65;
        nArray2[264] = 6;
        nArray2[265] = 19;
        nArray2[266] = 81;
        nArray2[267] = 97;
        nArray2[268] = 7;
        nArray2[269] = 34;
        nArray2[270] = 113;
        nArray2[271] = 20;
        nArray2[272] = 50;
        nArray2[273] = 129;
        nArray2[274] = 145;
        nArray2[275] = 161;
        nArray2[276] = 8;
        nArray2[277] = 35;
        nArray2[278] = 66;
        nArray2[279] = 177;
        nArray2[280] = 193;
        nArray2[281] = 21;
        nArray2[282] = 82;
        nArray2[283] = 209;
        nArray2[284] = 240;
        nArray2[285] = 36;
        nArray2[286] = 51;
        nArray2[287] = 98;
        nArray2[288] = 114;
        nArray2[289] = 130;
        nArray2[290] = 9;
        nArray2[291] = 10;
        nArray2[292] = 22;
        nArray2[293] = 23;
        nArray2[294] = 24;
        nArray2[295] = 25;
        nArray2[296] = 26;
        nArray2[297] = 37;
        nArray2[298] = 38;
        nArray2[299] = 39;
        nArray2[300] = 40;
        nArray2[301] = 41;
        nArray2[302] = 42;
        nArray2[303] = 52;
        nArray2[304] = 53;
        nArray2[305] = 54;
        nArray2[306] = 55;
        nArray2[307] = 56;
        nArray2[308] = 57;
        nArray2[309] = 58;
        nArray2[310] = 67;
        nArray2[311] = 68;
        nArray2[312] = 69;
        nArray2[313] = 70;
        nArray2[314] = 71;
        nArray2[315] = 72;
        nArray2[316] = 73;
        nArray2[317] = 74;
        nArray2[318] = 83;
        nArray2[319] = 84;
        nArray2[320] = 85;
        nArray2[321] = 86;
        nArray2[322] = 87;
        nArray2[323] = 88;
        nArray2[324] = 89;
        nArray2[325] = 90;
        nArray2[326] = 99;
        nArray2[327] = 100;
        nArray2[328] = 101;
        nArray2[329] = 102;
        nArray2[330] = 103;
        nArray2[331] = 104;
        nArray2[332] = 105;
        nArray2[333] = 106;
        nArray2[334] = 115;
        nArray2[335] = 116;
        nArray2[336] = 117;
        nArray2[337] = 118;
        nArray2[338] = 119;
        nArray2[339] = 120;
        nArray2[340] = 121;
        nArray2[341] = 122;
        nArray2[342] = 131;
        nArray2[343] = 132;
        nArray2[344] = 133;
        nArray2[345] = 134;
        nArray2[346] = 135;
        nArray2[347] = 136;
        nArray2[348] = 137;
        nArray2[349] = 138;
        nArray2[350] = 146;
        nArray2[351] = 147;
        nArray2[352] = 148;
        nArray2[353] = 149;
        nArray2[354] = 150;
        nArray2[355] = 151;
        nArray2[356] = 152;
        nArray2[357] = 153;
        nArray2[358] = 154;
        nArray2[359] = 162;
        nArray2[360] = 163;
        nArray2[361] = 164;
        nArray2[362] = 165;
        nArray2[363] = 166;
        nArray2[364] = 167;
        nArray2[365] = 168;
        nArray2[366] = 169;
        nArray2[367] = 170;
        nArray2[368] = 178;
        nArray2[369] = 179;
        nArray2[370] = 180;
        nArray2[371] = 181;
        nArray2[372] = 182;
        nArray2[373] = 183;
        nArray2[374] = 184;
        nArray2[375] = 185;
        nArray2[376] = 186;
        nArray2[377] = 194;
        nArray2[378] = 195;
        nArray2[379] = 196;
        nArray2[380] = 197;
        nArray2[381] = 198;
        nArray2[382] = 199;
        nArray2[383] = 200;
        nArray2[384] = 201;
        nArray2[385] = 202;
        nArray2[386] = 210;
        nArray2[387] = 211;
        nArray2[388] = 212;
        nArray2[389] = 213;
        nArray2[390] = 214;
        nArray2[391] = 215;
        nArray2[392] = 216;
        nArray2[393] = 217;
        nArray2[394] = 218;
        nArray2[395] = 225;
        nArray2[396] = 226;
        nArray2[397] = 227;
        nArray2[398] = 228;
        nArray2[399] = 229;
        nArray2[400] = 230;
        nArray2[401] = 231;
        nArray2[402] = 232;
        nArray2[403] = 233;
        nArray2[404] = 234;
        nArray2[405] = 241;
        nArray2[406] = 242;
        nArray2[407] = 243;
        nArray2[408] = 244;
        nArray2[409] = 245;
        nArray2[410] = 246;
        nArray2[411] = 247;
        nArray2[412] = 248;
        nArray2[413] = 249;
        nArray2[414] = 250;
        nArray2[415] = 255;
        nArray2[416] = 196;
        nArray2[418] = 31;
        nArray2[419] = 1;
        nArray2[421] = 3;
        nArray2[422] = 1;
        nArray2[423] = 1;
        nArray2[424] = 1;
        nArray2[425] = 1;
        nArray2[426] = 1;
        nArray2[427] = 1;
        nArray2[428] = 1;
        nArray2[429] = 1;
        nArray2[430] = 1;
        nArray2[437] = 1;
        nArray2[438] = 2;
        nArray2[439] = 3;
        nArray2[440] = 4;
        nArray2[441] = 5;
        nArray2[442] = 6;
        nArray2[443] = 7;
        nArray2[444] = 8;
        nArray2[445] = 9;
        nArray2[446] = 10;
        nArray2[447] = 11;
        nArray2[448] = 255;
        nArray2[449] = 196;
        nArray2[451] = 181;
        nArray2[452] = 17;
        nArray2[454] = 2;
        nArray2[455] = 1;
        nArray2[456] = 2;
        nArray2[457] = 4;
        nArray2[458] = 4;
        nArray2[459] = 3;
        nArray2[460] = 4;
        nArray2[461] = 7;
        nArray2[462] = 5;
        nArray2[463] = 4;
        nArray2[464] = 4;
        nArray2[466] = 1;
        nArray2[467] = 2;
        nArray2[468] = 119;
        nArray2[470] = 1;
        nArray2[471] = 2;
        nArray2[472] = 3;
        nArray2[473] = 17;
        nArray2[474] = 4;
        nArray2[475] = 5;
        nArray2[476] = 33;
        nArray2[477] = 49;
        nArray2[478] = 6;
        nArray2[479] = 18;
        nArray2[480] = 65;
        nArray2[481] = 81;
        nArray2[482] = 7;
        nArray2[483] = 97;
        nArray2[484] = 113;
        nArray2[485] = 19;
        nArray2[486] = 34;
        nArray2[487] = 50;
        nArray2[488] = 129;
        nArray2[489] = 8;
        nArray2[490] = 20;
        nArray2[491] = 66;
        nArray2[492] = 145;
        nArray2[493] = 161;
        nArray2[494] = 177;
        nArray2[495] = 193;
        nArray2[496] = 9;
        nArray2[497] = 35;
        nArray2[498] = 51;
        nArray2[499] = 82;
        nArray2[500] = 240;
        nArray2[501] = 21;
        nArray2[502] = 98;
        nArray2[503] = 114;
        nArray2[504] = 209;
        nArray2[505] = 10;
        nArray2[506] = 22;
        nArray2[507] = 36;
        nArray2[508] = 52;
        nArray2[509] = 225;
        nArray2[510] = 37;
        nArray2[511] = 241;
        nArray2[512] = 23;
        nArray2[513] = 24;
        nArray2[514] = 25;
        nArray2[515] = 26;
        nArray2[516] = 38;
        nArray2[517] = 39;
        nArray2[518] = 40;
        nArray2[519] = 41;
        nArray2[520] = 42;
        nArray2[521] = 53;
        nArray2[522] = 54;
        nArray2[523] = 55;
        nArray2[524] = 56;
        nArray2[525] = 57;
        nArray2[526] = 58;
        nArray2[527] = 67;
        nArray2[528] = 68;
        nArray2[529] = 69;
        nArray2[530] = 70;
        nArray2[531] = 71;
        nArray2[532] = 72;
        nArray2[533] = 73;
        nArray2[534] = 74;
        nArray2[535] = 83;
        nArray2[536] = 84;
        nArray2[537] = 85;
        nArray2[538] = 86;
        nArray2[539] = 87;
        nArray2[540] = 88;
        nArray2[541] = 89;
        nArray2[542] = 90;
        nArray2[543] = 99;
        nArray2[544] = 100;
        nArray2[545] = 101;
        nArray2[546] = 102;
        nArray2[547] = 103;
        nArray2[548] = 104;
        nArray2[549] = 105;
        nArray2[550] = 106;
        nArray2[551] = 115;
        nArray2[552] = 116;
        nArray2[553] = 117;
        nArray2[554] = 118;
        nArray2[555] = 119;
        nArray2[556] = 120;
        nArray2[557] = 121;
        nArray2[558] = 122;
        nArray2[559] = 130;
        nArray2[560] = 131;
        nArray2[561] = 132;
        nArray2[562] = 133;
        nArray2[563] = 134;
        nArray2[564] = 135;
        nArray2[565] = 136;
        nArray2[566] = 137;
        nArray2[567] = 138;
        nArray2[568] = 146;
        nArray2[569] = 147;
        nArray2[570] = 148;
        nArray2[571] = 149;
        nArray2[572] = 150;
        nArray2[573] = 151;
        nArray2[574] = 152;
        nArray2[575] = 153;
        nArray2[576] = 154;
        nArray2[577] = 162;
        nArray2[578] = 163;
        nArray2[579] = 164;
        nArray2[580] = 165;
        nArray2[581] = 166;
        nArray2[582] = 167;
        nArray2[583] = 168;
        nArray2[584] = 169;
        nArray2[585] = 170;
        nArray2[586] = 178;
        nArray2[587] = 179;
        nArray2[588] = 180;
        nArray2[589] = 181;
        nArray2[590] = 182;
        nArray2[591] = 183;
        nArray2[592] = 184;
        nArray2[593] = 185;
        nArray2[594] = 186;
        nArray2[595] = 194;
        nArray2[596] = 195;
        nArray2[597] = 196;
        nArray2[598] = 197;
        nArray2[599] = 198;
        nArray2[600] = 199;
        nArray2[601] = 200;
        nArray2[602] = 201;
        nArray2[603] = 202;
        nArray2[604] = 210;
        nArray2[605] = 211;
        nArray2[606] = 212;
        nArray2[607] = 213;
        nArray2[608] = 214;
        nArray2[609] = 215;
        nArray2[610] = 216;
        nArray2[611] = 217;
        nArray2[612] = 218;
        nArray2[613] = 226;
        nArray2[614] = 227;
        nArray2[615] = 228;
        nArray2[616] = 229;
        nArray2[617] = 230;
        nArray2[618] = 231;
        nArray2[619] = 232;
        nArray2[620] = 233;
        nArray2[621] = 234;
        nArray2[622] = 242;
        nArray2[623] = 243;
        nArray2[624] = 244;
        nArray2[625] = 245;
        nArray2[626] = 246;
        nArray2[627] = 247;
        nArray2[628] = 248;
        nArray2[629] = 249;
        nArray2[630] = 250;
        nArray2[631] = 255;
        nArray2[632] = 218;
        nArray2[634] = 12;
        nArray2[635] = 3;
        nArray2[636] = 1;
        nArray2[638] = 2;
        nArray2[639] = 17;
        nArray2[640] = 3;
        nArray2[641] = 17;
        nArray2[643] = 63;
        nArray2[645] = 248;
        nArray2[646] = 10;
        nArray2[647] = 210;
        nArray2[648] = 13;
        nArray2[649] = 31;
        nArray2[650] = 254;
        nArray2[651] = 17;
        nArray2[652] = 29;
        nArray2[653] = 65;
        nArray2[654] = 22;
        nArray2[655] = 238;
        nArray2[656] = 252;
        nArray2[657] = 192;
        nArray2[658] = 110;
        nArray2[659] = 160;
        nArray2[660] = 44;
        nArray2[661] = 198;
        nArray2[662] = 221;
        nArray2[663] = 119;
        nArray2[664] = 3;
        nArray2[665] = 178;
        nArray2[666] = 92;
        nArray2[667] = 12;
        nArray2[668] = 110;
        nArray2[669] = 233;
        nArray2[670] = 215;
        nArray2[671] = 244;
        nArray2[672] = 245;
        nArray2[673] = 227;
        nArray2[674] = 48;
        nArray2[675] = 89;
        nArray2[676] = 104;
        nArray2[677] = 35;
        nArray2[678] = 143;
        nArray2[679] = 183;
        nArray2[680] = 106;
        nArray2[681] = 60;
        nArray2[682] = 127;
        nArray2[683] = 211;
        nArray2[684] = 170;
        nArray2[685] = 127;
        nArray2[686] = 241;
        nArray2[687] = 84;
        nArray2[688] = 182;
        nArray2[689] = 31;
        nArray2[690] = 242;
        nArray2[691] = 35;
        nArray2[692] = 106;
        nArray2[693] = 63;
        nArray2[694] = 245;
        nArray2[695] = 247;
        nArray2[696] = 111;
        nArray2[697] = 255;
        nArray2[699] = 160;
        nArray2[700] = 203;
        nArray2[701] = 88;
        nArray2[702] = 213;
        nArray2[703] = 143;
        nArray2[704] = 41;
        nArray2[705] = 162;
        nArray2[706] = 143;
        nArray2[707] = 153;
        nArray2[708] = 255;
        nArray2[709] = 217;
        BACKGROUND_MONITOR_SMALL = nArray2;
    }

    public void dispatch() {
        this.init();
        Runnable runnable = new Runnable(){
            private int pulse;

            @Override
            public void run() {
                if (OscilloscopeDispatcher.this.getOscilloscope().isDisposed()) {
                    return;
                }
                OscilloscopeDispatcher.this.hookBeforeDraw(OscilloscopeDispatcher.this.getOscilloscope(), this.pulse);
                OscilloscopeDispatcher.this.getOscilloscope().redraw();
                OscilloscopeDispatcher.this.hookAfterDraw(OscilloscopeDispatcher.this.getOscilloscope(), this.pulse);
                ++this.pulse;
                if (this.pulse >= OscilloscopeDispatcher.this.getPulse()) {
                    if (OscilloscopeDispatcher.this.getPulse() != 0) {
                        OscilloscopeDispatcher.this.hookPulse(OscilloscopeDispatcher.this.getOscilloscope(), this.pulse);
                    }
                    this.pulse = 0;
                }
                if (OscilloscopeDispatcher.this.getDelayLoop() > 1) {
                    OscilloscopeDispatcher.this.getOscilloscope().getDisplay().timerExec(OscilloscopeDispatcher.this.getDelayLoop(), (Runnable)this);
                } else {
                    OscilloscopeDispatcher.this.getOscilloscope().getDisplay().asyncExec((Runnable)this);
                }
            }
        };
        this.getOscilloscope().getDisplay().syncExec(runnable);
    }

    protected void finalize() throws Throwable {
        if (this.image != null && !this.image.isDisposed()) {
            this.image.dispose();
        }
        super.finalize();
    }

    public Color getActiveForegoundColor() {
        return this.getOscilloscope().getDisplay().getSystemColor(5);
    }

    public File getActiveSoundfile() {
        return null;
    }

    public Image getBackgroundImage() {
        if (this.image == null) {
            byte[] bytes = new byte[BACKGROUND_MONITOR.length];
            int i = 0;
            while (i < BACKGROUND_MONITOR.length) {
                bytes[i] = (byte)BACKGROUND_MONITOR[i];
                ++i;
            }
            this.image = new Image(null, (InputStream)new ByteArrayInputStream(bytes));
        }
        return this.image;
    }

    public int getBaseOffset() {
        return 50;
    }

    public PlayClip getClipper() {
        return this.clipper;
    }

    public int getDelayLoop() {
        return 30;
    }

    public boolean getFade() {
        return true;
    }

    public Color getInactiveForegoundColor() {
        return this.getOscilloscope().getDisplay().getSystemColor(3);
    }

    public File getInactiveSoundfile() {
        return null;
    }

    public int getLineWidth() {
        return 180;
    }

    public abstract Oscilloscope getOscilloscope();

    public int getProgression() {
        return 1;
    }

    public int getPulse() {
        return 40;
    }

    public int getSteadyPosition() {
        return -1;
    }

    public int getTailFade() {
        return 25;
    }

    public int getTailSize() {
        return -1;
    }

    public void hookAfterDraw(Oscilloscope oscilloscope, int counter) {
    }

    public void hookBeforeDraw(Oscilloscope oscilloscope, int counter) {
        if (counter == this.getPulse() - 1) {
            this.hookChangeAttributes();
        }
    }

    public void hookChangeAttributes() {
        this.getOscilloscope().setPercentage(this.isPercentage());
        this.getOscilloscope().setTailSize(this.isTailSizeMax() ? -1 : this.getTailSize());
        this.getOscilloscope().setSteady(this.isSteady(), this.getSteadyPosition());
        this.getOscilloscope().setFade(this.getFade());
        this.getOscilloscope().setTailFade(this.getTailFade());
        this.getOscilloscope().setConnect(this.mustConnect());
        this.getOscilloscope().setLineWidth(this.getLineWidth());
        this.getOscilloscope().setBackgroundImage(this.getBackgroundImage());
        this.getOscilloscope().setProgression(this.getProgression());
        this.getOscilloscope().setBaseOffset(this.getBaseOffset());
        this.getOscilloscope().setProgression(this.getProgression());
    }

    public void hookPulse(Oscilloscope oscilloscope, int pulse) {
        if (this.isServiceActive()) {
            this.getOscilloscope().setForeground(this.getActiveForegoundColor());
            this.hookSetValues(pulse);
            if (this.isSoundRequired()) {
                this.getClipper().playClip(this.getActiveSoundfile(), 0);
            }
        } else {
            if (this.isSoundRequired()) {
                this.getClipper().playClip(this.getInactiveSoundfile(), 0);
            }
            this.getOscilloscope().setForeground(this.getInactiveForegoundColor());
        }
    }

    public abstract void hookSetValues(int var1);

    public void init() {
    }

    public boolean isPercentage() {
        return true;
    }

    public boolean isServiceActive() {
        return true;
    }

    public boolean isSoundRequired() {
        return false;
    }

    public boolean isSteady() {
        return false;
    }

    public boolean isTailSizeMax() {
        return false;
    }

    public boolean mustConnect() {
        return false;
    }

    public class PlayClip {
        private Clip clip = null;
        private String oldFile = "";

        public Clip getClip() {
            return this.clip;
        }

        public void playClip(File file, int loopCount) {
            if (file == null) {
                return;
            }
            try {
                if (this.clip == null || !file.getAbsolutePath().equals(this.oldFile)) {
                    this.oldFile = file.getAbsolutePath();
                    this.clip = AudioSystem.getClip();
                    this.clip.open(AudioSystem.getAudioInputStream(file));
                }
                if (this.clip.isActive()) {
                    return;
                }
                this.clip.setFramePosition(0);
                this.clip.loop(loopCount);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

