/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.animation.effects;

import org.eclipse.nebula.animation.effects.AbstractEffect;
import org.eclipse.nebula.animation.movement.IMovement;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class SetColorEffect
extends AbstractEffect {
    Color src;
    Color dest;
    int diffR;
    int diffG;
    int diffB;
    IColoredObject control = null;

    public SetColorEffect(IColoredObject control, Color src, Color dest, long lengthMilli, IMovement movement, Runnable onStop, Runnable onCancel) {
        super(lengthMilli, movement, onStop, onCancel);
        this.src = src;
        this.dest = dest;
        this.diffR = dest.getRed() - src.getRed();
        this.diffG = dest.getGreen() - src.getGreen();
        this.diffB = dest.getBlue() - src.getBlue();
        this.control = control;
        this.easingFunction.init(0.0, 1.0, (int)lengthMilli);
    }

    @Override
    public void applyEffect(long currentTime) {
        Color currentColor = this.control.getColor();
        int nextRed = (int)((double)this.src.getRed() + (double)this.diffR * this.easingFunction.getValue(currentTime));
        int nextGreen = (int)((double)this.src.getGreen() + (double)this.diffG * this.easingFunction.getValue(currentTime));
        int nextBlue = (int)((double)this.src.getBlue() + (double)this.diffB * this.easingFunction.getValue(currentTime));
        RGB nextRGB = new RGB(nextRed, nextGreen, nextBlue);
        if (currentColor == null || !nextRGB.equals((Object)currentColor.getRGB())) {
            Color nextColor = new Color((Device)Display.getCurrent(), nextRed, nextGreen, nextBlue);
            if (this.dest.getRGB().equals((Object)nextColor.getRGB())) {
                nextColor.dispose();
                nextColor = this.dest;
            }
            this.control.setColor(nextColor);
            if (currentColor != null && !currentColor.isDisposed() && this.dest != currentColor && this.src != currentColor) {
                currentColor.dispose();
            }
        }
    }

    public static interface IColoredObject {
        public void setColor(Color var1);

        public Color getColor();
    }
}

