/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.selection.event;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionUtil;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.event.RowVisualChangeEvent;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.event.ISelectionEvent;

public class RowSelectionEvent
extends RowVisualChangeEvent
implements ISelectionEvent {
    private final SelectionLayer selectionLayer;
    private int rowPositionToMoveIntoViewport;
    private boolean withShiftMask = false;
    private boolean withControlMask = false;

    public RowSelectionEvent(SelectionLayer selectionLayer, Collection<Integer> rowPositions, int rowPositionToMoveIntoViewport, boolean withShiftMask, boolean withControlMask) {
        super((ILayer)selectionLayer, PositionUtil.getRanges(rowPositions));
        this.selectionLayer = selectionLayer;
        this.rowPositionToMoveIntoViewport = rowPositionToMoveIntoViewport;
        this.withShiftMask = withShiftMask;
        this.withControlMask = withControlMask;
    }

    public RowSelectionEvent(SelectionLayer selectionLayer, int[] rowPositions, int rowPositionToMoveIntoViewport, boolean withShiftMask, boolean withControlMask) {
        super((ILayer)selectionLayer, PositionUtil.getRanges(rowPositions));
        this.selectionLayer = selectionLayer;
        this.rowPositionToMoveIntoViewport = rowPositionToMoveIntoViewport;
        this.withShiftMask = withShiftMask;
        this.withControlMask = withControlMask;
    }

    public RowSelectionEvent(SelectionLayer selectionLayer, Range rowPositionRange, int rowPositionToMoveIntoViewport, boolean withShiftMask, boolean withControlMask) {
        super((ILayer)selectionLayer, Arrays.asList(rowPositionRange));
        this.selectionLayer = selectionLayer;
        this.rowPositionToMoveIntoViewport = rowPositionToMoveIntoViewport;
        this.withShiftMask = withShiftMask;
        this.withControlMask = withControlMask;
    }

    protected RowSelectionEvent(RowSelectionEvent event) {
        super(event);
        this.selectionLayer = event.selectionLayer;
        this.rowPositionToMoveIntoViewport = event.rowPositionToMoveIntoViewport;
        this.withShiftMask = event.withShiftMask;
        this.withControlMask = event.withControlMask;
    }

    @Override
    public SelectionLayer getSelectionLayer() {
        return this.selectionLayer;
    }

    public int getRowPositionToMoveIntoViewport() {
        return this.rowPositionToMoveIntoViewport;
    }

    public boolean isWithShiftMask() {
        return this.withShiftMask;
    }

    public boolean isWithControlMask() {
        return this.withControlMask;
    }

    @Override
    public boolean convertToLocal(ILayer localLayer) {
        this.rowPositionToMoveIntoViewport = localLayer.underlyingToLocalRowPosition(this.getLayer(), this.rowPositionToMoveIntoViewport);
        return super.convertToLocal(localLayer);
    }

    @Override
    public RowSelectionEvent cloneEvent() {
        return new RowSelectionEvent(this);
    }
}

