/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.grid.cell;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelProvider;

public class AlternatingRowConfigLabelAccumulator
implements IConfigLabelProvider {
    public static final String ODD_ROW_CONFIG_TYPE = "ODD_BODY";
    public static final String EVEN_ROW_CONFIG_TYPE = "EVEN_BODY";
    protected ILayer layer;

    public AlternatingRowConfigLabelAccumulator() {
    }

    public AlternatingRowConfigLabelAccumulator(ILayer layer) {
        this.layer = layer;
    }

    @Override
    public void accumulateConfigLabels(LabelStack configLabels, int columnPosition, int rowPosition) {
        int row = rowPosition;
        if (this.layer != null) {
            row = this.layer.getRowIndexByPosition(rowPosition);
        }
        configLabels.addLabel(row % 2 == 0 ? EVEN_ROW_CONFIG_TYPE : ODD_ROW_CONFIG_TYPE);
    }

    @Override
    public Collection<String> getProvidedLabels() {
        return Arrays.asList(ODD_ROW_CONFIG_TYPE, EVEN_ROW_CONFIG_TYPE);
    }
}

