/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.selection;

import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.SelectionUtils;
import org.eclipse.nebula.widgets.nattable.selection.command.SelectColumnCommand;
import org.eclipse.nebula.widgets.nattable.selection.event.ColumnSelectionEvent;
import org.eclipse.swt.graphics.Rectangle;

public class SelectColumnCommandHandler
implements ILayerCommandHandler<SelectColumnCommand> {
    protected final SelectionLayer selectionLayer;

    public SelectColumnCommandHandler(SelectionLayer selectionLayer) {
        this.selectionLayer = selectionLayer;
    }

    @Override
    public boolean doCommand(ILayer targetLayer, SelectColumnCommand command) {
        if (command.convertToTargetLayer(this.selectionLayer)) {
            this.selectColumn(command.getColumnPosition(), command.getRowPosition(), command.isWithShiftMask(), command.isWithControlMask());
            return true;
        }
        return false;
    }

    protected void selectColumn(int columnPosition, int rowPosition, boolean withShiftMask, boolean withControlMask) {
        if (SelectionUtils.noShiftOrControl(withShiftMask, withControlMask)) {
            this.selectionLayer.clear(false);
            this.selectionLayer.selectCell(columnPosition, 0, false, false);
            this.selectionLayer.selectRegion(columnPosition, 0, 1, Integer.MAX_VALUE);
            this.selectionLayer.moveSelectionAnchor(columnPosition, rowPosition);
        } else if (SelectionUtils.bothShiftAndControl(withShiftMask, withControlMask)) {
            this.selectColumnWithShiftKey(columnPosition);
        } else if (SelectionUtils.isShiftOnly(withShiftMask, withControlMask)) {
            this.selectColumnWithShiftKey(columnPosition);
        } else if (SelectionUtils.isControlOnly(withShiftMask, withControlMask)) {
            this.selectColumnWithCtrlKey(columnPosition, rowPosition);
        }
        this.selectionLayer.setLastSelectedCell(columnPosition, this.selectionLayer.getRowCount() - 1);
        this.selectionLayer.fireLayerEvent(new ColumnSelectionEvent(this.selectionLayer, columnPosition, withShiftMask, withControlMask));
    }

    private void selectColumnWithCtrlKey(int columnPosition, int rowPosition) {
        Rectangle selectedColumnRectangle = new Rectangle(columnPosition, 0, 1, Integer.MAX_VALUE);
        if (this.selectionLayer.isColumnPositionFullySelected(columnPosition)) {
            this.selectionLayer.clearSelection(selectedColumnRectangle);
            this.selectionLayer.setLastSelectedRegion(null);
            int[] selectedColumns = this.selectionLayer.getFullySelectedColumnPositions();
            if (selectedColumns.length > 0 && this.selectionLayer.getSelectionAnchor().columnPosition == -1) {
                int toPos = selectedColumns[0];
                int i = 0;
                while (i < selectedColumns.length) {
                    if (selectedColumns[i] >= columnPosition) break;
                    toPos = selectedColumns[i];
                    ++i;
                }
                this.selectionLayer.moveSelectionAnchor(toPos, rowPosition);
            }
        } else {
            if (this.selectionLayer.getLastSelectedRegion() != null) {
                this.selectionLayer.selectRegion(this.selectionLayer.getLastSelectedRegion().x, this.selectionLayer.getLastSelectedRegion().y, this.selectionLayer.getLastSelectedRegion().width, this.selectionLayer.getLastSelectedRegion().height);
            }
            this.selectionLayer.selectRegion(columnPosition, 0, 1, Integer.MAX_VALUE);
            this.selectionLayer.moveSelectionAnchor(columnPosition, rowPosition);
        }
    }

    private void selectColumnWithShiftKey(int columnPosition) {
        int numOfColumnsToInclude = 1;
        int startColumnPosition = columnPosition;
        Rectangle lastSelectedRegion = this.selectionLayer.getLastSelectedRegion();
        if (lastSelectedRegion != null) {
            this.selectionLayer.getSelectionModel().clearSelection(lastSelectedRegion);
        } else {
            this.selectionLayer.getSelectionModel().clearSelection();
        }
        if (!this.selectionLayer.getSelectionModel().isMultipleSelectionAllowed() || this.selectionLayer.getSelectionAnchor().columnPosition == -1) {
            this.selectionLayer.moveSelectionAnchor(columnPosition, 0);
        }
        if (this.selectionLayer.getSelectionAnchor().columnPosition != -1) {
            numOfColumnsToInclude = Math.abs(this.selectionLayer.getSelectionAnchor().columnPosition - columnPosition) + 1;
            if (this.selectionLayer.getSelectionAnchor().columnPosition < columnPosition) {
                startColumnPosition = this.selectionLayer.getSelectionAnchor().columnPosition;
            }
        }
        this.selectionLayer.selectRegion(startColumnPosition, 0, numOfColumnsToInclude, Integer.MAX_VALUE);
    }

    @Override
    public Class<SelectColumnCommand> getCommandClass() {
        return SelectColumnCommand.class;
    }
}

