/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests;

import junit.framework.TestCase;
import org.eclipse.mylyn.internal.tasks.core.RepositoryTemplateManager;
import org.eclipse.mylyn.internal.tasks.ui.TaskRepositoryUtil;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.RepositoryTemplate;

public class RepositoryTemplateManagerTest
extends TestCase {
    private RepositoryTemplateManager manager;

    protected void setUp() throws Exception {
        this.manager = TasksUiPlugin.getRepositoryTemplateManager();
    }

    public void testTemplateDeletion() {
        RepositoryTemplate template = new RepositoryTemplate("Mock", "http://mockrepository.test", "", "", "", "", "", "", false, true);
        try {
            this.manager.addTemplate("mock", template);
            RepositoryTemplateManagerTest.assertFalse((boolean)TaskRepositoryUtil.isAddAutomaticallyDisabled((String)"http://mockrepository.test"));
            TaskRepositoryUtil.disableAddAutomatically((String)"http://mockrepository.test");
            RepositoryTemplateManagerTest.assertTrue((boolean)TaskRepositoryUtil.isAddAutomaticallyDisabled((String)"http://mockrepository.test"));
        }
        finally {
            this.manager.removeTemplate("mock", template);
        }
    }

    public void testStripSlashes() {
        RepositoryTemplate template = new RepositoryTemplate("Mock", "http://mockrepository.test///", "", "", "", "", "", "", false, true);
        RepositoryTemplateManagerTest.assertEquals((String)"http://mockrepository.test", (String)template.repositoryUrl);
    }
}

