/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.sdk.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.zip.ZipFile;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.mylyn.commons.core.CoreUtil;
import org.eclipse.mylyn.commons.core.net.NetUtil;
import org.eclipse.mylyn.commons.net.WebUtil;
import org.eclipse.mylyn.commons.repositories.core.auth.CertificateCredentials;
import org.eclipse.mylyn.commons.repositories.core.auth.UserCredentials;
import org.eclipse.mylyn.commons.sdk.util.MylynResourceMissingException;
import org.eclipse.mylyn.commons.sdk.util.TestConfiguration;
import org.eclipse.mylyn.internal.commons.net.CommonsNetPlugin;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public class CommonTestUtil {
    public static final String KEY_CREDENTIALS_FILE = "mylyn.credentials";
    private static final String KEY_IGNORE_LOCAL_SERVICES = "org.eclipse.mylyn.tests.ignore.local.services";
    private static final String KEY_IGNORE_GLOBAL_SERVICES = "org.eclipse.mylyn.tests.ignore.global.services";
    private static final int MAX_RETRY = 5;

    public static String changeSeparator(String path, char oldSeparator, char newSeparator) {
        return path.replace(oldSeparator, newSeparator);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void copy(File source, File dest) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            FileInputStream in = new FileInputStream(source);
            try {
                try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dest));){
                    CommonTestUtil.transferData(in, out);
                }
                if (in == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (in == null) throw throwable;
                ((InputStream)in).close();
                throw throwable;
            }
            ((InputStream)in).close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public static void copyFolder(File sourceFolder, File targetFolder) throws IOException {
        File[] fileArray = sourceFolder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File sourceFile = fileArray[n2];
            if (sourceFile.isFile()) {
                File destFile = new File(targetFolder, sourceFile.getName());
                CommonTestUtil.copy(sourceFile, destFile);
            }
            ++n2;
        }
    }

    public static void copyFolderRecursively(File sourceFolder, File targetFolder) throws IOException {
        File[] fileArray = sourceFolder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File sourceFile = fileArray[n2];
            if (sourceFile.isFile()) {
                File destFile = new File(targetFolder, sourceFile.getName());
                CommonTestUtil.copy(sourceFile, destFile);
            } else if (sourceFile.isDirectory()) {
                File destDir = new File(targetFolder, sourceFile.getName());
                if (!destDir.exists() && !destDir.mkdir()) {
                    throw new IOException("Unable to create destination folder: " + destDir.getAbsolutePath());
                }
                CommonTestUtil.copyFolderRecursively(sourceFile, destDir);
            }
            ++n2;
        }
    }

    public static File createTempFileInPlugin(Plugin plugin, IPath path) {
        IPath stateLocation = plugin.getStateLocation();
        stateLocation = stateLocation.append(path);
        return stateLocation.toFile();
    }

    public static File createTempFolder(String prefix) throws IOException {
        File location = File.createTempFile(prefix, null);
        location.delete();
        location.mkdirs();
        return location;
    }

    public static void delete(File file) {
        if (file.exists()) {
            int i = 0;
            while (i < 5) {
                if (file.delete()) {
                    i = 5;
                } else {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
    }

    public static void deleteFolder(File path) {
        if (path.isDirectory()) {
            File[] fileArray = path.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                file.delete();
                ++n2;
            }
            path.delete();
        }
    }

    public static void deleteFolderRecursively(File path) {
        File[] files = path.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    CommonTestUtil.deleteFolderRecursively(file);
                } else {
                    file.delete();
                }
                ++n2;
            }
        }
        path.delete();
    }

    public static CertificateCredentials getCertificateCredentials() {
        try {
            File keyStoreFile = CommonTestUtil.getFile(CommonTestUtil.class, "testdata/keystore");
            String password = CommonTestUtil.getUserCredentials().getPassword();
            return new CertificateCredentials(keyStoreFile.getAbsolutePath(), password, null);
        }
        catch (IOException cause) {
            MylynResourceMissingException e = new MylynResourceMissingException("Failed to load keystore file");
            e.initCause(cause);
            throw e;
        }
    }

    public static boolean hasCredentials(PrivilegeLevel level) {
        try {
            CommonTestUtil.getCredentials(level);
            return true;
        }
        catch (MylynResourceMissingException error) {
            return false;
        }
    }

    public static UserCredentials getCredentials(PrivilegeLevel level) {
        return CommonTestUtil.getCredentials(level, null);
    }

    public static UserCredentials getCredentials(PrivilegeLevel level, String realm) {
        Properties properties = new Properties();
        try {
            File file;
            String filename = System.getProperty(KEY_CREDENTIALS_FILE);
            if (filename != null) {
                file = new File(filename);
            } else {
                file = new File(new File(System.getProperty("user.home"), ".mylyn"), "credentials.properties");
                if (!file.exists()) {
                    file = CommonTestUtil.getFile(CommonTestUtil.class, "testdata/credentials.properties");
                }
            }
            properties.load(new FileInputStream(file));
        }
        catch (Exception e) {
            MylynResourceMissingException error = new MylynResourceMissingException("must define credentials in $HOME/.mylyn/credentials.properties");
            error.initCause(e);
            throw error;
        }
        String defaultPassword = properties.getProperty("pass");
        realm = realm != null ? (String)realm + "." : "";
        return switch (level) {
            case PrivilegeLevel.ANONYMOUS -> CommonTestUtil.createCredentials(properties, (String)realm + "anon.", "", "");
            case PrivilegeLevel.GUEST -> CommonTestUtil.createCredentials(properties, (String)realm + "guest.", "guest@mylyn.eclipse.org", defaultPassword);
            case PrivilegeLevel.USER -> CommonTestUtil.createCredentials(properties, (String)realm, "tests@mylyn.eclipse.org", defaultPassword);
            case PrivilegeLevel.READ_ONLY -> CommonTestUtil.createCredentials(properties, (String)realm, "read-only@mylyn.eclipse.org", defaultPassword);
            case PrivilegeLevel.ADMIN -> CommonTestUtil.createCredentials(properties, (String)realm + "admin.", "admin@mylyn.eclipse.org", null);
            default -> throw new MatchException(null, null);
        };
    }

    private static boolean isOsgiVersion310orNewer(ClassLoader classLoader) {
        return classLoader.getClass().getName().equals("org.eclipse.osgi.internal.loader.ModuleClassLoader") || classLoader.getClass().getName().equals("org.eclipse.osgi.internal.loader.EquinoxClassLoader");
    }

    public static File getFile(Object source, String filename) throws IOException {
        Class<?> clazz;
        Class<?> clazz2 = clazz = source instanceof Class ? (Class<?>)source : source.getClass();
        if (Platform.isRunning()) {
            ClassLoader classLoader = clazz.getClassLoader();
            try {
                if (CommonTestUtil.isOsgiVersion310orNewer(classLoader)) {
                    return Objects.requireNonNull(CommonTestUtil.getFileFromClassLoader4Luna(filename, classLoader));
                }
                return Objects.requireNonNull(CommonTestUtil.getFileFromClassLoaderBeforeLuna(filename, classLoader));
            }
            catch (Exception e) {
                MylynResourceMissingException exception = new MylynResourceMissingException(NLS.bind((String)"Could not locate {0} using classloader for {1}", (Object)filename, clazz));
                exception.initCause(e);
                throw exception;
            }
        }
        return CommonTestUtil.getFileFromNotRunningPlatform(filename, clazz);
    }

    private static File getFileFromNotRunningPlatform(String filename, Class<?> clazz) throws UnsupportedEncodingException, IOException {
        URL localURL = clazz.getResource("");
        Object path = URLDecoder.decode(localURL.getFile(), Charset.defaultCharset().name());
        int i = ((String)path).indexOf("!");
        if (i != -1) {
            int j = ((String)path).lastIndexOf(File.separatorChar, i);
            if (j == -1) {
                throw new MylynResourceMissingException("Unable to determine location for '" + (String)filename + "' at '" + (String)path + "'");
            }
            path = ((String)path).substring(0, j) + File.separator;
            if (((String)path).startsWith("file:")) {
                path = ((String)path).substring(5);
            }
            return new File((String)path + (String)filename);
        }
        Object directory = clazz.getName().replaceAll("[^.]", "");
        directory = ((String)directory).replaceAll(".", "../");
        if (((String)path).contains("/bin/")) {
            directory = (String)directory + "../";
        } else if (((String)path).contains("/target/classes/")) {
            directory = (String)directory + "../../";
        }
        filename = (String)path + ((String)directory + (String)filename).replace("/", File.separator);
        return new File((String)filename).getCanonicalFile();
    }

    private static File getFileFromClassLoaderBeforeLuna(String filename, ClassLoader classLoader) throws Exception {
        Object classpathManager = MethodUtils.invokeExactMethod((Object)classLoader, (String)"getClasspathManager", null);
        Object baseData = MethodUtils.invokeExactMethod((Object)classpathManager, (String)"getBaseData", null);
        Bundle bundle = (Bundle)MethodUtils.invokeExactMethod((Object)baseData, (String)"getBundle", null);
        URL localURL = FileLocator.toFileURL((URL)bundle.getEntry(filename));
        return new File(localURL.getFile());
    }

    private static File getFileFromClassLoader4Luna(String filename, ClassLoader classLoader) throws Exception {
        Object classpathManager = MethodUtils.invokeExactMethod((Object)classLoader, (String)"getClasspathManager", null);
        Object generation = MethodUtils.invokeExactMethod((Object)classpathManager, (String)"getGeneration", null);
        Object bundleFile = MethodUtils.invokeExactMethod((Object)generation, (String)"getBundleFile", null);
        File file = (File)MethodUtils.invokeExactMethod((Object)bundleFile, (String)"getFile", (Object[])new Object[]{filename, true}, (Class[])new Class[]{String.class, Boolean.TYPE});
        return file;
    }

    public static InputStream getResource(Object source, String filename) throws IOException {
        File file;
        Class<?> clazz = source instanceof Class ? (Class<?>)source : source.getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        InputStream in = classLoader.getResourceAsStream(filename);
        if (in == null && (file = CommonTestUtil.getFile(source, filename)) != null) {
            return new FileInputStream(file);
        }
        if (in == null) {
            throw new IOException(NLS.bind((String)"Failed to locate ''{0}'' for ''{1}''", (Object)filename, (Object)clazz.getName()));
        }
        return in;
    }

    public static UserCredentials getUserCredentials() {
        return CommonTestUtil.getCredentials(PrivilegeLevel.USER, null);
    }

    public static String read(File source) throws IOException {
        FileInputStream in = new FileInputStream(source);
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            try {
                int len;
                StringBuilder sb = new StringBuilder();
                byte[] buf = new byte[1024];
                while ((len = ((InputStream)in).read(buf)) > 0) {
                    sb.append(new String(buf, 0, len));
                }
                return sb.toString();
            }
            finally {
                if (in != null) {
                    ((InputStream)in).close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static boolean runHeartbeatTestsOnly() {
        return !Boolean.getBoolean("org.eclipse.mylyn.tests.all");
    }

    public static boolean runNonCIServerTestsOnly() {
        return !CommonTestUtil.runOnCIServerTestsOnly();
    }

    public static boolean runOnCIServerTestsOnly() {
        return TestConfiguration.URL_SERVICES_CI_DEFAULT.equals(TestConfiguration.URL_SERVICES_DEFAULT) || TestConfiguration.URL_SERVICES_CI_DEFAULT.equals(TestConfiguration.URL_SERVICES_LOCALHOST);
    }

    public static void unzip(ZipFile zipFile, File dstDir) throws IOException {
        CommonTestUtil.unzip(zipFile, dstDir, dstDir, 0);
    }

    public static void write(String fileName, StringBuffer content) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileWriter writer = new FileWriter(fileName);){
            writer.write(content.toString());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static UserCredentials createCredentials(Properties properties, String prefix, String defaultUsername, String defaultPassword) {
        String username = properties.getProperty(prefix + "user");
        String password = properties.getProperty(prefix + "pass");
        if (username == null) {
            username = defaultUsername;
        }
        if (password == null) {
            password = defaultPassword;
        }
        if (username == null || password == null) {
            throw new MylynResourceMissingException("username or password not found for " + prefix + " in <plug-in dir>/credentials.properties, make sure file is valid");
        }
        return new UserCredentials(username, password);
    }

    private static void transferData(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
    }

    /*
     * Exception decompiling
     */
    private static void unzip(ZipFile zipFile, File rootDstDir, File dstDir, int depth) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean isCertificateAuthBroken() {
        return new VersionRange("[0.0.0,1.6.0.25]").isIncluded(CoreUtil.getRuntimeVersion());
    }

    public static boolean hasCertificateCredentials() {
        try {
            CommonTestUtil.getCertificateCredentials();
            return true;
        }
        catch (MylynResourceMissingException error) {
            return false;
        }
    }

    public static String getShortUserName(UserCredentials credentials) {
        String username = credentials.getUserName();
        if (username.contains("@")) {
            return username.substring(0, username.indexOf("@"));
        }
        return username;
    }

    public static boolean fixProxyConfiguration() {
        if (Platform.isRunning() && CommonsNetPlugin.getProxyService() != null && CommonsNetPlugin.getProxyService().isSystemProxiesEnabled() && !CommonsNetPlugin.getProxyService().hasSystemProxies()) {
            System.err.println("Forcing manual proxy configuration");
            CommonsNetPlugin.getProxyService().setSystemProxiesEnabled(false);
            CommonsNetPlugin.getProxyService().setProxiesEnabled(true);
            return true;
        }
        return false;
    }

    public static void dumpSystemInfo(PrintStream out) {
        Properties p = System.getProperties();
        if (Platform.isRunning()) {
            p.put("build.system", Platform.getOS() + "-" + Platform.getOSArch() + "-" + Platform.getWS());
        } else {
            p.put("build.system", "standalone");
        }
        String info = "System: ${os.name} ${os.version} (${os.arch}) / ${build.system} / ${java.vendor} ${java.vm.name} ${java.version}";
        for (Map.Entry<Object, Object> entry : p.entrySet()) {
            info = info.replaceFirst(Pattern.quote("${" + String.valueOf(entry.getKey()) + "}"), entry.getValue().toString());
        }
        out.println(info);
        out.print("HTTP Proxy : " + String.valueOf(WebUtil.getProxyForUrl((String)"http://mylyn.org")) + " (Platform)");
        try {
            out.print(" / " + String.valueOf(ProxySelector.getDefault().select(new URI("http://mylyn.org"))) + " (Java)");
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        out.println();
        out.print("HTTPS Proxy : " + String.valueOf(WebUtil.getProxyForUrl((String)"https://mylyn.org")) + " (Platform)");
        try {
            out.print(" / " + String.valueOf(ProxySelector.getDefault().select(new URI("https://mylyn.org"))) + " (Java)");
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        out.println();
        out.println();
    }

    public static boolean isEclipse4() {
        return Platform.getBundle((String)"org.eclipse.e4.core.commands") != null;
    }

    public static boolean isHttpsProxyBroken() {
        Proxy httpProxy = WebUtil.getProxyForUrl((String)"http://mylyn.org");
        Proxy httpsProxy = WebUtil.getProxyForUrl((String)"https://mylyn.org");
        return CoreUtil.areEqual((Object)httpProxy, (Object)httpsProxy);
    }

    public static boolean ignoreLocalTestServices() {
        return Boolean.getBoolean(KEY_IGNORE_LOCAL_SERVICES);
    }

    public static boolean ignoreGlobalTestServices() {
        return Boolean.getBoolean(KEY_IGNORE_GLOBAL_SERVICES);
    }

    public static boolean isBehindProxy() {
        return NetUtil.getProxyForUrl((String)"https://mylyn.org/secure/index.txt") != null;
    }

    public static boolean skipBrowserTests() {
        return Boolean.getBoolean("mylyn.test.skipBrowserTests");
    }

    public static boolean bundleWithNameIsPresent(String name) {
        Bundle bundle = Platform.getBundle((String)name);
        return bundle != null;
    }

    public static enum PrivilegeLevel {
        ADMIN,
        ANONYMOUS,
        GUEST,
        READ_ONLY,
        USER;

    }
}

