/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.model.edit;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.PerformChangeOperation;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.xtext.ide.serializer.IChangeSerializer;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.refactoring2.ChangeConverter;
import org.eclipse.xtext.ui.refactoring2.LtkIssueAcceptor;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;
import org.eclipse.xtext.ui.resource.LiveScopeResourceSetInitializer;
import org.eclipse.xtext.util.IAcceptor;

public class BatchModification {
    private static final Logger LOG = Logger.getLogger(BatchModification.class);
    @Inject
    private ChangeConverter.Factory changeConverterFactory;
    private IXtextDocument document;
    @Inject
    private LtkIssueAcceptor issueAcceptor;
    @Inject
    private LiveScopeResourceSetInitializer liveScopeResourceSetInitializer;
    private IProject project;
    @Inject
    private IResourceSetProvider resourceSetProvider;
    @Inject
    private Provider<IChangeSerializer> serializerProvider;

    public void apply(final Iterable<IBatchableModification> modifications, IProgressMonitor monitor) {
        if (Iterables.isEmpty(modifications)) {
            return;
        }
        try {
            new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                    BatchModification.this.applyInWorkspace(modifications, monitor);
                }
            }.run(monitor);
        }
        catch (InterruptedException | InvocationTargetException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected void applyInWorkspace(Iterable<IBatchableModification> modifications, IProgressMonitor monitor) throws CoreException {
        IProject proj = this.getResolvedProject();
        if (proj == null) {
            LOG.error((Object)"No project configured.");
            return;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ResourceSet resourceSet = this.resourceSetProvider.get(proj);
        this.liveScopeResourceSetInitializer.initialize(resourceSet);
        ArrayList resolved = Lists.newArrayList();
        for (IBatchableModification modification : modifications) {
            EObject obj = resourceSet.getEObject(modification.getEObjectURI(), true);
            if (obj == null || obj.eIsProxy()) {
                LOG.error((Object)("Invalid EObject URI " + String.valueOf(modification.getEObjectURI())));
                continue;
            }
            resolved.add(new ResolvedModification(obj, modification));
        }
        progress.split(5);
        IChangeSerializer serializer = (IChangeSerializer)this.serializerProvider.get();
        SubMonitor subProgress = SubMonitor.convert((IProgressMonitor)progress.split(80), (int)resolved.size());
        for (ResolvedModification mod : resolved) {
            serializer.setProgressMonitor((IProgressMonitor)subProgress.split(1));
            mod.modification.apply(mod.object, serializer);
            subProgress.split(1);
        }
        boolean first = true;
        for (ResolvedModification mod : resolved) {
            if (first) {
                serializer.setUpdateCrossReferences(mod.modification.isUpdateCrossReferences());
                serializer.setUpdateRelatedFiles(mod.modification.isUpdateRelatedFiles());
                continue;
            }
            if (serializer.isUpdateCrossReferences() != mod.modification.isUpdateCrossReferences()) {
                LOG.error((Object)"two modifications can't be batched.");
                return;
            }
            if (serializer.isUpdateRelatedFiles() == mod.modification.isUpdateRelatedFiles()) continue;
            LOG.error((Object)"two modifications can't be batched.");
            return;
        }
        progress.split(1);
        ChangeConverter converter = this.changeConverterFactory.create("Resolving Issues", null, this.issueAcceptor);
        serializer.applyModifications((IAcceptor)converter);
        progress.split(1);
        Change change = converter.getChange();
        if (change != null) {
            change.initializeValidationData((IProgressMonitor)progress.split(3));
            new PerformChangeOperation(change).run((IProgressMonitor)progress.split(10));
        }
        progress.done();
    }

    public IXtextDocument getDocument() {
        return this.document;
    }

    public IProject getProject() {
        return this.project;
    }

    public IProject getResolvedProject() {
        IResource resource;
        if (this.project != null) {
            return this.project;
        }
        if (this.document != null && (resource = this.document.getAdapter(IResource.class)) != null) {
            return resource.getProject();
        }
        return null;
    }

    public void setDocument(IXtextDocument document) {
        this.document = document;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public static interface IBatchableModification {
        public void apply(EObject var1, IChangeSerializer var2);

        public URI getEObjectURI();

        public boolean isUpdateCrossReferences();

        public boolean isUpdateRelatedFiles();
    }

    protected class ResolvedModification {
        private final IBatchableModification modification;
        private final EObject object;

        public ResolvedModification(EObject object, IBatchableModification modification) {
            this.object = object;
            this.modification = modification;
        }
    }
}

