/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.runtime.util;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.m2m.internal.qvt.oml.ast.env.InternalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalParserUtil;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModuleInstance;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QvtOperationalEvaluationVisitorImpl;
import org.eclipse.m2m.internal.qvt.oml.expressions.Helper;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImperativeOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.runtime.util.NonTransformationExecutionContext;
import org.eclipse.ocl.EvaluationEnvironment;

public class HelperOperationCall {
    private static final Object[] NO_ARGS = new Object[0];
    private NonTransformationExecutionContext fContext;
    private Module fOwningModule;
    private Helper fOperation;
    private EClassifier fContextType;
    private List<EClassifier> fArgumentTypes;

    HelperOperationCall(Helper operation, NonTransformationExecutionContext context) {
        if (operation == null || context == null) {
            throw new IllegalArgumentException();
        }
        this.fOwningModule = QvtOperationalParserUtil.getOwningModule((ImperativeOperation)operation);
        if (this.fOwningModule == null) {
            throw new IllegalArgumentException("Not a library query or helper");
        }
        this.fOperation = operation;
        this.fContextType = QvtOperationalParserUtil.getContextualType((ImperativeOperation)this.fOperation);
        this.fArgumentTypes = new ArrayList<EClassifier>(this.fOperation.getEParameters().size());
        for (EParameter eParam : this.fOperation.getEParameters()) {
            EClassifier paramType = eParam.getEType();
            if (paramType == null) {
                throw new IllegalArgumentException("Parameter with no type");
            }
            this.fArgumentTypes.add(paramType);
        }
        this.fContext = context;
    }

    public Helper getOperation() {
        return this.fOperation;
    }

    public Module getLibrary() {
        return this.fOwningModule;
    }

    public EClassifier getContextType() {
        return this.fContextType;
    }

    public boolean isContextual() {
        return this.fContextType != null;
    }

    public Object invoke(Object[] arguments) throws IllegalArgumentException, InvocationTargetException {
        if (this.isContextual()) {
            throw new IllegalArgumentException("Contextual operation called without self");
        }
        QvtOperationalEvaluationVisitorImpl evaluator = this.fContext.getEvaluator();
        ModuleInstance thisObject = evaluator.getOperationalEvaluationEnv().getThisOfType(this.fOwningModule);
        assert (thisObject != null);
        return this.doInvoke(thisObject, arguments);
    }

    public Object invoke(Object self, Object[] arguments) throws IllegalArgumentException, InvocationTargetException {
        if (!this.isContextual()) {
            throw new IllegalArgumentException("Self passed to non-contextual operation");
        }
        return this.doInvoke(self, arguments);
    }

    private Object doInvoke(Object self, Object[] arguments) throws IllegalArgumentException, InvocationTargetException {
        if (self == null) {
            throw new IllegalArgumentException("Null context instance");
        }
        Object[] actualArguments = arguments == null ? NO_ARGS : arguments;
        this.checkArgumentType(self, actualArguments);
        QvtOperationalEvaluationVisitorImpl evaluator = this.fContext.getEvaluator();
        Object result = null;
        try {
            result = evaluator.executeHelperOperation(this.fOperation, self, Arrays.asList(actualArguments));
            if (result == ((InternalEvaluationEnv)evaluator.getOperationalEvaluationEnv().getAdapter(InternalEvaluationEnv.class)).getInvalid()) {
                result = null;
            }
        }
        catch (RuntimeException e) {
            throw new InvocationTargetException(e);
        }
        return result;
    }

    private void checkArgumentType(Object self, Object[] arguments) {
        if (arguments.length != this.fArgumentTypes.size()) {
            throw new IllegalArgumentException("Parameter count mismatch");
        }
        EvaluationEnvironment evalEnv = this.fContext.getEvaluator().getEvaluationEnvironment();
        if (self != null) {
            EClassifier callContextType = this.fContextType;
            if (callContextType == null) {
                callContextType = this.fOwningModule;
            }
            if (!evalEnv.isKindOf(self, (Object)callContextType)) {
                throw new IllegalArgumentException("Invalid context instance type");
            }
        }
        int argIndex = 0;
        for (EClassifier nextArgType : this.fArgumentTypes) {
            Object nextArg;
            if ((nextArg = arguments[argIndex++]) == null || evalEnv.isKindOf(nextArg, (Object)nextArgType)) continue;
            throw new IllegalArgumentException("Invalid type of argument, pos = " + argIndex);
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.fContext != null) {
            buf.append(this.fContextType).append("::");
        }
        buf.append(this.fOperation.getName()).append(" - ").append(this.fOwningModule.getName());
        return buf.toString();
    }
}

