/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.plugin.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.papyrus.toolsmiths.plugin.builder.AbstractPapyrusBuilder;
import org.eclipse.papyrus.toolsmiths.plugin.builder.Activator;
import org.eclipse.papyrus.toolsmiths.plugin.builder.IPapyrusBuilderProvider;
import org.eclipse.papyrus.toolsmiths.plugin.builder.PapyrusBuilderKind;

public class PapyrusPluginBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDER_ID = "org.eclipse.papyrus.plugin.builder";
    @Deprecated
    private static final List<AbstractPapyrusBuilder> modelBuilders = new ArrayList<AbstractPapyrusBuilder>();
    @Deprecated
    private static final List<AbstractPapyrusBuilder> pluginBuilders = new ArrayList<AbstractPapyrusBuilder>();
    @Deprecated
    private static final List<AbstractPapyrusBuilder> manifestBuilders = new ArrayList<AbstractPapyrusBuilder>();

    @Deprecated(since="1.1")
    public static final void addModelBuilder(AbstractPapyrusBuilder modelBuilder) {
        modelBuilders.add(modelBuilder);
    }

    @Deprecated(since="1.1")
    public static final void addPluginBuilder(AbstractPapyrusBuilder pluginBuilder) {
        pluginBuilders.add(pluginBuilder);
    }

    @Deprecated(since="1.1")
    public static final void addManifestBuilder(AbstractPapyrusBuilder pluginBuilder) {
        manifestBuilders.add(pluginBuilder);
    }

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        if (this.getProject() == null) {
            return null;
        }
        if (!this.isPapyrusPluginBuilderActivated()) {
            return null;
        }
        List<AbstractPapyrusBuilder> delegates = this.getDelegates();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(1 + delegates.size()));
        this.clean((IProgressMonitor)subMonitor.newChild(1));
        ArrayList<IProject> wantedDeltaProjects = new ArrayList<IProject>();
        for (AbstractPapyrusBuilder builder : delegates) {
            try {
                IProject[] projects = builder.build(this.getProject(), this, kind, args, (IProgressMonitor)subMonitor.newChild(1));
                if (projects == null || projects.length == 0) continue;
                wantedDeltaProjects.addAll(Arrays.asList(projects));
            }
            catch (Exception e) {
                Activator.log.error("Uncaught exception in Papyrus project builder delegate.", (Throwable)e);
            }
        }
        SubMonitor.done((IProgressMonitor)monitor);
        return wantedDeltaProjects.toArray(new IProject[wantedDeltaProjects.size()]);
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        List<AbstractPapyrusBuilder> delegates = this.getDelegates();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(1 + delegates.size()));
        super.clean((IProgressMonitor)subMonitor.newChild(1));
        for (AbstractPapyrusBuilder builder : delegates) {
            try {
                builder.clean((IProgressMonitor)subMonitor.newChild(1), this.getProject());
            }
            catch (Exception e) {
                Activator.log.error("Uncaught exception in Papyrus project builder delegate.", (Throwable)e);
            }
        }
        SubMonitor.done((IProgressMonitor)monitor);
    }

    protected boolean isPapyrusPluginBuilderActivated() {
        Boolean result = Activator.getDefault().getPreferenceStore().getBoolean("ActivateMainPapyrusBuilder");
        return result;
    }

    protected boolean isPapyrusModelBuilderActivated() {
        boolean result = Activator.getDefault().getPreferenceStore().getBoolean("ActivatePapyrusModelBuilder");
        if (result) {
            result = Activator.getDefault().getPreferenceStore().getBoolean("PapyrusModelBuilder_CheckModelDependencies") || Activator.getDefault().getPreferenceStore().getBoolean("PapyrusModelBuilder_ValidateModel");
        }
        return result;
    }

    protected boolean isPapyrusManifestBuilderActivated() {
        boolean result = Activator.getDefault().getPreferenceStore().getBoolean("ActivatePapyrusManifestBuilder");
        if (result) {
            result = Activator.getDefault().getPreferenceStore().getBoolean("PapyrusManifestBuilder_CheckDependencyRange") || Activator.getDefault().getPreferenceStore().getBoolean("PapyrusManifestBuilder_CheckReexport");
        }
        return result;
    }

    private List<AbstractPapyrusBuilder> getDelegates() {
        ArrayList<AbstractPapyrusBuilder> result = new ArrayList<AbstractPapyrusBuilder>();
        Collection<IPapyrusBuilderProvider> providers = Activator.getDefault().getBuilderProviders();
        if (this.isPapyrusModelBuilderActivated()) {
            result.addAll(modelBuilders);
            providers.stream().map(p -> this.provide((IPapyrusBuilderProvider)p, PapyrusBuilderKind.MODEL_RESOURCE)).filter(Objects::nonNull).forEach(result::add);
        }
        if (this.isPapyrusManifestBuilderActivated()) {
            result.addAll(manifestBuilders);
            providers.stream().map(p -> this.provide((IPapyrusBuilderProvider)p, PapyrusBuilderKind.BUNDLE_MANIFEST)).filter(Objects::nonNull).forEach(result::add);
        }
        result.addAll(pluginBuilders);
        providers.stream().map(p -> this.provide((IPapyrusBuilderProvider)p, PapyrusBuilderKind.PLUGIN_MANIFEST)).filter(Objects::nonNull).forEach(result::add);
        return result;
    }

    private AbstractPapyrusBuilder provide(IPapyrusBuilderProvider provider, PapyrusBuilderKind builderKind) {
        return provider.getBuilder(builderKind, this.getProject());
    }
}

