/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.utils;

import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.LocalTableHeaderAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.TableHeaderAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablelabelprovider.FeatureLabelProviderConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablelabelprovider.ILabelProviderConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablelabelprovider.ObjectLabelProviderConfiguration;

public class LabelConfigurationManagementUtils {
    private LabelConfigurationManagementUtils() {
    }

    public static final FeatureLabelProviderConfiguration getRowFeatureLabelConfigurationInTable(Table table) {
        LocalTableHeaderAxisConfiguration config = table.getLocalRowHeaderAxisConfiguration();
        if (table.isInvertAxis()) {
            config = table.getLocalColumnHeaderAxisConfiguration();
        }
        if (config != null) {
            for (ILabelProviderConfiguration current : config.getOwnedLabelConfigurations()) {
                if (!(current instanceof FeatureLabelProviderConfiguration)) continue;
                return (FeatureLabelProviderConfiguration)current;
            }
        }
        return null;
    }

    public static final FeatureLabelProviderConfiguration getRowFeatureLabelConfigurationInTableConfiguration(Table table) {
        TableHeaderAxisConfiguration config = table.getTableConfiguration().getRowHeaderAxisConfiguration();
        if (table.isInvertAxis()) {
            config = table.getTableConfiguration().getColumnHeaderAxisConfiguration();
        }
        for (ILabelProviderConfiguration current : config.getOwnedLabelConfigurations()) {
            if (!(current instanceof FeatureLabelProviderConfiguration)) continue;
            return (FeatureLabelProviderConfiguration)current;
        }
        return null;
    }

    public static final boolean hasRowFeatureLabelConfiguration(Table table) {
        return LabelConfigurationManagementUtils.getRowFeatureLabelConfigurationInTable(table) != null || LabelConfigurationManagementUtils.getRowFeatureLabelConfigurationInTableConfiguration(table) != null;
    }

    public static final FeatureLabelProviderConfiguration getColumnFeatureLabelConfigurationInTable(Table table) {
        LocalTableHeaderAxisConfiguration config = table.getLocalRowHeaderAxisConfiguration();
        if (!table.isInvertAxis()) {
            config = table.getLocalColumnHeaderAxisConfiguration();
        }
        if (config != null) {
            for (ILabelProviderConfiguration current : config.getOwnedLabelConfigurations()) {
                if (!(current instanceof FeatureLabelProviderConfiguration)) continue;
                return (FeatureLabelProviderConfiguration)current;
            }
        }
        return null;
    }

    public static final FeatureLabelProviderConfiguration getColumnFeatureLabelConfigurationInTableConfiguration(Table table) {
        TableHeaderAxisConfiguration config = table.getTableConfiguration().getRowHeaderAxisConfiguration();
        if (!table.isInvertAxis()) {
            config = table.getTableConfiguration().getColumnHeaderAxisConfiguration();
        }
        for (ILabelProviderConfiguration current : config.getOwnedLabelConfigurations()) {
            if (!(current instanceof FeatureLabelProviderConfiguration)) continue;
            return (FeatureLabelProviderConfiguration)current;
        }
        return null;
    }

    public static final boolean hasColumnFeatureLabelConfiguration(Table table) {
        return LabelConfigurationManagementUtils.getColumnFeatureLabelConfigurationInTable(table) != null || LabelConfigurationManagementUtils.getColumnFeatureLabelConfigurationInTableConfiguration(table) != null;
    }

    public static final ObjectLabelProviderConfiguration getRowObjectLabelConfigurationInTable(Table table) {
        LocalTableHeaderAxisConfiguration config = table.getLocalRowHeaderAxisConfiguration();
        if (table.isInvertAxis()) {
            config = table.getLocalColumnHeaderAxisConfiguration();
        }
        if (config != null) {
            for (ILabelProviderConfiguration current : config.getOwnedLabelConfigurations()) {
                if (!(current instanceof ObjectLabelProviderConfiguration)) continue;
                return (ObjectLabelProviderConfiguration)current;
            }
        }
        return null;
    }

    public static final ObjectLabelProviderConfiguration getRowObjectLabelConfigurationInTableConfiguration(Table table) {
        TableHeaderAxisConfiguration config = table.getTableConfiguration().getRowHeaderAxisConfiguration();
        if (table.isInvertAxis()) {
            config = table.getTableConfiguration().getColumnHeaderAxisConfiguration();
        }
        for (ILabelProviderConfiguration current : config.getOwnedLabelConfigurations()) {
            if (!(current instanceof ObjectLabelProviderConfiguration)) continue;
            return (ObjectLabelProviderConfiguration)current;
        }
        return null;
    }

    public static final boolean hasRowObjectLabelConfiguration(Table table) {
        return LabelConfigurationManagementUtils.getRowObjectLabelConfigurationInTable(table) != null || LabelConfigurationManagementUtils.getRowObjectLabelConfigurationInTableConfiguration(table) != null;
    }

    public static final ObjectLabelProviderConfiguration getColumnObjectLabelConfigurationInTable(Table table) {
        LocalTableHeaderAxisConfiguration config = table.getLocalRowHeaderAxisConfiguration();
        if (!table.isInvertAxis()) {
            config = table.getLocalColumnHeaderAxisConfiguration();
        }
        if (config != null) {
            for (ILabelProviderConfiguration current : config.getOwnedLabelConfigurations()) {
                if (!(current instanceof ObjectLabelProviderConfiguration)) continue;
                return (ObjectLabelProviderConfiguration)current;
            }
        }
        return null;
    }

    public static final ObjectLabelProviderConfiguration getColumnObjectLabelConfigurationInTableConfiguration(Table table) {
        TableHeaderAxisConfiguration config = table.getTableConfiguration().getRowHeaderAxisConfiguration();
        if (!table.isInvertAxis()) {
            config = table.getTableConfiguration().getColumnHeaderAxisConfiguration();
        }
        for (ILabelProviderConfiguration current : config.getOwnedLabelConfigurations()) {
            if (!(current instanceof ObjectLabelProviderConfiguration)) continue;
            return (ObjectLabelProviderConfiguration)current;
        }
        return null;
    }

    public static final boolean hasColumnObjectLabelConfiguration(Table table) {
        return LabelConfigurationManagementUtils.getColumnObjectLabelConfigurationInTable(table) != null || LabelConfigurationManagementUtils.getColumnObjectLabelConfigurationInTableConfiguration(table) != null;
    }

    public static final FeatureLabelProviderConfiguration getUsedColumnFeatureLabelConfiguration(Table table) {
        FeatureLabelProviderConfiguration conf = LabelConfigurationManagementUtils.getColumnFeatureLabelConfigurationInTable(table);
        if (conf == null) {
            conf = LabelConfigurationManagementUtils.getColumnFeatureLabelConfigurationInTableConfiguration(table);
        }
        return conf;
    }

    public static final FeatureLabelProviderConfiguration getUsedRowFeatureLabelConfiguration(Table table) {
        FeatureLabelProviderConfiguration conf = LabelConfigurationManagementUtils.getRowFeatureLabelConfigurationInTable(table);
        if (conf == null) {
            conf = LabelConfigurationManagementUtils.getRowFeatureLabelConfigurationInTableConfiguration(table);
        }
        return conf;
    }

    public static final ObjectLabelProviderConfiguration getUsedColumnObjectLabelConfiguration(Table table) {
        ObjectLabelProviderConfiguration conf = LabelConfigurationManagementUtils.getColumnObjectLabelConfigurationInTable(table);
        if (conf == null) {
            conf = LabelConfigurationManagementUtils.getColumnObjectLabelConfigurationInTableConfiguration(table);
        }
        return conf;
    }

    public static final ObjectLabelProviderConfiguration getUsedRowObjectLabelConfiguration(Table table) {
        ObjectLabelProviderConfiguration conf = LabelConfigurationManagementUtils.getRowObjectLabelConfigurationInTable(table);
        if (conf == null) {
            conf = LabelConfigurationManagementUtils.getRowObjectLabelConfigurationInTableConfiguration(table);
        }
        return conf;
    }
}

