/*
 * Decompiled with CFR 0.152.
 */
package prefuse.visual.sort;

import java.util.Comparator;
import prefuse.Visualization;
import prefuse.visual.AggregateItem;
import prefuse.visual.DecoratorItem;
import prefuse.visual.EdgeItem;
import prefuse.visual.VisualItem;

public class ItemSorter
implements Comparator {
    protected static final int AGGREGATE = 0;
    protected static final int EDGE = 1;
    protected static final int ITEM = 2;
    protected static final int DECORATOR = 3;

    public int score(VisualItem item) {
        int type = 2;
        if (item instanceof EdgeItem) {
            type = 1;
        } else if (item instanceof AggregateItem) {
            type = 0;
        } else if (item instanceof DecoratorItem) {
            type = 3;
        }
        int score = 1 << 26 + type;
        if (item.isHover()) {
            score += 0x2000000;
        }
        if (item.isHighlighted()) {
            score += 0x1000000;
        }
        if (item.isInGroup(Visualization.FOCUS_ITEMS)) {
            score += 0x800000;
        }
        if (item.isInGroup(Visualization.SEARCH_ITEMS)) {
            score += 0x400000;
        }
        return score;
    }

    public int compare(VisualItem v1, VisualItem v2) {
        int score2;
        int score1 = this.score(v1);
        return score1 < (score2 = this.score(v2)) ? -1 : (score1 == score2 ? 0 : 1);
    }

    public int compare(Object o1, Object o2) {
        if (!(o1 instanceof VisualItem) || !(o2 instanceof VisualItem)) {
            throw new IllegalArgumentException();
        }
        return this.compare((VisualItem)o1, (VisualItem)o2);
    }
}

