/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.internal.service.impl.tests;

import java.util.Collection;
import ordersystem.OrderSystemFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.internal.service.AbstractGetConstraintsOperation;
import org.eclipse.emf.validation.internal.service.GetLiveConstraintsOperation;
import org.eclipse.emf.validation.internal.service.impl.tests.AbstractGetConstraintsOperationTest;
import org.eclipse.emf.validation.service.IModelConstraintProvider;
import org.eclipse.emf.validation.tests.TestNotification;

public class GetLiveConstraintsOperationTest
extends AbstractGetConstraintsOperationTest {
    private EObject target;
    private Notification notification;

    public GetLiveConstraintsOperationTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.target = OrderSystemFactory.eINSTANCE.createProduct();
        this.notification = new TestNotification(this.target, 1);
        this.setFixture((AbstractGetConstraintsOperation)new TestOperation(this.notification));
    }

    private GetLiveConstraintsOperation getLiveFixture() {
        return (GetLiveConstraintsOperation)this.getFixture();
    }

    public void test_getNotification() {
        GetLiveConstraintsOperationTest.assertSame((String)"Wrong notification", (Object)this.notification, (Object)this.getLiveFixture().getNotification());
    }

    public void test_getEventType() {
        GetLiveConstraintsOperationTest.assertSame((String)"Wrong event type", (Object)EMFEventType.SET, (Object)this.getLiveFixture().getEventType());
    }

    public void test_getEObject() {
        GetLiveConstraintsOperationTest.assertSame((String)"Wrong target object", (Object)this.target, (Object)this.getFixture().getEObject());
    }

    public void test_execute() {
        Collection c = this.getFixture().execute((IModelConstraintProvider)new AbstractGetConstraintsOperationTest.TestProvider());
        GetLiveConstraintsOperationTest.assertNotNull((Object)c);
        GetLiveConstraintsOperationTest.assertTrue((String)"Token not found", (boolean)c.contains(LIVE_TOKEN));
    }

    public void test_getConstraints() {
        this.getFixture().execute((IModelConstraintProvider)new AbstractGetConstraintsOperationTest.TestProvider());
        Collection c = this.getFixture().getConstraints();
        GetLiveConstraintsOperationTest.assertTrue((String)"Token not found", (boolean)c.contains(LIVE_TOKEN));
        ((AbstractGetConstraintsOperationTest.TestConstraint)LIVE_TOKEN).getDescriptor().setError((Throwable)new Exception());
        c = this.getFixture().getConstraints();
        GetLiveConstraintsOperationTest.assertFalse((String)"Token is found", (boolean)c.contains(LIVE_TOKEN));
    }

    private static class TestOperation
    extends GetLiveConstraintsOperation {
        TestOperation(Notification notification) {
            this.setNotification(notification);
        }
    }
}

