/*
 * Decompiled with CFR 0.152.
 */
package org.gastro.rcp.internal.department;

import com.swtdesigner.ResourceManager;
import com.swtdesigner.SWTResourceManager;
import java.util.Map;
import org.eclipse.nebula.widgets.gallery.AbstractGalleryGroupRenderer;
import org.eclipse.nebula.widgets.gallery.AbstractGalleryItemRenderer;
import org.eclipse.nebula.widgets.gallery.DefaultGalleryItemRenderer;
import org.eclipse.nebula.widgets.gallery.Gallery;
import org.eclipse.nebula.widgets.gallery.GalleryItem;
import org.eclipse.nebula.widgets.gallery.NoGroupRenderer;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.ref.ReferenceValueMap;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.ViewPart;
import org.gastro.inventory.Department;
import org.gastro.inventory.Employee;
import org.gastro.rcp.IModel;

public class EmployeesView
extends ViewPart {
    public static final String ID = "org.gastro.rcp.employees.view";
    private static final Map<String, String> fakeImages = new ReferenceValueMap.Soft();
    private static int fakeImageID;

    public void setFocus() {
    }

    public void createPartControl(Composite parent) {
        Department department = (Department)IModel.INSTANCE.getStation();
        DefaultGalleryItemRenderer ir = new DefaultGalleryItemRenderer();
        ir.setShowRoundedSelectionCorners(true);
        Gallery gallery = new Gallery(parent, 0);
        gallery.setBackground(SWTResourceManager.getColor(35));
        gallery.setForeground(SWTResourceManager.getColor(10));
        gallery.setFont(SWTResourceManager.getFont("Segoe UI", 16, 1));
        gallery.setGroupRenderer((AbstractGalleryGroupRenderer)new NoGroupRenderer());
        gallery.setItemRenderer((AbstractGalleryItemRenderer)ir);
        GalleryItem group = new GalleryItem(gallery, 0);
        for (Employee employee : department.getEmployees()) {
            GalleryItem item = new GalleryItem(group, 0);
            String imageName = this.getImageName(employee.getName());
            item.setImage(this.getCachedImage(imageName));
            item.setText(StringUtil.safe((String)employee.getName()));
        }
    }

    private String getImageName(String employee) {
        if (employee == null) {
            return null;
        }
        Object name = fakeImages.get(employee);
        if (name != null) {
            return name;
        }
        while (true) {
            Image image;
            if ((image = this.getCachedImage((String)(name = "employee-" + ++fakeImageID))) != null) {
                fakeImages.put(employee, (String)name);
                return name;
            }
            fakeImageID = 0;
        }
    }

    private Image getCachedImage(String name) {
        return ResourceManager.getPluginImage("org.gastro.rcp.department", "images/" + name + ".png");
    }
}

