/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.spi.common.revision;

import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionManager;
import org.eclipse.emf.cdo.common.revision.CDORevisionProvider;
import org.eclipse.emf.cdo.spi.common.revision.CDORevisionProviderWithSynthetics;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.spi.common.revision.SyntheticCDORevision;

public class ManagedRevisionProvider
implements CDORevisionProvider {
    protected final InternalCDORevisionManager revisionManager;
    protected final CDOBranchPoint branchPoint;

    public ManagedRevisionProvider(CDORevisionManager revisionManager, CDOBranchPoint branchPoint) {
        this.branchPoint = branchPoint;
        this.revisionManager = (InternalCDORevisionManager)revisionManager;
    }

    public CDORevisionManager getRevisionManager() {
        return this.revisionManager;
    }

    public CDOBranchPoint getBranchPoint() {
        return this.branchPoint;
    }

    @Override
    public CDORevision getRevision(CDOID id) {
        return ManagedRevisionProvider.provideRevision(this.revisionManager, id, this.branchPoint);
    }

    public static CDORevision provideRevision(CDORevisionManager revisionManager, CDOID id, CDOBranchPoint branchPoint) {
        return revisionManager.getRevision(id, branchPoint, -1, 0, true);
    }

    public CDORevisionProviderWithSynthetics withSynthetics() {
        return new WithSynthetics(this.revisionManager, this.branchPoint);
    }

    public static class WithSynthetics
    extends ManagedRevisionProvider
    implements CDORevisionProviderWithSynthetics {
        public WithSynthetics(CDORevisionManager revisionManager, CDOBranchPoint branchPoint) {
            super(revisionManager, branchPoint);
        }

        @Override
        public SyntheticCDORevision getSynthetic(CDOID id) {
            SyntheticCDORevision[] synthetic = new SyntheticCDORevision[1];
            this.revisionManager.getRevision(id, this.branchPoint, -1, 0, true, synthetic);
            return synthetic[0];
        }
    }
}

